/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.sds.model.SensitivityZoneFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class SensitivityZone
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String AUS = "AUS";
    public static final String NOTAUS = "NOTAUS";
    public static final String ACT = "ACT";
    public static final String NSW = "NSW";
    public static final String QLD = "QLD";
    public static final String VIC = "VIC";
    public static final String TAS = "TAS";
    public static final String SA = "SA";
    public static final String WA = "WA";
    public static final String NT = "NT";
    public static final String CC = "CC";
    public static final String CX = "CX";
    public static final String AC = "AC";
    public static final String CS = "CS";
    public static final String NF = "NF";
    public static final String HM = "HM";
    public static final String AQ = "AQ";
    public static final String TSPZ = "TSPZ";
    public static final String TSSQZ = "TSSQZ";
    public static final String FFEZ = "FFEZ";
    public static final String PFFPQA1995 = "PFFPQA1995";
    public static final String ECCPQA2004 = "ECCPQA2004";
    public static final String RIFARA = "RIFARA";
    public static final String PIZNSWAC = "PIZNSWAC";
    public static final String PIZNSWSR = "PIZNSWSR";
    public static final String PIZVICNE = "PIZVICNE";
    public static final String PIZVICMAR = "PIZVICMAR";
    public static final String PIZVICNAG = "PIZVICNAG";
    public static final String PIZVICMOR = "PIZVICMOR";
    public static final String PIZVICUPT = "PIZVICUPT";
    public static final String PIZVICWHB = "PIZVICWHB";
    public static final String PCNCAVICTHO = "PCNCAVICTHO";
    public static final String PCNCAVICGEM = "PCNCAVICGEM";
    public static final String PCNCAVICKWR = "PCNCAVICKWR";
    public static final String PCNCAVICWAN = "PCNCAVICWAN";
    private final String id;
    private final String name;
    private final String layerId;
    private final ZoneType type;
    static final Map<String, String> countryCodes = new HashMap<String, String>();

    public SensitivityZone(String id, String name, String layerId, ZoneType type) {
        this.id = id;
        this.name = name;
        this.layerId = layerId;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public ZoneType getType() {
        return this.type;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.name).append((Object)this.layerId).append((Object)this.type).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SensitivityZone other = (SensitivityZone)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.id).isEquals();
    }

    public String toString() {
        return this.id + ", Name: " + this.getName() + ", Zone: " + (Object)((Object)this.getType());
    }

    public String toJson() {
        return "{\"name\":\"" + this.name + "\", \"type\":\"" + this.type.toString() + "\"}";
    }

    public static boolean isInAustralia(SensitivityZone zone) {
        return zone == SensitivityZoneFactory.getZone(AUS) || zone.getType() == ZoneType.STATE;
    }

    public static boolean isInAustralia(List<SensitivityZone> zones) {
        for (SensitivityZone zone : zones) {
            if (!zone.equals(SensitivityZoneFactory.getZone(AUS)) && zone.getType() != ZoneType.STATE) continue;
            return true;
        }
        return false;
    }

    public static boolean isExternalTerritory(SensitivityZone zone) {
        return zone.getType() == ZoneType.EXTERNAL_TERRITORY;
    }

    public static boolean isExternalTerritory(List<SensitivityZone> zones) {
        for (SensitivityZone zone : zones) {
            if (zone.getType() != ZoneType.EXTERNAL_TERRITORY) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTorresStrait(List<SensitivityZone> zones) {
        for (SensitivityZone zone : zones) {
            if (!zone.equals(SensitivityZoneFactory.getZone(TSPZ)) && !zone.equals(SensitivityZoneFactory.getZone(TSSQZ))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotInAustralia(SensitivityZone zone) {
        return zone == null || zone.equals(SensitivityZoneFactory.getZone(NOTAUS));
    }

    public static boolean isNotInAustralia(List<SensitivityZone> zones) {
        for (SensitivityZone zone : zones) {
            if (!zone.equals(SensitivityZoneFactory.getZone(NOTAUS))) continue;
            return true;
        }
        return false;
    }

    public static List<SensitivityZone> getListFromString(String string) {
        String[] zones;
        ArrayList<SensitivityZone> zoneList = new ArrayList<SensitivityZone>();
        for (String zone : zones = StringUtils.split((String)StringUtils.substringBetween((String)string, (String)"[", (String)"]"), (char)',')) {
            SensitivityZone sz = SensitivityZoneFactory.getZone(StringUtils.strip((String)zone));
            if (sz == null) continue;
            zoneList.add(sz);
        }
        return zoneList;
    }

    public static String getZoneDescriptions(List<SensitivityZone> zones) {
        StringBuffer buff = new StringBuffer();
        Collections.sort(zones, new Comparator<SensitivityZone>(){

            @Override
            public int compare(SensitivityZone o1, SensitivityZone o2) {
                if (o1.getType() != null && o2.getType() != null && o1.getType().equals((Object)ZoneType.COUNTRY) && o2.getType().equals((Object)ZoneType.STATE)) {
                    return 1;
                }
                if (o1.getType() != null && o2.getType() != null && o1.getType().equals((Object)ZoneType.STATE) && o2.getType().equals((Object)ZoneType.COUNTRY)) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (SensitivityZone sz : zones) {
            if (sz == null) continue;
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append(sz.getName());
        }
        return buff.toString();
    }

    public static String getCountryCode(String name) {
        return countryCodes.get(name);
    }

    static {
        for (Locale locale : Locale.getAvailableLocales()) {
            countryCodes.put(locale.getDisplayCountry(), locale.getCountry());
        }
    }

    public static enum ZoneType {
        COUNTRY,
        STATE,
        EXTERNAL_TERRITORY,
        QUARANTINE_ZONE;

    }
}

