/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.util.NodeStatus;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import org.apache.curator.retry.RetryOneTime;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ZookeeperUtil$ {
    public static final ZookeeperUtil$ MODULE$;
    private final String RUNNING;
    private final String ERROR;
    private final String COMPLETE;
    private final String UNKNOWN;
    private final String ZK_NAMESPACE;
    private CuratorFramework curator;

    static {
        new ZookeeperUtil$();
    }

    public String RUNNING() {
        return this.RUNNING;
    }

    public String ERROR() {
        return this.ERROR;
    }

    public String COMPLETE() {
        return this.COMPLETE;
    }

    public String UNKNOWN() {
        return this.UNKNOWN;
    }

    public String ZK_NAMESPACE() {
        return this.ZK_NAMESPACE;
    }

    public CuratorFramework curator() {
        return this.curator;
    }

    public void curator_$eq(CuratorFramework x$1) {
        this.curator = x$1;
    }

    private CuratorFramework getCurator() {
        BoxedUnit boxedUnit;
        if (this.curator() == null) {
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
            this.curator_$eq(builder.retryPolicy((RetryPolicy)new RetryOneTime(1)).connectString(Config$.MODULE$.zookeeperAddress()).build());
            this.curator().start();
            boxedUnit = this.curator().usingNamespace(this.ZK_NAMESPACE());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.curator();
    }

    public void setStatus(String processName, String status, int count) {
        if (Config$.MODULE$.zookeeperUpdatesEnabled()) {
            String now = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.setProperty(processName, ((Object)BoxesRunTime.boxToInteger((int)Config$.MODULE$.nodeNumber())).toString(), "status", status);
            this.setProperty(processName, ((Object)BoxesRunTime.boxToInteger((int)Config$.MODULE$.nodeNumber())).toString(), "count", ((Object)BoxesRunTime.boxToInteger((int)count)).toString());
            this.setProperty(processName, ((Object)BoxesRunTime.boxToInteger((int)Config$.MODULE$.nodeNumber())).toString(), "lastUpdated", now);
        }
    }

    public void setStatus(String processName, String nodeID, String status, int count) {
        if (Config$.MODULE$.zookeeperUpdatesEnabled()) {
            String now = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.setProperty(processName, nodeID, "status", status);
            this.setProperty(processName, nodeID, "count", ((Object)BoxesRunTime.boxToInteger((int)count)).toString());
            this.setProperty(processName, nodeID, "lastUpdated", now);
        }
    }

    public void setStatus(String processName, String nodeID, String status, int count, String lastUpdated) {
        if (Config$.MODULE$.zookeeperUpdatesEnabled()) {
            this.setProperty(processName, nodeID, "status", status);
            this.setProperty(processName, nodeID, "count", ((Object)BoxesRunTime.boxToInteger((int)count)).toString());
            this.setProperty(processName, nodeID, "lastUpdated", lastUpdated);
        }
    }

    private void setProperty(String processName, String nodeID, String key, String value) {
        Stat stat = (Stat)this.getCurator().checkExists().forPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{processName, nodeID, key})));
        if (stat == null) {
            ProtectACLCreateModePathAndBytesable createBuilder = this.getCurator().create().creatingParentsIfNeeded();
            createBuilder.forPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{processName, nodeID, key})), value.getBytes());
        } else {
            this.getCurator().setData().forPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{processName, nodeID, key})), value.getBytes());
        }
    }

    private Option<String> getProperty(String processName, String nodeID, String key) {
        None$ none$;
        Stat stat = (Stat)this.getCurator().checkExists().forPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{processName, nodeID, key})));
        if (stat == null) {
            none$ = None$.MODULE$;
        } else {
            byte[] data = (byte[])this.getCurator().getData().forPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{processName, nodeID, key})));
            none$ = new Some((Object)Predef$.MODULE$.charArrayOps(((String)new StringOps(Predef$.MODULE$.augmentString(new String(data))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final char apply(char x$1) {
                    return x$1;
                }
            }, Predef$.MODULE$.StringCanBuildFrom())).toCharArray()).mkString());
        }
        return none$;
    }

    public NodeStatus getStatus(String processName, String nodeID) {
        Option<String> status = this.getProperty(processName, nodeID, "status");
        Option<String> count = this.getProperty(processName, nodeID, "count");
        Option<String> lastUpdated = this.getProperty(processName, nodeID, "lastUpdated");
        return new NodeStatus(processName, nodeID, (String)status.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ZookeeperUtil$.MODULE$.UNKNOWN();
            }
        }), new StringOps(Predef$.MODULE$.augmentString((String)count.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "-1";
            }
        }))).toInt(), (String)lastUpdated.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    public void getSolrConfig(String zookeeperHostPort, String solrHome) {
        Predef$.MODULE$.println((Object)"Reading zookeeper config...");
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        CuratorFramework curator = builder.namespace("configs").retryPolicy((RetryPolicy)new RetryOneTime(1)).connectString(zookeeperHostPort).build();
        curator.start();
        List list = (List)curator.getChildren().forPath("/biocache");
        File confDir = new File(new StringBuilder().append((Object)solrHome).append((Object)"/biocache/conf").toString());
        FileUtils.forceMkdir((File)confDir);
        File dataDir = new File(new StringBuilder().append((Object)solrHome).append((Object)"/biocache/data").toString());
        FileUtils.forceMkdir((File)dataDir);
        JavaConversions$.MODULE$.asScalaBuffer(list).foreach((Function1)new Serializable(solrHome, curator){
            public static final long serialVersionUID = 0L;
            private final String solrHome$1;
            private final CuratorFramework curator$1;

            public final void apply(String str) {
                byte[] data = (byte[])this.curator$1.getData().forPath(new StringBuilder().append((Object)"/biocache/").append((Object)str).toString());
                String configFile = Predef$.MODULE$.charArrayOps(((String)new StringOps(Predef$.MODULE$.augmentString(new String(data))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final char apply(char x$2) {
                        return x$2;
                    }
                }, Predef$.MODULE$.StringCanBuildFrom())).toCharArray()).mkString();
                FileUtils.writeStringToFile((File)new File(new StringBuilder().append((Object)this.solrHome$1).append((Object)"/biocache/conf/").append((Object)str).toString()), (String)configFile);
            }
            {
                this.solrHome$1 = solrHome$1;
                this.curator$1 = curator$1;
            }
        });
        FileUtils.writeStringToFile((File)new File(new StringBuilder().append((Object)solrHome).append((Object)"/solr.xml").toString()), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?><solr></solr>");
        FileUtils.writeStringToFile((File)new File(new StringBuilder().append((Object)solrHome).append((Object)"/zoo.cfg").toString()), (String)"");
        FileUtils.writeStringToFile((File)new File(new StringBuilder().append((Object)solrHome).append((Object)"/biocache/core.properties").toString()), (String)"name=biocache\nconfig=solrconfig.xml\nschema=schema.xml\ndataDir=data");
    }

    private ZookeeperUtil$() {
        MODULE$ = this;
        this.RUNNING = "RUNNING";
        this.ERROR = "ERROR";
        this.COMPLETE = "COMPLETE";
        this.UNKNOWN = "UNKNOWN";
        this.ZK_NAMESPACE = "biocache";
        this.curator = null;
    }
}

