/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.persistence;

import au.org.ala.biocache.persistence.CassandraPersistenceManager$;
import au.org.ala.biocache.util.Json$;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.SlicePredicate;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.Mutator;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.Pelops;
import org.scale7.cassandra.pelops.RowDeletor;
import org.scale7.cassandra.pelops.Selector;
import org.scale7.cassandra.pelops.exceptions.NotFoundException;
import org.scale7.cassandra.pelops.pool.CommonsBackedPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0011Ec\u0001B\u0001\u0003\u00015\u00111dQ1tg\u0006tGM]1QKJ\u001c\u0018n\u001d;f]\u000e,W*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003-\u0001XM]:jgR,gnY3\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\t!|7\u000f^\u000b\u0002/A\u0011\u0001d\u0007\b\u0003\u001feI!A\u0007\t\u0002\rA\u0013X\rZ3g\u0013\taRD\u0001\u0004TiJLgn\u001a\u0006\u00035AA\u0001b\b\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0006Q>\u001cH\u000f\t\u0005\tC\u0001\u0011)\u0019!C\u0001E\u0005!\u0001o\u001c:u+\u0005\u0019\u0003CA\b%\u0013\t)\u0003CA\u0002J]RD\u0001b\n\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0006a>\u0014H\u000f\t\u0005\tS\u0001\u0011)\u0019!C\u0001-\u0005A\u0001o\\8m\u001d\u0006lW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0001xn\u001c7OC6,\u0007\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001\u0017\u0003!YW-_:qC\u000e,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u0013-,\u0017p\u001d9bG\u0016\u0004\u0003\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u001d5\f\u0007pQ8o]\u0016\u001cG/[8og\"A1\u0007\u0001B\u0001B\u0003%1%A\bnCb\u001cuN\u001c8fGRLwN\\:!\u0011!)\u0004A!b\u0001\n\u0003\u0011\u0013AC7bqJ+GO]5fg\"Aq\u0007\u0001B\u0001B\u0003%1%A\u0006nCb\u0014V\r\u001e:jKN\u0004\u0003\u0002C\u001d\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002!=\u0004XM]1uS>tG+[7f_V$\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002#=\u0004XM]1uS>tG+[7f_V$\b\u0005C\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\t\u007f\u0005\u0013fK\u00170cMB\u0011\u0001\tA\u0007\u0002\u0005!9Q\u0003\u0010I\u0001\u0002\u00049\u0002\u0006B!D\u001fB\u0003\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\t9\fW.\u001a\u0006\u0003\u0011&\u000ba!\u001b8kK\u000e$(B\u0001&L\u0003\u00199wn\\4mK*\tA*A\u0002d_6L!AT#\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0003E\u000bqbY1tg\u0006tGM]1/Q>\u001cHo\u001d\u0005\bCq\u0002\n\u00111\u0001$Q\u0011\u00116i\u0014+\"\u0003U\u000babY1tg\u0006tGM]1/a>\u0014H\u000fC\u0004*yA\u0005\t\u0019A\f)\tY\u001bu\nW\u0011\u00023\u0006q1-Y:tC:$'/\u0019\u0018q_>d\u0007bB\u0017=!\u0003\u0005\ra\u0006\u0015\u00055\u000e{E,I\u0001^\u0003I\u0019\u0017m]:b]\u0012\u0014\u0018ML6fsN\u0004\u0018mY3\t\u000fEb\u0004\u0013!a\u0001G!\"alQ(aC\u0005\t\u0017!G2bgN\fg\u000e\u001a:b]5\f\u0007PL2p]:,7\r^5p]NDq!\u000e\u001f\u0011\u0002\u0003\u00071\u0005\u000b\u0003c\u0007>#\u0017%A3\u0002+\r\f7o]1oIJ\fg&\\1y]I,GO]5fg\"9\u0011\b\u0010I\u0001\u0002\u0004\u0019\u0003\u0006\u00024D\u001f\"\f\u0013![\u0001\u0019i\"\u0014\u0018N\u001a;/_B,'/\u0019;j_:tC/[7f_V$\bF\u0001\u001fl!\taW.D\u0001H\u0013\tqwI\u0001\u0004J]*,7\r\u001e\u0005\ba\u0002\u0011\r\u0011\"\u0001r\u0003\u0019awnZ4feV\t!\u000f\u0005\u0002to6\tAO\u0003\u0002vm\u0006)1\u000f\u001c45U*\t\u0011\"\u0003\u0002yi\n1Aj\\4hKJDaA\u001f\u0001!\u0002\u0013\u0011\u0018a\u00027pO\u001e,'\u000f\t\u0005\by\u0002\u0011\r\u0011\"\u0001#\u00039i\u0017\r_\"pYVlg\u000eT5nSRDaA \u0001!\u0002\u0013\u0019\u0013aD7bq\u000e{G.^7o\u0019&l\u0017\u000e\u001e\u0011\t\u0013\u0005\u0005\u0001A1A\u0005\u0002\u0005\r\u0011aB2mkN$XM]\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00165\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0004qK2|\u0007o\u001d\u0006\u0005\u0003\u001f\t\t\"A\u0005dCN\u001c\u0018M\u001c3sC*\u0019\u00111\u0003<\u0002\rM\u001c\u0017\r\\38\u0013\u0011\t9\"!\u0003\u0003\u000f\rcWo\u001d;fe\"A\u00111\u0004\u0001!\u0002\u0013\t)!\u0001\u0005dYV\u001cH/\u001a:!\u0011%\ty\u0002\u0001b\u0001\n\u0003\t\t#\u0001\u0004q_2L7-_\u000b\u0003\u0003G\u0001B!!\n\u000229!\u0011qEA\u0017\u001b\t\tIC\u0003\u0003\u0002,\u0005%\u0011\u0001\u00029p_2LA!a\f\u0002*\u0005\t2i\\7n_:\u001c()Y2lK\u0012\u0004vn\u001c7\n\t\u0005M\u0012Q\u0007\u0002\u0007!>d\u0017nY=\u000b\t\u0005=\u0012\u0011\u0006\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002$\u00059\u0001o\u001c7jGf\u0004\u0003\"CA\u001f\u0001\t\u0007I\u0011AA \u00035y\u0007/\u001a:b]\u0012\u0004v\u000e\\5dsV\u0011\u0011\u0011\t\t\u0005\u0003\u000f\t\u0019%\u0003\u0003\u0002F\u0005%!!D(qKJ\fg\u000e\u001a)pY&\u001c\u0017\u0010\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA!\u00039y\u0007/\u001a:b]\u0012\u0004v\u000e\\5ds\u0002Bq!!\u0014\u0001\t\u0003\ty%\u0001\u0006j]&$\u0018.\u00197jg\u0016,\"!!\u0015\u0011\u0007=\t\u0019&C\u0002\u0002VA\u0011A!\u00168ji\"9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013aA4fiR1\u0011QLA5\u0003[\u0002RaDA0\u0003GJ1!!\u0019\u0011\u0005\u0019y\u0005\u000f^5p]B)\u0001$!\u001a\u0018/%\u0019\u0011qM\u000f\u0003\u00075\u000b\u0007\u000fC\u0004\u0002l\u0005]\u0003\u0019A\f\u0002\rI|wo[3z\u0011\u001d\ty'a\u0016A\u0002]\t!\"\u001a8uSRLh*Y7f\u0011\u001d\tI\u0006\u0001C\u0005\u0003g\"\"\"!\u001e\u0002\u001a\u0006m\u0015QTAQ!\u0015y\u0011qLA<!\u0019\tI(a!\u0002\b6\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0003vi&d'BAAA\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00151\u0010\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\n\u0006UUBAAF\u0015\u0011\ti)a$\u0002\rQD'/\u001b4u\u0015\u0011\ty!!%\u000b\u0007\u0005Me/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003/\u000bYI\u0001\u0004D_2,XN\u001c\u0005\b\u0003W\n\t\b1\u0001\u0018\u0011\u001d\ty'!\u001dA\u0002]Aq!a(\u0002r\u0001\u0007q#A\u0007ti\u0006\u0014H\u000f\u0015:pa\u0016\u0014H/\u001f\u0005\b\u0003G\u000b\t\b1\u0001\u0018\u0003-)g\u000e\u001a)s_B,'\u000f^=\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006Ar-\u001a;D_2,XN\\:XSRDG+[7fgR\fW\u000e]:\u0015\r\u0005-\u0016QWA\\!\u0015y\u0011qLAW!\u0019A\u0012QM\f\u00020B\u0019q\"!-\n\u0007\u0005M\u0006C\u0001\u0003M_:<\u0007bBA6\u0003K\u0003\ra\u0006\u0005\b\u0003_\n)\u000b1\u0001\u0018\u0011\u001d\tY\f\u0001C\u0001\u0003{\u000b!bZ3u\u0005fLe\u000eZ3y)!\ti&a0\u0002D\u0006\u0015\u0007bBAa\u0003s\u0003\raF\u0001\rS:$W\r_3e-\u0006dW/\u001a\u0005\b\u0003_\nI\f1\u0001\u0018\u0011\u001d\t9-!/A\u0002]\t\u0011\"\u001b3y\u0007>dW/\u001c8\t\u000f\u0005m\u0006\u0001\"\u0001\u0002LRQ\u0011QZAh\u0003#\f\u0019.!6\u0011\t=\tyf\u0006\u0005\b\u0003\u0003\fI\r1\u0001\u0018\u0011\u001d\ty'!3A\u0002]Aq!a2\u0002J\u0002\u0007q\u0003C\u0004\u0002X\u0006%\u0007\u0019A\f\u0002\u0019A\u0014x\u000e]3sift\u0015-\\3\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\u00069r-\u001a;GSJ\u001cHOV1mk\u0016\u001chI]8n\u0013:$W\r\u001f\u000b\u000b\u0003;\ny.!9\u0002d\u0006\u0015\bbBA8\u00033\u0004\ra\u0006\u0005\b\u0003\u000f\fI\u000e1\u0001\u0018\u0011\u001d\t\t-!7A\u0002]A\u0001\"a:\u0002Z\u0002\u0007\u0011\u0011^\u0001\u000fg2L7-\u001a)sK\u0012L7-\u0019;f!\u0011\tI)a;\n\t\u00055\u00181\u0012\u0002\u000f'2L7-\u001a)sK\u0012L7-\u0019;f\u0011\u001d\tI\u0006\u0001C\u0001\u0003c$\u0002\"a=\u0002\u0000\n\u0005!1\u0001\t\u0006\u001f\u0005}\u0013Q\u001f\t\u0005\u0003o\fi0\u0004\u0002\u0002z*!\u00111`A@\u0003\u0011a\u0017M\\4\n\u0007q\tI\u0010C\u0004\u0002l\u0005=\b\u0019A\f\t\u000f\u0005=\u0014q\u001ea\u0001/!9\u0011q[Ax\u0001\u00049\u0002b\u0002B\u0004\u0001\u0011\u0005!\u0011B\u0001\fO\u0016$8+\u001a7fGR,G\r\u0006\u0005\u0002^\t-!Q\u0002B\b\u0011\u001d\tYG!\u0002A\u0002]Aq!a\u001c\u0003\u0006\u0001\u0007q\u0003\u0003\u0005\u0003\u0012\t\u0015\u0001\u0019\u0001B\n\u00035\u0001(o\u001c9feRLh*Y7fgB)!Q\u0003B\u0013/9!!q\u0003B\u0011\u001d\u0011\u0011IBa\b\u000e\u0005\tm!b\u0001B\u000f\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u0005G\u0001\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0011ICA\u0002TKFT1Aa\t\u0011\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_\t\u0001\u0002];u\u0005\u0006$8\r\u001b\u000b\u000b\u0003#\u0012\tDa\r\u0003:\t\r\u0003bBA8\u0005W\u0001\ra\u0006\u0005\t\u0005k\u0011Y\u00031\u0001\u00038\u0005)!-\u0019;dQB1\u0001$!\u001a\u0018\u0003GB\u0001Ba\u000f\u0003,\u0001\u0007!QH\u0001\n]\u0016<(+Z2pe\u0012\u00042a\u0004B \u0013\r\u0011\t\u0005\u0005\u0002\b\u0005>|G.Z1o\u0011!\u0011)Ea\u000bA\u0002\tu\u0012\u0001\u0005:f[>4XMT;mY\u001aKW\r\u001c3t\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017\n1\u0001];u)-9\"Q\nB)\u0005'\u00129F!\u0017\t\u000f\t=#q\ta\u0001/\u0005!Q/^5e\u0011\u001d\tyGa\u0012A\u0002]A\u0001B!\u0016\u0003H\u0001\u0007\u00111M\u0001\u000eW\u0016Lh+\u00197vKB\u000b\u0017N]:\t\u0011\tm\"q\ta\u0001\u0005{A\u0001B!\u0012\u0003H\u0001\u0007!Q\b\u0005\b\u0005\u0013\u0002A\u0011\u0001B/)59\"q\fB1\u0005G\u0012)G!\u001b\u0003l!9\u00111\u000eB.\u0001\u00049\u0002bBA8\u00057\u0002\ra\u0006\u0005\b\u0003/\u0014Y\u00061\u0001\u0018\u0011\u001d\u00119Ga\u0017A\u0002]\tQ\u0002\u001d:pa\u0016\u0014H/\u001f,bYV,\u0007\u0002\u0003B\u001e\u00057\u0002\rA!\u0010\t\u0011\t\u0015#1\fa\u0001\u0005{AqAa\u001c\u0001\t\u0003\u0011\t(A\u0004hKRd\u0015n\u001d;\u0016\t\tM$Q\u0010\u000b\u000b\u0005k\u0012yI!%\u0003\u0014\nU\u0005C\u0002B\u000b\u0005o\u0012I(\u0003\u0003\u0002\u0006\n%\u0002\u0003\u0002B>\u0005{b\u0001\u0001\u0002\u0005\u0003\u0000\t5$\u0019\u0001BA\u0005\u0005\t\u0015\u0003\u0002BB\u0005\u0013\u00032a\u0004BC\u0013\r\u00119\t\u0005\u0002\b\u001d>$\b.\u001b8h!\ry!1R\u0005\u0004\u0005\u001b\u0003\"aA!os\"9\u00111\u000eB7\u0001\u00049\u0002bBA8\u0005[\u0002\ra\u0006\u0005\b\u0003/\u0014i\u00071\u0001\u0018\u0011!\u00119J!\u001cA\u0002\te\u0015\u0001\u0003;iK\u000ec\u0017m]:1\t\tm%1\u0015\t\u0007\u0003o\u0014iJ!)\n\t\t}\u0015\u0011 \u0002\u0006\u00072\f7o\u001d\t\u0005\u0005w\u0012\u0019\u000b\u0002\u0007\u0003&\nU\u0015\u0011!A\u0001\u0006\u0003\u0011\tIA\u0002`IEBqA!+\u0001\t\u0003\u0011Y+A\u0004qkRd\u0015n\u001d;\u0016\t\t5&Q\u0018\u000b\u0012/\t=&\u0011\u0017BZ\u0005k\u0013yLa3\u0003N\nE\u0007bBA6\u0005O\u0003\ra\u0006\u0005\b\u0003_\u00129\u000b1\u0001\u0018\u0011\u001d\t9Na*A\u0002]A\u0001Ba.\u0003(\u0002\u0007!\u0011X\u0001\b]\u0016<H*[:u!\u0019\u0011)B!\n\u0003<B!!1\u0010B_\t!\u0011yHa*C\u0002\t\u0005\u0005\u0002\u0003BL\u0005O\u0003\rA!11\t\t\r'q\u0019\t\u0007\u0003o\u0014iJ!2\u0011\t\tm$q\u0019\u0003\r\u0005\u0013\u0014y,!A\u0001\u0002\u000b\u0005!\u0011\u0011\u0002\u0004?\u0012\u0012\u0004\u0002\u0003B\u001e\u0005O\u0003\rA!\u0010\t\u0011\t='q\u0015a\u0001\u0005{\t\u0011b\u001c<fe^\u0014\u0018\u000e^3\t\u0011\t\u0015#q\u0015a\u0001\u0005{AqA!6\u0001\t\u0003\u00119.\u0001\u0005qC\u001e,wJ^3s)A\t\tF!7\u0003\\\n\u0015(\u0011\u001eBv\u0005_\u0014\u0019\u0010C\u0004\u0002p\tM\u0007\u0019A\f\t\u0011\tu'1\u001ba\u0001\u0005?\fA\u0001\u001d:pGBAqB!9\u0018\u0003G\u0012i$C\u0002\u0003dB\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000f\t\u001d(1\u001ba\u0001G\u0005A\u0001/Y4f'&TX\r\u0003\u0005\u0002h\nM\u0007\u0019AAu\u0011)\u0011iOa5\u0011\u0002\u0003\u0007!QH\u0001\u000bG\",7m[#naRL\b\"\u0003By\u0005'\u0004\n\u00111\u0001\u0018\u0003-\u0019H/\u0019:u%><8.Z=\t\u0013\tU(1\u001bI\u0001\u0002\u00049\u0012!C3oIJ{wo[3z\u0011\u001d\u0011I\u0010\u0001C\u0005\u0005w\fQdZ3u\u0007>dW/\u001c8t\rJ|WNU8xg^KG\u000f\u001b*fiJLWm\u001d\u000b\r\u0005{\u001c9a!\u0003\u0004\u0014\rU1q\u0004\t\t\u0003s\u0012yp!\u0001\u0002x%!\u0011qMA>!\u0011\t9aa\u0001\n\t\r\u0015\u0011\u0011\u0002\u0002\u0006\u0005f$Xm\u001d\u0005\b\u0003_\u00129\u00101\u0001\u0018\u0011!\u0019YAa>A\u0002\r5\u0011\u0001C6fsJ\u000bgnZ3\u0011\t\u0005%5qB\u0005\u0005\u0007#\tYI\u0001\u0005LKf\u0014\u0016M\\4f\u0011!\t9Oa>A\u0002\u0005%\b\u0002CB\f\u0005o\u0004\ra!\u0007\u0002\u0005\rd\u0007\u0003BAE\u00077IAa!\b\u0002\f\n\u00012i\u001c8tSN$XM\\2z\u0019\u00164X\r\u001c\u0005\b\u0007C\u00119\u00101\u0001$\u0003A\u0001XM]7jiR,GMU3ue&,7\u000fC\u0004\u0004&\u0001!\taa\n\u0002\u001dA\fw-Z(wKJ\u001cV\r\\3diRq\u0011\u0011KB\u0015\u0007W\u0019ica\f\u00042\rM\u0002bBA8\u0007G\u0001\ra\u0006\u0005\t\u0005;\u001c\u0019\u00031\u0001\u0003`\"9!\u0011_B\u0012\u0001\u00049\u0002b\u0002B{\u0007G\u0001\ra\u0006\u0005\b\u0005O\u001c\u0019\u00031\u0001$\u0011!\u0019)da\tA\u0002\r]\u0012AC2pYVlgNT1nKB!qb!\u000f\u0018\u0013\r\u0019Y\u0004\u0005\u0002\u000byI,\u0007/Z1uK\u0012t\u0004bBB \u0001\u0011\u00051\u0011I\u0001\u0014a\u0006<Wm\u0014<fe\u000e{G.^7o%\u0006tw-\u001a\u000b\u0011\u0003#\u001a\u0019e!\u0012\u0004H\r%31JB'\u0007#Bq!a\u001c\u0004>\u0001\u0007q\u0003\u0003\u0005\u0003^\u000eu\u0002\u0019\u0001Bp\u0011%\u0011\tp!\u0010\u0011\u0002\u0003\u0007q\u0003C\u0005\u0003v\u000eu\u0002\u0013!a\u0001/!I!q]B\u001f!\u0003\u0005\ra\t\u0005\n\u0007\u001f\u001ai\u0004%AA\u0002]\t1b\u001d;beR\u001cu\u000e\\;n]\"I11KB\u001f!\u0003\u0005\raF\u0001\nK:$7i\u001c7v[:Dqaa\u0016\u0001\t\u0003\u0019I&A\u0006qC\u001e,wJ^3s\u00032dG\u0003DA)\u00077\u001aifa\u0018\u0004b\r\r\u0004bBA8\u0007+\u0002\ra\u0006\u0005\t\u0005;\u001c)\u00061\u0001\u0003`\"I!\u0011_B+!\u0003\u0005\ra\u0006\u0005\n\u0005k\u001c)\u0006%AA\u0002]A\u0011Ba:\u0004VA\u0005\t\u0019A\u0012\t\u000f\r\u001d\u0004\u0001\"\u0001\u0004j\u0005i\u0001/Y4f\u001fZ,'\u000fT8dC2$\u0012bIB6\u0007[\u001ayga\u001d\t\u000f\u0005=4Q\ra\u0001/!A!Q\\B3\u0001\u0004\u0011y\u000eC\u0004\u0004r\r\u0015\u0004\u0019A\u0012\u0002\u000fQD'/Z1eg\"A1QOB3\u0001\u0004\u00199(A\u0004d_2,XN\\:\u0011\t=\u0019IhF\u0005\u0004\u0007w\u0002\"!B!se\u0006L\bbBB@\u0001\u0011\u00051\u0011Q\u0001\u000bg\u0016dWm\u0019;S_^\u001cHCCA)\u0007\u0007\u001b9i!#\u0004\u000e\"A1QQB?\u0001\u0004\u0011\u0019\"A\u0004s_^\\W-_:\t\u000f\u0005=4Q\u0010a\u0001/!A11RB?\u0001\u0004\u0011\u0019\"\u0001\u0004gS\u0016dGm\u001d\u0005\t\u0005;\u001ci\b1\u0001\u0004\u0010B9qb!%\u0002d\u0005E\u0013bABJ!\tIa)\u001e8di&|g.\r\u0005\b\u0007/\u0003A\u0011CBM\u00039\u0019w\u000e\\;n]2K7\u000f\u001e\u001aNCB$B!a\u0019\u0004\u001c\"A1QTBK\u0001\u0004\t9(\u0001\u0006d_2,XN\u001c'jgRDqa!)\u0001\t#\u0019\u0019+\u0001\nd_2,XN\u001c'jgR\u0014D+[7f\u001b\u0006\u0004H\u0003BAW\u0007KC\u0001b!(\u0004 \u0002\u0007\u0011q\u000f\u0005\b\u0007S\u0003A\u0011CBV\u0003%9W\r^\"pYVlg\u000e\u0006\u0005\u0004.\u000e=6\u0011WB[!\u0015y\u0011qLAD\u0011\u001d\u0011yea*A\u0002]Aqaa-\u0004(\u0002\u0007q#\u0001\u0007d_2,XN\u001c$b[&d\u0017\u0010C\u0004\u00046\r\u001d\u0006\u0019A\f\t\u000f\re\u0006\u0001\"\u0001\u0002P\u0005A1\u000f[;uI><h\u000eC\u0004\u0004>\u0002!\taa0\u0002\u001b\u0011,G.\u001a;f\u0007>dW/\u001c8t)!\t\tf!1\u0004D\u000e\u0015\u0007b\u0002B(\u0007w\u0003\ra\u0006\u0005\b\u0003_\u001aY\f1\u0001\u0018\u0011!\u0019)da/A\u0002\r]\u0002bBBe\u0001\u0011\u000511Z\u0001\u0007I\u0016dW\r^3\u0015\r\u0005E3QZBh\u0011\u001d\u0011yea2A\u0002]Aq!a\u001c\u0004H\u0002\u0007q\u0003C\u0004\u0004T\u0002!\ta!6\u0002)\r\u0014X-\u0019;f'\u0016\u001cwN\u001c3befLe\u000eZ3y)\u001d\u00193q[Bm\u00077DqAa\u0014\u0004R\u0002\u0007q\u0003C\u0004\u0002p\rE\u0007\u0019A\f\t\u000f\rE4\u0011\u001ba\u0001G!I1q\u001c\u0001\u0012\u0002\u0013\u00051\u0011]\u0001\u0013a\u0006<Wm\u0014<fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004d*\"!QHBsW\t\u00199\u000f\u0005\u0003\u0004j\u000eMXBABv\u0015\u0011\u0019ioa<\u0002\u0013Ut7\r[3dW\u0016$'bABy!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rU81\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CB}\u0001E\u0005I\u0011AB~\u0003I\u0001\u0018mZ3Pm\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\ru(fA\f\u0004f\"IA\u0011\u0001\u0001\u0012\u0002\u0013\u000511`\u0001\u0013a\u0006<Wm\u0014<fe\u0012\"WMZ1vYR$s\u0007C\u0005\u0005\u0006\u0001\t\n\u0011\"\u0001\u0004|\u0006i\u0002/Y4f\u001fZ,'oQ8mk6t'+\u00198hK\u0012\"WMZ1vYR$3\u0007C\u0005\u0005\n\u0001\t\n\u0011\"\u0001\u0004|\u0006i\u0002/Y4f\u001fZ,'oQ8mk6t'+\u00198hK\u0012\"WMZ1vYR$C\u0007C\u0005\u0005\u000e\u0001\t\n\u0011\"\u0001\u0005\u0010\u0005i\u0002/Y4f\u001fZ,'oQ8mk6t'+\u00198hK\u0012\"WMZ1vYR$S'\u0006\u0002\u0005\u0012)\u001a1e!:\t\u0013\u0011U\u0001!%A\u0005\u0002\rm\u0018!\b9bO\u0016|e/\u001a:D_2,XN\u001c*b]\u001e,G\u0005Z3gCVdG\u000f\n\u001c\t\u0013\u0011e\u0001!%A\u0005\u0002\rm\u0018!\b9bO\u0016|e/\u001a:D_2,XN\u001c*b]\u001e,G\u0005Z3gCVdG\u000fJ\u001c\t\u0013\u0011u\u0001!%A\u0005\u0002\rm\u0018!\u00069bO\u0016|e/\u001a:BY2$C-\u001a4bk2$He\r\u0005\n\tC\u0001\u0011\u0013!C\u0001\u0007w\fQ\u0003]1hK>3XM]!mY\u0012\"WMZ1vYR$C\u0007C\u0005\u0005&\u0001\t\n\u0011\"\u0001\u0005\u0010\u0005)\u0002/Y4f\u001fZ,'/\u00117mI\u0011,g-Y;mi\u0012*t!\u0003C\u0015\u0005\u0005\u0005\t\u0012\u0001C\u0016\u0003m\u0019\u0015m]:b]\u0012\u0014\u0018\rU3sg&\u001cH/\u001a8dK6\u000bg.Y4feB\u0019\u0001\t\"\f\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\t_\u00192\u0001\"\f\u000f\u0011\u001diDQ\u0006C\u0001\tg!\"\u0001b\u000b\t\u0015\u0011]BQFI\u0001\n\u0003\u0019Y0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0005\u000b\tw!i#%A\u0005\u0002\u0011=\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0005@\u00115\u0012\u0013!C\u0001\u0007w\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003C\"\t[\t\n\u0011\"\u0001\u0004|\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQB!\u0002b\u0012\u0005.E\u0005I\u0011\u0001C\b\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k!QA1\nC\u0017#\u0003%\t\u0001b\u0004\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0011)!y\u0005\"\f\u0012\u0002\u0013\u0005AqB\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c")
public class CassandraPersistenceManager {
    private final String host;
    private final int port;
    private final String poolName;
    private final String keyspace;
    private final int maxConnections;
    private final int maxRetries;
    private final int operationTimeout;
    private final Logger logger;
    private final int maxColumnLimit;
    private final Cluster cluster;
    private final CommonsBackedPool.Policy policy;
    private final OperandPolicy operandPolicy;

    public static int $lessinit$greater$default$7() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$6() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$1();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String poolName() {
        return this.poolName;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public int maxConnections() {
        return this.maxConnections;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public int operationTimeout() {
        return this.operationTimeout;
    }

    public Logger logger() {
        return this.logger;
    }

    public int maxColumnLimit() {
        return this.maxColumnLimit;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public CommonsBackedPool.Policy policy() {
        return this.policy;
    }

    public OperandPolicy operandPolicy() {
        return this.operandPolicy;
    }

    public void initialise() {
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with pool name: ").append((Object)this.poolName()).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with hosts: ").append((Object)this.host()).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with port: ").append((Object)BoxesRunTime.boxToInteger((int)this.port())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with max connections: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxConnections())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with max retries: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxRetries())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with operation timeout: ").append((Object)BoxesRunTime.boxToInteger((int)this.operationTimeout())).toString());
        Pelops.addPool((String)this.poolName(), (Cluster)this.cluster(), (String)this.keyspace(), (CommonsBackedPool.Policy)this.policy(), (OperandPolicy)this.operandPolicy());
    }

    public Option<scala.collection.immutable.Map<String, String>> get(String rowkey, String entityName) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, rowkey, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2Map(columnList));
        }
        catch (Exception exception) {
            this.logger().trace(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    public Option<java.util.List<Column>> au$org$ala$biocache$persistence$CassandraPersistenceManager$$get(String rowkey, String entityName, String startProperty, String endProperty) {
        Some some;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String)startProperty, (String)endProperty, (boolean)false, (int)this.maxColumnLimit());
        try {
            some = new Some((Object)selector.getColumnsFromRow(entityName, rowkey, slicePredicate, ConsistencyLevel.ONE));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Option<scala.collection.immutable.Map<String, Object>> getColumnsWithTimestamps(String rowkey, String entityName) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, rowkey, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2TimeMap(columnList));
        }
        catch (Exception exception) {
            this.logger().debug(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    public Option<scala.collection.immutable.Map<String, String>> getByIndex(String indexedValue, String entityName, String idxColumn) {
        return this.getFirstValuesFromIndex(entityName, idxColumn, indexedValue, Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit()));
    }

    public Option<String> getByIndex(String indexedValue, String entityName, String idxColumn, String propertyName) {
        Option<scala.collection.immutable.Map<String, String>> map = this.getFirstValuesFromIndex(entityName, idxColumn, indexedValue, Selector.newColumnsPredicate((String[])new String[]{propertyName}));
        return map.isEmpty() ? None$.MODULE$ : new Some(((MapLike)map.get()).getOrElse((Object)propertyName, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    private Option<scala.collection.immutable.Map<String, String>> getFirstValuesFromIndex(String entityName, String idxColumn, String indexedValue, SlicePredicate slicePredicate) {
        None$ none$;
        Selector selector = Pelops.createSelector((String)this.poolName());
        IndexClause indexClause = Selector.newIndexClause((Bytes)Bytes.EMPTY, (int)1, (IndexExpression[])new IndexExpression[]{Selector.newIndexExpression((String)idxColumn, (IndexOperator)IndexOperator.EQ, (Bytes)Bytes.fromUTF8((String)indexedValue))});
        try {
            LinkedHashMap columnMap = selector.getIndexedColumns(entityName, indexClause, slicePredicate, ConsistencyLevel.ONE);
            if (columnMap == null || columnMap.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                java.util.List columnList = (java.util.List)columnMap.entrySet().iterator().next().getValue();
                scala.collection.immutable.Map<String, String> map = this.columnList2Map(columnList);
                none$ = new Some(map);
            }
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<String> get(String rowkey, String entityName, String propertyName) {
        None$ none$;
        try {
            Selector selector = Pelops.createSelector((String)this.poolName());
            Column column = selector.getColumnFromRow(entityName, rowkey, propertyName, ConsistencyLevel.ONE);
            none$ = new Some((Object)new String(column.getValue(), "UTF-8"));
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        catch (NotFoundException notFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<scala.collection.immutable.Map<String, String>> getSelected(String rowkey, String entityName, Seq<String> propertyNames) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])propertyNames.toArray(ClassTag$.MODULE$.apply(String.class))));
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, rowkey, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2Map(columnList));
        }
        catch (Exception exception) {
            this.logger().trace(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    public void putBatch(String entityName, scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>> batch, boolean newRecord, boolean removeNullFields) {
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        batch.foreach((Function1)new Serializable(this, entityName, removeNullFields, mutator){
            public static final long serialVersionUID = 0L;
            public final String entityName$1;
            public final boolean removeNullFields$1;
            public final Mutator mutator$1;

            public final void apply(Tuple2<String, scala.collection.immutable.Map<String, String>> uuidMap) {
                String uuid = (String)uuidMap._1();
                scala.collection.immutable.Map keyValuePairs = (scala.collection.immutable.Map)uuidMap._2();
                keyValuePairs.foreach((Function1)new Serializable(this, uuid){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$putBatch$1 $outer;
                    private final String uuid$1;

                    public final Mutator apply(Tuple2<String, String> keyValue) {
                        return this.$outer.mutator$1.writeColumn(this.$outer.entityName$1, Bytes.fromUTF8((String)this.uuid$1), this.$outer.mutator$1.newColumn((String)keyValue._1(), (String)keyValue._2()), this.$outer.removeNullFields$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.uuid$1 = uuid$1;
                    }
                });
            }
            {
                this.entityName$1 = entityName$1;
                this.removeNullFields$1 = removeNullFields$1;
                this.mutator$1 = mutator$1;
            }
        });
        mutator.execute(ConsistencyLevel.ONE);
    }

    public String put(String uuid, String entityName, scala.collection.immutable.Map<String, String> keyValuePairs, boolean newRecord, boolean removeNullFields) {
        String recordId = uuid == null ? UUID.randomUUID().toString() : uuid;
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        keyValuePairs.foreach((Function1)new Serializable(this, entityName, removeNullFields, recordId, mutator){
            public static final long serialVersionUID = 0L;
            private final String entityName$2;
            private final boolean removeNullFields$2;
            private final String recordId$1;
            private final Mutator mutator$2;

            public final Object apply(Tuple2<String, String> keyValue) {
                return this.removeNullFields$2 ? this.mutator$2.writeColumn(this.entityName$2, Bytes.fromUTF8((String)this.recordId$1), this.mutator$2.newColumn((String)keyValue._1(), (String)keyValue._2()), this.removeNullFields$2) : (keyValue._2() == null ? BoxedUnit.UNIT : this.mutator$2.writeColumn(this.entityName$2, this.recordId$1, this.mutator$2.newColumn((String)keyValue._1(), (String)keyValue._2())));
            }
            {
                this.entityName$2 = entityName$2;
                this.removeNullFields$2 = removeNullFields$2;
                this.recordId$1 = recordId$1;
                this.mutator$2 = mutator$2;
            }
        });
        Object object = uuid == null ? mutator.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator.newColumn("uuid", recordId), removeNullFields) : BoxedUnit.UNIT;
        mutator.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    public String put(String rowkey, String entityName, String propertyName, String propertyValue, boolean newRecord, boolean removeNullFields) {
        String recordId = rowkey == null ? UUID.randomUUID().toString() : rowkey;
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        mutator.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator.newColumn(propertyName, propertyValue), removeNullFields);
        Object object = rowkey == null ? mutator.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator.newColumn("uuid", recordId), removeNullFields) : BoxedUnit.UNIT;
        mutator.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    public <A> List<A> getList(String rowkey, String entityName, String propertyName, Class<?> theClass) {
        List list;
        Option<Column> column = this.getColumn(rowkey, entityName, propertyName);
        if (column.isEmpty()) {
            list = Nil$.MODULE$;
        } else {
            String json = new String(((Column)column.get()).getValue());
            list = Json$.MODULE$.toListWithGeneric(json, theClass);
        }
        return list;
    }

    public <A> String putList(String rowkey, String entityName, String propertyName, Seq<A> newList, Class<?> theClass, boolean newRecord, boolean overwrite, boolean removeNullFields) {
        Mutator mutator;
        String recordId = rowkey == null ? UUID.randomUUID().toString() : rowkey;
        Mutator mutator2 = Pelops.createMutator((String)this.poolName());
        if (overwrite) {
            String json = Json$.MODULE$.toJSONWithGeneric(newList);
            mutator = mutator2.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator2.newColumn(propertyName, json), removeNullFields);
        } else {
            Option<Column> column = this.getColumn(rowkey, entityName, propertyName);
            if (column.isEmpty()) {
                String json = Json$.MODULE$.toJSONWithGeneric(newList);
                mutator = mutator2.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator2.newColumn(propertyName, json), removeNullFields);
            } else {
                String currentJson = new String(((Column)column.get()).getValue());
                List currentList = Json$.MODULE$.toListWithGeneric(currentJson, theClass);
                ObjectRef buffer = new ObjectRef((Object)new ListBuffer());
                currentList.foreach((Function1)new Serializable(this, newList, buffer){
                    public static final long serialVersionUID = 0L;
                    private final Seq newList$1;
                    private final ObjectRef buffer$1;

                    public final Object apply(Nothing$ theObject) {
                        Seq seq = this.newList$1;
                        throw theObject;
                    }
                    {
                        this.newList$1 = newList$1;
                        this.buffer$1 = buffer$1;
                    }
                });
                ((ListBuffer)buffer.elem).$plus$plus$eq(newList);
                String newJson = Json$.MODULE$.toJSONWithGeneric(((ListBuffer)buffer.elem).toList());
                mutator = mutator2.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator2.newColumn(propertyName, newJson), removeNullFields);
            }
        }
        mutator2.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    public void pageOver(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, int pageSize, SlicePredicate slicePredicate, boolean checkEmpty, String startRowkey, String endRowkey) {
        Bytes startKey = new Bytes(startRowkey.getBytes());
        Bytes endKey = new Bytes(endRowkey.getBytes());
        KeyRange keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
        int counter = 0;
        BooleanRef booleanRef = new BooleanRef(true);
        ObjectRef columnMap = new ObjectRef(this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10));
        while (!((Map)columnMap.elem).isEmpty() && booleanRef.elem) {
            List columnsObj;
            List keys = columnsObj = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(((Map)columnMap.elem).keySet().toArray()));
            startKey = (Bytes)keys.last();
            keys.foreach((Function1)new Serializable(this, proc, checkEmpty, booleanRef, columnMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraPersistenceManager $outer;
                private final Function2 proc$1;
                private final boolean checkEmpty$1;
                private final BooleanRef continue$1;
                private final ObjectRef columnMap$1;

                public final void apply(Bytes buuid) {
                    java.util.List columnList = (java.util.List)((Map)this.columnMap$1.elem).get(buuid);
                    if (!this.checkEmpty$1 || !columnList.isEmpty()) {
                        scala.collection.immutable.Map<String, String> map = this.$outer.columnList2Map(columnList);
                        String uuid = (String)map.getOrElse((Object)"rowkey", (Function0)new Serializable(this, buuid){
                            public static final long serialVersionUID = 0L;
                            private final Bytes buuid$1;

                            public final String apply() {
                                return this.buuid$1.toUTF8();
                            }
                            {
                                this.buuid$1 = buuid$1;
                            }
                        });
                        this.continue$1.elem = BoxesRunTime.unboxToBoolean((Object)this.proc$1.apply((Object)uuid, map));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.proc$1 = proc$1;
                    this.checkEmpty$1 = checkEmpty$1;
                    this.continue$1 = continue$1;
                    this.columnMap$1 = columnMap$1;
                }
            });
            counter += keys.size();
            keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
            columnMap.elem = this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10);
            ((Map)columnMap.elem).remove(startKey);
        }
        if (counter > 0) {
            this.logger().debug(new StringBuilder().append((Object)"Finished paging. Records paged over : ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
        }
    }

    public boolean pageOver$default$5() {
        return false;
    }

    public String pageOver$default$6() {
        return "";
    }

    public String pageOver$default$7() {
        return "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Bytes, java.util.List<Column>> getColumnsFromRowsWithRetries(String entityName, KeyRange keyRange, SlicePredicate slicePredicate, ConsistencyLevel cl, int permittedRetries) {
        boolean success = false;
        boolean noOfRetries = false;
        HashMap columnMap = null;
        while (!success) {
            try {
                Selector selector = Pelops.createSelector((String)this.poolName());
                LinkedHashMap linkedHashMap = selector.getColumnsFromRows(entityName, keyRange, slicePredicate, cl);
                boolean bl = true;
                continue;
            }
            catch (Exception exception) {
                void var7_7;
                this.logger().warn(new StringBuilder().append((Object)"Problem retrieving data. Number of retries left:").append((Object)BoxesRunTime.boxToInteger((int)(permittedRetries - var7_7))).append((Object)", Error: ").append((Object)exception.getMessage()).toString());
                Thread.sleep(20000L);
                try {
                    this.initialise();
                }
                catch (Exception exception2) {
                    this.logger().warn(new StringBuilder().append((Object)"Problem reinitialising Cassandra connection Error: ").append((Object)exception2.getMessage()).toString());
                }
                if (var7_7 == permittedRetries) {
                    this.logger().error(new StringBuilder().append((Object)"Problem retrieving data. Number of DB connection retries exceeded. Error: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                    throw new RuntimeException(exception);
                }
                ++var7_7;
                continue;
            }
            break;
        }
        return columnMap;
    }

    public void pageOverSelect(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startRowkey, String endRowkey, int pageSize, Seq<String> columnName) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])columnName.toArray(ClassTag$.MODULE$.apply(String.class))));
        String x$1 = entityName;
        Function2<String, scala.collection.immutable.Map<String, String>, Object> x$2 = proc;
        int x$3 = pageSize;
        SlicePredicate x$4 = slicePredicate;
        String x$5 = startRowkey;
        String x$6 = endRowkey;
        boolean x$7 = this.pageOver$default$5();
        this.pageOver(x$1, x$2, x$3, x$4, x$7, x$5, x$6);
    }

    public void pageOverColumnRange(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startRowkey, String endRowkey, int pageSize, String startColumn, String endColumn) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String)startColumn, (String)endColumn, (boolean)false, (int)this.maxColumnLimit());
        Bytes startKey = new Bytes(startRowkey.getBytes());
        Bytes endKey = new Bytes(endRowkey.getBytes());
        KeyRange keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
        int counter = 0;
        BooleanRef booleanRef = new BooleanRef(true);
        ObjectRef columnMap = new ObjectRef(this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10));
        while (!((Map)columnMap.elem).isEmpty() && booleanRef.elem) {
            List columnsObj;
            List keys = columnsObj = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(((Map)columnMap.elem).keySet().toArray()));
            startKey = (Bytes)keys.last();
            keys.foreach((Function1)new Serializable(this, entityName, proc, endColumn, booleanRef, columnMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraPersistenceManager $outer;
                private final String entityName$3;
                private final Function2 proc$2;
                private final String endColumn$1;
                private final BooleanRef continue$2;
                private final ObjectRef columnMap$2;

                public final void apply(Bytes buuid) {
                    java.util.List columnList = (java.util.List)((Map)this.columnMap$2.elem).get(buuid);
                    boolean moreCols = true;
                    String uuid = buuid.toUTF8();
                    if (columnList != null && !columnList.isEmpty()) {
                        String startCol = new String(((Column)columnList.get(columnList.size() - 1)).getName(), "UTF-8");
                        while (moreCols) {
                            Option<java.util.List<Column>> nextCols = this.$outer.au$org$ala$biocache$persistence$CassandraPersistenceManager$$get(uuid, this.entityName$3, startCol, this.endColumn$1);
                            if (!nextCols.isDefined()) continue;
                            ((java.util.List)nextCols.get()).remove(0);
                            if (((java.util.List)nextCols.get()).isEmpty()) {
                                moreCols = false;
                                continue;
                            }
                            columnList.addAll((Collection)nextCols.get());
                            startCol = new String(((Column)columnList.get(columnList.size() - 1)).getName(), "UTF-8");
                        }
                        scala.collection.immutable.Map<String, String> map = this.$outer.columnList2Map(columnList);
                        this.continue$2.elem = BoxesRunTime.unboxToBoolean((Object)this.proc$2.apply((Object)uuid, map));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.entityName$3 = entityName$3;
                    this.proc$2 = proc$2;
                    this.endColumn$1 = endColumn$1;
                    this.continue$2 = continue$2;
                    this.columnMap$2 = columnMap$2;
                }
            });
            counter += keys.size();
            keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
            columnMap.elem = this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10);
            ((Map)columnMap.elem).remove(startKey);
        }
        if (counter > 0) {
            this.logger().debug(new StringBuilder().append((Object)"Finished paging. Records paged over : ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
        }
    }

    public String pageOverColumnRange$default$3() {
        return "";
    }

    public String pageOverColumnRange$default$4() {
        return "";
    }

    public int pageOverColumnRange$default$5() {
        return 1000;
    }

    public String pageOverColumnRange$default$6() {
        return "";
    }

    public String pageOverColumnRange$default$7() {
        return "";
    }

    public void pageOverAll(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startRowkey, String endRowkey, int pageSize) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        this.pageOver(entityName, proc, pageSize, slicePredicate, true, startRowkey, endRowkey);
    }

    public String pageOverAll$default$3() {
        return "";
    }

    public String pageOverAll$default$4() {
        return "";
    }

    public int pageOverAll$default$5() {
        return 1000;
    }

    public int pageOverLocal(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, int threads, String[] columns) {
        throw new RuntimeException("Not supported with cassandra 1 !!!!");
    }

    public void selectRows(Seq<String> rowkeys, String entityName, Seq<String> fields, Function1<scala.collection.immutable.Map<String, String>, BoxedUnit> proc) {
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])fields.toArray(ClassTag$.MODULE$.apply(String.class))));
        LinkedHashMap columnMap = selector.getColumnsFromRowsUtf8Keys(entityName, JavaConversions$.MODULE$.seqAsJavaList((Seq)rowkeys.toList()), slicePredicate, ConsistencyLevel.ONE);
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(columnMap.keySet().toArray()));
        keys.foreach((Function1)new Serializable(this, proc, columnMap){
            public static final long serialVersionUID = 0L;
            private final Function1 proc$3;
            private final LinkedHashMap columnMap$3;

            public final void apply(Object key) {
                java.util.List columnsList = (java.util.List)this.columnMap$3.get(key);
                Tuple2[] fieldValues = (Tuple2[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(columnsList).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Column column) {
                        return new Tuple2((Object)new String(column.getName(), "UTF-8"), (Object)new String(column.getValue(), "UTF-8"));
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                scala.collection.mutable.Map map = Map$.MODULE$.empty();
                Predef$.MODULE$.refArrayOps((Object[])fieldValues).foreach((Function1)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Map map$1;

                    public final void apply(Tuple2<String, String> fieldValue) {
                        this.map$1.update(fieldValue._1(), fieldValue._2());
                    }
                    {
                        this.map$1 = map$1;
                    }
                });
                this.proc$3.apply((Object)map.toMap(Predef$.MODULE$.conforms()));
            }
            {
                this.proc$3 = proc$3;
                this.columnMap$3 = columnMap$3;
            }
        });
    }

    public scala.collection.immutable.Map<String, String> columnList2Map(java.util.List<Column> columnList) {
        scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
        for (Column c : columnList) {
            map.put((Object)new String(c.getName(), "UTF-8"), (Object)new String(c.getValue(), "UTF-8"));
        }
        return map.toMap(Predef$.MODULE$.conforms());
    }

    public scala.collection.immutable.Map<String, Object> columnList2TimeMap(java.util.List<Column> columnList) {
        scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
        for (Column c : columnList) {
            map.put((Object)new String(c.getName(), "UTF-8"), (Object)BoxesRunTime.boxToLong((long)(c.getTimestamp() / 1000L)));
        }
        return map.toMap(Predef$.MODULE$.conforms());
    }

    public Option<Column> getColumn(String uuid, String columnFamily, String columnName) {
        Some some;
        try {
            Selector selector = Pelops.createSelector((String)this.poolName());
            some = new Some((Object)selector.getColumnFromRow(columnFamily, uuid, columnName, ConsistencyLevel.ONE));
        }
        catch (Exception exception) {
            this.logger().debug(new StringBuilder().append((Object)exception.getMessage()).append((Object)" for ").append((Object)uuid).append((Object)" - ").append((Object)columnFamily).append((Object)" - ").append((Object)columnName).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public void shutdown() {
        try {
            Pelops.shutdown();
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
        }
    }

    public void deleteColumns(String uuid, String entityName, Seq<String> columnName) {
        if (uuid != null && entityName != null && columnName != null) {
            Mutator mutator = Pelops.createMutator((String)this.poolName());
            mutator.deleteColumns(entityName, uuid, (String[])columnName.toArray(ClassTag$.MODULE$.apply(String.class)));
            mutator.execute(ConsistencyLevel.ONE);
        }
    }

    public void delete(String uuid, String entityName) {
        if (uuid != null && entityName != null) {
            RowDeletor deletor = Pelops.createRowDeletor((String)this.poolName());
            deletor.deleteRow(entityName, uuid, ConsistencyLevel.ONE);
        }
    }

    public int createSecondaryIndex(String uuid, String entityName, int threads) {
        throw new RuntimeException("Unsupported");
    }

    @Inject
    public CassandraPersistenceManager(@Named(value="cassandra.hosts") String host, @Named(value="cassandra.port") int port, @Named(value="cassandra.pool") String poolName, @Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.max.connections") int maxConnections, @Named(value="cassandra.max.retries") int maxRetries, @Named(value="thrift.operation.timeout") int operationTimeout) {
        this.host = host;
        this.port = port;
        this.poolName = poolName;
        this.keyspace = keyspace;
        this.maxConnections = maxConnections;
        this.maxRetries = maxRetries;
        this.operationTimeout = operationTimeout;
        this.logger = LoggerFactory.getLogger((String)"CassandraPersistenceManager");
        this.maxColumnLimit = 10000;
        this.cluster = new Cluster(host, port, operationTimeout, false);
        this.policy = new CommonsBackedPool.Policy();
        this.policy().setMaxTotal(maxConnections);
        this.policy().setMaxWaitForConnection(3 * operationTimeout);
        this.operandPolicy = new OperandPolicy(maxRetries, false);
        this.initialise();
    }
}

