/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.tool.FileDelete;
import au.org.ala.biocache.tool.QueryDelete;
import au.org.ala.biocache.tool.RecordDeletor;
import au.org.ala.biocache.util.OptionParser;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class DeleteRecords$
implements Tool {
    public static final DeleteRecords$ MODULE$;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;

    static {
        new DeleteRecords$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "delete-records";
    }

    @Override
    public String desc() {
        return "Delete records from the system via query to SOLR, resource or file of IDs. ";
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public void main(String[] args) {
        ObjectRef query = new ObjectRef((Object)None$.MODULE$);
        ObjectRef dr = new ObjectRef((Object)None$.MODULE$);
        ObjectRef lastLoadedDate = new ObjectRef((Object)None$.MODULE$);
        ObjectRef file = new ObjectRef((Object)None$.MODULE$);
        int fieldDelimiter = 9;
        BooleanRef hasHeader = new BooleanRef(false);
        OptionParser parser = new OptionParser(query, dr, lastLoadedDate, file, hasHeader){
            {
                this.opt("q", "query", "The query to run to obtain the records for deletion e.g. 'year:[2001 TO *]' or 'taxon_name:Macropus'", (Function1<String, BoxedUnit>)new Serializable(this, query$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef query$1;

                    public final void apply(String v) {
                        this.query$1.elem = new Some((Object)v);
                    }
                    {
                        this.query$1 = query$1;
                    }
                });
                this.opt("dr", "resource", "The data resource to process", (Function1<String, BoxedUnit>)new Serializable(this, dr$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dr$1;

                    public final void apply(String v) {
                        this.dr$1.elem = new Some((Object)v);
                    }
                    {
                        this.dr$1 = dr$1;
                    }
                });
                this.opt("lld", "last-loaded", "Delete records from a data resource that where not loade before a date (yyy-MM-dd format)", (Function1<String, BoxedUnit>)new Serializable(this, lastLoadedDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef lastLoadedDate$1;

                    public final void apply(String v) {
                        this.lastLoadedDate$1.elem = new Some((Object)v);
                    }
                    {
                        this.lastLoadedDate$1 = lastLoadedDate$1;
                    }
                });
                this.opt("f", "file", "The file of row keys to delete. Can be an absolute local file path or URL to a file that contains rowkeys or UUIDs.", (Function1<String, BoxedUnit>)new Serializable(this, file$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef file$1;

                    public final void apply(String v) {
                        this.file$1.elem = new Some((Object)v);
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
                this.opt("hdr", "fileHasHeader", "The supplied file has a header", (Function0<BoxedUnit>)new Serializable(this, hasHeader$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef hasHeader$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.hasHeader$1.elem = true;
                    }
                    {
                        this.hasHeader$1 = hasHeader$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            Some deletor;
            Object object = ((Option)query.elem).isEmpty() ? (((Option)dr.elem).isEmpty() || ((Option)lastLoadedDate.elem).isEmpty() ? (((Option)dr.elem).isEmpty() ? (((Option)file.elem).isDefined() ? new Some((Object)new FileDelete((String)((Option)file.elem).get(), hasHeader.elem)) : None$.MODULE$) : new Some((Object)new QueryDelete(new StringBuilder().append((Object)"data_resource_uid:").append(((Option)dr.elem).get()).toString()))) : new Some((Object)new QueryDelete(new StringBuilder().append((Object)"data_resource_uid:").append(((Option)dr.elem).get()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" AND -last_load_date:[", "T00:00:00Z TO *]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)lastLoadedDate.elem).get()}))).toString()))) : (deletor = new Some((Object)new QueryDelete((String)((Option)query.elem).get())));
            if (deletor.isEmpty()) {
                parser.showUsage();
            } else {
                ((RecordDeletor)deletor.get()).deleteFromPersistent();
                ((RecordDeletor)deletor.get()).deleteFromIndex();
            }
        }
    }

    private DeleteRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.occurrenceDAO = Config$.MODULE$.occurrenceDAO();
        this.persistenceManager = Config$.MODULE$.persistenceManager();
    }
}

