/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.parser.EventDate;
import au.org.ala.biocache.processor.EventProcessor$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.DateUtil$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.DatePrecision$;
import au.org.ala.biocache.vocab.Term;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00015\u0011a\"\u0012<f]R\u0004&o\\2fgN|'O\u0003\u0002\u0004\t\u0005I\u0001O]8dKN\u001cxN\u001d\u0006\u0003\u000b\u0019\t\u0001BY5pG\u0006\u001c\u0007.\u001a\u0006\u0003\u000f!\t1!\u00197b\u0015\tI!\"A\u0002pe\u001eT\u0011aC\u0001\u0003CV\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%\u0001&o\\2fgN|'\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011Q\u0003\u0001\u0005\b;\u0001\u0011\r\u0011\"\u0001\u001f\u0003\u0019awnZ4feV\tq\u0004\u0005\u0002!I5\t\u0011E\u0003\u0002#G\u0005)1\u000f\u001c45U*\t\u0011\"\u0003\u0002&C\t1Aj\\4hKJDaa\n\u0001!\u0002\u0013y\u0012a\u00027pO\u001e,'\u000f\t\u0005\u0006S\u0001!\tAK\u0001\u000fm\u0006d\u0017\u000eZ1uK:+XNY3s)\rYC'\u0010\t\u0005\u001f1r\u0013'\u0003\u0002.!\t1A+\u001e9mKJ\u0002\"aD\u0018\n\u0005A\u0002\"aA%oiB\u0011qBM\u0005\u0003gA\u0011qAQ8pY\u0016\fg\u000eC\u00036Q\u0001\u0007a'\u0001\u0004ok6\u0014WM\u001d\t\u0003oir!a\u0004\u001d\n\u0005e\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\t\t\u000byB\u0003\u0019A \u0002\u0003\u0019\u0004Ba\u0004!/c%\u0011\u0011\t\u0005\u0002\n\rVt7\r^5p]FBQa\u0011\u0001\u0005\u0002\u0011\u000bq\u0001\u001d:pG\u0016\u001c8\u000fF\u0003F\u001dB+v\u000bE\u0002\u0010\r\"K!a\u0012\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%cU\"\u0001&\u000b\u0005-#\u0011!B7pI\u0016d\u0017BA'K\u0005A\tV/\u00197jif\f5o]3si&|g\u000eC\u0003P\u0005\u0002\u0007a'\u0001\u0003hk&$\u0007\"B)C\u0001\u0004\u0011\u0016a\u0001:boB\u0011\u0011jU\u0005\u0003)*\u0013!BR;mYJ+7m\u001c:e\u0011\u00151&\t1\u0001S\u0003%\u0001(o\\2fgN,G\rC\u0004Y\u0005B\u0005\t\u0019A-\u0002\u001b1\f7\u000f\u001e)s_\u000e,7o]3e!\ry!LU\u0005\u00037B\u0011aa\u00149uS>t\u0007\"B/\u0001\t\u0003q\u0016!\u0005:v]f+\u0017M\u001d,bY&$\u0017\r^5p]R)qL\u00193gQB)q\u0002\u0019\u001c2]%\u0011\u0011\r\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u000b\rd\u0006\u0019\u0001\u0018\u0002\u000fI\fw/_3be\")Q\r\u0018a\u0001]\u0005Y1-\u001e:sK:$\u0018,Z1s\u0011\u001d9G\f%AA\u00029\n1\u0001Z1z\u0011\u001dIG\f%AA\u00029\nQ!\\8oi\"DQa\u001b\u0001\u0005\u00021\f\u0011\u0003\u001d:pG\u0016\u001c8OR5sgR$\u0015\r^3t)\u0011i\u0007/\u001d:\u0011\u0005=q\u0017BA8\u0011\u0005\u0011)f.\u001b;\t\u000bES\u0007\u0019\u0001*\t\u000bYS\u0007\u0019\u0001*\t\u000bMT\u0007\u0019\u0001;\u0002\u0015\u0005\u001c8/\u001a:uS>t7\u000fE\u0002vu\"k\u0011A\u001e\u0006\u0003ob\fq!\\;uC\ndWM\u0003\u0002z!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m4(aC!se\u0006L()\u001e4gKJDQ! \u0001\u0005\u0002y\f\u0011\u0003\u001d:pG\u0016\u001c8o\u0014;iKJ$\u0015\r^3t)\u0019iw0!\u0001\u0002\u0004!)\u0011\u000b a\u0001%\")a\u000b a\u0001%\")1\u000f a\u0001i\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011\u0001B:lSB$\u0012\"RA\u0006\u0003\u001b\ty!!\u0005\t\r=\u000b)\u00011\u00017\u0011\u0019\t\u0016Q\u0001a\u0001%\"1a+!\u0002A\u0002IC\u0001\u0002WA\u0003!\u0003\u0005\r!\u0017\u0005\b\u0003+\u0001A\u0011AA\f\u00039\u0019\u0007.Z2l!J,7-[:j_:$r!\\A\r\u00037\ti\u0002\u0003\u0004R\u0003'\u0001\rA\u0015\u0005\u0007-\u0006M\u0001\u0019\u0001*\t\rM\f\u0019\u00021\u0001u\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\t1C]3g_Jl\u0017\r\u001e+p!J,7-[:j_:$2\"\\A\u0013\u0003O\tY#a\f\u00024!1a+a\bA\u0002ICq!!\u000b\u0002 \u0001\u0007a'\u0001\u0004g_Jl\u0017\r\u001e\u0005\b\u0003[\ty\u00021\u00012\u0003=1wN]2f\u001dVdG.\u001b4z\t\u0006L\bbBA\u0019\u0003?\u0001\r!M\u0001\u0012M>\u00148-\u001a(vY2Lg-_'p]RD\u0007bBA\u001b\u0003?\u0001\r!M\u0001\u0011M>\u00148-\u001a(vY2Lg-_-fCJD\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u000f\u0002'\u0011\u000b\u0015l\u0018*B\u001d\u001e+u\f\u0015*F\u0007&\u001b\u0016j\u0014(\u0016\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0005Y\u0006twM\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\rY\u0014\u0011\t\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002>\u0005!B)Q-`%\u0006su)R0Q%\u0016\u001b\u0015jU%P\u001d\u0002B\u0011\"!\u0015\u0001\u0005\u0004%\t!a\u000f\u0002+5{e\n\u0016%`%\u0006su)R0Q%\u0016\u001b\u0015jU%P\u001d\"A\u0011Q\u000b\u0001!\u0002\u0013\ti$\u0001\fN\u001f:#\u0006j\u0018*B\u001d\u001e+u\f\u0015*F\u0007&\u001b\u0016j\u0014(!\u0011%\tI\u0006\u0001b\u0001\n\u0003\tY$\u0001\u000bZ\u000b\u0006\u0013vLU!O\u000f\u0016{\u0006KU#D\u0013NKuJ\u0014\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002>\u0005)\u0012,R!S?J\u000bejR#`!J+5)S*J\u001f:\u0003\u0003\"CA1\u0001\t\u0007I\u0011AA\u001e\u00031qu\nV0T+B\u0003F*S#E\u0011!\t)\u0007\u0001Q\u0001\n\u0005u\u0012!\u0004(P)~\u001bV\u000b\u0015)M\u0013\u0016#\u0005\u0005C\u0005\u0002j\u0001\u0011\r\u0011\"\u0001\u0002<\u0005iA)Q-`!J+5)S*J\u001f:C\u0001\"!\u001c\u0001A\u0003%\u0011QH\u0001\u000f\t\u0006Kv\f\u0015*F\u0007&\u001b\u0016j\u0014(!\u0011%\t\t\b\u0001b\u0001\n\u0003\tY$A\bN\u001f:#\u0006j\u0018)S\u000b\u000eK5+S(O\u0011!\t)\b\u0001Q\u0001\n\u0005u\u0012\u0001E'P\u001dRCu\f\u0015*F\u0007&\u001b\u0016j\u0014(!\u0011%\tI\b\u0001b\u0001\n\u0003\tY$\u0001\bZ\u000b\u0006\u0013v\f\u0015*F\u0007&\u001b\u0016j\u0014(\t\u0011\u0005u\u0004\u0001)A\u0005\u0003{\tq\"W#B%~\u0003&+R\"J'&{e\n\t\u0005\b\u0003\u0003\u0003A\u0011AA\u001e\u0003\u001d9W\r\u001e(b[\u0016D\u0011\"!\"\u0001#\u0003%\t%a\"\u0002#A\u0014xnY3tg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\n*\u001a\u0011,a#,\u0005\u00055\u0005\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a&\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a(\u0001#\u0003%\t!!)\u00027I,h.W3beZ\u000bG.\u001b3bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019KK\u0002/\u0003\u0017C\u0011\"a*\u0001#\u0003%\t!!)\u00027I,h.W3beZ\u000bG.\u001b3bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0011%\tY\u000bAI\u0001\n\u0003\n9)\u0001\btW&\u0004H\u0005Z3gCVdG\u000f\n\u001b")
public class EventProcessor
implements Processor {
    private final Logger logger;
    private final String DAY_RANGE_PRECISION;
    private final String MONTH_RANGE_PRECISION;
    private final String YEAR_RANGE_PRECISION;
    private final String NOT_SUPPLIED;
    private final String DAY_PRECISION;
    private final String MONTH_PRECISION;
    private final String YEAR_PRECISION;

    public Logger logger() {
        return this.logger;
    }

    public Tuple2<Object, Object> validateNumber(String number, Function1<Object, Object> f) {
        Tuple2.mcIZ.sp sp2;
        try {
            if (number == null) {
                sp2 = new Tuple2.mcIZ.sp(-1, false);
            } else {
                int parsedNumber = new StringOps(Predef$.MODULE$.augmentString(number)).toInt();
                sp2 = new Tuple2.mcIZ.sp(parsedNumber, f.apply$mcZI$sp(parsedNumber));
            }
        }
        catch (NumberFormatException numberFormatException) {
            sp2 = new Tuple2.mcIZ.sp(-1, false);
        }
        return sp2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        boolean dateComplete;
        boolean addPassedInvalidCollectionDate;
        None$ date;
        ArrayBuffer assertions;
        block40: {
            String comment;
            block41: {
                Option<EventDate> parsedDate;
                Option<EventDate> parsedDate2;
                Option<EventDate> parsedDate3;
                boolean validDayMonthYear;
                BoxedUnit boxedUnit;
                Tuple2.mcIZ.sp sp2;
                Tuple2.mcIZ.sp sp3;
                Tuple2.mcIZ.sp sp4;
                assertions = new ArrayBuffer();
                Object object = !(raw.event().day() != null && !raw.event().day().isEmpty() || raw.event().month() != null && !raw.event().month().isEmpty() || raw.event().year() != null && !raw.event().year().isEmpty() || raw.event().eventDate() != null && !raw.event().eventDate().isEmpty() || raw.event().eventDateEnd() != null && !raw.event().eventDateEnd().isEmpty() || raw.event().verbatimEventDate() != null && !raw.event().verbatimEventDate().isEmpty()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COLLECTION_DATE(), "No date information supplied")) : BoxedUnit.UNIT;
                date = None$.MODULE$;
                int currentYear = DateUtil$.MODULE$.getCurrentYear();
                comment = "";
                addPassedInvalidCollectionDate = true;
                dateComplete = false;
                Tuple2<Object, Object> tuple2 = this.validateNumber(raw.event().year(), (Function1<Object, Object>)new $anonfun$1(this, currentYear));
                if (tuple2 == null) throw new MatchError(tuple2);
                int year = tuple2._1$mcI$sp();
                boolean validYear = tuple2._2$mcZ$sp();
                Tuple2.mcIZ.sp sp5 = sp4 = new Tuple2.mcIZ.sp(year, validYear);
                int year2 = sp5._1$mcI$sp();
                boolean validYear2 = sp5._2$mcZ$sp();
                Tuple2<Object, Object> tuple22 = this.validateNumber(raw.event().month(), (Function1<Object, Object>)new $anonfun$2(this));
                if (tuple22 == null) throw new MatchError(tuple22);
                int month = tuple22._1$mcI$sp();
                boolean validMonth = tuple22._2$mcZ$sp();
                Tuple2.mcIZ.sp sp6 = sp3 = new Tuple2.mcIZ.sp(month, validMonth);
                int month2 = sp6._1$mcI$sp();
                boolean validMonth2 = sp6._2$mcZ$sp();
                Tuple2<Object, Object> tuple23 = this.validateNumber(raw.event().day(), (Function1<Object, Object>)new $anonfun$3(this));
                if (tuple23 == null) throw new MatchError(tuple23);
                int day = tuple23._1$mcI$sp();
                boolean validDay = tuple23._2$mcZ$sp();
                Tuple2.mcIZ.sp sp7 = sp2 = new Tuple2.mcIZ.sp(day, validDay);
                int day2 = sp7._1$mcI$sp();
                boolean validDay2 = sp7._2$mcZ$sp();
                if (!validMonth2 && StringHelper$.MODULE$.string2helper(raw.event().month()).isInt() && StringHelper$.MODULE$.string2helper(raw.event().day()).isInt()) {
                    int monthValue = new StringOps(Predef$.MODULE$.augmentString(raw.event().month())).toInt();
                    int dayValue = new StringOps(Predef$.MODULE$.augmentString(raw.event().day())).toInt();
                    if (monthValue > 12 && dayValue < 12) {
                        month2 = dayValue;
                        day2 = monthValue;
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DAY_MONTH_TRANSPOSED(), "Assume day and month transposed"));
                        validMonth2 = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Invalid month supplied"));
                        addPassedInvalidCollectionDate = false;
                        boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DAY_MONTH_TRANSPOSED(), AssertionStatus$.MODULE$.PASSED()));
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (day2 == 0 || day2 > 31) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Invalid day supplied"));
                    addPassedInvalidCollectionDate = false;
                }
                if (year2 > 0) {
                    Tuple3 tuple3;
                    Tuple3<String, Object, Object> tuple32 = this.runYearValidation(year2, currentYear, day2, month2);
                    if (tuple32 == null) throw new MatchError(tuple32);
                    String newComment = (String)tuple32._1();
                    boolean newValidYear = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
                    int newYear = BoxesRunTime.unboxToInt((Object)tuple32._3());
                    Tuple3 tuple33 = tuple3 = new Tuple3((Object)newComment, (Object)BoxesRunTime.boxToBoolean((boolean)newValidYear), (Object)BoxesRunTime.boxToInteger((int)newYear));
                    String newComment2 = (String)tuple33._1();
                    boolean newValidYear2 = BoxesRunTime.unboxToBoolean((Object)tuple33._2());
                    int newYear2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
                    comment = newComment2;
                    validYear2 = newValidYear2;
                    year2 = newYear2;
                    if (StringUtils.isNotEmpty((String)comment)) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), comment));
                        addPassedInvalidCollectionDate = false;
                    }
                }
                boolean bl = validDayMonthYear = validYear2 && validDay2 && validMonth2;
                if (validDayMonthYear) {
                    try {
                        GregorianCalendar calendar = new GregorianCalendar(year2, month2 - 1, day2);
                        calendar.setLenient(false);
                        date = new Some((Object)calendar.getTime());
                        dateComplete = true;
                    }
                    catch (Exception exception) {
                        validDayMonthYear = false;
                        comment = "Invalid year, day, month";
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), comment));
                        addPassedInvalidCollectionDate = false;
                    }
                }
                if (validYear2) {
                    processed.event().year_$eq(((Object)BoxesRunTime.boxToInteger((int)year2)).toString());
                }
                if (validMonth2) {
                    processed.event().month_$eq(String.format("%02d", Predef$.MODULE$.int2Integer(month2)));
                }
                if (validDay2) {
                    processed.event().day_$eq(((Object)BoxesRunTime.boxToInteger((int)day2)).toString());
                }
                if (!date.isEmpty()) {
                    processed.event().eventDate_$eq(DateFormatUtils.format((Date)((Date)date.get()), (String)"yyyy-MM-dd"));
                }
                if (date.isEmpty() && raw.event().eventDate() != null && !raw.event().eventDate().isEmpty() && !(parsedDate3 = DateParser$.MODULE$.parseDate(raw.event().eventDate(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isEmpty()) {
                    date = new Some((Object)((EventDate)parsedDate3.get()).parsedStartDate());
                    processed.event().eventDate_$eq(((EventDate)parsedDate3.get()).startDate());
                    if (!((EventDate)parsedDate3.get()).endDate().equals(((EventDate)parsedDate3.get()).startDate())) {
                        processed.event().eventDateEnd_$eq(((EventDate)parsedDate3.get()).endDate());
                    }
                    processed.event().day_$eq(((EventDate)parsedDate3.get()).startDay());
                    processed.event().month_$eq(((EventDate)parsedDate3.get()).startMonth());
                    String string = ((EventDate)parsedDate3.get()).startYear();
                    String string2 = "";
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        Tuple3 tuple3;
                        String string3 = ((EventDate)parsedDate3.get()).startDay();
                        String string4 = "";
                        String string5 = ((EventDate)parsedDate3.get()).startMonth();
                        String string6 = "";
                        Tuple3<String, Object, Object> tuple34 = this.runYearValidation(new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate3.get()).startYear())).toInt(), currentYear, !(string3 != null ? !string3.equals(string4) : string4 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate3.get()).startDay())).toInt(), !(string5 != null ? !string5.equals(string6) : string6 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate3.get()).startMonth())).toInt());
                        if (tuple34 == null) throw new MatchError(tuple34);
                        String newComment = (String)tuple34._1();
                        boolean isValidYear = BoxesRunTime.unboxToBoolean((Object)tuple34._2());
                        int newYear = BoxesRunTime.unboxToInt((Object)tuple34._3());
                        Tuple3 tuple35 = tuple3 = new Tuple3((Object)newComment, (Object)BoxesRunTime.boxToBoolean((boolean)isValidYear), (Object)BoxesRunTime.boxToInteger((int)newYear));
                        String newComment3 = (String)tuple35._1();
                        boolean isValidYear2 = BoxesRunTime.unboxToBoolean((Object)tuple35._2());
                        int newYear3 = BoxesRunTime.unboxToInt((Object)tuple35._3());
                        comment = newComment3;
                        validYear2 = isValidYear2;
                        year2 = newYear3;
                        if (isValidYear2) {
                            processed.event().year_$eq(((Object)BoxesRunTime.boxToInteger((int)newYear3)).toString());
                            String string7 = processed.event().day();
                            String string8 = "";
                            if (string7 == null ? string8 != null : !string7.equals(string8)) {
                                String string9 = processed.event().month();
                                String string10 = "";
                                if (string9 == null ? string10 != null : !string9.equals(string10)) {
                                    processed.event().eventDate_$eq(new StringBuilder().append((Object)processed.event().year()).append((Object)"-").append((Object)processed.event().month()).append((Object)"-").append((Object)processed.event().day()).toString());
                                }
                            }
                        } else {
                            processed.event().eventDate_$eq(null);
                            processed.event().year_$eq(null);
                        }
                    }
                    if (StringUtils.isNotBlank((String)((EventDate)parsedDate3.get()).startDate())) {
                        dateComplete = true;
                    }
                    if (DateUtil$.MODULE$.isFutureDate((EventDate)parsedDate3.get())) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Future date supplied"));
                        addPassedInvalidCollectionDate = false;
                    }
                    if (!((EventDate)parsedDate3.get()).endDate().equals(((EventDate)parsedDate3.get()).startDate())) {
                        processed.event().eventDateEnd_$eq(((EventDate)parsedDate3.get()).endDate());
                    }
                }
                if (StringUtils.isNotEmpty((String)raw.event().eventDateEnd()) && !(parsedDate2 = DateParser$.MODULE$.parseDate(raw.event().eventDateEnd(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isEmpty()) {
                    processed.event().eventDateEnd_$eq(((EventDate)parsedDate2.get()).startDate());
                }
                if (date.isEmpty() && raw.event().verbatimEventDate() != null && !raw.event().verbatimEventDate().isEmpty()) {
                    Option<EventDate> parsedDate4 = DateParser$.MODULE$.parseDate(raw.event().verbatimEventDate(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3());
                    if (!parsedDate4.isEmpty()) {
                        processed.event().eventDate_$eq(((EventDate)parsedDate4.get()).startDate());
                        if (!((EventDate)parsedDate4.get()).endDate().equals(((EventDate)parsedDate4.get()).startDate())) {
                            processed.event().eventDateEnd_$eq(((EventDate)parsedDate4.get()).endDate());
                        }
                        processed.event().day_$eq(((EventDate)parsedDate4.get()).startDay());
                        processed.event().month_$eq(((EventDate)parsedDate4.get()).startMonth());
                        processed.event().year_$eq(((EventDate)parsedDate4.get()).startYear());
                        String string = ((EventDate)parsedDate4.get()).startYear();
                        String string11 = "";
                        if (string == null ? string11 != null : !string.equals(string11)) {
                            Tuple3 tuple3;
                            String string12 = ((EventDate)parsedDate4.get()).startDay();
                            String string13 = "";
                            String string14 = ((EventDate)parsedDate4.get()).startMonth();
                            String string15 = "";
                            Tuple3<String, Object, Object> tuple36 = this.runYearValidation(new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate4.get()).startYear())).toInt(), currentYear, !(string12 != null ? !string12.equals(string13) : string13 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate4.get()).startDay())).toInt(), !(string14 != null ? !string14.equals(string15) : string15 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(((EventDate)parsedDate4.get()).startMonth())).toInt());
                            if (tuple36 == null) throw new MatchError(tuple36);
                            String newComment = (String)tuple36._1();
                            boolean isValidYear = BoxesRunTime.unboxToBoolean((Object)tuple36._2());
                            int newYear = BoxesRunTime.unboxToInt((Object)tuple36._3());
                            Tuple3 tuple37 = tuple3 = new Tuple3((Object)newComment, (Object)BoxesRunTime.boxToBoolean((boolean)isValidYear), (Object)BoxesRunTime.boxToInteger((int)newYear));
                            String newComment4 = (String)tuple37._1();
                            boolean isValidYear3 = BoxesRunTime.unboxToBoolean((Object)tuple37._2());
                            int newYear4 = BoxesRunTime.unboxToInt((Object)tuple37._3());
                            comment = newComment4;
                            validYear2 = isValidYear3;
                            year2 = newYear4;
                            if (isValidYear3) {
                                processed.event().year_$eq(((Object)BoxesRunTime.boxToInteger((int)newYear4)).toString());
                                String string16 = processed.event().day();
                                String string17 = "";
                                if (string16 == null ? string17 != null : !string16.equals(string17)) {
                                    String string18 = processed.event().month();
                                    String string19 = "";
                                    if (string18 == null ? string19 != null : !string18.equals(string19)) {
                                        processed.event().eventDate_$eq(new StringBuilder().append((Object)processed.event().year()).append((Object)"-").append((Object)processed.event().month()).append((Object)"-").append((Object)processed.event().day()).toString());
                                    }
                                }
                            } else {
                                processed.event().eventDate_$eq(null);
                                processed.event().year_$eq(null);
                            }
                        }
                        dateComplete = StringUtils.isNotBlank((String)((EventDate)parsedDate4.get()).startDate());
                    }
                } else if (!(processed.event().eventDateEnd() != null && !processed.event().eventDateEnd().isEmpty() || raw.event().verbatimEventDate() == null || raw.event().verbatimEventDate().isEmpty() || (parsedDate = DateParser$.MODULE$.parseDate(raw.event().verbatimEventDate(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isEmpty() || ((EventDate)parsedDate.get()).endDate().equals(((EventDate)parsedDate.get()).startDate()) || ((EventDate)parsedDate.get()).endDate().equals(((EventDate)parsedDate.get()).startDate()))) {
                    processed.event().eventDateEnd_$eq(((EventDate)parsedDate.get()).endDate());
                }
                if (validYear2) break block40;
                if (processed.event().eventDate() == null) break block41;
                String string = processed.event().eventDate();
                String string20 = "";
                if (!(string == null ? string20 != null : !string.equals(string20))) break block41;
                String string21 = comment;
                String string22 = "";
                if (!(string21 == null ? string22 != null : !string21.equals(string22))) break block40;
            }
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), comment));
            addPassedInvalidCollectionDate = false;
        }
        if (!date.isEmpty() && ((Date)date.get()).after(new Date())) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), "Future date supplied"));
            addPassedInvalidCollectionDate = false;
        }
        Object object = addPassedInvalidCollectionDate ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE(), AssertionStatus$.MODULE$.PASSED())) : BoxedUnit.UNIT;
        ArrayBuffer arrayBuffer = dateComplete ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INCOMPLETE_COLLECTION_DATE(), AssertionStatus$.MODULE$.PASSED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INCOMPLETE_COLLECTION_DATE(), "The supplied collection date is not complete"));
        this.processOtherDates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processFirstDates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.checkPrecision(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public Tuple3<String, Object, Object> runYearValidation(int rawyear, int currentYear, int day, int month) {
        boolean validYear = true;
        String comment = "";
        int year = rawyear;
        if (year > 0) {
            if (year < 100) {
                Date date;
                if (year > currentYear % 100) {
                    year += (currentYear / 100 - 1) * 100;
                } else if (day != 0 && month != 0 && (date = DateUtils.parseDate((String)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)(year += currentYear / 100 * 100))).toString()).append((Object)String.format("%02d", Predef$.MODULE$.int2Integer(month))).append((Object)((Object)BoxesRunTime.boxToInteger((int)day)).toString()).toString(), (String[])((String[])((Object[])new String[]{"yyyyMMdd"})))).after(new Date())) {
                    year -= 100;
                }
            } else if (year >= 100 && year < 1600) {
                year = -1;
                validYear = false;
                comment = "Year out of range";
            } else if (year > DateUtil$.MODULE$.getCurrentYear()) {
                year = -1;
                validYear = false;
                comment = "Future year supplied";
            } else if (year == 1788 && month == 1 && day == 26) {
                validYear = false;
                comment = "First Fleet arrival implies a null date";
            }
        }
        return new Tuple3((Object)comment, (Object)BoxesRunTime.boxToBoolean((boolean)validYear), (Object)BoxesRunTime.boxToInteger((int)year));
    }

    public int runYearValidation$default$3() {
        return 0;
    }

    public int runYearValidation$default$4() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void processFirstDates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        block5: {
            block7: {
                Tuple2.mcIZ.sp sp2;
                block6: {
                    block4: {
                        String string = processed.event().day();
                        String string2 = "1";
                        if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                        String string3 = processed.event().day();
                        String string4 = "01";
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
                    }
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_MONTH()));
                    String string = processed.event().month();
                    String string5 = "01";
                    if (!(string == null ? string5 != null : !string.equals(string5))) break block6;
                    String string6 = processed.event().month();
                    String string7 = "1";
                    if (string6 != null ? !string6.equals(string7) : string7 != null) break block7;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_YEAR()));
                if (processed.event().year() == null) return;
                Tuple2<Object, Object> tuple2 = this.validateNumber(processed.event().year(), (Function1<Object, Object>)new $anonfun$4(this));
                if (tuple2 == null) throw new MatchError(tuple2);
                int year = tuple2._1$mcI$sp();
                boolean validYear = tuple2._2$mcZ$sp();
                Tuple2.mcIZ.sp sp3 = sp2 = new Tuple2.mcIZ.sp(year, validYear);
                int year2 = sp3._1$mcI$sp();
                boolean validYear2 = sp3._2$mcZ$sp();
                if (validYear2 && year2 % 100 == 0) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_CENTURY()));
                    return;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_CENTURY(), AssertionStatus$.MODULE$.PASSED()));
                return;
            }
            if (processed.event().month() == null) return;
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_YEAR(), AssertionStatus$.MODULE$.PASSED()));
            return;
        }
        if (processed.event().day() == null) return;
        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.FIRST_OF_MONTH(), AssertionStatus$.MODULE$.PASSED()));
    }

    public void processOtherDates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Option<Date> eventDate;
        Option<EventDate> parsedDate;
        Option<EventDate> parsedDate2;
        Option<EventDate> parsedDate3;
        if (raw.occurrence().modified() != null && (parsedDate3 = DateParser$.MODULE$.parseDate(raw.occurrence().modified(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isDefined()) {
            processed.occurrence().modified_$eq(((EventDate)parsedDate3.get()).startDate());
        }
        if (raw.identification().dateIdentified() != null && (parsedDate2 = DateParser$.MODULE$.parseDate(raw.identification().dateIdentified(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isDefined()) {
            processed.identification().dateIdentified_$eq(((EventDate)parsedDate2.get()).startDate());
        }
        if ((raw.location().georeferencedDate() != null || raw.miscProperties().containsKey("georeferencedDate")) && (parsedDate = DateParser$.MODULE$.parseDate(this.rawdate$1(raw), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3())).isDefined()) {
            processed.location().georeferencedDate_$eq(((EventDate)parsedDate.get()).startDate());
        }
        if (StringUtils.isNotBlank((String)processed.event().eventDate()) && (eventDate = DateParser$.MODULE$.parseStringToDate(processed.event().eventDate())).isDefined()) {
            Object object = StringUtils.isNotBlank((String)processed.identification().dateIdentified()) ? (((Date)DateParser$.MODULE$.parseStringToDate(processed.identification().dateIdentified()).get()).before((Date)eventDate.get()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ID_PRE_OCCURRENCE(), "The records was identified before it was collected")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ID_PRE_OCCURRENCE(), AssertionStatus$.MODULE$.PASSED()))) : BoxedUnit.UNIT;
            if (StringUtils.isNotBlank((String)processed.location().georeferencedDate())) {
                if (((Date)DateParser$.MODULE$.parseStringToDate(processed.location().georeferencedDate()).get()).after((Date)eventDate.get())) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEOREFERENCE_POST_OCCURRENCE(), "The record was not georeferenced when it was collected"));
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEOREFERENCE_POST_OCCURRENCE(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
        }
    }

    @Override
    public QualityAssertion[] skip(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions = new ArrayBuffer();
        if (lastProcessed.isDefined()) {
            assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])((FullRecord)lastProcessed.get()).findAssertions(new int[]{AssertionCodes$.MODULE$.GEOREFERENCE_POST_OCCURRENCE().code(), AssertionCodes$.MODULE$.ID_PRE_OCCURRENCE().code(), AssertionCodes$.MODULE$.MISSING_COLLECTION_DATE().code(), AssertionCodes$.MODULE$.DAY_MONTH_TRANSPOSED().code(), AssertionCodes$.MODULE$.INVALID_COLLECTION_DATE().code(), AssertionCodes$.MODULE$.INCOMPLETE_COLLECTION_DATE().code(), AssertionCodes$.MODULE$.FIRST_OF_MONTH().code(), AssertionCodes$.MODULE$.FIRST_OF_YEAR().code(), AssertionCodes$.MODULE$.FIRST_OF_CENTURY().code()})));
            processed.event_$eq(((FullRecord)lastProcessed.get()).event());
            processed.occurrence().modified_$eq(((FullRecord)lastProcessed.get()).occurrence().modified());
            processed.identification().dateIdentified_$eq(((FullRecord)lastProcessed.get()).identification().dateIdentified());
            processed.location().georeferencedDate_$eq(((FullRecord)lastProcessed.get()).location().georeferencedDate());
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> skip$default$4() {
        return None$.MODULE$;
    }

    public void checkPrecision(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (StringUtils.isNotBlank((String)raw.event().datePrecision()) && StringUtils.isNotBlank((String)processed.event().eventDate())) {
            Option<Term> matchedTerm = DatePrecision$.MODULE$.matchTerm(raw.event().datePrecision());
            if (!matchedTerm.isEmpty()) {
                Term term = (Term)matchedTerm.get();
                processed.event().datePrecision_$eq(term.canonical());
                if (term.canonical().equalsIgnoreCase(this.DAY_PRECISION())) {
                    this.reformatToPrecision(processed, "yyyy-MM-dd", false, false, false);
                } else if (term.canonical().equalsIgnoreCase(this.MONTH_PRECISION())) {
                    this.reformatToPrecision(processed, "yyyy-MM", true, false, false);
                } else if (term.canonical().equalsIgnoreCase(this.YEAR_PRECISION())) {
                    this.reformatToPrecision(processed, "yyyy", true, true, false);
                } else if (term.canonical().equalsIgnoreCase(this.DAY_RANGE_PRECISION())) {
                    this.reformatToPrecision(processed, "yyyy-MM", false, false, false);
                } else if (term.canonical().equalsIgnoreCase(this.MONTH_RANGE_PRECISION())) {
                    this.reformatToPrecision(processed, "yyyy-MM", true, false, false);
                } else if (term.canonical().equalsIgnoreCase(this.YEAR_RANGE_PRECISION())) {
                    this.reformatToPrecision(processed, "yyyy", true, true, true);
                } else {
                    this.reformatToPrecision(processed, "yyyy-MM-dd", false, false, false);
                }
            }
        } else {
            this.reformatToPrecision(processed, "yyyy-MM-dd", false, false, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void reformatToPrecision(FullRecord processed, String format, boolean forceNullifyDay, boolean forceNullifyMonth, boolean forceNullifyYear) {
        block29: {
            block31: {
                block34: {
                    block33: {
                        block32: {
                            block30: {
                                startDate = DateParser$.MODULE$.parseDate(processed.event().eventDate(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3());
                                endDate = DateParser$.MODULE$.parseDate(processed.event().eventDateEnd(), DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3());
                                if (!startDate.isEmpty() && ((EventDate)startDate.get()).singleDate() && ((EventDate)startDate.get()).parsedStartDate() != null) {
                                    try {
                                        processed.event().eventDate_$eq(DateFormatUtils.format((Date)((EventDate)startDate.get()).parsedStartDate(), (String)format));
                                    }
                                    catch (Exception var8_8) {
                                        this.logger().error("Problem reformatting date to new precision");
                                    }
                                }
                                if (!endDate.isEmpty() && ((EventDate)endDate.get()).singleDate() && ((EventDate)endDate.get()).parsedStartDate() != null) {
                                    try {
                                        processed.event().eventDateEnd_$eq(DateFormatUtils.format((Date)((EventDate)endDate.get()).parsedStartDate(), (String)format));
                                    }
                                    catch (Exception var9_9) {
                                        this.logger().error("Problem reformatting date to new precision");
                                    }
                                }
                                if (forceNullifyDay) {
                                    processed.event().day_$eq(null);
                                }
                                if (forceNullifyMonth) {
                                    processed.event().month_$eq(null);
                                }
                                if (forceNullifyYear) {
                                    processed.event().year_$eq(null);
                                }
                                determinedDatePrecision = "";
                                if (!startDate.isEmpty() && !endDate.isEmpty()) {
                                    if (StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startDay()) && StringUtils.isNotEmpty((String)((EventDate)endDate.get()).startDay())) {
                                        v0 = ((EventDate)startDate.get()).startDay();
                                        var11_11 = ((EventDate)endDate.get()).startDay();
                                        if (v0 == null ? var11_11 != null : v0.equals(var11_11) == false) {
                                            processed.event().day_$eq(null);
                                        }
                                    }
                                    if (StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startMonth()) && StringUtils.isNotEmpty((String)((EventDate)endDate.get()).startMonth())) {
                                        v1 = ((EventDate)startDate.get()).startMonth();
                                        var12_12 = ((EventDate)endDate.get()).startMonth();
                                        if (v1 == null ? var12_12 != null : v1.equals(var12_12) == false) {
                                            processed.event().month_$eq(null);
                                            processed.event().day_$eq(null);
                                        }
                                    }
                                    if (StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startYear()) && StringUtils.isNotEmpty((String)((EventDate)endDate.get()).startYear())) {
                                        v2 = ((EventDate)startDate.get()).startYear();
                                        var13_13 = ((EventDate)endDate.get()).startYear();
                                        if (v2 == null ? var13_13 != null : v2.equals(var13_13) == false) {
                                            processed.event().year_$eq(null);
                                            processed.event().month_$eq(null);
                                            processed.event().day_$eq(null);
                                        }
                                    }
                                }
                                if (!StringUtils.isEmpty((String)processed.event().datePrecision())) break block29;
                                if (!startDate.isEmpty() && !endDate.isEmpty()) break block30;
                                if (startDate.isEmpty()) {
                                    determinedDatePrecision = this.NOT_SUPPLIED();
                                } else {
                                    determinedDatePrecision = this.DAY_PRECISION();
                                    if (processed.event().day() == null && processed.event().month() != null && processed.event().year() != null) {
                                        determinedDatePrecision = this.MONTH_PRECISION();
                                    }
                                    if (processed.event().day() == null && processed.event().month() == null && processed.event().year() != null) {
                                        determinedDatePrecision = this.YEAR_PRECISION();
                                    }
                                }
                                break block31;
                            }
                            determinedDatePrecision = this.DAY_RANGE_PRECISION();
                            v3 = ((EventDate)startDate.get()).startDay();
                            var14_14 = ((EventDate)endDate.get()).startDay();
                            if (!(v3 != null ? v3.equals(var14_14) == false : var14_14 != null) && StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startDay())) {
                                v4 = ((EventDate)startDate.get()).startMonth();
                                var15_15 = ((EventDate)endDate.get()).startMonth();
                                if (!(v4 != null ? v4.equals(var15_15) == false : var15_15 != null) && StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startMonth())) {
                                    v5 = ((EventDate)startDate.get()).startYear();
                                    var16_16 = ((EventDate)endDate.get()).startYear();
                                    if (!(v5 != null ? v5.equals(var16_16) == false : var16_16 != null) && StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startYear())) {
                                        determinedDatePrecision = this.DAY_PRECISION();
                                    }
                                }
                            }
                            v6 = ((EventDate)startDate.get()).startDay();
                            var17_17 = ((EventDate)endDate.get()).startDay();
                            if (v6 != null ? v6.equals(var17_17) == false : var17_17 != null) break block32;
                            if (!StringUtils.isEmpty((String)((EventDate)startDate.get()).startDay()) || !StringUtils.isEmpty((String)((EventDate)endDate.get()).startDay())) ** GOTO lbl-1000
                        }
                        v7 = ((EventDate)startDate.get()).startMonth();
                        var18_18 = ((EventDate)endDate.get()).startMonth();
                        if ((v7 != null ? v7.equals(var18_18) == false : var18_18 != null) || !StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startMonth())) ** GOTO lbl-1000
                        v8 = ((EventDate)startDate.get()).startYear();
                        var19_19 = ((EventDate)endDate.get()).startYear();
                        if (!(v8 != null ? v8.equals(var19_19) == false : var19_19 != null) && StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startYear())) {
                            determinedDatePrecision = this.MONTH_PRECISION();
                        } else if (StringUtils.isEmpty((String)((EventDate)startDate.get()).startDay()) && StringUtils.isEmpty((String)((EventDate)endDate.get()).startDay())) {
                            determinedDatePrecision = this.MONTH_RANGE_PRECISION();
                        }
                        v9 = ((EventDate)startDate.get()).startDay();
                        var20_20 = ((EventDate)endDate.get()).startDay();
                        if (v9 != null ? v9.equals(var20_20) == false : var20_20 != null) break block33;
                        if (!StringUtils.isEmpty((String)((EventDate)startDate.get()).startDay()) || !StringUtils.isEmpty((String)((EventDate)endDate.get()).startDay())) ** GOTO lbl-1000
                    }
                    v10 = ((EventDate)startDate.get()).startMonth();
                    var21_21 = ((EventDate)endDate.get()).startMonth();
                    if (v10 != null ? v10.equals(var21_21) == false : var21_21 != null) break block34;
                    if (!StringUtils.isEmpty((String)((EventDate)startDate.get()).startMonth()) || !StringUtils.isEmpty((String)((EventDate)endDate.get()).startMonth())) ** GOTO lbl-1000
                }
                v11 = ((EventDate)startDate.get()).startYear();
                var22_22 = ((EventDate)endDate.get()).startYear();
                if (!(v11 != null ? v11.equals(var22_22) == false : var22_22 != null) && StringUtils.isNotEmpty((String)((EventDate)startDate.get()).startYear())) {
                    determinedDatePrecision = this.YEAR_PRECISION();
                } else if (StringUtils.isEmpty((String)((EventDate)startDate.get()).startMonth()) && StringUtils.isEmpty((String)((EventDate)endDate.get()).startMonth())) {
                    determinedDatePrecision = this.YEAR_RANGE_PRECISION();
                }
            }
            processed.event().datePrecision_$eq(determinedDatePrecision);
        }
    }

    public String DAY_RANGE_PRECISION() {
        return this.DAY_RANGE_PRECISION;
    }

    public String MONTH_RANGE_PRECISION() {
        return this.MONTH_RANGE_PRECISION;
    }

    public String YEAR_RANGE_PRECISION() {
        return this.YEAR_RANGE_PRECISION;
    }

    public String NOT_SUPPLIED() {
        return this.NOT_SUPPLIED;
    }

    public String DAY_PRECISION() {
        return this.DAY_PRECISION;
    }

    public String MONTH_PRECISION() {
        return this.MONTH_PRECISION;
    }

    public String YEAR_PRECISION() {
        return this.YEAR_PRECISION;
    }

    @Override
    public String getName() {
        return "event";
    }

    private final String rawdate$1(FullRecord raw$1) {
        return raw$1.location().georeferencedDate() == null ? raw$1.miscProperties().get("georeferencedDate") : raw$1.location().georeferencedDate();
    }

    public EventProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"EventProcessor");
        this.DAY_RANGE_PRECISION = "Day Range";
        this.MONTH_RANGE_PRECISION = "Month Range";
        this.YEAR_RANGE_PRECISION = "Year Range";
        this.NOT_SUPPLIED = "Not Supplied";
        this.DAY_PRECISION = "Day";
        this.MONTH_PRECISION = "Month";
        this.YEAR_PRECISION = "Year";
    }
}

