/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.util.GISPoint;
import au.org.ala.biocache.util.GISPoint$;
import au.org.ala.biocache.util.GISUtil$;
import au.org.ala.biocache.util.GridRef;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.geotools.referencing.CRS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class GridUtil$ {
    public static final GridUtil$ MODULE$;
    private final Logger logger;
    private final Object lock;
    private final Cache<String, Option<GISPoint>> lru;
    private final Regex osGridRefNoEastingNorthing;
    private final Regex osGridRefRegex1Number;
    private final Regex osGridRef2kRegex;
    private final Regex osGridRefRegex;
    private final Regex osGridRefWithQuadRegex;
    private final char[] irishGridletterscodes;
    private final String irishGridlettersFlattened;
    private final Regex irishGridRefNoEastingNorthing;
    private final Regex irishGridRefRegex1Number;
    private final Regex irishGridRef2kRegex;
    private final Regex irishGridRefRegex;
    private final Regex irishGridRefWithQuadRegex;
    private final char[] tetradLetters;
    private final String IRISH_CRS;
    private final String OSGB_CRS;
    private Map<String, String> crsEpsgCodesMap;
    private Map<String, String> zoneEpsgCodesMap;
    private volatile byte bitmap$0;

    static {
        new GridUtil$();
    }

    private Map crsEpsgCodesMap$lzycompute() {
        GridUtil$ gridUtil$ = this;
        synchronized (gridUtil$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/crsEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$1;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$1.elem = ((Map)this.valuesMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$1 = valuesMap$1;
                    }
                });
                this.crsEpsgCodesMap = (Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.crsEpsgCodesMap;
        }
    }

    private Map zoneEpsgCodesMap$lzycompute() {
        GridUtil$ gridUtil$ = this;
        synchronized (gridUtil$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/zoneEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$2;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$2.elem = ((Map)this.valuesMap$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$2 = valuesMap$2;
                    }
                });
                this.zoneEpsgCodesMap = (Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.zoneEpsgCodesMap;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    private Object lock() {
        return this.lock;
    }

    public Cache<String, Option<GISPoint>> lru() {
        return this.lru;
    }

    public Regex osGridRefNoEastingNorthing() {
        return this.osGridRefNoEastingNorthing;
    }

    public Regex osGridRefRegex1Number() {
        return this.osGridRefRegex1Number;
    }

    public Regex osGridRef2kRegex() {
        return this.osGridRef2kRegex;
    }

    public Regex osGridRefRegex() {
        return this.osGridRefRegex;
    }

    public Regex osGridRefWithQuadRegex() {
        return this.osGridRefWithQuadRegex;
    }

    public char[] irishGridletterscodes() {
        return this.irishGridletterscodes;
    }

    public String irishGridlettersFlattened() {
        return this.irishGridlettersFlattened;
    }

    public Regex irishGridRefNoEastingNorthing() {
        return this.irishGridRefNoEastingNorthing;
    }

    public Regex irishGridRefRegex1Number() {
        return this.irishGridRefRegex1Number;
    }

    public Regex irishGridRef2kRegex() {
        return this.irishGridRef2kRegex;
    }

    public Regex irishGridRefRegex() {
        return this.irishGridRefRegex;
    }

    public Regex irishGridRefWithQuadRegex() {
        return this.irishGridRefWithQuadRegex;
    }

    public char[] tetradLetters() {
        return this.tetradLetters;
    }

    public String IRISH_CRS() {
        return this.IRISH_CRS;
    }

    public String OSGB_CRS() {
        return this.OSGB_CRS;
    }

    public Map<String, String> crsEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.crsEpsgCodesMap$lzycompute() : this.crsEpsgCodesMap;
    }

    public Map<String, String> zoneEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.zoneEpsgCodesMap$lzycompute() : this.zoneEpsgCodesMap;
    }

    public Option<Object> getCoordinateUncertaintyFromGridRef(int noOfNumericalDigits, int noOfSecondaryAlphaChars) {
        Some some;
        int n;
        int n2 = noOfNumericalDigits;
        switch (n2) {
            default: {
                return None$.MODULE$;
            }
            case 0: {
                n = 100000;
                break;
            }
            case 2: {
                n = 10000;
                break;
            }
            case 4: {
                n = 1000;
                break;
            }
            case 6: {
                n = 100;
                break;
            }
            case 8: {
                n = 10;
                break;
            }
            case 10: {
                n = 1;
            }
        }
        int accuracy = n;
        int n3 = noOfSecondaryAlphaChars;
        switch (n3) {
            default: {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)accuracy));
                break;
            }
            case 1: {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)(accuracy / 5)));
                break;
            }
            case 2: {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)(accuracy / 2)));
            }
        }
        return some;
    }

    public Option<String> convertReferenceToResolution(String gridReference, String uncertaintyString) {
        Object object;
        try {
            String ref;
            java.util.Map<String, String> gridRefs = this.getGridRefAsResolutions(gridReference);
            int uncertainty = new StringOps(Predef$.MODULE$.augmentString(uncertaintyString)).toInt();
            String[] gridRefSeq = (String[])((Object[])new String[]{(String)JavaConversions$.MODULE$.mapAsScalaMap(gridRefs).getOrElse((Object)"grid_ref_100000", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), (String)JavaConversions$.MODULE$.mapAsScalaMap(gridRefs).getOrElse((Object)"grid_ref_10000", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), (String)JavaConversions$.MODULE$.mapAsScalaMap(gridRefs).getOrElse((Object)"grid_ref_2000", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), (String)JavaConversions$.MODULE$.mapAsScalaMap(gridRefs).getOrElse((Object)"grid_ref_1000", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), (String)JavaConversions$.MODULE$.mapAsScalaMap(gridRefs).getOrElse((Object)"grid_ref_100", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })});
            String string = ref = uncertainty > 10000 ? this.getBestValue((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])gridRefSeq), 0) : (uncertainty <= 10000 && uncertainty > 2000 ? this.getBestValue((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])gridRefSeq), 1) : (uncertainty <= 2000 && uncertainty > 1000 ? this.getBestValue((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])gridRefSeq), 2) : (uncertainty <= 1000 && uncertainty > 100 ? this.getBestValue((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])gridRefSeq), 3) : (uncertainty < 100 ? this.getBestValue((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])gridRefSeq), 4) : ""))));
            String string2 = "";
            object = !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)ref);
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Problem converting grid reference ").append((Object)gridReference).append((Object)" to lower resolution of ").append((Object)uncertaintyString).toString(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    public String getBestValue(Seq<String> values, int preferredIndex) {
        for (int counter = preferredIndex; counter >= 0; --counter) {
            Object object = values.apply(counter);
            String string = "";
            if (!(object != null ? !object.equals(string) : string != null)) {
                continue;
            }
            return (String)values.apply(counter);
        }
        return "";
    }

    private String padWithZeros(String ref, int pad) {
        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("0")).$times(pad - ref.length())).append((Object)ref).toString();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, String> getGridRefAsResolutions(String gridRef) {
        Option<GridRef> option;
        block9: {
            void var2_2;
            block8: {
                BoxedUnit boxedUnit;
                block7: {
                    Object object;
                    HashMap<String, String> map = new HashMap<String, String>();
                    option = this.gridReferenceToEastingNorthing(gridRef);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    GridRef gr = (GridRef)some.x();
                    int gridSize = BoxesRunTime.unboxToInt((Object)gr.coordinateUncertainty().getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return -1;
                        }
                    }));
                    map.put("grid_ref_100000", gr.gridLetters());
                    if (gridRef.length() > 2) {
                        Object object2;
                        String eastingAsStr = this.padWithZeros(((Object)BoxesRunTime.boxToInteger((int)(gr.easting() % 100000))).toString(), 5);
                        String northingAsStr = this.padWithZeros(((Object)BoxesRunTime.boxToInteger((int)(gr.northing() % 100000))).toString(), 5);
                        Object object3 = eastingAsStr.length() >= 2 && northingAsStr.length() >= 2 ? map.put("grid_ref_10000", new StringBuilder().append((Object)gr.gridLetters()).append((Object)eastingAsStr.substring(0, 1)).append((Object)northingAsStr.substring(0, 1)).toString()) : BoxedUnit.UNIT;
                        if (eastingAsStr.length() >= 3 && northingAsStr.length() >= 3) {
                            int eastingWithin10km = new StringOps(Predef$.MODULE$.augmentString(eastingAsStr.substring(1, 2))).toInt();
                            int northingWithin10km = new StringOps(Predef$.MODULE$.augmentString(northingAsStr.substring(1, 2))).toInt();
                            char tetrad = this.tetradLetters()[eastingWithin10km / 2 * 5 + northingWithin10km / 2];
                            Object object4 = gridSize != -1 && gridSize <= 2000 ? map.put("grid_ref_2000", new StringBuilder().append((Object)gr.gridLetters()).append((Object)eastingAsStr.substring(0, 1)).append((Object)northingAsStr.substring(0, 1)).append((Object)BoxesRunTime.boxToCharacter((char)tetrad)).toString()) : BoxedUnit.UNIT;
                            object2 = gridSize != -1 && gridSize <= 1000 ? map.put("grid_ref_1000", new StringBuilder().append((Object)gr.gridLetters()).append((Object)eastingAsStr.substring(0, 2)).append((Object)northingAsStr.substring(0, 2)).toString()) : BoxedUnit.UNIT;
                        } else {
                            object2 = BoxedUnit.UNIT;
                        }
                        object = gridSize != -1 && gridSize <= 100 && eastingAsStr.length() > 3 ? map.put("grid_ref_100", new StringBuilder().append((Object)gr.gridLetters()).append((Object)eastingAsStr.substring(0, 3)).append((Object)northingAsStr.substring(0, 3)).toString()) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    boxedUnit = object;
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<GridRef> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }
        throw new MatchError(option);
    }

    public Option<GridRef> gridReferenceToEastingNorthing(String gridRef) {
        Option<GridRef> result = this.osGridReferenceToEastingNorthing(gridRef);
        return result.isEmpty() ? this.irishGridReferenceToEastingNorthing(gridRef) : result;
    }

    public Option<GridRef> irishGridReferenceToEastingNorthing(String gridRef) {
        block7: {
            Tuple6 tuple6;
            block8: {
                block16: {
                    int n;
                    int e;
                    Option coordinateUncertainty;
                    String gridletters;
                    block10: {
                        int cellSize;
                        String twoKRef;
                        block15: {
                            String easting;
                            block9: {
                                block14: {
                                    String string;
                                    int cellSize2;
                                    block13: {
                                        block12: {
                                            block11: {
                                                Tuple6 tuple62;
                                                Tuple6 tuple63;
                                                block3: {
                                                    String string2;
                                                    block6: {
                                                        block5: {
                                                            block4: {
                                                                block2: {
                                                                    string2 = gridRef.trim();
                                                                    Option option = this.irishGridRefRegex1Number().unapplySeq((Object)string2);
                                                                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block2;
                                                                    String gridletters2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                                    String oneNumber = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                                    String gridDigits = oneNumber.toString();
                                                                    String[] en = (String[])((Object[])new String[]{gridDigits.substring(0, gridDigits.length() / 2), gridDigits.substring(gridDigits.length() / 2)});
                                                                    Option<Object> coordUncertainty = this.getCoordinateUncertaintyFromGridRef(gridDigits.length(), 0);
                                                                    tuple63 = new Tuple6((Object)gridletters2, (Object)en[0], (Object)en[1], (Object)"", (Object)"", coordUncertainty);
                                                                    break block3;
                                                                }
                                                                Option option = this.irishGridRefRegex().unapplySeq((Object)string2);
                                                                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block4;
                                                                String gridletters3 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                                String easting2 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                                String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                                tuple63 = new Tuple6((Object)gridletters3, (Object)easting2, (Object)northing, (Object)"", (Object)"", this.getCoordinateUncertaintyFromGridRef(easting2.length() * 2, 0));
                                                                break block3;
                                                            }
                                                            Option option = this.irishGridRef2kRegex().unapplySeq((Object)string2);
                                                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block5;
                                                            String gridletters4 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                            String easting3 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                            String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                            String twoKRef2 = (String)((LinearSeqOptimized)option.get()).apply(3);
                                                            tuple63 = new Tuple6((Object)gridletters4, (Object)easting3, (Object)northing, (Object)twoKRef2, (Object)"", this.getCoordinateUncertaintyFromGridRef(easting3.length() * 2, 1));
                                                            break block3;
                                                        }
                                                        Option option = this.irishGridRefWithQuadRegex().unapplySeq((Object)string2);
                                                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block6;
                                                        String gridletters5 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                        String easting4 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                        String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                        String quadRef = (String)((LinearSeqOptimized)option.get()).apply(3);
                                                        tuple63 = new Tuple6((Object)gridletters5, (Object)easting4, (Object)northing, (Object)"", (Object)quadRef, this.getCoordinateUncertaintyFromGridRef(easting4.length() * 2, 2));
                                                        break block3;
                                                    }
                                                    Option option = this.irishGridRefNoEastingNorthing().unapplySeq((Object)string2);
                                                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block7;
                                                    String gridletters6 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                    tuple63 = new Tuple6((Object)gridletters6, (Object)"0", (Object)"0", (Object)"", (Object)"", this.getCoordinateUncertaintyFromGridRef(0, 0));
                                                }
                                                tuple6 = tuple63;
                                                if (tuple6 == null) break block8;
                                                String gridletters7 = (String)tuple6._1();
                                                String easting5 = (String)tuple6._2();
                                                String northing = (String)tuple6._3();
                                                String twoKRef3 = (String)tuple6._4();
                                                String quadRef = (String)tuple6._5();
                                                Option coordinateUncertainty2 = (Option)tuple6._6();
                                                if (gridletters7 == null) break block8;
                                                String string3 = gridletters7;
                                                if (easting5 == null) break block8;
                                                String string4 = easting5;
                                                if (northing == null) break block8;
                                                String string5 = northing;
                                                if (twoKRef3 == null) break block8;
                                                String string6 = twoKRef3;
                                                if (quadRef == null) break block8;
                                                String string7 = quadRef;
                                                if (coordinateUncertainty2 == null) break block8;
                                                Option option = coordinateUncertainty2;
                                                Tuple6 tuple64 = tuple62 = new Tuple6((Object)string3, (Object)string4, (Object)string5, (Object)string6, (Object)string7, (Object)option);
                                                gridletters = (String)tuple64._1();
                                                easting = (String)tuple64._2();
                                                String northing2 = (String)tuple64._3();
                                                twoKRef = (String)tuple64._4();
                                                String quadRef2 = (String)tuple64._5();
                                                coordinateUncertainty = (Option)tuple64._6();
                                                char singleGridLetter = gridletters.length() == 2 ? gridletters.charAt(1) : gridletters.charAt(0);
                                                int gridIdx = Predef$.MODULE$.charArrayOps(this.irishGridletterscodes()).indexOf((Object)BoxesRunTime.boxToCharacter((char)singleGridLetter));
                                                int e100km = gridIdx % 4;
                                                int n100km = 4 - gridIdx / 4;
                                                String easting10digit = new StringBuilder().append((Object)easting).append((Object)"00000").toString().substring(0, 5);
                                                String northing10digit = new StringBuilder().append((Object)northing2).append((Object)"00000").toString().substring(0, 5);
                                                e = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)e100km)).toString()).append((Object)easting10digit).toString())).toInt();
                                                n = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)n100km)).toString()).append((Object)northing10digit).toString())).toInt();
                                                String string8 = twoKRef;
                                                String string9 = "";
                                                if (string8 != null ? !string8.equals(string9) : string9 != null) break block9;
                                                String string10 = quadRef2;
                                                String string11 = "";
                                                if (!(string10 == null ? string11 != null : !string10.equals(string11))) break block10;
                                                int n2 = easting.length() == 1 ? 5000 : (easting.length() == 2 ? 500 : (easting.length() == 3 ? 50 : (cellSize2 = easting.length() == 4 ? 5 : 0)));
                                                if (cellSize2 <= 0) break block10;
                                                String string12 = string = twoKRef;
                                                if ("NW" != null ? !"NW".equals(string12) : string12 != null) break block11;
                                                e += cellSize2 / 2;
                                                n += cellSize2 + cellSize2 / 2;
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block10;
                                            }
                                            String string13 = string;
                                            if ("NE" != null ? !"NE".equals(string13) : string13 != null) break block12;
                                            e += cellSize2 + cellSize2 / 2;
                                            n += cellSize2 + cellSize2 / 2;
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block10;
                                        }
                                        String string14 = string;
                                        if ("SW" != null ? !"SW".equals(string14) : string14 != null) break block13;
                                        e += cellSize2 / 2;
                                        n += cellSize2 / 2;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block10;
                                    }
                                    String string15 = string;
                                    if ("SE" != null ? !"SE".equals(string15) : string15 != null) break block14;
                                    e += cellSize2 + cellSize2 / 2;
                                    n += cellSize2 / 2;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block10;
                                }
                                return None$.MODULE$;
                            }
                            cellSize = easting.length() == 1 ? 2000 : (easting.length() == 2 ? 200 : (easting.length() == 3 ? 20 : (easting.length() == 4 ? 2 : 0)));
                            String string = twoKRef;
                            if (Character.codePointAt(twoKRef, 0) > 78) break block15;
                            e += (Character.codePointAt(twoKRef, 0) - 65) / 5 * cellSize;
                            n += (Character.codePointAt(twoKRef, 0) - 65) % 5 * cellSize;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block10;
                        }
                        if (Character.codePointAt(twoKRef, 0) < 80) break block16;
                        e += (Character.codePointAt(twoKRef, 0) - 66) / 5 * cellSize;
                        n += (Character.codePointAt(twoKRef, 0) - 66) % 5 * cellSize;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    int coordinateUncertaintyOrZero = coordinateUncertainty.isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)coordinateUncertainty.get());
                    return new Some((Object)new GridRef(gridletters, e, n, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)coordinateUncertaintyOrZero)), e, n, e + coordinateUncertaintyOrZero, n + coordinateUncertaintyOrZero, this.IRISH_CRS()));
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple6);
        }
        return None$.MODULE$;
    }

    public Option<GridRef> osGridReferenceToEastingNorthing(String gridRef) {
        block11: {
            Tuple6 tuple6;
            block12: {
                block20: {
                    int n;
                    int e;
                    Option coordinateUncertainty;
                    String gridletters;
                    block14: {
                        int cellSize;
                        String twoKRef;
                        block19: {
                            String easting;
                            block13: {
                                block18: {
                                    String string;
                                    int cellSize2;
                                    block17: {
                                        block16: {
                                            block15: {
                                                Tuple6 tuple62;
                                                Tuple6 tuple63;
                                                block7: {
                                                    String string2;
                                                    Regex osGridRefNoEastingNorthing;
                                                    block10: {
                                                        Regex osGridRefWithQuadRegex;
                                                        block9: {
                                                            Regex osGridRef2kRegex;
                                                            block8: {
                                                                Regex osGridRefRegex;
                                                                block6: {
                                                                    osGridRefNoEastingNorthing = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})")).r();
                                                                    Regex osGridRefRegex1Number = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)$")).r();
                                                                    osGridRef2kRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([A-Z]{1})")).r();
                                                                    osGridRefRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)$")).r();
                                                                    osGridRefWithQuadRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([NW|NE|SW|SE]{2})$")).r();
                                                                    string2 = gridRef.toUpperCase().trim();
                                                                    Option option = osGridRefRegex1Number.unapplySeq((Object)string2);
                                                                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block6;
                                                                    String gridletters2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                                    String oneNumber = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                                    String gridDigits = oneNumber.toString();
                                                                    String[] en = (String[])((Object[])new String[]{gridDigits.substring(0, gridDigits.length() / 2), gridDigits.substring(gridDigits.length() / 2)});
                                                                    Option<Object> coordUncertainty = this.getCoordinateUncertaintyFromGridRef(gridDigits.length(), 0);
                                                                    tuple63 = new Tuple6((Object)gridletters2, (Object)en[0], (Object)en[1], (Object)"", (Object)"", coordUncertainty);
                                                                    break block7;
                                                                }
                                                                Option option = osGridRefRegex.unapplySeq((Object)string2);
                                                                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block8;
                                                                String gridletters3 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                                String easting2 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                                String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                                tuple63 = new Tuple6((Object)gridletters3, (Object)easting2, (Object)northing, (Object)"", (Object)"", this.getCoordinateUncertaintyFromGridRef(easting2.length() * 2, 0));
                                                                break block7;
                                                            }
                                                            Option option = osGridRef2kRegex.unapplySeq((Object)string2);
                                                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block9;
                                                            String gridletters4 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                            String easting3 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                            String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                            String twoKRef2 = (String)((LinearSeqOptimized)option.get()).apply(3);
                                                            tuple63 = new Tuple6((Object)gridletters4, (Object)easting3, (Object)northing, (Object)twoKRef2, (Object)"", this.getCoordinateUncertaintyFromGridRef(easting3.length() * 2, 1));
                                                            break block7;
                                                        }
                                                        Option option = osGridRefWithQuadRegex.unapplySeq((Object)string2);
                                                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block10;
                                                        String gridletters5 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                        String easting4 = (String)((LinearSeqOptimized)option.get()).apply(1);
                                                        String northing = (String)((LinearSeqOptimized)option.get()).apply(2);
                                                        String quadRef = (String)((LinearSeqOptimized)option.get()).apply(3);
                                                        tuple63 = new Tuple6((Object)gridletters5, (Object)easting4, (Object)northing, (Object)"", (Object)quadRef, this.getCoordinateUncertaintyFromGridRef(easting4.length() * 2, 2));
                                                        break block7;
                                                    }
                                                    Option option = osGridRefNoEastingNorthing.unapplySeq((Object)string2);
                                                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block11;
                                                    String gridletters6 = (String)((LinearSeqOptimized)option.get()).apply(0);
                                                    tuple63 = new Tuple6((Object)gridletters6, (Object)"0", (Object)"0", (Object)"", (Object)"", this.getCoordinateUncertaintyFromGridRef(0, 0));
                                                }
                                                tuple6 = tuple63;
                                                if (tuple6 == null) break block12;
                                                String gridletters7 = (String)tuple6._1();
                                                String easting5 = (String)tuple6._2();
                                                String northing = (String)tuple6._3();
                                                String twoKRef3 = (String)tuple6._4();
                                                String quadRef = (String)tuple6._5();
                                                Option coordinateUncertainty2 = (Option)tuple6._6();
                                                if (gridletters7 == null) break block12;
                                                String string3 = gridletters7;
                                                if (easting5 == null) break block12;
                                                String string4 = easting5;
                                                if (northing == null) break block12;
                                                String string5 = northing;
                                                if (twoKRef3 == null) break block12;
                                                String string6 = twoKRef3;
                                                if (quadRef == null) break block12;
                                                String string7 = quadRef;
                                                if (coordinateUncertainty2 == null) break block12;
                                                Option option = coordinateUncertainty2;
                                                Tuple6 tuple64 = tuple62 = new Tuple6((Object)string3, (Object)string4, (Object)string5, (Object)string6, (Object)string7, (Object)option);
                                                gridletters = (String)tuple64._1();
                                                easting = (String)tuple64._2();
                                                String northing2 = (String)tuple64._3();
                                                twoKRef = (String)tuple64._4();
                                                String quadRef2 = (String)tuple64._5();
                                                coordinateUncertainty = (Option)tuple64._6();
                                                int value = Character.codePointAt(gridletters, 0) - Character.codePointAt("A", 0);
                                                int l1 = value > 7 ? value - 1 : value;
                                                int value2 = Character.codePointAt(gridletters, 1) - Character.codePointAt("A", 0);
                                                int l2 = value2 > 7 ? value2 - 1 : value2;
                                                int e100km = (l1 - 2) % 5 * 5 + l2 % 5;
                                                int n100km = (int)((double)19 - Math.floor(l1 / 5) * (double)5 - Math.floor(l2 / 5));
                                                if (e100km < 0 || e100km > 6 || n100km < 0 || n100km > 12) {
                                                    return None$.MODULE$;
                                                }
                                                if (easting == null || northing2 == null) {
                                                    return None$.MODULE$;
                                                }
                                                if (easting.length() != northing2.length()) {
                                                    return None$.MODULE$;
                                                }
                                                String easting10digit = new StringBuilder().append((Object)easting).append((Object)"00000").toString().substring(0, 5);
                                                String northing10digit = new StringBuilder().append((Object)northing2).append((Object)"00000").toString().substring(0, 5);
                                                e = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)e100km)).toString()).append((Object)easting10digit).toString())).toInt();
                                                n = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)n100km)).toString()).append((Object)northing10digit).toString())).toInt();
                                                String string8 = twoKRef;
                                                String string9 = "";
                                                if (string8 != null ? !string8.equals(string9) : string9 != null) break block13;
                                                String string10 = quadRef2;
                                                String string11 = "";
                                                if (!(string10 == null ? string11 != null : !string10.equals(string11))) break block14;
                                                int n2 = easting.length() == 1 ? 5000 : (easting.length() == 2 ? 500 : (easting.length() == 3 ? 50 : (cellSize2 = easting.length() == 4 ? 5 : 0)));
                                                if (cellSize2 <= 0) break block14;
                                                String string12 = string = twoKRef;
                                                if ("NW" != null ? !"NW".equals(string12) : string12 != null) break block15;
                                                e += cellSize2 / 2;
                                                n += cellSize2 + cellSize2 / 2;
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block14;
                                            }
                                            String string13 = string;
                                            if ("NE" != null ? !"NE".equals(string13) : string13 != null) break block16;
                                            e += cellSize2 + cellSize2 / 2;
                                            n += cellSize2 + cellSize2 / 2;
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block14;
                                        }
                                        String string14 = string;
                                        if ("SW" != null ? !"SW".equals(string14) : string14 != null) break block17;
                                        e += cellSize2 / 2;
                                        n += cellSize2 / 2;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block14;
                                    }
                                    String string15 = string;
                                    if ("SE" != null ? !"SE".equals(string15) : string15 != null) break block18;
                                    e += cellSize2 + cellSize2 / 2;
                                    n += cellSize2 / 2;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block14;
                                }
                                return None$.MODULE$;
                            }
                            cellSize = easting.length() == 1 ? 2000 : (easting.length() == 2 ? 200 : (easting.length() == 3 ? 20 : (easting.length() == 4 ? 2 : 0)));
                            String string = twoKRef;
                            if (Character.codePointAt(twoKRef, 0) > 78) break block19;
                            e += (Character.codePointAt(twoKRef, 0) - 65) / 5 * cellSize;
                            n += (Character.codePointAt(twoKRef, 0) - 65) % 5 * cellSize;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block14;
                        }
                        if (Character.codePointAt(twoKRef, 0) < 80) break block20;
                        e += (Character.codePointAt(twoKRef, 0) - 66) / 5 * cellSize;
                        n += (Character.codePointAt(twoKRef, 0) - 66) % 5 * cellSize;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    int coordinateUncertaintyOrZero = coordinateUncertainty.isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)coordinateUncertainty.get());
                    return new Some((Object)new GridRef(gridletters, e, n, (Option<Object>)coordinateUncertainty, e, n, e + coordinateUncertaintyOrZero, n + coordinateUncertaintyOrZero, this.OSGB_CRS()));
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple6);
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Option<GISPoint> processGridReference(String gridReference) {
        void var2_2;
        block3: {
            Option<GridRef> option;
            block9: {
                void var3_19;
                None$ none$;
                block8: {
                    block4: {
                        Tuple2 tuple2;
                        block7: {
                            None$ none$2;
                            block6: {
                                Tuple2 tuple22;
                                Option[] bbox;
                                Option<Tuple2<String, String>> coords;
                                GridRef gr;
                                block5: {
                                    Option cachedObject = (Option)this.lru().getIfPresent((Object)gridReference);
                                    if (cachedObject != null) break block3;
                                    option = this.gridReferenceToEastingNorthing(gridReference);
                                    if (!(option instanceof Some)) break block4;
                                    Some some = (Some)option;
                                    gr = (GridRef)some.x();
                                    int reposition = !gr.coordinateUncertainty().isEmpty() && BoxesRunTime.unboxToInt((Object)gr.coordinateUncertainty().get()) > 0 ? BoxesRunTime.unboxToInt((Object)gr.coordinateUncertainty().get()) / 2 : 0;
                                    coords = GISUtil$.MODULE$.reprojectCoordinatesToWGS84(gr.easting() + reposition, gr.northing() + reposition, gr.datum(), 5);
                                    bbox = (Option[])((Object[])new Option[]{GISUtil$.MODULE$.reprojectCoordinatesToWGS84(gr.minEasting(), gr.minNorthing(), gr.datum(), 5), GISUtil$.MODULE$.reprojectCoordinatesToWGS84(gr.maxEasting(), gr.maxNorthing(), gr.datum(), 5)});
                                    if (!coords.isEmpty()) break block5;
                                    none$2 = None$.MODULE$;
                                    break block6;
                                }
                                tuple2 = (Tuple2)coords.get();
                                if (tuple2 == null) break block7;
                                String latitude = (String)tuple2._1();
                                String longitude = (String)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)latitude, (Object)longitude);
                                String latitude2 = (String)tuple23._1();
                                String longitude2 = (String)tuple23._2();
                                String uncertaintyToUse = gr.coordinateUncertainty().isEmpty() ? null : gr.coordinateUncertainty().get().toString();
                                none$2 = new Some((Object)new GISPoint(latitude2, longitude2, GISUtil$.MODULE$.WGS84_EPSG_Code(), uncertaintyToUse, ((Object)BoxesRunTime.boxToInteger((int)gr.easting())).toString(), ((Object)BoxesRunTime.boxToInteger((int)gr.northing())).toString(), (String)((Tuple2)bbox[0].get())._1(), (String)((Tuple2)bbox[0].get())._2(), (String)((Tuple2)bbox[1].get())._1(), (String)((Tuple2)bbox[1].get())._2()));
                            }
                            none$ = none$2;
                            break block8;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    None$ none$3 = None$.MODULE$;
                    Option<GridRef> option2 = option;
                    if (none$3 != null ? !none$3.equals(option2) : option2 != null) break block9;
                    none$ = None$.MODULE$;
                }
                None$ result = none$;
                this.lru().put((Object)gridReference, (Object)result);
                return var3_19;
            }
            throw new MatchError(option);
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<String> lookupEpsgCode(String crs) {
        None$ none$;
        if (StringUtils.startsWithIgnoreCase((String)crs, (String)"EPSG:")) {
            try {
                CRS.decode((String)crs.toUpperCase());
                none$ = new Some((Object)crs.toUpperCase());
                return none$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
                return none$;
            }
        } else {
            if (this.crsEpsgCodesMap().contains((Object)crs.toUpperCase())) {
                none$ = new Some(this.crsEpsgCodesMap().apply((Object)crs.toUpperCase()));
                return none$;
            }
            none$ = None$.MODULE$;
            return none$;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<GISPoint> processNorthingEastingZone(String verbatimSRS, String easting, String northing, String zone, ArrayBuffer<QualityAssertion> assertions) {
        None$ none$;
        String epsgCodeKey;
        String string = epsgCodeKey = verbatimSRS == null ? new StringBuilder().append((Object)"GDA94|").append((Object)zone).toString() : new StringBuilder().append((Object)verbatimSRS.toUpperCase()).append((Object)"|").append((Object)zone).toString();
        if (this.zoneEpsgCodesMap().contains((Object)epsgCodeKey)) {
            String crsEpsgCode = (String)this.zoneEpsgCodesMap().apply((Object)epsgCodeKey);
            Option<Object> eastingAsDouble = StringHelper$.MODULE$.string2helper(easting).toDoubleWithOption();
            Option<Object> northingAsDouble = StringHelper$.MODULE$.string2helper(northing).toDoubleWithOption();
            if (eastingAsDouble.isEmpty() || northingAsDouble.isEmpty()) {
                none$ = None$.MODULE$;
                return none$;
            } else {
                Option<Tuple2<String, String>> reprojectedCoords = GISUtil$.MODULE$.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToDouble((Object)eastingAsDouble.get()), BoxesRunTime.unboxToDouble((Object)northingAsDouble.get()), crsEpsgCode, 5);
                if (reprojectedCoords.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), "Transformation of verbatim easting and northing to WGS84 failed"));
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    Tuple2 tuple2;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING(), "Decimal latitude and longitude were calculated using easting, northing and zone."));
                    Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    String reprojectedLatitude = (String)tuple22._1();
                    String reprojectedLongitude = (String)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                    String reprojectedLatitude2 = (String)tuple23._1();
                    String reprojectedLongitude2 = (String)tuple23._2();
                    none$ = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                }
            }
            return none$;
        } else {
            ArrayBuffer arrayBuffer = verbatimSRS == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone GDA94 / MGA zone ").append((Object)zone).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone ").append((Object)verbatimSRS).append((Object)" / zone ").append((Object)zone).toString()));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private GridUtil$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"GridUtil");
        this.lock = new Object();
        this.lru = CacheBuilder.newBuilder().maximumSize(100000L).build();
        this.osGridRefNoEastingNorthing = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})")).r();
        this.osGridRefRegex1Number = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)$")).r();
        this.osGridRef2kRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([A-Z]{1})")).r();
        this.osGridRefRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)$")).r();
        this.osGridRefWithQuadRegex = new StringOps(Predef$.MODULE$.augmentString("([A-Z]{2})\\s*([0-9]+)\\s*([0-9]+)\\s*([NW|NE|SW|SE]{2})$")).r();
        this.irishGridletterscodes = new char[]{'A', 'B', 'C', 'D', 'F', 'G', 'H', 'J', 'L', 'M', 'N', 'O', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y'};
        this.irishGridlettersFlattened = Predef$.MODULE$.charArrayOps(this.irishGridletterscodes()).mkString();
        this.irishGridRefNoEastingNorthing = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"(I?[").append((Object)this.irishGridlettersFlattened()).append((Object)"]{1})").toString())).r();
        this.irishGridRefRegex1Number = new StringOps(Predef$.MODULE$.augmentString("(I?[A-Z]{1})\\s*([0-9]+)$")).r();
        this.irishGridRef2kRegex = new StringOps(Predef$.MODULE$.augmentString("(I?[A-Z]{1})\\s*([0-9]+)\\s*([0-9]+)\\s*([A-Z]{1})")).r();
        this.irishGridRefRegex = new StringOps(Predef$.MODULE$.augmentString("(I?[A-Z]{1})\\s*([0-9]+)\\s*([0-9]+)$")).r();
        this.irishGridRefWithQuadRegex = new StringOps(Predef$.MODULE$.augmentString("(I?[A-Z]{1})\\s*([0-9]+)\\s*([0-9]+)\\s*([NW|NE|SW|SE]{2})$")).r();
        this.tetradLetters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        this.IRISH_CRS = "EPSG:29902";
        this.OSGB_CRS = "EPSG:27700";
    }
}

