/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processors$;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u00015\u0011qBU3d_J$\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\ta\u0001\\8hO\u0016\u0014X#\u0001\u000f\u0011\u0005u\tS\"\u0001\u0010\u000b\u0005}\u0001\u0013!B:mMRR'\"A\u0005\n\u0005\tr\"A\u0002'pO\u001e,'\u000f\u0003\u0004%\u0001\u0001\u0006I\u0001H\u0001\bY><w-\u001a:!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n1\u0002\u001d:pG\u0016\u001c8\u000fV5nKV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!A.\u00198h\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\rM#(/\u001b8h\u0011\u0019\t\u0004\u0001)A\u0005Q\u0005a\u0001O]8dKN\u001cH+[7fA!91\u0007\u0001b\u0001\n\u0003!\u0014A\u00033va2L7-\u0019;fgV\tQ\u0007E\u00027w!j\u0011a\u000e\u0006\u0003qe\n\u0011\"[7nkR\f'\r\\3\u000b\u0005i\u0002\u0012AC2pY2,7\r^5p]&\u0011Ah\u000e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004?\u0001\u0001\u0006I!N\u0001\fIV\u0004H.[2bi\u0016\u001c\b\u0005C\u0004A\u0001\t\u0007I\u0011A!\u0002\u001dA\u0014xnY3tgRKW.\u001b8hgV\t!\t\u0005\u0003D\r\"sU\"\u0001#\u000b\u0005\u0015K\u0014aB7vi\u0006\u0014G.Z\u0005\u0003\u000f\u0012\u00131!T1q!\tIEJ\u0004\u0002\u0010\u0015&\u00111\nE\u0001\u0007!J,G-\u001a4\n\u0005=j%BA&\u0011!\tye+D\u0001Q\u0015\t\t&+\u0001\u0004bi>l\u0017n\u0019\u0006\u0003'R\u000b!bY8oGV\u0014(/\u001a8u\u0015\t)F&\u0001\u0003vi&d\u0017BA,Q\u0005)\tEo\\7jG2{gn\u001a\u0005\u00073\u0002\u0001\u000b\u0011\u0002\"\u0002\u001fA\u0014xnY3tgRKW.\u001b8hg\u0002BQa\u0017\u0001\u0005\u0002\u0005\u000b\u0011cZ3u!J|7-Z:t)&l\u0017N\\4t\u0011\u0015i\u0006\u0001\"\u0001_\u00035\u0001(o\\2fgN\u0014VmY8sIR1q\f\u001a7ogV\u0004B!\u00131IC&\u0011q)\u0014\t\u0003S\tL!a\u0019\u0016\u0003\r=\u0013'.Z2u\u0011\u0015)G\f1\u0001g\u0003\r\u0011\u0018m\u001e\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0012\tQ!\\8eK2L!a\u001b5\u0003\u0015\u0019+H\u000e\u001c*fG>\u0014H\rC\u0003n9\u0002\u0007a-\u0001\tdkJ\u0014XM\u001c;Qe>\u001cWm]:fI\"9q\u000e\u0018I\u0001\u0002\u0004\u0001\u0018!\u00022bi\u000eD\u0007CA\br\u0013\t\u0011\bCA\u0004C_>dW-\u00198\t\u000fQd\u0006\u0013!a\u0001a\u0006Ia-\u001b:ti2{\u0017\r\u001a\u0005\bmr\u0003\n\u00111\u0001x\u0003)\u0001(o\\2fgN|'o\u001d\t\u0004\u001faD\u0015BA=\u0011\u0005\u0019y\u0005\u000f^5p]\")1\u0010\u0001C\u0001y\u0006\trO]5uKB\u0013xnY3tg\n\u000bGo\u00195\u0015\u0007u\f\t\u0001\u0005\u0002\u0010}&\u0011q\u0010\u0005\u0002\u0005+:LG\u000f\u0003\u0004pu\u0002\u0007\u00111\u0001\t\u0006\u0003\u000b\t)b\u0018\b\u0005\u0003\u000f\t\tB\u0004\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti\u0001D\u0001\u0007yI|w\u000e\u001e \n\u0003EI1!a\u0005\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L1\u0001PA\f\u0015\r\t\u0019\u0002\u0005\u0005\u0007;\u0002!\t!a\u0007\u0015\t\u0005u\u0011\u0011\u0007\t\u0007\u001f\u0005}a-a\t\n\u0007\u0005\u0005\u0002C\u0001\u0004UkBdWM\r\t\u0006\u0013\u0002D\u0015Q\u0005\t\u0006\u001f\u0005\u001d\u00121F\u0005\u0004\u0003S\u0001\"!B!se\u0006L\bcA4\u0002.%\u0019\u0011q\u00065\u0003!E+\u0018\r\\5us\u0006\u001b8/\u001a:uS>t\u0007BB3\u0002\u001a\u0001\u0007a\rC\u0004\u00026\u0001!\t!a\u000e\u0002-A\u0014xnY3tgJ+7m\u001c:e\u0003:$W\u000b\u001d3bi\u0016$2!`A\u001d\u0011\u0019)\u00171\u0007a\u0001M\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012!C1eIJ+7m\u001c:e)\u0015A\u0015\u0011IA#\u0011\u001d\t\u0019%a\u000fA\u0002!\u000bq\u0002Z1uCJ+7o\\;sG\u0016,\u0016\u000e\u001a\u0005\t\u0003\u000f\nY\u00041\u0001\u0002J\u0005Q\u0001O]8qKJ$\u0018.Z:\u0011\t%\u0003\u0007\n\u0013\u0005\n\u0003\u001b\u0002\u0011\u0013!C\u0001\u0003\u001f\nq\u0003\u001d:pG\u0016\u001c8OU3d_J$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E#f\u00019\u0002T-\u0012\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003%)hn\u00195fG.,GMC\u0002\u0002`A\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019'!\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002h\u0001\t\n\u0011\"\u0001\u0002P\u00059\u0002O]8dKN\u001c(+Z2pe\u0012$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003[\nq\u0003\u001d:pG\u0016\u001c8OU3d_J$G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005=$fA<\u0002T\u0001")
public class RecordProcessor {
    private final Logger logger = LoggerFactory.getLogger(RecordProcessor.class);
    private final String processTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final List<String> duplicates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D", "D1", "D2"}));
    private final scala.collection.mutable.Map<String, AtomicLong> processTimings = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

    public Logger logger() {
        return this.logger;
    }

    public String processTime() {
        return this.processTime;
    }

    public List<String> duplicates() {
        return this.duplicates;
    }

    public scala.collection.mutable.Map<String, AtomicLong> processTimings() {
        return this.processTimings;
    }

    public scala.collection.mutable.Map<String, AtomicLong> getProcessTimings() {
        return this.processTimings();
    }

    public scala.collection.immutable.Map<String, Object> processRecord(FullRecord raw, FullRecord currentProcessed, boolean batch, boolean firstLoad, Option<String> processors) {
        scala.collection.immutable.Map map;
        try {
            String guid = raw.rowKey();
            OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
            FullRecord processed = raw.createNewProcessedRecord();
            ObjectRef assertions = new ObjectRef((Object)new HashMap());
            Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, currentProcessed, firstLoad, processors, guid, processed, assertions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecordProcessor $outer;
                private final FullRecord raw$2;
                private final FullRecord currentProcessed$1;
                private final boolean firstLoad$1;
                private final Option processors$1;
                private final String guid$1;
                private final FullRecord processed$1;
                private final ObjectRef assertions$1;

                public final void apply(Processor processor) {
                    block7: {
                        if (!processor.getName().equals("offline") || !this.firstLoad$1) {
                            long start = System.nanoTime();
                            try {
                                if (this.processors$1.isEmpty() || ((String)this.processors$1.get()).contains(processor.getName())) {
                                    ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                                } else {
                                    ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.skip(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                                }
                                ((AtomicLong)this.$outer.processTimings().getOrElseUpdate((Object)processor.getName(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final AtomicLong apply() {
                                        return new AtomicLong(0L);
                                    }
                                })).addAndGet(System.nanoTime() - start);
                            }
                            catch (Exception exception) {
                                try {
                                    this.$outer.logger().warn(new StringBuilder().append((Object)"Non-fatal error processing record: ").append((Object)this.raw$2.rowKey()).append((Object)", processorName: ").append((Object)processor.getName()).append((Object)", error: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                                }
                                catch (Throwable throwable) {
                                    ((AtomicLong)this.$outer.processTimings().getOrElseUpdate((Object)processor.getName(), (Function0)new /* invalid duplicate definition of identical inner class */)).addAndGet(System.nanoTime() - start);
                                    throw throwable;
                                }
                            }
                            break block7;
                            ((AtomicLong)this.$outer.processTimings().getOrElseUpdate((Object)processor.getName(), (Function0)new /* invalid duplicate definition of identical inner class */)).addAndGet(System.nanoTime() - start);
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.raw$2 = raw$2;
                    this.currentProcessed$1 = currentProcessed$1;
                    this.firstLoad$1 = firstLoad$1;
                    this.processors$1 = processors$1;
                    this.guid$1 = guid$1;
                    this.processed$1 = processed$1;
                    this.assertions$1 = assertions$1;
                }
            });
            processed.lastModifiedTime_$eq(this.processTime());
            Some systemAssertions = new Some((Object)((HashMap)assertions.elem).toMap(Predef$.MODULE$.conforms()));
            if (batch) {
                map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowKey"), (Object)guid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"oldRecord"), (Object)currentProcessed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"newRecord"), (Object)processed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"assertions"), (Object)systemAssertions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)Processed$.MODULE$)}));
            } else {
                long startPersist = System.nanoTime();
                occurrenceDAO.updateOccurrence(guid, currentProcessed, processed, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
                ((AtomicLong)this.processTimings().getOrElseUpdate((Object)"persist", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AtomicLong apply() {
                        return new AtomicLong(0L);
                    }
                })).addAndGet(System.nanoTime() - startPersist);
                map = null;
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Error processing record: ").append((Object)raw.rowKey()).append((Object)", ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            map = null;
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProcessBatch(List<scala.collection.immutable.Map<String, Object>> batch) {
        OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        int retries = 0;
        boolean processedOK = false;
        if (processedOK) return;
        if (retries >= 6) return;
        {
            occurrenceDAO.updateOccurrenceBatch(batch);
            return;
        }
    }

    public Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> processRecord(FullRecord raw) {
        FullRecord processed = raw.createNewProcessedRecord();
        HashMap assertions = new HashMap();
        Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, processed, assertions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final FullRecord raw$1;
            private final FullRecord processed$2;
            private final HashMap assertions$2;

            public final void apply(Processor processor) {
                if (this.$outer.logger().isDebugEnabled()) {
                    this.$outer.logger().debug(new StringBuilder().append((Object)"Running processor ").append((Object)processor.getName()).toString());
                }
                this.assertions$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.raw$1.rowKey(), this.raw$1, this.processed$2, processor.process$default$4())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.raw$1 = raw$1;
                this.processed$2 = processed$2;
                this.assertions$2 = assertions$2;
            }
        });
        processed.lastModifiedTime_$eq(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
        return new Tuple2((Object)processed, (Object)assertions.toMap(Predef$.MODULE$.conforms()));
    }

    public boolean processRecord$default$3() {
        return false;
    }

    public boolean processRecord$default$4() {
        return false;
    }

    public Option<String> processRecord$default$5() {
        return None$.MODULE$;
    }

    public void processRecordAndUpdate(FullRecord raw) {
        Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> tuple2 = this.processRecord(raw);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FullRecord processed = (FullRecord)tuple2._1();
            scala.collection.immutable.Map assertions = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)processed, (Object)assertions);
            FullRecord processed2 = (FullRecord)tuple23._1();
            scala.collection.immutable.Map assertions2 = (scala.collection.immutable.Map)tuple23._2();
            Some systemAssertions = new Some((Object)assertions2);
            processed2.lastModifiedTime_$eq(this.processTime());
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), processed2, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public String addRecord(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = UUID.randomUUID().toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(uuid, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)None$.MODULE$, Versions$.MODULE$.RAW());
        boolean downloaded = Config$.MODULE$.occurrenceDAO().downloadMedia(raw);
        if (downloaded) {
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)None$.MODULE$, Versions$.MODULE$.RAW());
        }
        return var3_3;
    }
}

