/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.GraphWalker;
import org.geotools.graph.traverse.basic.BasicGraphTraversal;
import org.geotools.graph.traverse.standard.DepthFirstIterator;

public class GraphPartitioner
implements GraphWalker {
    private Graph m_graph;
    private ArrayList m_partitions;
    private ArrayList m_partition;
    private int m_nvisited;

    public GraphPartitioner(Graph graph) {
        this.m_graph = graph;
        this.m_partitions = new ArrayList();
    }

    public boolean partition() {
        try {
            this.m_nvisited = this.m_graph.getNodes().size();
            DepthFirstIterator iterator = new DepthFirstIterator();
            BasicGraphTraversal traversal = new BasicGraphTraversal(this.m_graph, this, iterator);
            Iterator sources = this.m_graph.getNodes().iterator();
            traversal.init();
            this.m_partition = new ArrayList();
            while (this.m_nvisited > 0) {
                Graphable source = null;
                while (sources.hasNext() && (source = (Node)sources.next()).isVisited()) {
                }
                if (source == null || source.isVisited()) {
                    return false;
                }
                iterator.setSource(source);
                traversal.traverse();
            }
            HashSet<Node> nodes = null;
            HashSet edges = null;
            ArrayList<BasicGraph> graphs = new ArrayList<BasicGraph>();
            for (ArrayList this.m_partition : this.m_partitions) {
                if (this.m_partition.size() == 0) continue;
                nodes = new HashSet<Node>();
                edges = new HashSet();
                for (Node node : this.m_partition) {
                    nodes.add(node);
                    edges.addAll(node.getEdges());
                }
                graphs.add(new BasicGraph(nodes, edges));
            }
            this.m_partitions = graphs;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List getPartitions() {
        return this.m_partitions;
    }

    @Override
    public int visit(Graphable element, GraphTraversal traversal) {
        --this.m_nvisited;
        this.m_partition.add(element);
        return 0;
    }

    @Override
    public void finish() {
        this.m_partitions.add(this.m_partition);
        this.m_partition = new ArrayList();
    }
}

