/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.utils;

import java.util.Comparator;
import org.gbif.ecat.voc.Rank;
import org.gbif.ecat.voc.RankComparator;

public class RankUtil {
    private static final Comparator<Rank> rankComp = new RankComparator();

    public static boolean isLowerRank(Rank r1, Rank r2) {
        return r1 != null && r2 != null && rankComp.compare(r1, r2) == -1;
    }

    public static Rank nextHigherDwcRank(Rank r) {
        if (r == null) {
            return null;
        }
        if (r == Rank.InfragenericName) {
            return Rank.GENUS;
        }
        while (r != null) {
            if ((r = Rank.valueOfTermID(r.termID() - 25)) == null || !Rank.MAYOR_RANKS.contains(r)) continue;
            return r;
        }
        return r;
    }

    public static Rank nextHigherRank(Rank r) {
        if (r == null) {
            return null;
        }
        if (r == Rank.InfragenericName) {
            return Rank.GENUS;
        }
        Rank nextRank = null;
        for (Rank nr : Rank.values()) {
            if (Rank.UNCOMPARABLE_RANKS.contains(nr)) continue;
            nextRank = nextRank == null || rankComp.compare(nr, r) == 1 && rankComp.compare(nr, nextRank) == -1 ? nr : nextRank;
        }
        return nextRank;
    }
}

