/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.utils;

import java.util.Collection;
import java.util.Stack;

public class LimitedStack<E>
extends Stack<E> {
    private final int size;

    public LimitedStack(int size) {
        this.size = size;
    }

    private void reduce() {
        if (this.size() == this.size) {
            this.remove(0);
        }
    }

    @Override
    public E push(E item) {
        this.reduce();
        return super.push(item);
    }

    @Override
    public synchronized void addElement(E obj) {
        this.reduce();
        super.addElement(obj);
    }

    @Override
    public synchronized void insertElementAt(E obj, int index) {
        this.reduce();
        super.insertElementAt(obj, index);
    }

    @Override
    public boolean add(E o) {
        this.reduce();
        return super.add(o);
    }

    @Override
    public void add(int index, E element) {
        this.reduce();
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }
}

