/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetSortableMerger;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.StrAggValueSource;
import org.apache.solr.search.facet.UniqueMultiDvSlotAcc;
import org.apache.solr.search.facet.UniqueMultivaluedSlotAcc;
import org.apache.solr.search.facet.UniqueSinglevaluedSlotAcc;

public class UniqueAgg
extends StrAggValueSource {
    public static String UNIQUE = "unique";
    static String VALS = "vals";

    public UniqueAgg(String field) {
        super(UNIQUE, field);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(this.getArg());
        if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
            if (sf.hasDocValues()) {
                return new UniqueMultiDvSlotAcc(fcontext, sf, numSlots, null);
            }
            return new UniqueMultivaluedSlotAcc(fcontext, sf, numSlots, null);
        }
        if (sf.getType().getNumberType() != null) {
            return new NumericAcc(fcontext, this.getArg(), numSlots);
        }
        return new UniqueSinglevaluedSlotAcc(fcontext, sf, numSlots, null);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    static class NumericAcc
    extends SlotAcc {
        SchemaField sf;
        LongSet[] sets;
        NumericDocValues values;
        Bits exists;

        public NumericAcc(FacetContext fcontext, String field, int numSlots) throws IOException {
            super(fcontext);
            this.sf = fcontext.searcher.getSchema().getField(field);
            this.sets = new LongSet[numSlots];
        }

        @Override
        public void reset() {
            this.sets = new LongSet[this.sets.length];
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.sets = resizer.resize(this.sets, null);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            this.values = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
            this.exists = DocValues.getDocsWithField((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        public void collect(int doc, int slot) throws IOException {
            long val = this.values.get(doc);
            if (val == 0L && !this.exists.get(doc)) {
                return;
            }
            LongSet set = this.sets[slot];
            if (set == null) {
                set = this.sets[slot] = new LongSet(16);
            }
            set.add(val);
        }

        @Override
        public Object getValue(int slot) throws IOException {
            if (this.fcontext.isShard()) {
                return this.getShardValue(slot);
            }
            return this.getCardinality(slot);
        }

        private int getCardinality(int slot) {
            LongSet set = this.sets[slot];
            return set == null ? 0 : set.cardinality();
        }

        public Object getShardValue(int slot) throws IOException {
            LongSet set = this.sets[slot];
            int unique = this.getCardinality(slot);
            SimpleOrderedMap map = new SimpleOrderedMap();
            map.add("unique", (Object)unique);
            int maxExplicit = 100;
            if (unique <= maxExplicit) {
                ArrayList<Number> lst = new ArrayList<Number>(Math.min(unique, maxExplicit));
                if (set != null) {
                    if (set.zeroCount > 0) {
                        lst.add(0);
                    }
                    for (long val : set.vals) {
                        if (val == 0L) continue;
                        lst.add(val);
                    }
                }
                map.add("vals", lst);
            }
            return map;
        }

        @Override
        public int compare(int slotA, int slotB) {
            return this.getCardinality(slotA) - this.getCardinality(slotB);
        }
    }

    static class LongSet {
        static final float LOAD_FACTOR = 0.7f;
        long[] vals;
        int cardinality;
        int mask;
        int threshold;
        int zeroCount;

        LongSet(int sz) {
            this.vals = new long[sz];
            this.mask = sz - 1;
            this.threshold = (int)((float)sz * 0.7f);
        }

        void add(long val) {
            if (val == 0L) {
                this.zeroCount = 1;
                return;
            }
            if (this.cardinality >= this.threshold) {
                this.rehash();
            }
            int h = (int)(val + (val >>> 44) + (val >>> 15));
            int slot = h & this.mask;
            while (true) {
                long v;
                if ((v = this.vals[slot]) == 0L) {
                    this.vals[slot] = val;
                    ++this.cardinality;
                    break;
                }
                if (v == val) break;
                slot = slot + 1 & this.mask;
            }
        }

        private void rehash() {
            long[] oldVals = this.vals;
            int newCapacity = this.vals.length << 1;
            this.vals = new long[newCapacity];
            this.mask = newCapacity - 1;
            this.threshold = (int)((float)newCapacity * 0.7f);
            this.cardinality = 0;
            for (long val : oldVals) {
                if (val == 0L) continue;
                this.add(val);
            }
        }

        int cardinality() {
            return this.cardinality + this.zeroCount;
        }
    }

    private static class Merger
    extends FacetSortableMerger {
        long answer = -1L;
        long sumUnique;
        Set<Object> values;
        long sumAdded;
        long shardsMissingSum;
        long shardsMissingMax;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            SimpleOrderedMap map = (SimpleOrderedMap)facetResult;
            long unique = ((Number)map.get("unique")).longValue();
            this.sumUnique += unique;
            int valsListed = 0;
            List vals = (List)map.get("vals");
            if (vals != null) {
                if (this.values == null) {
                    this.values = new HashSet<Object>(vals.size() * 4);
                }
                this.values.addAll(vals);
                valsListed = vals.size();
                this.sumAdded += (long)valsListed;
            }
            this.shardsMissingSum += unique - (long)valsListed;
            this.shardsMissingMax = Math.max(this.shardsMissingMax, unique - (long)valsListed);
        }

        private long getLong() {
            if (this.answer >= 0L) {
                return this.answer;
            }
            long l = this.answer = this.values == null ? 0L : (long)this.values.size();
            if (this.answer == 0L) {
                this.answer = this.shardsMissingSum;
                return this.answer;
            }
            double factor = (double)this.values.size() / (double)this.sumAdded;
            long estimate = (long)((double)this.shardsMissingSum * factor);
            this.answer = (long)this.values.size() + estimate;
            return this.answer;
        }

        @Override
        public Object getMergedResult() {
            return this.getLong();
        }

        @Override
        public int compareTo(FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return Long.compare(this.getLong(), ((Merger)other).getLong());
        }
    }
}

