/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.IntFloatHashMap;
import com.carrotsearch.hppc.IntIntHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.SolrIndexSearcher;

public class ReRankCollector
extends TopDocsCollector {
    private final TopDocsCollector mainCollector;
    private final IndexSearcher searcher;
    private final int reRankDocs;
    private final int length;
    private final Map<BytesRef, Integer> boostedPriority;
    private final Rescorer reRankQueryRescorer;

    public ReRankCollector(int reRankDocs, int length, Rescorer reRankQueryRescorer, QueryCommand cmd, IndexSearcher searcher, Map<BytesRef, Integer> boostedPriority) throws IOException {
        super(null);
        this.reRankDocs = reRankDocs;
        this.length = length;
        this.boostedPriority = boostedPriority;
        Sort sort = cmd.getSort();
        if (sort == null) {
            this.mainCollector = TopScoreDocCollector.create((int)Math.max(this.reRankDocs, length));
        } else {
            sort = sort.rewrite(searcher);
            this.mainCollector = TopFieldCollector.create((Sort)sort, (int)Math.max(this.reRankDocs, length), (boolean)false, (boolean)true, (boolean)true);
        }
        this.searcher = searcher;
        this.reRankQueryRescorer = reRankQueryRescorer;
    }

    public int getTotalHits() {
        return this.mainCollector.getTotalHits();
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.mainCollector.getLeafCollector(context);
    }

    public boolean needsScores() {
        return true;
    }

    public TopDocs topDocs(int start, int howMany) {
        try {
            ScoreDoc[] scoreDocs;
            TopDocs mainDocs = this.mainCollector.topDocs(0, Math.max(this.reRankDocs, this.length));
            if (mainDocs.totalHits == 0 || mainDocs.scoreDocs.length == 0) {
                return mainDocs;
            }
            ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
            ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
            System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
            mainDocs.scoreDocs = reRankScoreDocs;
            TopDocs rescoredDocs = this.reRankQueryRescorer.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
            howMany = Math.min(howMany, mainScoreDocs.length);
            if (this.boostedPriority != null) {
                SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
                Map<Object, Object> requestContext = null;
                if (info != null) {
                    requestContext = info.getReq().getContext();
                }
                IntIntHashMap boostedDocs = QueryElevationComponent.getBoostDocs((SolrIndexSearcher)this.searcher, this.boostedPriority, requestContext);
                Arrays.sort(rescoredDocs.scoreDocs, new BoostedComp(boostedDocs, mainDocs.scoreDocs, rescoredDocs.getMaxScore()));
            }
            if (howMany == rescoredDocs.scoreDocs.length) {
                return rescoredDocs;
            }
            if (howMany > rescoredDocs.scoreDocs.length) {
                scoreDocs = new ScoreDoc[howMany];
                System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                rescoredDocs.scoreDocs = scoreDocs;
                return rescoredDocs;
            }
            scoreDocs = new ScoreDoc[howMany];
            System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
            rescoredDocs.scoreDocs = scoreDocs;
            return rescoredDocs;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    public static class BoostedComp
    implements Comparator {
        IntFloatHashMap boostedMap;

        public BoostedComp(IntIntHashMap boostedDocs, ScoreDoc[] scoreDocs, float maxScore) {
            int idx;
            this.boostedMap = new IntFloatHashMap(boostedDocs.size() * 2);
            for (int i = 0; i < scoreDocs.length && (idx = boostedDocs.indexOf(scoreDocs[i].doc)) >= 0; ++i) {
                this.boostedMap.put(scoreDocs[i].doc, maxScore + (float)boostedDocs.indexGet(idx));
            }
        }

        public int compare(Object o1, Object o2) {
            ScoreDoc doc1 = (ScoreDoc)o1;
            ScoreDoc doc2 = (ScoreDoc)o2;
            float score1 = doc1.score;
            float score2 = doc2.score;
            int idx = this.boostedMap.indexOf(doc1.doc);
            if (idx >= 0) {
                score1 = this.boostedMap.indexGet(idx);
            }
            if ((idx = this.boostedMap.indexOf(doc2.doc)) >= 0) {
                score2 = this.boostedMap.indexGet(idx);
            }
            return -Float.compare(score1, score2);
        }
    }
}

