/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionRangeQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.util.DateMathParser;

public abstract class NumericFieldType
extends PrimitiveFieldType {
    protected NumberType type;
    private static long FLOAT_NEGATIVE_INFINITY_BITS = Float.floatToIntBits(Float.NEGATIVE_INFINITY);
    private static long DOUBLE_NEGATIVE_INFINITY_BITS = Double.doubleToLongBits(Double.NEGATIVE_INFINITY);
    private static long FLOAT_POSITIVE_INFINITY_BITS = Float.floatToIntBits(Float.POSITIVE_INFINITY);
    private static long DOUBLE_POSITIVE_INFINITY_BITS = Double.doubleToLongBits(Double.POSITIVE_INFINITY);
    private static long FLOAT_MINUS_ZERO_BITS = Float.floatToIntBits(-0.0f);
    private static long DOUBLE_MINUS_ZERO_BITS = Double.doubleToLongBits(-0.0);
    private static long FLOAT_ZERO_BITS = Float.floatToIntBits(0.0f);
    private static long DOUBLE_ZERO_BITS = Double.doubleToLongBits(0.0);

    @Override
    public NumberType getNumberType() {
        return this.type;
    }

    protected Query getDocValuesRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        assert (field.hasDocValues() && (field.getType().isPointField() || !field.multiValued()));
        switch (this.getNumberType()) {
            case INTEGER: {
                return NumericFieldType.numericDocValuesRangeQuery(field.getName(), min == null ? null : Long.valueOf(Integer.parseInt(min)), max == null ? null : Long.valueOf(Integer.parseInt(max)), minInclusive, maxInclusive, field.multiValued());
            }
            case FLOAT: {
                if (field.multiValued()) {
                    return this.getRangeQueryForMultiValuedFloatDocValues(field, min, max, minInclusive, maxInclusive);
                }
                return this.getRangeQueryForFloatDoubleDocValues(field, min, max, minInclusive, maxInclusive);
            }
            case LONG: {
                return NumericFieldType.numericDocValuesRangeQuery(field.getName(), min == null ? null : Long.valueOf(Long.parseLong(min)), max == null ? null : Long.valueOf(Long.parseLong(max)), minInclusive, maxInclusive, field.multiValued());
            }
            case DOUBLE: {
                if (field.multiValued()) {
                    return this.getRangeQueryForMultiValuedDoubleDocValues(field, min, max, minInclusive, maxInclusive);
                }
                return this.getRangeQueryForFloatDoubleDocValues(field, min, max, minInclusive, maxInclusive);
            }
            case DATE: {
                return NumericFieldType.numericDocValuesRangeQuery(field.getName(), min == null ? null : Long.valueOf(DateMathParser.parseMath(null, min).getTime()), max == null ? null : Long.valueOf(DateMathParser.parseMath(null, max).getTime()), minInclusive, maxInclusive, field.multiValued());
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for numeric field");
    }

    protected Query getRangeQueryForFloatDoubleDocValues(SchemaField sf, String min, String max, boolean minInclusive, boolean maxInclusive) {
        FunctionRangeQuery query;
        long zeroBits;
        Long minBits;
        Double maxVal;
        Double minVal;
        String fieldName = sf.getName();
        Double d = min == null ? null : (minVal = Double.valueOf(this.getNumberType() == NumberType.FLOAT ? (double)Float.parseFloat(min) : Double.parseDouble(min)));
        Double d2 = max == null ? null : (maxVal = Double.valueOf(this.getNumberType() == NumberType.FLOAT ? (double)Float.parseFloat(max) : Double.parseDouble(max)));
        Long l = min == null ? null : (minBits = Long.valueOf(this.getNumberType() == NumberType.FLOAT ? (long)Float.floatToIntBits(((Number)minVal).floatValue()) : Double.doubleToLongBits(minVal)));
        Long maxBits = max == null ? null : Long.valueOf(this.getNumberType() == NumberType.FLOAT ? (long)Float.floatToIntBits(((Number)maxVal).floatValue()) : Double.doubleToLongBits(maxVal));
        long negativeInfinityBits = this.getNumberType() == NumberType.FLOAT ? FLOAT_NEGATIVE_INFINITY_BITS : DOUBLE_NEGATIVE_INFINITY_BITS;
        long positiveInfinityBits = this.getNumberType() == NumberType.FLOAT ? FLOAT_POSITIVE_INFINITY_BITS : DOUBLE_POSITIVE_INFINITY_BITS;
        long minusZeroBits = this.getNumberType() == NumberType.FLOAT ? FLOAT_MINUS_ZERO_BITS : DOUBLE_MINUS_ZERO_BITS;
        long l2 = zeroBits = this.getNumberType() == NumberType.FLOAT ? FLOAT_ZERO_BITS : DOUBLE_ZERO_BITS;
        if ((minVal == null || minVal < 0.0 || minBits == minusZeroBits) && (maxVal == null || maxVal > 0.0 || maxBits == zeroBits)) {
            ValueSource vs = this.getValueSource(sf, null);
            query = new FunctionRangeQuery(new ValueSourceRangeFilter(vs, min, max, minInclusive, maxInclusive));
        } else {
            query = (minVal == null || minVal < 0.0 || minBits == minusZeroBits) && maxVal != null && (maxVal < 0.0 || maxBits == minusZeroBits) ? NumericFieldType.numericDocValuesRangeQuery(fieldName, maxBits, min == null ? Long.valueOf(negativeInfinityBits) : minBits, maxInclusive, minInclusive, false) : NumericFieldType.numericDocValuesRangeQuery(fieldName, minBits, max == null ? Long.valueOf(positiveInfinityBits) : maxBits, minInclusive, maxInclusive, false);
        }
        return query;
    }

    protected Query getRangeQueryForMultiValuedDoubleDocValues(SchemaField sf, String min, String max, boolean minInclusive, boolean maxInclusive) {
        Long minBits = min == null ? NumericUtils.doubleToSortableLong((double)Double.NEGATIVE_INFINITY) : NumericUtils.doubleToSortableLong((double)Double.parseDouble(min));
        Long maxBits = max == null ? NumericUtils.doubleToSortableLong((double)Double.POSITIVE_INFINITY) : NumericUtils.doubleToSortableLong((double)Double.parseDouble(max));
        return NumericFieldType.numericDocValuesRangeQuery(sf.getName(), minBits, maxBits, minInclusive, maxInclusive, true);
    }

    protected Query getRangeQueryForMultiValuedFloatDocValues(SchemaField sf, String min, String max, boolean minInclusive, boolean maxInclusive) {
        Long minBits = min == null ? NumericUtils.floatToSortableInt((float)Float.NEGATIVE_INFINITY) : NumericUtils.floatToSortableInt((float)Float.parseFloat(min));
        Long maxBits = max == null ? NumericUtils.floatToSortableInt((float)Float.POSITIVE_INFINITY) : NumericUtils.floatToSortableInt((float)Float.parseFloat(max));
        return NumericFieldType.numericDocValuesRangeQuery(sf.getName(), minBits, maxBits, minInclusive, maxInclusive, true);
    }

    public static Query numericDocValuesRangeQuery(String field, Number lowerValue, Number upperValue, boolean lowerInclusive, boolean upperInclusive, boolean multiValued) {
        long actualLowerValue = Long.MIN_VALUE;
        if (lowerValue != null) {
            actualLowerValue = lowerValue.longValue();
            if (!lowerInclusive) {
                if (actualLowerValue == Long.MAX_VALUE) {
                    return new MatchNoDocsQuery();
                }
                ++actualLowerValue;
            }
        }
        long actualUpperValue = Long.MAX_VALUE;
        if (upperValue != null) {
            actualUpperValue = upperValue.longValue();
            if (!upperInclusive) {
                if (actualUpperValue == Long.MIN_VALUE) {
                    return new MatchNoDocsQuery();
                }
                --actualUpperValue;
            }
        }
        if (multiValued) {
            return SortedNumericDocValuesField.newRangeQuery((String)field, (long)actualLowerValue, (long)actualUpperValue);
        }
        return NumericDocValuesField.newRangeQuery((String)field, (long)actualLowerValue, (long)actualUpperValue);
    }
}

