/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.handler.admin.BaseHandlerApiSupport;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class CoreAdminHandlerApi
extends BaseHandlerApiSupport {
    private final CoreAdminHandler handler;

    public CoreAdminHandlerApi(CoreAdminHandler handler) {
        this.handler = handler;
    }

    @Override
    protected List<BaseHandlerApiSupport.ApiCommand> getCommands() {
        return Arrays.asList(Cmd.values());
    }

    @Override
    protected List<BaseHandlerApiSupport.V2EndPoint> getEndPoints() {
        return Arrays.asList(EndPoint.values());
    }

    static enum EndPoint implements BaseHandlerApiSupport.V2EndPoint
    {
        CORES_STATUS("cores.Status"),
        CORES_COMMANDS("cores.Commands"),
        PER_CORE_COMMANDS("cores.core.Commands"),
        NODEINVOKE("node.invoke"),
        NODEAPIS("node.Commands");

        final String specName;

        private EndPoint(String specName) {
            this.specName = specName;
        }

        @Override
        public String getSpecName() {
            return this.specName;
        }
    }

    static enum Cmd implements BaseHandlerApiSupport.ApiCommand
    {
        CREATE(EndPoint.CORES_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.CREATE_OP, null, (Map<String, String>)ImmutableMap.of((Object)"config", (Object)"configSet")),
        UNLOAD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.UNLOAD_OP, null, null),
        RELOAD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.RELOAD_OP, null, null),
        STATUS(EndPoint.CORES_STATUS, SolrRequest.METHOD.GET, CoreAdminOperation.STATUS_OP),
        SWAP(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.SWAP_OP, null, (Map<String, String>)ImmutableMap.of((Object)"other", (Object)"with")),
        RENAME(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.RENAME_OP, null, null),
        MERGEINDEXES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.MERGEINDEXES_OP, "merge-indexes", null),
        SPLIT(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.SPLIT_OP, null, (Map<String, String>)ImmutableMap.of((Object)"split.key", (Object)"splitKey")),
        PREPRECOVERY(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.PREPRECOVERY_OP, "prep-recovery", null),
        REQUESTRECOVERY(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.REQUESTRECOVERY_OP, null, null),
        REQUESTSYNCSHARD(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.REQUESTSYNCSHARD_OP, "request-sync-shard", null),
        REQUESTBUFFERUPDATES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.REQUESTBUFFERUPDATES_OP, "request-buffer-updates", null),
        REQUESTAPPLYUPDATES(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.REQUESTAPPLYUPDATES_OP, "request-apply-updates", null),
        REQUESTSTATUS(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.REQUESTSTATUS_OP, null, null),
        OVERSEEROP(EndPoint.NODEAPIS, SolrRequest.METHOD.POST, CoreAdminOperation.OVERSEEROP_OP, "overseer-op", null),
        REJOINLEADERELECTION(EndPoint.NODEAPIS, SolrRequest.METHOD.POST, CoreAdminOperation.REJOINLEADERELECTION_OP, "rejoin-leader-election", null),
        INVOKE(EndPoint.NODEINVOKE, SolrRequest.METHOD.GET, CoreAdminOperation.INVOKE_OP, null, null),
        FORCEPREPAREFORLEADERSHIP(EndPoint.PER_CORE_COMMANDS, SolrRequest.METHOD.POST, CoreAdminOperation.FORCEPREPAREFORLEADERSHIP_OP, "force-prepare-for-leadership", null);

        public final String commandName;
        public final BaseHandlerApiSupport.V2EndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final Map<String, String> paramstoAttr;
        final CoreAdminOperation target;

        private Cmd(EndPoint endPoint, SolrRequest.METHOD method, CoreAdminOperation target) {
            this.endPoint = endPoint;
            this.method = method;
            this.target = target;
            this.commandName = null;
            this.paramstoAttr = Collections.EMPTY_MAP;
        }

        private Cmd(EndPoint endPoint, SolrRequest.METHOD method, CoreAdminOperation target, String commandName, Map<String, String> paramstoAttr) {
            this.commandName = commandName == null ? target.action.toString().toLowerCase(Locale.ROOT) : commandName;
            this.endPoint = endPoint;
            this.method = method;
            this.target = target;
            this.paramstoAttr = paramstoAttr == null ? Collections.EMPTY_MAP : paramstoAttr;
        }

        @Override
        public String getName() {
            return this.commandName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public BaseHandlerApiSupport.V2EndPoint getEndPoint() {
            return this.endPoint;
        }

        @Override
        public String getParamSubstitute(String param) {
            return this.paramstoAttr.containsKey(param) ? this.paramstoAttr.get(param) : param;
        }

        @Override
        public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
            this.target.execute(new CoreAdminHandler.CallInfo(((CoreAdminHandlerApi)apiHandler).handler, req, rsp, this.target));
        }
    }
}

