/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkContainer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ZkController zkController;
    private SolrZkServer zkServer;
    private ExecutorService coreZkRegister = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new DefaultSolrThreadFactory("coreZkRegister"));
    private boolean zkRunOnly = Boolean.getBoolean("zkRunOnly");

    public void initZooKeeper(final CoreContainer cc, String solrHome, CloudConfig config) {
        ZkController zkController = null;
        String zkRun = System.getProperty("zkRun");
        if (zkRun != null && config == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot start Solr in cloud mode - no cloud config provided");
        }
        if (config == null) {
            return;
        }
        String zookeeperHost = config.getZkHost();
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        if (zkRun != null) {
            String zkDataHome = System.getProperty("zkServerDataDir", Paths.get(solrHome, new String[0]).resolve("zoo_data").toString());
            String zkConfHome = System.getProperty("zkServerConfDir", solrHome);
            this.zkServer = new SolrZkServer(this.stripChroot(zkRun), this.stripChroot(config.getZkHost()), zkDataHome, zkConfHome, config.getSolrHostPort());
            this.zkServer.parseConfig();
            this.zkServer.start();
            if (zookeeperHost == null) {
                zookeeperHost = this.zkServer.getClientString();
            }
        }
        int zkClientConnectTimeout = 30000;
        if (zookeeperHost != null) {
            try {
                if (zkRun != null && this.zkServer.getServers().size() > 1) {
                    zkClientConnectTimeout = 86400000;
                    log.info("Zookeeper client=" + zookeeperHost + "  Waiting for a quorum.");
                } else {
                    log.info("Zookeeper client=" + zookeeperHost);
                }
                String confDir = System.getProperty("bootstrap_confdir");
                boolean boostrapConf = Boolean.getBoolean("bootstrap_conf");
                if (!ZkController.checkChrootPath(zookeeperHost, confDir != null || boostrapConf || this.zkRunOnly)) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A chroot was specified in ZkHost but the znode doesn't exist. " + zookeeperHost);
                }
                zkController = new ZkController(cc, zookeeperHost, zkClientConnectTimeout, config, new CurrentCoreDescriptorProvider(){

                    @Override
                    public List<CoreDescriptor> getCurrentDescriptors() {
                        ArrayList<CoreDescriptor> descriptors = new ArrayList<CoreDescriptor>(cc.getLoadedCoreNames().size());
                        Collection<SolrCore> cores = cc.getCores();
                        for (SolrCore core : cores) {
                            descriptors.add(core.getCoreDescriptor());
                        }
                        return descriptors;
                    }
                });
                if (zkRun != null && this.zkServer.getServers().size() > 1 && confDir == null && !boostrapConf) {
                    Thread.sleep(10000L);
                }
                if (confDir != null) {
                    Path configPath = Paths.get(confDir, new String[0]);
                    if (!Files.isDirectory(configPath, new LinkOption[0])) {
                        throw new IllegalArgumentException("bootstrap_confdir must be a directory of configuration files");
                    }
                    String confName = System.getProperty("collection.configName", "configuration1");
                    ZkConfigManager configManager = new ZkConfigManager(zkController.getZkClient());
                    configManager.uploadConfigDir(configPath, confName);
                }
                if (boostrapConf) {
                    ZkController.bootstrapConf(zkController.getZkClient(), cc, solrHome);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("Could not connect to ZooKeeper", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (IOException | KeeperException e) {
                log.error("", e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
            }
        }
        this.zkController = zkController;
    }

    private String stripChroot(String zkRun) {
        if (zkRun == null || zkRun.trim().length() == 0 || zkRun.lastIndexOf(47) < 0) {
            return zkRun;
        }
        return zkRun.substring(0, zkRun.lastIndexOf(47));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInZk(SolrCore core, boolean background, boolean skipRecovery) {
        Runnable r = () -> {
            MDCLoggingContext.setCore(core);
            try {
                try {
                    this.zkController.register(core.getName(), core.getCoreDescriptor(), skipRecovery);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
                catch (Exception e) {
                    try {
                        this.zkController.publish(core.getCoreDescriptor(), Replica.State.DOWN);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        log.error("", (Throwable)e1);
                    }
                    catch (Exception e1) {
                        log.error("", (Throwable)e1);
                    }
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
            }
            finally {
                MDCLoggingContext.clear();
            }
        };
        if (this.zkController != null) {
            if (background) {
                this.coreZkRegister.execute(r);
            } else {
                MDCLoggingContext.setCore(core);
                try {
                    r.run();
                }
                finally {
                    MDCLoggingContext.clear();
                }
            }
        }
    }

    public ZkController getZkController() {
        return this.zkController;
    }

    public void publishCoresAsDown(List<SolrCore> cores) {
        for (SolrCore core : cores) {
            try {
                this.zkController.publish(core.getCoreDescriptor(), Replica.State.DOWN);
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                log.error("", (Throwable)e);
            }
        }
    }

    public void close() {
        try {
            if (this.zkController != null) {
                this.zkController.close();
            }
        }
        finally {
            try {
                if (this.zkServer != null) {
                    this.zkServer.stop();
                }
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreZkRegister);
            }
        }
    }

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.coreZkRegister;
    }
}

