/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ZkStateReader zkStateReader;

    public CollectionMutator(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
    }

    public ZkWriteCommand createShard(ClusterState clusterState, ZkNodeProps message) {
        String collectionName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String shardId = message.getStr("shard");
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(shardId);
        if (slice == null) {
            Map replicas = Collections.EMPTY_MAP;
            HashMap<String, String> sliceProps = new HashMap<String, String>();
            String shardRange = message.getStr("shard_range");
            String shardState = message.getStr("shard_state");
            String shardParent = message.getStr("shard_parent");
            String shardParentZkSession = message.getStr("shard_parent_zk_session");
            String shardParentNode = message.getStr("shard_parent_node");
            sliceProps.put("range", shardRange);
            sliceProps.put("state", shardState);
            if (shardParent != null) {
                sliceProps.put("parent", shardParent);
            }
            if (shardParentZkSession != null) {
                sliceProps.put("shard_parent_zk_session", shardParentZkSession);
            }
            if (shardParentNode != null) {
                sliceProps.put("shard_parent_node", shardParentNode);
            }
            collection = CollectionMutator.updateSlice(collectionName, collection, new Slice(shardId, replicas, sliceProps));
            return new ZkWriteCommand(collectionName, collection);
        }
        log.error("Unable to create Shard: " + shardId + " because it already exists in collection: " + collectionName);
        return ZkStateWriter.NO_OP;
    }

    public ZkWriteCommand deleteShard(ClusterState clusterState, ZkNodeProps message) {
        String sliceId = message.getStr("shard");
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        log.info("Removing collection: " + collection + " shard: " + sliceId + " from clusterstate");
        DocCollection coll = clusterState.getCollection(collection);
        LinkedHashMap newSlices = new LinkedHashMap(coll.getSlicesMap());
        newSlices.remove(sliceId);
        DocCollection newCollection = coll.copyWithSlices(newSlices);
        return new ZkWriteCommand(collection, newCollection);
    }

    public ZkWriteCommand modifyCollection(ClusterState clusterState, ZkNodeProps message) {
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollection(message.getStr("collection"));
        Map m = coll.shallowCopy();
        boolean hasAnyOps = false;
        for (String prop : CollectionsHandler.MODIFIABLE_COLL_PROPS) {
            if (message.get(prop) == null) continue;
            hasAnyOps = true;
            m.put(prop, message.get(prop));
        }
        if (!hasAnyOps) {
            return ZkStateWriter.NO_OP;
        }
        return new ZkWriteCommand(coll.getName(), new DocCollection(coll.getName(), coll.getSlicesMap(), m, coll.getRouter(), coll.getZNodeVersion(), coll.getZNode()));
    }

    public static DocCollection updateSlice(String collectionName, DocCollection collection, Slice slice) {
        DocCollection newCollection = null;
        if (collection == null) {
            LinkedHashMap<String, Slice> slices = new LinkedHashMap<String, Slice>(1);
            slices.put(slice.getName(), slice);
            HashMap<String, Map> props = new HashMap<String, Map>(1);
            props.put("router", Utils.makeMap((Object[])new Object[]{"name", "implicit"}));
            newCollection = new DocCollection(collectionName, slices, props, (DocRouter)new ImplicitDocRouter());
        } else {
            LinkedHashMap<String, Slice> slices = new LinkedHashMap<String, Slice>(collection.getSlicesMap());
            slices.put(slice.getName(), slice);
            newCollection = collection.copyWithSlices(slices);
        }
        return newCollection;
    }

    static boolean checkCollectionKeyExistence(ZkNodeProps message) {
        return CollectionMutator.checkKeyExistence(message, "collection");
    }

    static boolean checkKeyExistence(ZkNodeProps message, String key) {
        String value = message.getStr(key);
        if (value == null || value.trim().length() == 0) {
            log.error("Skipping invalid Overseer message because it has no " + key + " specified: " + message);
            return false;
        }
        return true;
    }
}

