/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.UUID;

public class CrawlConfiguration {
    private final UUID datasetKey;
    private final URI url;
    private final int attempt;

    protected CrawlConfiguration(UUID datasetKey, URI url, int attempt) {
        this.datasetKey = (UUID)Preconditions.checkNotNull((Object)datasetKey, (Object)"datasetKey can't be null");
        this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url can't be null");
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"crawl attempt has to be greater than or equal to 1");
        this.attempt = attempt;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public URI getUrl() {
        return this.url;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CrawlConfiguration)) {
            return false;
        }
        CrawlConfiguration other = (CrawlConfiguration)obj;
        return Objects.equal((Object)this.datasetKey, (Object)other.datasetKey) && Objects.equal((Object)this.url, (Object)other.url) && Objects.equal((Object)this.attempt, (Object)other.attempt);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetKey, this.url, this.attempt});
    }

    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper(this.getClass()).add("datasetKey", (Object)this.datasetKey).add("url", (Object)this.url).add("attempt", this.attempt);
    }
}

