/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.geospatial;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gbif.common.parsers.core.ASCIIParser;
import org.gbif.common.parsers.core.FileBasedDictionaryParser;
import org.gbif.common.parsers.core.ParseResult;

public class DatumParser
extends FileBasedDictionaryParser<Integer> {
    private static DatumParser singletonObject;
    private final Pattern EPSG = Pattern.compile("\\s*(EPSG|ESPG)\\s*:+\\s*(\\d+)\\s*$", 2);
    private final Pattern NORMALIZER = Pattern.compile("[^a-zA-Z0-9]+");
    private final ASCIIParser ascii = ASCIIParser.getInstance();

    private DatumParser() {
        super(false);
        this.init(DatumParser.class.getResourceAsStream("/dictionaries/parse/datum.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatumParser getInstance() {
        Class<DatumParser> clazz = DatumParser.class;
        synchronized (DatumParser.class) {
            if (singletonObject == null) {
                singletonObject = new DatumParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }

    @Override
    public ParseResult<Integer> parse(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return null;
        }
        Matcher m = this.EPSG.matcher(input);
        if (m.find()) {
            Integer code = Integer.valueOf(m.group(2));
            return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, code);
        }
        return super.parse(input);
    }

    @Override
    protected String normalize(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        ParseResult<String> asci = this.ascii.parse(value);
        return this.NORMALIZER.matcher(asci.getPayload()).replaceAll("").toUpperCase();
    }

    @Override
    protected Integer fromDictFile(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }
}

