/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class LetStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private StreamContext streamContext;
    private Map letParams = new HashMap();

    public LetStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionParameter streamExpressionParameter : namedParams) {
            String name = ((StreamExpressionNamedParameter)streamExpressionParameter).getName();
            StreamExpressionParameter param = ((StreamExpressionNamedParameter)streamExpressionParameter).getParameter();
            if (factory.isEvaluator((StreamExpression)param)) {
                StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
                this.letParams.put(name, evaluator);
                continue;
            }
            TupleStream tupleStream = factory.constructStream((StreamExpression)param);
            this.letParams.put(name, tupleStream);
        }
        if (streamExpressions.size() != 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting 1 stream but found %d", expression, streamExpressions.size()));
        }
        this.stream = factory.constructStream(streamExpressions.get(0));
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        explanation.addChild(this.stream.toExplanation(factory));
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        return this.stream.read();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        Map<String, Object> lets = this.streamContext.getLets();
        Set entries = this.letParams.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Object o = entry.getValue();
            if (o instanceof TupleStream) {
                ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                TupleStream tStream = (TupleStream)o;
                tStream.setStreamContext(this.streamContext);
                try {
                    tStream.open();
                    while (true) {
                        Tuple tuple = tStream.read();
                        if (tuple.EOF) break;
                        tuples.add(tuple);
                    }
                    lets.put(name, tuples);
                    continue;
                }
                finally {
                    tStream.close();
                    continue;
                }
            }
            Tuple eTuple = new Tuple(lets);
            StreamEvaluator evaluator = (StreamEvaluator)o;
            Object eo = evaluator.evaluate(eTuple);
            lets.put(name, eo);
        }
        this.stream.open();
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

