/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import au.org.ala.layers.dto.StoreRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class LayerStoreFilesUtil {
    private static final String[] VALID_DIRECTORIES = new String[]{"diva", "diva_cache", "shape", "shape_diva", "analysis", "tabulation"};
    private static final Logger logger = Logger.getLogger(LayerStoreFilesUtil.class);
    private static Thread thread = null;
    private static Map log = new ConcurrentSkipListMap();

    public static void writeFilesZippedToStream(String layerFilesPath, OutputStream stream, StoreRequest request) throws Exception {
        ZipOutputStream zos = null;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(stream);
            zos = new ZipOutputStream(bos);
            ZipEntry ze = new ZipEntry("blank");
            zos.putNextEntry(ze);
            zos.write(1);
            zos.closeEntry();
            String[] dirs = VALID_DIRECTORIES;
            if (request.getFilter() != null) {
                dirs = new String[request.getFilter().size()];
                request.getFilter().toArray(dirs);
            }
            for (String dir : dirs) {
                if (!ArrayUtils.contains((Object[])VALID_DIRECTORIES, (Object)dir)) continue;
                for (File f : new File(layerFilesPath + dir).listFiles()) {
                    if (f.isDirectory()) {
                        for (File sub : f.listFiles()) {
                            LayerStoreFilesUtil.zipFile(sub, dir + "/" + f.getName(), request, zos);
                        }
                        continue;
                    }
                    LayerStoreFilesUtil.zipFile(f, dir, request, zos);
                }
            }
            zos.flush();
        }
        catch (Exception e) {
            logger.error((Object)"failed to return layers files.", (Throwable)e);
            throw new RuntimeException("failed to get files");
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File f, String dir, StoreRequest request, ZipOutputStream zos) throws IOException {
        int i;
        if (!f.isFile()) {
            return;
        }
        String fname = dir + "/" + f.getName();
        boolean include = true;
        if (request.getExclude() != null) {
            for (i = 0; i < request.getExclude().size() && include; ++i) {
                include = !request.getExclude().get(i).get("filename").equals(fname) || Long.parseLong(String.valueOf(request.getExclude().get(i).get("lastModified"))) < f.lastModified();
            }
        }
        if (request.getInclude() != null) {
            include = false;
            for (i = 0; i < request.getInclude().size() && !include; ++i) {
                include = request.getInclude().get(i).equals(fname) || fname.startsWith(request.getInclude().get(i) + ".");
            }
        }
        if (include) {
            ZipEntry ze = new ZipEntry(fname);
            zos.putNextEntry(ze);
            BufferedInputStream bis = null;
            try {
                int n;
                bis = new BufferedInputStream(new FileInputStream(f));
                byte[] b = new byte[0x100000];
                while ((n = bis.read(b)) > 0) {
                    zos.write(b, 0, n);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            zos.closeEntry();
        }
    }

    public static synchronized Map sync(String layerFilesPath, StoreRequest request, boolean waitUntilFinished) throws Exception {
        final String apiKeyFinal = request.getApiKey();
        final String layersServiceUrlFinal = request.getLayersServiceUrl();
        final List<String> filterFinal = request.getFilter();
        final List<String> includeFinal = request.getInclude();
        final String layerFilesPathFinal = layerFilesPath;
        if (thread == null || !thread.isAlive() || waitUntilFinished) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HttpClient client = new HttpClient();
                        PostMethod post = new PostMethod(layersServiceUrlFinal + "/store/get");
                        post.addRequestHeader("Content-Type", "application/json");
                        JSONObject jo = new JSONObject();
                        jo.put((Object)"apiKey", (Object)apiKeyFinal);
                        jo.put((Object)"filter", (Object)filterFinal);
                        if (includeFinal != null) {
                            jo.put((Object)"include", (Object)includeFinal);
                        }
                        JSONArray exclude = new JSONArray();
                        for (Object o : filterFinal) {
                            String dir = (String)o;
                            if (!ArrayUtils.contains((Object[])VALID_DIRECTORIES, (Object)dir)) continue;
                            for (File f : new File(layerFilesPathFinal + "/" + dir).listFiles()) {
                                JSONObject fo = new JSONObject();
                                fo.put((Object)"filename", (Object)(dir + "/" + f.getName()));
                                fo.put((Object)"lastModified", (Object)f.lastModified());
                                exclude.add((Object)fo);
                            }
                        }
                        jo.put((Object)"exclude", (Object)exclude);
                        post.setRequestEntity((RequestEntity)new StringRequestEntity(jo.toString(), "text/xml", "UTF-8"));
                        int result = client.executeMethod((HttpMethod)post);
                        String pth = layerFilesPathFinal + "/forSync/";
                        File filePth = new File(pth);
                        ZipInputStream zis = null;
                        try {
                            ZipEntry ze;
                            zis = new ZipInputStream(new BufferedInputStream(post.getResponseBodyAsStream()));
                            try {
                                FileUtils.deleteDirectory((File)filePth);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            FileUtils.forceMkdir((File)filePth);
                            while ((ze = zis.getNextEntry()) != null) {
                                FileUtils.forceMkdir((File)new File(new File(pth + ze.getName()).getParent()));
                                FilterOutputStream bos = null;
                                try {
                                    int n;
                                    bos = new BufferedOutputStream(new FileOutputStream(pth + ze.getName()));
                                    byte[] b = new byte[1024];
                                    while ((n = zis.read(b)) > 0) {
                                        ((BufferedOutputStream)bos).write(b, 0, n);
                                    }
                                    ((BufferedOutputStream)bos).flush();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                                finally {
                                    if (bos != null) {
                                        try {
                                            bos.close();
                                        }
                                        catch (Exception e) {
                                            logger.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }
                                long len = new File(pth + ze.getName()).length();
                                int typeIdx = 0;
                                String[] types = new String[]{"B", "KB", "MB"};
                                while (len / 1024L > 0L && typeIdx < types.length - 1) {
                                    ++typeIdx;
                                    len /= 1024L;
                                }
                                String size = String.valueOf(len) + " " + types[typeIdx];
                                log.put(new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS").format(new Date()), "Downloaded " + ze.getName() + " (" + size + ")");
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (zis != null) {
                                try {
                                    zis.close();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            if (post != null) {
                                try {
                                    post.releaseConnection();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        for (File src : filePth.listFiles()) {
                            if (!src.isDirectory()) continue;
                            File dst = new File(layerFilesPathFinal + "/" + src.getName());
                            String size = String.valueOf(FileUtils.sizeOfDirectory((File)src) / 1024L / 1024L) + " MB";
                            FileUtils.copyDirectory((File)src, (File)dst);
                            FileUtils.deleteDirectory((File)src);
                            log.put(new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS").format(new Date()), "Copied " + src.getName() + " (" + size + ")");
                        }
                        log.put(new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS").format(new Date()), "FINISHED");
                    }
                    catch (Exception e) {
                        log.put(new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS").format(new Date()), "ERROR " + e);
                        logger.error((Object)"error in store/pullRequest", (Throwable)e);
                        throw new RuntimeException("failed to send");
                    }
                }
            };
            log.put(new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS").format(new Date()), "STARTED: " + layersServiceUrlFinal + " filter=" + filterFinal);
            if (!waitUntilFinished) {
                thread = t;
                thread.start();
            } else {
                t.run();
            }
        }
        return log;
    }

    public static Map getLog() {
        return log;
    }
}

