/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.legend;

import au.org.ala.layers.legend.Legend;
import au.org.ala.layers.legend.LegendEvenInterval;
import au.org.ala.layers.legend.LegendEvenIntervalLog;
import au.org.ala.layers.legend.LegendEvenIntervalLog10;
import java.util.Arrays;

public class LegendEvaluate {
    public static Legend buildFrom(double[] d) {
        float[] dsorted = new float[d.length];
        for (int i = 0; i < d.length; ++i) {
            dsorted[i] = (float)d[i];
        }
        Arrays.sort(dsorted);
        Legend[] legends = new Legend[3];
        legends[1] = new LegendEvenInterval();
        legends[2] = new LegendEvenIntervalLog();
        legends[0] = new LegendEvenIntervalLog10();
        double bestE = Double.MAX_VALUE;
        int bestI = -1;
        for (int i = 0; i < legends.length; ++i) {
            legends[i].generate(dsorted);
            legends[i].determineGroupSizes(dsorted);
            double e2 = legends[i].evaluateStdDev(dsorted);
            if (i == 0 && !Double.isNaN(e2)) {
                bestI = i;
                bestE = e2;
                continue;
            }
            if (!(e2 < bestE)) continue;
            bestI = i;
            bestE = e2;
        }
        if (bestI == -1) {
            return null;
        }
        return legends[bestI];
    }

    public static Legend buildFrom(int[] intArray) {
        double[] d = new double[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            d[i] = intArray[i] == Integer.MIN_VALUE ? Double.NaN : (double)intArray[i];
        }
        return LegendEvaluate.buildFrom(d);
    }
}

