/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.grid;

import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.intersect.Grid;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class GridCacheBuilder {
    private static final Logger logger = Logger.getLogger(GridCacheBuilder.class);

    public static void main(String[] args) throws IOException {
        logger.info((Object)"args[0]=diva grid input dir\nargs[1]=cached diva grid output dir\n\n");
        ArrayList<Grid> grids = GridCacheBuilder.loadGridHeaders(args[0]);
        ArrayList<ArrayList<Grid>> groups = GridCacheBuilder.identifyGroups(grids);
        for (int i = 0; i < groups.size(); ++i) {
            GridCacheBuilder.writeGroup(args[1], groups.get(i));
        }
    }

    public static void all(String divaGridDir, String outputDir, LayerIntersectDAO layerIntersectDAO) {
        ArrayList<Grid> grids = GridCacheBuilder.loadGridHeaders(divaGridDir);
        ArrayList<ArrayList<Grid>> groups = GridCacheBuilder.identifyGroups(grids);
        File tmpDir = new File(outputDir + "/tmp/");
        try {
            FileUtils.forceMkdir((File)tmpDir);
            for (File f : tmpDir.listFiles()) {
                if (!f.isFile()) continue;
                FileUtils.deleteQuietly((File)f);
            }
        }
        catch (IOException e) {
            logger.error((Object)("failed to create or empty tmp dir in: " + outputDir), (Throwable)e);
        }
        for (int i = 0; i < groups.size(); ++i) {
            try {
                GridCacheBuilder.writeGroup(tmpDir.getPath(), groups.get(i));
                continue;
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (File f : new File(outputDir).listFiles()) {
            if (!f.isFile()) continue;
            FileUtils.deleteQuietly((File)f);
        }
        for (File f : tmpDir.listFiles()) {
            try {
                FileUtils.moveFile((File)f, (File)new File(f.getPath().replace("/tmp/", "")));
            }
            catch (IOException e) {
                logger.error((Object)("failed to move new grid cache file: " + f.getPath()));
            }
        }
        layerIntersectDAO.reload();
    }

    private static ArrayList<Grid> loadGridHeaders(String directory) {
        ArrayList<Grid> grids = new ArrayList<Grid>();
        File dir = new File(directory);
        for (File f : dir.listFiles()) {
            try {
                if (!f.getName().endsWith(".grd")) continue;
                Grid g = new Grid(f.getPath().substring(0, f.getPath().length() - 4));
                grids.add(g);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return grids;
    }

    private static ArrayList<ArrayList<Grid>> identifyGroups(ArrayList<Grid> grids) {
        ArrayList<ArrayList<Grid>> groups = new ArrayList<ArrayList<Grid>>();
        for (int i = 0; i < grids.size(); ++i) {
            boolean newGroup = true;
            for (int j = 0; j < groups.size(); ++j) {
                if (!GridCacheBuilder.compareGrids(groups.get(j).get(0), grids.get(i))) continue;
                groups.get(j).add(grids.get(i));
                newGroup = false;
                break;
            }
            if (!newGroup) continue;
            ArrayList<Grid> gs = new ArrayList<Grid>();
            gs.add(grids.get(i));
            groups.add(gs);
        }
        return groups;
    }

    private static boolean compareGrids(Grid g1, Grid g2) {
        return g1.ncols == g2.ncols && g1.nrows == g2.nrows && g1.xmin == g2.xmin && g1.ymin == g2.ymin && g1.xmax == g2.xmax && g1.ymax == g2.ymax;
    }

    private static void writeGroup(String dir, ArrayList<Grid> group) throws IOException {
        File f = null;
        int count = 0;
        while ((f = new File(dir + File.separator + "group_" + count + ".txt")).exists()) {
            ++count;
        }
        logger.info((Object)("writing: " + f.getName()));
        for (int i = 0; i < group.size(); ++i) {
            logger.info((Object)("   has: " + group.get((int)i).filename));
        }
        GridCacheBuilder.writeGroupHeader(f, group);
        GridCacheBuilder.writeGroupGRD(new File(dir + File.separator + "group_" + count), group);
        GridCacheBuilder.writeGroupGRI(new File(dir + File.separator + "group_" + count + ".gri"), group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeGroupHeader(File f, ArrayList<Grid> group) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(f);
            for (int i = 0; i < group.size(); ++i) {
                fw.write(group.get((int)i).filename);
                fw.write("\n");
            }
            fw.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void writeGroupGRD(File file, ArrayList<Grid> group) {
        Grid g = group.get(0);
        g.writeHeader(file.getPath(), g.xmin, g.ymin, g.xmin + g.xres * (double)g.nrows, g.ymin + g.yres * (double)g.ncols, g.xres, g.yres, g.nrows, g.ncols, g.minval, g.maxval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeGroupGRI(File file, ArrayList<Grid> group) {
        Grid g = group.get(0);
        RandomAccessFile[] raf = new RandomAccessFile[group.size()];
        RandomAccessFile output = null;
        try {
            output = new RandomAccessFile(file, "rw");
            for (int i = 0; i < group.size(); ++i) {
                raf[i] = new RandomAccessFile(group.get((int)i).filename + ".gri", "r");
            }
            int length = g.ncols * g.nrows;
            int size = 4;
            byte[] b = new byte[size * group.size() * g.ncols];
            float noDataValue = -3.4028235E38f;
            byte[] bi = new byte[g.ncols * 8];
            float[][] rows = new float[group.size()][g.ncols];
            for (int i = 0; i < g.nrows; ++i) {
                for (int j = 0; j < raf.length; ++j) {
                    GridCacheBuilder.nextRowOfFloats(rows[j], group.get((int)j).datatype, group.get((int)j).byteorderLSB, g.ncols, raf[j], bi, (float)g.nodatavalue);
                }
                ByteBuffer bb = ByteBuffer.wrap(b);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                for (int k = 0; k < g.ncols; ++k) {
                    for (int j = 0; j < raf.length; ++j) {
                        float f = rows[j][k];
                        if (Float.isNaN(f)) {
                            bb.putFloat(noDataValue);
                            continue;
                        }
                        bb.putFloat(f);
                    }
                }
                output.write(b);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (int i = 0; i < raf.length; ++i) {
                if (raf[i] == null) continue;
                try {
                    raf[i].close();
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static float getNextValue(RandomAccessFile raf, Grid g) {
        float f = Float.NaN;
        try {
            if (g.datatype.charAt(0) == 'B') {
                f = raf.readByte();
            } else if (g.datatype.charAt(0) == 'U') {
                f = raf.readByte();
                if (f < 0.0f) {
                    f += 256.0f;
                }
            } else if (g.datatype.charAt(0) == 'S') {
                int size = 2;
                byte[] b = new byte[size];
                raf.read(b);
                f = g.byteorderLSB.booleanValue() ? (float)((short)((0xFF & b[1]) << 8 | b[0] & 0xFF)) : (float)((short)((0xFF & b[0]) << 8 | b[1] & 0xFF));
            } else if (g.datatype.charAt(0) == 'I') {
                int size = 4;
                byte[] b = new byte[size];
                raf.read(b);
                f = g.byteorderLSB.booleanValue() ? (float)((0xFF & b[3]) << 24 | ((0xFF & b[2]) << 16) + ((0xFF & b[1]) << 8) + (b[0] & 0xFF)) : (float)((0xFF & b[0]) << 24 | ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3] & 0xFF));
            } else if (g.datatype.charAt(0) == 'L') {
                int size = 8;
                byte[] b = new byte[size];
                raf.read(b);
                f = g.byteorderLSB.booleanValue() ? (float)(((long)(0xFF & b[7]) << 56) + ((long)(0xFF & b[6]) << 48) + ((long)(0xFF & b[5]) << 40) + ((long)(0xFF & b[4]) << 32) + ((long)(0xFF & b[3]) << 24) + ((long)(0xFF & b[2]) << 16) + ((long)(0xFF & b[1]) << 8) + (long)(0xFF & b[0])) : (float)(((long)(0xFF & b[0]) << 56) + ((long)(0xFF & b[1]) << 48) + ((long)(0xFF & b[2]) << 40) + ((long)(0xFF & b[3]) << 32) + ((long)(0xFF & b[4]) << 24) + ((long)(0xFF & b[5]) << 16) + ((long)(0xFF & b[6]) << 8) + (long)(0xFF & b[7]));
            } else if (g.datatype.charAt(0) == 'F') {
                int size = 4;
                byte[] b = new byte[size];
                raf.read(b);
                ByteBuffer bb = ByteBuffer.wrap(b);
                if (g.byteorderLSB.booleanValue()) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                }
                f = bb.getFloat();
            } else if (g.datatype.charAt(0) == 'D') {
                int size = 8;
                byte[] b = new byte[8];
                raf.read(b);
                ByteBuffer bb = ByteBuffer.wrap(b);
                if (g.byteorderLSB.booleanValue()) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                }
                f = (float)bb.getDouble();
            }
            if (f == (float)g.nodatavalue) {
                f = Float.NaN;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    static void nextRowOfFloats(float[] row, String datatype, boolean byteOrderLSB, int ncols, RandomAccessFile raf, byte[] b, float noDataValue) throws IOException {
        int i;
        int size = 4;
        if (datatype.charAt(0) == 'U') {
            size = 1;
        } else if (datatype.charAt(0) == 'B') {
            size = 1;
        } else if (datatype.charAt(0) == 'S') {
            size = 2;
        } else if (datatype.charAt(0) == 'I') {
            size = 4;
        } else if (datatype.charAt(0) == 'L') {
            size = 8;
        } else if (datatype.charAt(0) == 'F') {
            size = 4;
        } else if (datatype.charAt(0) == 'D') {
            size = 8;
        }
        raf.read(b, 0, size * ncols);
        ByteBuffer bb = ByteBuffer.wrap(b);
        if (byteOrderLSB) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            bb.order(ByteOrder.BIG_ENDIAN);
        }
        int length = ncols;
        if (datatype.charAt(0) == 'U') {
            for (i = 0; i < length; ++i) {
                float ret = bb.get();
                if (ret < 0.0f) {
                    ret += 256.0f;
                }
                row[i] = ret;
            }
        } else if (datatype.charAt(0) == 'B') {
            for (i = 0; i < length; ++i) {
                row[i] = bb.get();
            }
        } else if (datatype.charAt(0) == 'S') {
            for (i = 0; i < length; ++i) {
                row[i] = bb.getShort();
            }
        } else if (datatype.charAt(0) == 'I') {
            for (i = 0; i < length; ++i) {
                row[i] = bb.getInt();
            }
        } else if (datatype.charAt(0) == 'L') {
            for (i = 0; i < length; ++i) {
                row[i] = bb.getLong();
            }
        } else if (datatype.charAt(0) == 'F') {
            for (i = 0; i < length; ++i) {
                row[i] = bb.getFloat();
            }
        } else if (datatype.charAt(0) == 'D') {
            for (i = 0; i < length; ++i) {
                row[i] = (float)bb.getDouble();
            }
        } else {
            logger.info((Object)("UNKNOWN TYPE: " + datatype));
        }
        for (i = 0; i < length; ++i) {
            if (row[i] != noDataValue) continue;
            row[i] = Float.NaN;
        }
    }
}

