/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.grid;

import au.org.ala.layers.grid.Grid2Shape;
import au.org.ala.layers.intersect.Grid;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class Envelope {
    private static final Logger logger = Logger.getLogger(Envelope.class);

    public static String getGridEnvelopeAsWkt(String params) {
        String[] p = params.split(",");
        Object geomIntersect = null;
        if (p.length == 3) {
            Grid g = new Grid(p[0]);
            return Grid2Shape.grid2Wkt(g.getGrid(), Double.parseDouble(p[1]), Double.parseDouble(p[2]), g.nrows, g.ncols, g.xmin, g.ymin, g.xres, g.yres);
        }
        for (int i = 0; i < p.length; i += 3) {
            Grid g = new Grid(p[i]);
            MultiPolygon thisGeometry = Grid2Shape.grid2Multipolygon(g.getGrid(), Double.parseDouble(p[i + 1]), Double.parseDouble(p[i + 2]), g.nrows, g.ncols, g.xmin, g.ymin, g.xres, g.yres);
            geomIntersect = geomIntersect == null ? thisGeometry : geomIntersect.intersection((Geometry)thisGeometry);
        }
        StringBuilder sb = new StringBuilder();
        if (geomIntersect instanceof Polygon || geomIntersect instanceof MultiPolygon) {
            sb.append(geomIntersect.toText().replace(" (", "(").replace(", ", ","));
        } else if (geomIntersect instanceof GeometryCollection) {
            sb.append("MULTIPOLYGON(");
            int count = 0;
            for (int i = 0; i < geomIntersect.getNumGeometries(); ++i) {
                if (geomIntersect.getGeometryN(i) instanceof Polygon) {
                    if (count > 0) {
                        sb.append(",");
                    }
                    ++count;
                    sb.append(geomIntersect.getGeometryN(i).toText().substring(8).replace(", ", ","));
                    continue;
                }
                if (geomIntersect.getGeometryN(i) instanceof MultiPolygon) {
                    if (count > 0) {
                        sb.append(",");
                    }
                    ++count;
                    String s = geomIntersect.getGeometryN(i).toText().replace(", ", ",");
                    sb.append(s.substring(14, s.length() - 1));
                    continue;
                }
                if (!(geomIntersect.getGeometryN(i) instanceof GeometryCollection)) continue;
                logger.debug((Object)"GridCacheReader.getGridEnvelopeAsWkt not processed: GeometryCollection inside of GeometryCollection");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static MultiPolygon getGridEnvelopeAsMultiPolygon(String params) {
        String[] p = params.split(",");
        Object geomIntersect = null;
        if (p.length == 3) {
            Grid g = new Grid(p[0]);
            return Grid2Shape.grid2Multipolygon(g.getGrid(), Double.parseDouble(p[1]), Double.parseDouble(p[2]), g.nrows, g.ncols, g.xmin, g.ymin, g.xres, g.yres);
        }
        for (int i = 0; i < p.length; i += 3) {
            Grid g = new Grid(p[i]);
            MultiPolygon thisGeometry = Grid2Shape.grid2Multipolygon(g.getGrid(), Double.parseDouble(p[i + 1]), Double.parseDouble(p[i + 2]), g.nrows, g.ncols, g.xmin, g.ymin, g.xres, g.yres);
            geomIntersect = geomIntersect == null ? thisGeometry : geomIntersect.intersection((Geometry)thisGeometry);
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        if (geomIntersect instanceof Polygon) {
            polygons.add((Polygon)geomIntersect);
        } else if (geomIntersect instanceof GeometryCollection || geomIntersect instanceof MultiPolygon) {
            for (int i = 0; i < geomIntersect.getNumGeometries(); ++i) {
                if (geomIntersect.getGeometryN(i) instanceof Polygon) {
                    polygons.add((Polygon)geomIntersect.getGeometryN(i));
                    continue;
                }
                if (geomIntersect.getGeometryN(i) instanceof MultiPolygon) {
                    MultiPolygon mp = (MultiPolygon)geomIntersect.getGeometryN(i);
                    for (int j = 0; j < mp.getNumGeometries(); ++j) {
                        polygons.add((Polygon)mp.getGeometryN(j));
                    }
                    continue;
                }
                if (!(geomIntersect.getGeometryN(i) instanceof GeometryCollection)) continue;
                logger.debug((Object)"GridCacheReader.getGridEnvelopeAsMultiPolygon not processed: GeometryCollection inside of GeometryCollection");
            }
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        Polygon[] pa = new Polygon[polygons.size()];
        polygons.toArray(pa);
        return geometryFactory.createMultiPolygon(pa);
    }

    public static void streamGridEnvelopeAsWkt(String params, OutputStream os) throws IOException {
        String[] p = params.split(",");
        Object geomIntersect = null;
        if (p.length == 3) {
            Grid g = new Grid(p[0]);
            Grid2Shape.streamGrid2Wkt(os, g.getGrid(), Double.parseDouble(p[1]), Double.parseDouble(p[2]), g.nrows, g.ncols, g.xmin, g.ymin, g.xres, g.yres);
        } else {
            for (int i = 0; i < p.length; i += 3) {
                Grid g = new Grid(p[i]);
                MultiPolygon thisGeometry = Grid2Shape.grid2Multipolygon(g.getGrid(), Double.parseDouble(p[i + 1]), Double.parseDouble(p[i + 2]), g.nrows, g.ncols, g.xmin, g.ymin, g.xres, g.yres);
                geomIntersect = geomIntersect == null ? thisGeometry : geomIntersect.intersection((Geometry)thisGeometry);
            }
            if (geomIntersect instanceof Polygon || geomIntersect instanceof MultiPolygon) {
                os.write(geomIntersect.toText().replace(" (", "(").replace(", ", ",").getBytes());
            } else if (geomIntersect instanceof GeometryCollection) {
                os.write("MULTIPOLYGON(".getBytes());
                int count = 0;
                for (int i = 0; i < geomIntersect.getNumGeometries(); ++i) {
                    if (geomIntersect.getGeometryN(i) instanceof Polygon) {
                        if (count > 0) {
                            os.write(",".getBytes());
                        }
                        ++count;
                        os.write(geomIntersect.getGeometryN(i).toText().substring(8).replace(", ", ",").getBytes());
                        continue;
                    }
                    if (geomIntersect.getGeometryN(i) instanceof MultiPolygon) {
                        if (count > 0) {
                            os.write(",".getBytes());
                        }
                        ++count;
                        String s = geomIntersect.getGeometryN(i).toText().replace(", ", ",");
                        os.write(s.substring(14, s.length() - 1).getBytes());
                        continue;
                    }
                    if (!(geomIntersect.getGeometryN(i) instanceof GeometryCollection)) continue;
                    logger.debug((Object)"GridCacheReader.getGridEnvelopeAsWkt not processed: GeometryCollection inside of GeometryCollection");
                }
                os.write(")".getBytes());
            }
        }
    }

    public static Map getGridSingleLayerEnvelopeAsWktIndexed(String params, int[] map) {
        String[] p = params.split(",");
        Grid g = new Grid(p[0]);
        return Grid2Shape.grid2WktIndexed(g.getGrid(), Double.parseDouble(p[1]), Double.parseDouble(p[2]), g.nrows, g.ncols, g.xmin, g.ymin, g.xres, g.yres, map);
    }
}

