/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.SearchDAO;
import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.SearchObject;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="searchDao")
public class SearchDAOImpl
implements SearchDAO {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    private SimpleJdbcTemplate jdbcTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int limit) {
        logger.info((Object)("Getting search results for query: " + criteria));
        String sql = "select pid, id, name, \"desc\" as description, fid, fieldname from searchobjects(?,?)";
        return this.addGridClassesToSearch(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(SearchObject.class), new Object[]{"%" + criteria + "%", limit}), criteria, limit);
    }

    private List<SearchObject> addGridClassesToSearch(List<SearchObject> search, String criteria, int limit) {
        int pos;
        criteria = criteria.toLowerCase();
        int maxPos = Integer.MAX_VALUE;
        for (SearchObject searchObject : search) {
            pos = searchObject.getName().toLowerCase().indexOf(criteria);
            if (pos < 0 || pos >= maxPos) continue;
            maxPos = pos;
        }
        for (Map.Entry entry : this.layerIntersectDao.getConfig().getIntersectionFiles().entrySet()) {
            IntersectionFile f = (IntersectionFile)entry.getValue();
            if (!"a".equalsIgnoreCase(f.getType()) || f.getClasses() == null || !((String)entry.getKey()).equals(f.getFieldId())) continue;
            for (Map.Entry<Integer, GridClass> c : f.getClasses().entrySet()) {
                pos = c.getValue().getName().toLowerCase().indexOf(criteria);
                if (pos < 0 || pos > maxPos) continue;
                search.add(SearchObject.create(f.getLayerPid() + ":" + c.getKey(), f.getLayerPid() + ":" + c.getKey(), c.getValue().getName(), null, f.getFieldId(), f.getFieldName()));
            }
        }
        return search;
    }
}

