/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPConst;
import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPPathFactory;
import com.adobe.xmp.XMPUtils;
import com.adobe.xmp.impl.ParameterAsserts;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.XMPIteratorImpl;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.impl.XMPNodeUtils;
import com.adobe.xmp.impl.XMPNormalizer;
import com.adobe.xmp.impl.xpath.XMPPath;
import com.adobe.xmp.impl.xpath.XMPPathParser;
import com.adobe.xmp.options.IteratorOptions;
import com.adobe.xmp.options.ParseOptions;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.properties.XMPProperty;
import java.util.Calendar;
import java.util.Iterator;

public class XMPMetaImpl
implements XMPMeta,
XMPConst {
    private static final int VALUE_STRING = 0;
    private static final int VALUE_BOOLEAN = 1;
    private static final int VALUE_INTEGER = 2;
    private static final int VALUE_LONG = 3;
    private static final int VALUE_DOUBLE = 4;
    private static final int VALUE_DATE = 5;
    private static final int VALUE_CALENDAR = 6;
    private static final int VALUE_BASE64 = 7;
    private XMPNode tree;
    private String packetHeader = null;

    public XMPMetaImpl() {
        this.tree = new XMPNode(null, null, null);
    }

    public XMPMetaImpl(XMPNode xMPNode) {
        this.tree = xMPNode;
    }

    @Override
    public void appendArrayItem(String string, String string2, PropertyOptions propertyOptions, String string3, PropertyOptions propertyOptions2) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        if (propertyOptions == null) {
            propertyOptions = new PropertyOptions();
        }
        if (!propertyOptions.isOnlyArrayOptions()) {
            throw new XMPException("Only array form flags allowed for arrayOptions", 103);
        }
        propertyOptions = XMPNodeUtils.verifySetOptions(propertyOptions, null);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
        if (xMPNode != null) {
            if (!xMPNode.getOptions().isArray()) {
                throw new XMPException("The named property is not an array", 102);
            }
        } else if (propertyOptions.isArray()) {
            xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, true, propertyOptions);
            if (xMPNode == null) {
                throw new XMPException("Failure creating array node", 102);
            }
        } else {
            throw new XMPException("Explicit arrayOptions required to create new array", 103);
        }
        this.doSetArrayItem(xMPNode, -1, string3, propertyOptions2, true);
    }

    @Override
    public void appendArrayItem(String string, String string2, String string3) throws XMPException {
        this.appendArrayItem(string, string2, null, string3, null);
    }

    @Override
    public int countArrayItems(String string, String string2) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
        if (xMPNode == null) {
            return 0;
        }
        if (xMPNode.getOptions().isArray()) {
            return xMPNode.getChildrenLength();
        }
        throw new XMPException("The named property is not an array", 102);
    }

    @Override
    public void deleteArrayItem(String string, String string2, int n) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertArrayName(string2);
            String string3 = XMPPathFactory.composeArrayItemPath(string2, n);
            this.deleteProperty(string, string3);
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    @Override
    public void deleteProperty(String string, String string2) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertPropName(string2);
            XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
            XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
            if (xMPNode != null) {
                XMPNodeUtils.deleteNode(xMPNode);
            }
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    @Override
    public void deleteQualifier(String string, String string2, String string3, String string4) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertPropName(string2);
            String string5 = string2 + XMPPathFactory.composeQualifierPath(string3, string4);
            this.deleteProperty(string, string5);
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    @Override
    public void deleteStructField(String string, String string2, String string3, String string4) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertStructName(string2);
            String string5 = string2 + XMPPathFactory.composeStructFieldPath(string3, string4);
            this.deleteProperty(string, string5);
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    @Override
    public boolean doesPropertyExist(String string, String string2) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertPropName(string2);
            XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
            XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
            return xMPNode != null;
        }
        catch (XMPException xMPException) {
            return false;
        }
    }

    @Override
    public boolean doesArrayItemExist(String string, String string2, int n) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertArrayName(string2);
            String string3 = XMPPathFactory.composeArrayItemPath(string2, n);
            return this.doesPropertyExist(string, string3);
        }
        catch (XMPException xMPException) {
            return false;
        }
    }

    @Override
    public boolean doesStructFieldExist(String string, String string2, String string3, String string4) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertStructName(string2);
            String string5 = XMPPathFactory.composeStructFieldPath(string3, string4);
            return this.doesPropertyExist(string, string2 + string5);
        }
        catch (XMPException xMPException) {
            return false;
        }
    }

    @Override
    public boolean doesQualifierExist(String string, String string2, String string3, String string4) {
        try {
            ParameterAsserts.assertSchemaNS(string);
            ParameterAsserts.assertPropName(string2);
            String string5 = XMPPathFactory.composeQualifierPath(string3, string4);
            return this.doesPropertyExist(string, string2 + string5);
        }
        catch (XMPException xMPException) {
            return false;
        }
    }

    @Override
    public XMPProperty getArrayItem(String string, String string2, int n) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        String string3 = XMPPathFactory.composeArrayItemPath(string2, n);
        return this.getProperty(string, string3);
    }

    @Override
    public XMPProperty getLocalizedText(String string, String string2, String string3, String string4) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        ParameterAsserts.assertSpecificLang(string4);
        string3 = string3 != null ? Utils.normalizeLangValue(string3) : null;
        string4 = Utils.normalizeLangValue(string4);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
        if (xMPNode == null) {
            return null;
        }
        Object[] objectArray = XMPNodeUtils.chooseLocalizedText(xMPNode, string3, string4);
        int n = (Integer)objectArray[0];
        final XMPNode xMPNode2 = (XMPNode)objectArray[1];
        if (n != 0) {
            return new XMPProperty(){

                @Override
                public Object getValue() {
                    return xMPNode2.getValue();
                }

                @Override
                public PropertyOptions getOptions() {
                    return xMPNode2.getOptions();
                }

                @Override
                public String getLanguage() {
                    return xMPNode2.getQualifier(1).getValue();
                }

                public String toString() {
                    return xMPNode2.getValue().toString();
                }
            };
        }
        return null;
    }

    @Override
    public void setLocalizedText(String string, String string2, String string3, String string4, String string5, PropertyOptions propertyOptions) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        ParameterAsserts.assertSpecificLang(string4);
        string3 = string3 != null ? Utils.normalizeLangValue(string3) : null;
        string4 = Utils.normalizeLangValue(string4);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, true, new PropertyOptions(7680));
        if (xMPNode == null) {
            throw new XMPException("Failed to find or create array node", 102);
        }
        if (!xMPNode.getOptions().isArrayAltText()) {
            if (!xMPNode.hasChildren() && xMPNode.getOptions().isArrayAlternate()) {
                xMPNode.getOptions().setArrayAltText(true);
            } else {
                throw new XMPException("Specified property is no alt-text array", 102);
            }
        }
        boolean bl = false;
        XMPNode xMPNode2 = null;
        Object[] objectArray = xMPNode.iterateChildren();
        while (objectArray.hasNext()) {
            XMPNode xMPNode3 = (XMPNode)objectArray.next();
            if (!xMPNode3.hasQualifier() || !"xml:lang".equals(xMPNode3.getQualifier(1).getName())) {
                throw new XMPException("Language qualifier must be first", 102);
            }
            if (!"x-default".equals(xMPNode3.getQualifier(1).getValue())) continue;
            xMPNode2 = xMPNode3;
            bl = true;
            break;
        }
        if (xMPNode2 != null && xMPNode.getChildrenLength() > 1) {
            xMPNode.removeChild(xMPNode2);
            xMPNode.addChild(1, xMPNode2);
        }
        objectArray = XMPNodeUtils.chooseLocalizedText(xMPNode, string3, string4);
        int n = (Integer)objectArray[0];
        XMPNode xMPNode4 = (XMPNode)objectArray[1];
        boolean bl2 = "x-default".equals(string4);
        switch (n) {
            case 0: {
                XMPNodeUtils.appendLangItem(xMPNode, "x-default", string5);
                bl = true;
                if (bl2) break;
                XMPNodeUtils.appendLangItem(xMPNode, string4, string5);
                break;
            }
            case 1: {
                if (!bl2) {
                    if (bl && xMPNode2 != xMPNode4 && xMPNode2 != null && xMPNode2.getValue().equals(xMPNode4.getValue())) {
                        xMPNode2.setValue(string5);
                    }
                    xMPNode4.setValue(string5);
                    break;
                }
                assert (bl && xMPNode2 == xMPNode4);
                Iterator iterator = xMPNode.iterateChildren();
                while (iterator.hasNext()) {
                    XMPNode xMPNode5 = (XMPNode)iterator.next();
                    if (xMPNode5 == xMPNode2 || !xMPNode5.getValue().equals(xMPNode2 != null ? xMPNode2.getValue() : null)) continue;
                    xMPNode5.setValue(string5);
                }
                if (xMPNode2 == null) break;
                xMPNode2.setValue(string5);
                break;
            }
            case 2: {
                if (bl && xMPNode2 != xMPNode4 && xMPNode2 != null && xMPNode2.getValue().equals(xMPNode4.getValue())) {
                    xMPNode2.setValue(string5);
                }
                xMPNode4.setValue(string5);
                break;
            }
            case 3: {
                XMPNodeUtils.appendLangItem(xMPNode, string4, string5);
                if (!bl2) break;
                bl = true;
                break;
            }
            case 4: {
                if (xMPNode2 != null && xMPNode.getChildrenLength() == 1) {
                    xMPNode2.setValue(string5);
                }
                XMPNodeUtils.appendLangItem(xMPNode, string4, string5);
                break;
            }
            case 5: {
                XMPNodeUtils.appendLangItem(xMPNode, string4, string5);
                if (!bl2) break;
                bl = true;
                break;
            }
            default: {
                throw new XMPException("Unexpected result from ChooseLocalizedText", 9);
            }
        }
        if (!bl && xMPNode.getChildrenLength() == 1) {
            XMPNodeUtils.appendLangItem(xMPNode, "x-default", string5);
        }
    }

    @Override
    public void setLocalizedText(String string, String string2, String string3, String string4, String string5) throws XMPException {
        this.setLocalizedText(string, string2, string3, string4, string5, null);
    }

    @Override
    public XMPProperty getProperty(String string, String string2) throws XMPException {
        return this.getProperty(string, string2, 0);
    }

    protected XMPProperty getProperty(String string, String string2, int n) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertPropName(string2);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        final XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
        if (xMPNode != null) {
            if (n != 0 && xMPNode.getOptions().isCompositeProperty()) {
                throw new XMPException("Property must be simple when a value type is requested", 102);
            }
            final Object object = this.evaluateNodeValue(n, xMPNode);
            return new XMPProperty(){

                @Override
                public Object getValue() {
                    return object;
                }

                @Override
                public PropertyOptions getOptions() {
                    return xMPNode.getOptions();
                }

                @Override
                public String getLanguage() {
                    return null;
                }

                public String toString() {
                    return object.toString();
                }
            };
        }
        return null;
    }

    protected Object getPropertyObject(String string, String string2, int n) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertPropName(string2);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
        if (xMPNode != null) {
            if (n != 0 && xMPNode.getOptions().isCompositeProperty()) {
                throw new XMPException("Property must be simple when a value type is requested", 102);
            }
            return this.evaluateNodeValue(n, xMPNode);
        }
        return null;
    }

    @Override
    public Boolean getPropertyBoolean(String string, String string2) throws XMPException {
        return (Boolean)this.getPropertyObject(string, string2, 1);
    }

    @Override
    public void setPropertyBoolean(String string, String string2, boolean bl, PropertyOptions propertyOptions) throws XMPException {
        this.setProperty(string, string2, bl ? "True" : "False", propertyOptions);
    }

    @Override
    public void setPropertyBoolean(String string, String string2, boolean bl) throws XMPException {
        this.setProperty(string, string2, bl ? "True" : "False", null);
    }

    @Override
    public Integer getPropertyInteger(String string, String string2) throws XMPException {
        return (Integer)this.getPropertyObject(string, string2, 2);
    }

    @Override
    public void setPropertyInteger(String string, String string2, int n, PropertyOptions propertyOptions) throws XMPException {
        this.setProperty(string, string2, new Integer(n), propertyOptions);
    }

    @Override
    public void setPropertyInteger(String string, String string2, int n) throws XMPException {
        this.setProperty(string, string2, new Integer(n), null);
    }

    @Override
    public Long getPropertyLong(String string, String string2) throws XMPException {
        return (Long)this.getPropertyObject(string, string2, 3);
    }

    @Override
    public void setPropertyLong(String string, String string2, long l, PropertyOptions propertyOptions) throws XMPException {
        this.setProperty(string, string2, new Long(l), propertyOptions);
    }

    @Override
    public void setPropertyLong(String string, String string2, long l) throws XMPException {
        this.setProperty(string, string2, new Long(l), null);
    }

    @Override
    public Double getPropertyDouble(String string, String string2) throws XMPException {
        return (Double)this.getPropertyObject(string, string2, 4);
    }

    @Override
    public void setPropertyDouble(String string, String string2, double d, PropertyOptions propertyOptions) throws XMPException {
        this.setProperty(string, string2, new Double(d), propertyOptions);
    }

    @Override
    public void setPropertyDouble(String string, String string2, double d) throws XMPException {
        this.setProperty(string, string2, new Double(d), null);
    }

    @Override
    public XMPDateTime getPropertyDate(String string, String string2) throws XMPException {
        return (XMPDateTime)this.getPropertyObject(string, string2, 5);
    }

    @Override
    public void setPropertyDate(String string, String string2, XMPDateTime xMPDateTime, PropertyOptions propertyOptions) throws XMPException {
        this.setProperty(string, string2, xMPDateTime, propertyOptions);
    }

    @Override
    public void setPropertyDate(String string, String string2, XMPDateTime xMPDateTime) throws XMPException {
        this.setProperty(string, string2, xMPDateTime, null);
    }

    @Override
    public Calendar getPropertyCalendar(String string, String string2) throws XMPException {
        return (Calendar)this.getPropertyObject(string, string2, 6);
    }

    @Override
    public void setPropertyCalendar(String string, String string2, Calendar calendar, PropertyOptions propertyOptions) throws XMPException {
        this.setProperty(string, string2, calendar, propertyOptions);
    }

    @Override
    public void setPropertyCalendar(String string, String string2, Calendar calendar) throws XMPException {
        this.setProperty(string, string2, calendar, null);
    }

    @Override
    public byte[] getPropertyBase64(String string, String string2) throws XMPException {
        return (byte[])this.getPropertyObject(string, string2, 7);
    }

    @Override
    public String getPropertyString(String string, String string2) throws XMPException {
        return (String)this.getPropertyObject(string, string2, 0);
    }

    @Override
    public void setPropertyBase64(String string, String string2, byte[] byArray, PropertyOptions propertyOptions) throws XMPException {
        this.setProperty(string, string2, byArray, propertyOptions);
    }

    @Override
    public void setPropertyBase64(String string, String string2, byte[] byArray) throws XMPException {
        this.setProperty(string, string2, byArray, null);
    }

    @Override
    public XMPProperty getQualifier(String string, String string2, String string3, String string4) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertPropName(string2);
        String string5 = string2 + XMPPathFactory.composeQualifierPath(string3, string4);
        return this.getProperty(string, string5);
    }

    @Override
    public XMPProperty getStructField(String string, String string2, String string3, String string4) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertStructName(string2);
        String string5 = string2 + XMPPathFactory.composeStructFieldPath(string3, string4);
        return this.getProperty(string, string5);
    }

    @Override
    public XMPIterator iterator() throws XMPException {
        return this.iterator(null, null, null);
    }

    @Override
    public XMPIterator iterator(IteratorOptions iteratorOptions) throws XMPException {
        return this.iterator(null, null, iteratorOptions);
    }

    @Override
    public XMPIterator iterator(String string, String string2, IteratorOptions iteratorOptions) throws XMPException {
        return new XMPIteratorImpl(this, string, string2, iteratorOptions);
    }

    @Override
    public void setArrayItem(String string, String string2, int n, String string3, PropertyOptions propertyOptions) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
        if (xMPNode == null) {
            throw new XMPException("Specified array does not exist", 102);
        }
        this.doSetArrayItem(xMPNode, n, string3, propertyOptions, false);
    }

    @Override
    public void setArrayItem(String string, String string2, int n, String string3) throws XMPException {
        this.setArrayItem(string, string2, n, string3, null);
    }

    @Override
    public void insertArrayItem(String string, String string2, int n, String string3, PropertyOptions propertyOptions) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, false, null);
        if (xMPNode == null) {
            throw new XMPException("Specified array does not exist", 102);
        }
        this.doSetArrayItem(xMPNode, n, string3, propertyOptions, true);
    }

    @Override
    public void insertArrayItem(String string, String string2, int n, String string3) throws XMPException {
        this.insertArrayItem(string, string2, n, string3, null);
    }

    @Override
    public void setProperty(String string, String string2, Object object, PropertyOptions propertyOptions) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertPropName(string2);
        propertyOptions = XMPNodeUtils.verifySetOptions(propertyOptions, object);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(this.tree, xMPPath, true, propertyOptions);
        if (xMPNode == null) {
            throw new XMPException("Specified property does not exist", 102);
        }
        this.setNode(xMPNode, object, propertyOptions, false);
    }

    @Override
    public void setProperty(String string, String string2, Object object) throws XMPException {
        this.setProperty(string, string2, object, null);
    }

    @Override
    public void setQualifier(String string, String string2, String string3, String string4, String string5, PropertyOptions propertyOptions) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertPropName(string2);
        if (!this.doesPropertyExist(string, string2)) {
            throw new XMPException("Specified property does not exist!", 102);
        }
        String string6 = string2 + XMPPathFactory.composeQualifierPath(string3, string4);
        this.setProperty(string, string6, string5, propertyOptions);
    }

    @Override
    public void setQualifier(String string, String string2, String string3, String string4, String string5) throws XMPException {
        this.setQualifier(string, string2, string3, string4, string5, null);
    }

    @Override
    public void setStructField(String string, String string2, String string3, String string4, String string5, PropertyOptions propertyOptions) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertStructName(string2);
        String string6 = string2 + XMPPathFactory.composeStructFieldPath(string3, string4);
        this.setProperty(string, string6, string5, propertyOptions);
    }

    @Override
    public void setStructField(String string, String string2, String string3, String string4, String string5) throws XMPException {
        this.setStructField(string, string2, string3, string4, string5, null);
    }

    @Override
    public String getObjectName() {
        return this.tree.getName() != null ? this.tree.getName() : "";
    }

    @Override
    public void setObjectName(String string) {
        this.tree.setName(string);
    }

    @Override
    public String getPacketHeader() {
        return this.packetHeader;
    }

    public void setPacketHeader(String string) {
        this.packetHeader = string;
    }

    @Override
    public Object clone() {
        XMPNode xMPNode = (XMPNode)this.tree.clone();
        return new XMPMetaImpl(xMPNode);
    }

    @Override
    public String dumpObject() {
        return this.getRoot().dumpNode(true);
    }

    @Override
    public void sort() {
        this.tree.sort();
    }

    @Override
    public void normalize(ParseOptions parseOptions) throws XMPException {
        if (parseOptions == null) {
            parseOptions = new ParseOptions();
        }
        XMPNormalizer.process(this, parseOptions);
    }

    public XMPNode getRoot() {
        return this.tree;
    }

    private void doSetArrayItem(XMPNode xMPNode, int n, String string, PropertyOptions propertyOptions, boolean bl) throws XMPException {
        int n2;
        XMPNode xMPNode2 = new XMPNode("[]", null);
        propertyOptions = XMPNodeUtils.verifySetOptions(propertyOptions, string);
        int n3 = n2 = bl ? xMPNode.getChildrenLength() + 1 : xMPNode.getChildrenLength();
        if (n == -1) {
            n = n2;
        }
        if (1 <= n && n <= n2) {
            if (!bl) {
                xMPNode.removeChild(n);
            }
        } else {
            throw new XMPException("Array index out of bounds", 104);
        }
        xMPNode.addChild(n, xMPNode2);
        this.setNode(xMPNode2, string, propertyOptions, false);
    }

    void setNode(XMPNode xMPNode, Object object, PropertyOptions propertyOptions, boolean bl) throws XMPException {
        if (bl) {
            xMPNode.clear();
        }
        xMPNode.getOptions().mergeWith(propertyOptions);
        if (!xMPNode.getOptions().isCompositeProperty()) {
            XMPNodeUtils.setNodeValue(xMPNode, object);
        } else {
            if (object != null && object.toString().length() > 0) {
                throw new XMPException("Composite nodes can't have values", 102);
            }
            xMPNode.removeChildren();
        }
    }

    private Object evaluateNodeValue(int n, XMPNode xMPNode) throws XMPException {
        Object object;
        String string = xMPNode.getValue();
        switch (n) {
            case 1: {
                object = new Boolean(XMPUtils.convertToBoolean(string));
                break;
            }
            case 2: {
                object = new Integer(XMPUtils.convertToInteger(string));
                break;
            }
            case 3: {
                object = new Long(XMPUtils.convertToLong(string));
                break;
            }
            case 4: {
                object = new Double(XMPUtils.convertToDouble(string));
                break;
            }
            case 5: {
                object = XMPUtils.convertToDate(string);
                break;
            }
            case 6: {
                XMPDateTime xMPDateTime = XMPUtils.convertToDate(string);
                object = xMPDateTime.getCalendar();
                break;
            }
            case 7: {
                object = XMPUtils.decodeBase64(string);
                break;
            }
            default: {
                object = string != null || xMPNode.getOptions().isCompositeProperty() ? string : "";
            }
        }
        return object;
    }
}

