/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.SessionManager;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;

public class Metrics {
    private final Cluster.Manager manager;
    private final MetricRegistry registry = new MetricRegistry();
    private final JmxReporter jmxReporter;
    private final Errors errors = new Errors();
    private final Timer requests = this.registry.timer("requests");
    private final Meter bytesSent = this.registry.meter("bytes-sent");
    private final Meter bytesReceived = this.registry.meter("bytes-received");
    private final Gauge<Integer> knownHosts = (Gauge)this.registry.register("known-hosts", (Metric)new Gauge<Integer>(){

        public Integer getValue() {
            return ((Metrics)Metrics.this).manager.metadata.allHosts().size();
        }
    });
    private final Gauge<Integer> connectedTo = (Gauge)this.registry.register("connected-to", (Metric)new Gauge<Integer>(){

        public Integer getValue() {
            HashSet s = new HashSet();
            for (SessionManager session : ((Metrics)Metrics.this).manager.sessions) {
                s.addAll(session.pools.keySet());
            }
            return s.size();
        }
    });
    private final Gauge<Integer> openConnections = (Gauge)this.registry.register("open-connections", (Metric)new Gauge<Integer>(){

        public Integer getValue() {
            int value = ((Metrics)Metrics.this).manager.controlConnection.isOpen() ? 1 : 0;
            for (SessionManager session : ((Metrics)Metrics.this).manager.sessions) {
                for (HostConnectionPool pool : session.pools.values()) {
                    value += pool.opened();
                }
            }
            return value;
        }
    });
    private final Gauge<Integer> trashedConnections = (Gauge)this.registry.register("trashed-connections", (Metric)new Gauge<Integer>(){

        public Integer getValue() {
            int value = 0;
            for (SessionManager session : ((Metrics)Metrics.this).manager.sessions) {
                for (HostConnectionPool pool : session.pools.values()) {
                    value += pool.trashed();
                }
            }
            return value;
        }
    });
    private final Gauge<Integer> inFlightRequests = (Gauge)this.registry.register("inflight-requests", (Metric)new Gauge<Integer>(){

        public Integer getValue() {
            int value = 0;
            for (SessionManager session : ((Metrics)Metrics.this).manager.sessions) {
                for (HostConnectionPool pool : session.pools.values()) {
                    value += pool.totalInFlight.get();
                }
            }
            return value;
        }
    });
    private final Gauge<Integer> executorQueueDepth;
    private final Gauge<Integer> blockingExecutorQueueDepth;
    private final Gauge<Integer> reconnectionSchedulerQueueSize;
    private final Gauge<Integer> taskSchedulerQueueSize;

    Metrics(Cluster.Manager manager) {
        this.manager = manager;
        this.executorQueueDepth = (Gauge)this.registry.register("executor-queue-depth", Metrics.buildQueueSizeGauge(manager.executorQueue));
        this.blockingExecutorQueueDepth = (Gauge)this.registry.register("blocking-executor-queue-depth", Metrics.buildQueueSizeGauge(manager.blockingExecutorQueue));
        this.reconnectionSchedulerQueueSize = (Gauge)this.registry.register("reconnection-scheduler-task-count", Metrics.buildQueueSizeGauge(manager.reconnectionExecutorQueue));
        this.taskSchedulerQueueSize = (Gauge)this.registry.register("task-scheduler-task-count", Metrics.buildQueueSizeGauge(manager.scheduledTasksExecutorQueue));
        if (manager.configuration.getMetricsOptions().isJMXReportingEnabled()) {
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.registry).inDomain(manager.clusterName + "-metrics").build();
            this.jmxReporter.start();
        } else {
            this.jmxReporter = null;
        }
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public Timer getRequestsTimer() {
        return this.requests;
    }

    public Errors getErrorMetrics() {
        return this.errors;
    }

    public Gauge<Integer> getKnownHosts() {
        return this.knownHosts;
    }

    public Gauge<Integer> getConnectedToHosts() {
        return this.connectedTo;
    }

    public Gauge<Integer> getOpenConnections() {
        return this.openConnections;
    }

    public Gauge<Integer> getTrashedConnections() {
        return this.trashedConnections;
    }

    public Gauge<Integer> getInFlightRequests() {
        return this.inFlightRequests;
    }

    public Gauge<Integer> getExecutorQueueDepth() {
        return this.executorQueueDepth;
    }

    public Gauge<Integer> getBlockingExecutorQueueDepth() {
        return this.blockingExecutorQueueDepth;
    }

    public Gauge<Integer> getReconnectionSchedulerQueueSize() {
        return this.reconnectionSchedulerQueueSize;
    }

    public Gauge<Integer> getTaskSchedulerQueueSize() {
        return this.taskSchedulerQueueSize;
    }

    public Meter getBytesSent() {
        return this.bytesSent;
    }

    public Meter getBytesReceived() {
        return this.bytesReceived;
    }

    void shutdown() {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
        }
    }

    private static Gauge<Integer> buildQueueSizeGauge(final BlockingQueue<?> queue) {
        if (queue != null) {
            return new Gauge<Integer>(){

                public Integer getValue() {
                    return queue.size();
                }
            };
        }
        return new Gauge<Integer>(){

            public Integer getValue() {
                return -1;
            }
        };
    }

    public class Errors {
        private final Counter connectionErrors;
        private final Counter authenticationErrors;
        private final Counter writeTimeouts;
        private final Counter readTimeouts;
        private final Counter unavailables;
        private final Counter clientTimeouts;
        private final Counter otherErrors;
        private final Counter retries;
        private final Counter retriesOnWriteTimeout;
        private final Counter retriesOnReadTimeout;
        private final Counter retriesOnUnavailable;
        private final Counter retriesOnClientTimeout;
        private final Counter retriesOnConnectionError;
        private final Counter retriesOnOtherErrors;
        private final Counter ignores;
        private final Counter ignoresOnWriteTimeout;
        private final Counter ignoresOnReadTimeout;
        private final Counter ignoresOnUnavailable;
        private final Counter ignoresOnClientTimeout;
        private final Counter ignoresOnConnectionError;
        private final Counter ignoresOnOtherErrors;
        private final Counter speculativeExecutions;

        public Errors() {
            this.connectionErrors = Metrics.this.registry.counter("connection-errors");
            this.authenticationErrors = Metrics.this.registry.counter("authentication-errors");
            this.writeTimeouts = Metrics.this.registry.counter("write-timeouts");
            this.readTimeouts = Metrics.this.registry.counter("read-timeouts");
            this.unavailables = Metrics.this.registry.counter("unavailables");
            this.clientTimeouts = Metrics.this.registry.counter("client-timeouts");
            this.otherErrors = Metrics.this.registry.counter("other-errors");
            this.retries = Metrics.this.registry.counter("retries");
            this.retriesOnWriteTimeout = Metrics.this.registry.counter("retries-on-write-timeout");
            this.retriesOnReadTimeout = Metrics.this.registry.counter("retries-on-read-timeout");
            this.retriesOnUnavailable = Metrics.this.registry.counter("retries-on-unavailable");
            this.retriesOnClientTimeout = Metrics.this.registry.counter("retries-on-client-timeout");
            this.retriesOnConnectionError = Metrics.this.registry.counter("retries-on-connection-error");
            this.retriesOnOtherErrors = Metrics.this.registry.counter("retries-on-other-errors");
            this.ignores = Metrics.this.registry.counter("ignores");
            this.ignoresOnWriteTimeout = Metrics.this.registry.counter("ignores-on-write-timeout");
            this.ignoresOnReadTimeout = Metrics.this.registry.counter("ignores-on-read-timeout");
            this.ignoresOnUnavailable = Metrics.this.registry.counter("ignores-on-unavailable");
            this.ignoresOnClientTimeout = Metrics.this.registry.counter("ignores-on-client-timeout");
            this.ignoresOnConnectionError = Metrics.this.registry.counter("ignores-on-connection-error");
            this.ignoresOnOtherErrors = Metrics.this.registry.counter("ignores-on-other-errors");
            this.speculativeExecutions = Metrics.this.registry.counter("speculative-executions");
        }

        public Counter getConnectionErrors() {
            return this.connectionErrors;
        }

        public Counter getAuthenticationErrors() {
            return this.authenticationErrors;
        }

        public Counter getWriteTimeouts() {
            return this.writeTimeouts;
        }

        public Counter getReadTimeouts() {
            return this.readTimeouts;
        }

        public Counter getUnavailables() {
            return this.unavailables;
        }

        public Counter getClientTimeouts() {
            return this.clientTimeouts;
        }

        public Counter getOthers() {
            return this.otherErrors;
        }

        public Counter getRetries() {
            return this.retries;
        }

        public Counter getRetriesOnReadTimeout() {
            return this.retriesOnReadTimeout;
        }

        public Counter getRetriesOnWriteTimeout() {
            return this.retriesOnWriteTimeout;
        }

        public Counter getRetriesOnUnavailable() {
            return this.retriesOnUnavailable;
        }

        public Counter getRetriesOnClientTimeout() {
            return this.retriesOnClientTimeout;
        }

        public Counter getRetriesOnConnectionError() {
            return this.retriesOnConnectionError;
        }

        public Counter getRetriesOnOtherErrors() {
            return this.retriesOnOtherErrors;
        }

        public Counter getIgnores() {
            return this.ignores;
        }

        public Counter getIgnoresOnReadTimeout() {
            return this.ignoresOnReadTimeout;
        }

        public Counter getIgnoresOnWriteTimeout() {
            return this.ignoresOnWriteTimeout;
        }

        public Counter getIgnoresOnUnavailable() {
            return this.ignoresOnUnavailable;
        }

        public Counter getIgnoresOnClientTimeout() {
            return this.ignoresOnClientTimeout;
        }

        public Counter getIgnoresOnConnectionError() {
            return this.ignoresOnConnectionError;
        }

        public Counter getIgnoresOnOtherErrors() {
            return this.ignoresOnOtherErrors;
        }

        public Counter getSpeculativeExecutions() {
            return this.speculativeExecutions;
        }
    }
}

