/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.names.parser.PhraseNameParser;
import au.org.ala.sds.model.SDSSpeciesListDTO;
import au.org.ala.sds.model.SDSSpeciesListItemDTO;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.model.SensitivityZoneFactory;
import au.org.ala.sds.util.SpeciesListUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.gbif.ecat.model.ParsedName;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class SensitiveSpeciesXmlBuilder {
    static final Logger logger = Logger.getLogger(SensitiveSpeciesXmlBuilder.class);

    public static void main(String[] args) throws Exception {
        OutputStream outputStream = args.length > 1 ? new FileOutputStream(new File(args[1])) : System.out;
        SensitiveSpeciesXmlBuilder.generateFromWebservices(outputStream, null);
    }

    private static boolean hasListsChanged(Collection<SDSSpeciesListDTO> lists, Date date) {
        for (SDSSpeciesListDTO list : lists) {
            if (!list.getDateUpdated().after(date)) continue;
            return true;
        }
        return false;
    }

    public static boolean generateFromWebservices(OutputStream out, Date lastGenerateDate) {
        Document doc = new Document(new Element("sensitiveSpeciesList"));
        PhraseNameParser parser = new PhraseNameParser();
        Map<String, SDSSpeciesListDTO> sdsLists = SpeciesListUtil.getSDSLists();
        if (lastGenerateDate != null && !SensitiveSpeciesXmlBuilder.hasListsChanged(sdsLists.values(), lastGenerateDate)) {
            return false;
        }
        List<SDSSpeciesListItemDTO> guidItems = SpeciesListUtil.getSDSListItems(true);
        if (sdsLists.isEmpty() || guidItems == null || guidItems.isEmpty()) {
            return false;
        }
        String currentGuid = "";
        ArrayList<String> resources = new ArrayList<String>();
        Element sensitiveSpecies = null;
        Element instances = null;
        for (SDSSpeciesListItemDTO item : guidItems) {
            if (!currentGuid.equals(item.getGuid())) {
                if (instances != null) {
                    sensitiveSpecies.addContent(instances);
                }
                instances = new Element("instances");
                sensitiveSpecies = new Element("sensitiveSpecies");
                sensitiveSpecies.setAttribute("name", item.getName());
                sensitiveSpecies.setAttribute("family", item.getFamily() != null ? item.getFamily() : "");
                Object rank = "UNKNOWN";
                try {
                    ParsedName pn = parser.parse(item.getName());
                    if (pn != null && pn.getRank() != null) {
                        rank = pn.getRank().toString().toUpperCase();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to get rank for " + item.getName()), (Throwable)e);
                }
                sensitiveSpecies.setAttribute("guid", item.getGuid());
                sensitiveSpecies.setAttribute("rank", (String)rank);
                String commonName = item.getKVPValue(SDSSpeciesListItemDTO.commonNameLabels);
                sensitiveSpecies.setAttribute("commonName", commonName != null ? commonName : "");
                doc.getRootElement().addContent((Content)sensitiveSpecies);
                currentGuid = item.getGuid();
                resources.clear();
            }
            if (resources.contains(item.getDataResourceUid())) continue;
            resources.add(item.getDataResourceUid());
            SensitiveSpeciesXmlBuilder.addInstanceInformation(sdsLists, item, instances);
        }
        if (instances != null) {
            sensitiveSpecies.addContent(instances);
        }
        List<SDSSpeciesListItemDTO> unmatchedItems = SpeciesListUtil.getSDSListItems(false);
        String currentName = "";
        sensitiveSpecies = null;
        instances = null;
        resources.clear();
        for (SDSSpeciesListItemDTO item : unmatchedItems) {
            if (!currentName.equals(item.getName())) {
                if (instances != null && sensitiveSpecies != null) {
                    sensitiveSpecies.addContent((Content)instances);
                }
                instances = new Element("instances");
                sensitiveSpecies = new Element("sensitiveSpecies");
                sensitiveSpecies.setAttribute("name", item.getName());
                sensitiveSpecies.setAttribute("family", item.getFamily() != null ? item.getFamily() : "");
                String rank = "UNKNOWN";
                try {
                    rank = parser.parse(item.getName()).getRank().toString().toUpperCase();
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to get rank for " + item.getName()), (Throwable)e);
                }
                sensitiveSpecies.setAttribute("rank", rank);
                String commonName = item.getKVPValue(SDSSpeciesListItemDTO.commonNameLabels);
                sensitiveSpecies.setAttribute("commonName", commonName != null ? commonName : "");
                doc.getRootElement().addContent((Content)sensitiveSpecies);
                currentName = item.getName();
                resources.clear();
            }
            if (resources.contains(item.getDataResourceUid())) continue;
            resources.add(item.getDataResourceUid());
            SensitiveSpeciesXmlBuilder.addInstanceInformation(sdsLists, item, instances);
        }
        if (instances != null) {
            sensitiveSpecies.addContent((Content)instances);
        }
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xmlOutputter.output(doc, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void addInstanceInformation(Map<String, SDSSpeciesListDTO> sdsLists, SDSSpeciesListItemDTO item, Element instances) {
        String remarks;
        SDSSpeciesListDTO list = sdsLists.get(item.getDataResourceUid());
        boolean isConservation = "CONSERVATION".equals(list.getSdsType());
        boolean isStateBased = "PBC6".equals(list.getCategory());
        Element instance = isConservation ? new Element("conservationInstance") : new Element("plantPestInstance");
        String category = item.getKVPValue("category");
        if (category == null) {
            category = list.getCategory();
        }
        instance.setAttribute("category", category != null ? category : "");
        instance.setAttribute("authority", list.getAuthority() != null ? list.getAuthority() : "");
        instance.setAttribute("dataResourceId", list.getDataResourceUid());
        String reason = item.getKVPValue("reason");
        if (reason != null) {
            instance.setAttribute("reason", reason);
        }
        if ((remarks = item.getKVPValue("remarks")) != null) {
            instance.setAttribute("remarks", remarks);
        }
        if (isConservation) {
            String generalisation = item.getKVPValue("generalisation");
            if (generalisation == null) {
                generalisation = list.getGeneralisation();
            }
            instance.setAttribute("generalisation", generalisation);
        } else {
            String fromDate = item.getKVPValue("fromDate");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            fromDate = fromDate != null ? dateFormat.format(fromDate) : "";
            instance.setAttribute("fromDate", fromDate);
            String toDate = item.getKVPValue("toDate");
            toDate = toDate != null ? dateFormat.format(toDate) : "";
            instance.setAttribute("toDate", toDate);
        }
        if (isStateBased && StringUtils.isBlank((CharSequence)list.getRegion())) {
            for (Map<String, String> kvp : item.getKvpValues()) {
                SensitivityZone zone = SensitivityZoneFactory.getZone(kvp.get("key").toUpperCase());
                if (zone == null) continue;
                Element newInstance = instance.clone();
                newInstance.setAttribute("zone", zone.getId());
                instances.addContent((Content)newInstance);
            }
        } else {
            instance.setAttribute("zone", list.getRegion() != null ? list.getRegion() : "AUS");
            instances.addContent((Content)instance);
        }
    }
}

