/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dao;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.sds.dao.DataRowHandler;
import au.org.ala.sds.dao.DataStreamDao;
import au.org.ala.sds.dto.DataColumnMapper;
import au.org.ala.sds.dto.DataStreamProperties;
import au.org.ala.sds.util.ExcelUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataStreamCsvDao
implements DataStreamDao {
    protected static final Logger logger = Logger.getLogger(DataStreamCsvDao.class);
    private final String fileName;
    private final InputStream stream;
    private char delimiter = (char)44;

    public DataStreamCsvDao(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
    }

    public DataStreamCsvDao(String fileName, InputStream stream, char delimiter) {
        this.fileName = fileName;
        this.stream = stream;
        this.delimiter = delimiter;
    }

    @Override
    public void processStream(DataColumnMapper mapper, DataStreamProperties properties, DataRowHandler rowHandler) throws IOException {
        int i;
        CSVReader reader = new CSVReader((Reader)new BufferedReader(new InputStreamReader(this.stream)), this.delimiter);
        logger.debug((Object)("Reading data file - " + this.fileName));
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        for (String key : mapper.getKeySet()) {
            String value = mapper.get(key);
            if (StringUtils.isNumeric((String)value)) {
                columnMap.put(key, Integer.parseInt(value) - 1);
                continue;
            }
            columnMap.put(key, ExcelUtils.getOrdinal(value) - 1);
        }
        int rowCount = 0;
        int start = properties.getStartRow();
        int end = properties.getEndRow() == 0 ? Integer.MAX_VALUE : properties.getEndRow();
        boolean eof = false;
        for (i = 1; i < start; ++i) {
            if (reader.readNext() != null) continue;
            eof = true;
            break;
        }
        while (!eof && i <= end) {
            String[] row = reader.readNext();
            if (row == null) {
                eof = true;
            } else {
                HashMap<String, String> facts = new HashMap<String, String>();
                for (String key : columnMap.keySet()) {
                    String value;
                    Integer idx = (Integer)columnMap.get(key);
                    if (idx >= row.length || !StringUtils.isNotBlank((String)(value = row[idx].trim()))) continue;
                    facts.put(key, value);
                }
                if (!facts.isEmpty()) {
                    facts.put("row", Integer.toString(i));
                    ++rowCount;
                    rowHandler.handleRow(facts);
                }
            }
            ++i;
        }
        System.out.println("Total no of rows = " + rowCount);
    }
}

