/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class RangeVariable
implements Cloneable {
    static final RangeVariable[] emptyArray = new RangeVariable[0];
    public static final int TABLE_RANGE = 1;
    public static final int TRANSITION_RANGE = 2;
    public static final int PARAMETER_RANGE = 3;
    public static final int VARIALBE_RANGE = 4;
    Table rangeTable;
    final HsqlNameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private HsqlNameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    private Object[] emptyData;
    boolean[] columnsInGroupBy;
    boolean hasKeyedColumnInGroupBy;
    boolean[] usedColumns;
    boolean[] updatedColumns;
    RangeVariableConditions[] joinConditions;
    RangeVariableConditions[] whereConditions;
    int subRangeCount;
    Expression joinCondition;
    boolean isLeftJoin;
    boolean isRightJoin;
    boolean isBoundary;
    int level;
    int indexDistinctCount;
    int rangePositionInJoin;
    int rangePosition;
    int parsePosition;
    HashMappedList variables;
    int rangeType;
    boolean isGenerated;

    RangeVariable(HashMappedList hashMappedList, HsqlNameManager.SimpleName simpleName, boolean bl, int n) {
        this.variables = hashMappedList;
        this.rangeType = n;
        this.rangeTable = null;
        this.tableAlias = simpleName;
        this.emptyData = null;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    RangeVariable(Table table, HsqlNameManager.SimpleName simpleName, OrderedHashSet orderedHashSet, HsqlNameManager.SimpleName[] simpleNameArray, ParserDQL.CompileContext compileContext) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = simpleName;
        this.columnAliases = orderedHashSet;
        this.columnAliasNames = simpleNameArray;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        compileContext.registerRangeVariable(this);
        SubQuery subQuery = this.rangeTable.getSubQuery();
        if (subQuery == null || subQuery.isResolved()) {
            this.setRangeTableVariables();
        }
    }

    RangeVariable(Table table, int n) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = n;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public void resetViewRageTableAsSubquery() {
        this.rangeTable = ((View)this.rangeTable).getSubqueryTable();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public void setRangeTableVariables() {
        if (this.columnAliasNames != null && this.rangeTable.getColumnCount() != this.columnAliasNames.length) {
            throw Error.error(5593);
        }
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public RangeVariable duplicate() {
        RangeVariable rangeVariable = null;
        try {
            rangeVariable = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        rangeVariable.resetConditions();
        return rangeVariable;
    }

    void setJoinType(boolean bl, boolean bl2) {
        this.isLeftJoin = bl;
        this.isRightJoin = bl2;
        if (this.isRightJoin) {
            this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        }
    }

    public void addNamedJoinColumns(OrderedHashSet orderedHashSet) {
        this.namedJoinColumns = orderedHashSet;
    }

    public void addColumn(int n) {
        this.usedColumns[n] = true;
    }

    public void addAllColumns() {
    }

    void addNamedJoinColumnExpression(String string, Expression expression) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(string, expression);
    }

    ExpressionColumn getColumnExpression(String string) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(string);
    }

    Table getTable() {
        return this.rangeTable;
    }

    boolean hasAnyIndexCondition() {
        int n;
        for (n = 0; n < this.joinConditions.length; ++n) {
            if (this.joinConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        for (n = 0; n < this.whereConditions.length; ++n) {
            if (this.whereConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        return false;
    }

    boolean hasSingleIndexCondition() {
        return this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount > 0;
    }

    boolean setDistinctColumnsOnIndex(int[] nArray) {
        if (this.joinConditions.length != 1) {
            return false;
        }
        int[] nArray2 = this.joinConditions[0].rangeIndex.getColumns();
        if (nArray.length != ArrayUtil.countTrueElements(this.usedColumns)) {
            return false;
        }
        if (nArray.length == 1 && nArray[0] == nArray2[0]) {
            this.indexDistinctCount = 1;
            return true;
        }
        return false;
    }

    Index getSortIndex() {
        if (this.joinConditions.length == 1) {
            return this.joinConditions[0].rangeIndex;
        }
        return null;
    }

    boolean setSortIndex(Index index, boolean bl) {
        if (this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount == 0) {
            this.joinConditions[0].rangeIndex = index;
            this.joinConditions[0].reversed = bl;
            return true;
        }
        return false;
    }

    boolean reverseOrder() {
        this.joinConditions[0].reverseIndexCondition();
        return true;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        if (this.columnAliases != null) {
            orderedHashSet.addAll(this.columnAliases);
            return orderedHashSet;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String string = this.rangeTable.getColumn((int)i).getName().name;
            boolean bl = orderedHashSet.add(string);
            if (bl) continue;
            throw Error.error(5578, string);
        }
        return orderedHashSet;
    }

    public int findColumn(ExpressionColumn expressionColumn) {
        if (!this.resolvesTableName(expressionColumn)) {
            return -1;
        }
        return this.findColumn(expressionColumn.columnName);
    }

    public int findColumn(String string) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(string)) {
            return -1;
        }
        if (this.variables != null) {
            return this.variables.getIndex(string);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(string);
        }
        return this.rangeTable.findColumn(string);
    }

    ColumnSchema getColumn(String string) {
        int n = this.findColumn(string);
        return n < 0 ? null : this.rangeTable.getColumn(n);
    }

    ColumnSchema getColumn(int n) {
        if (this.variables == null) {
            return this.rangeTable.getColumn(n);
        }
        return (ColumnSchema)this.variables.get(n);
    }

    public HsqlNameManager.SimpleName getColumnAlias(int n) {
        if (this.columnAliases == null) {
            return this.rangeTable.getColumn(n).getName();
        }
        return this.columnAliasNames[n];
    }

    boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    HsqlNameManager.SimpleName getTableAlias() {
        return this.tableAlias == null ? this.rangeTable.getName() : this.tableAlias;
    }

    boolean resolvesTableName(ExpressionColumn expressionColumn) {
        if (expressionColumn.tableName == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return expressionColumn.tableName.equals(this.tableAlias.name);
            }
            return false;
        }
        return expressionColumn.schema == null ? (this.tableAlias == null ? expressionColumn.tableName.equals(this.rangeTable.getName().name) : expressionColumn.tableName.equals(this.tableAlias.name)) : this.tableAlias == null && expressionColumn.tableName.equals(this.rangeTable.getName().name) && expressionColumn.schema.equals(this.rangeTable.getSchemaName().name);
    }

    public boolean resolvesTableName(String string) {
        if (string == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return string.equals(this.tableAlias.name);
            }
            return false;
        }
        return this.tableAlias == null ? string.equals(this.rangeTable.getName().name) : string.equals(this.tableAlias.name);
    }

    boolean resolvesSchemaName(String string) {
        if (string == null) {
            return true;
        }
        if (this.variables != null) {
            return false;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return string.equals(this.rangeTable.getSchemaName().name);
    }

    void addTableColumns(HsqlArrayList hsqlArrayList) {
        if (this.namedJoinColumns != null) {
            int n = hsqlArrayList.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Expression expression = (Expression)hsqlArrayList.get(i);
                String string = expression.getColumnName();
                if (!this.namedJoinColumns.contains(string)) continue;
                if (n2 != i) {
                    hsqlArrayList.remove(i);
                    hsqlArrayList.add(n2, expression);
                }
                expression = this.getColumnExpression(string);
                hsqlArrayList.set(n2, expression);
                ++n2;
            }
        }
        this.addTableColumns(hsqlArrayList, hsqlArrayList.size(), this.namedJoinColumns);
    }

    int addTableColumns(HsqlArrayList hsqlArrayList, int n, HashSet hashSet) {
        Table table = this.getTable();
        int n2 = table.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(n++, expressionColumn);
        }
        return n;
    }

    void addTableColumns(Expression expression, HashSet hashSet) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Table table = this.getTable();
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(expressionColumn);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression.nodes = expressionArray;
    }

    void setForCheckConstraint() {
        this.joinConditions[0].rangeIndex = null;
        this.rangePosition = 0;
    }

    Expression getJoinCondition() {
        return this.joinCondition;
    }

    void addJoinCondition(Expression expression) {
        this.joinCondition = ExpressionLogical.andExpressions(this.joinCondition, expression);
    }

    void resetConditions() {
        Index index = this.joinConditions[0].rangeIndex;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = index;
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    OrderedHashSet getSubqueries() {
        OrderedHashSet orderedHashSet = null;
        if (this.joinCondition != null) {
            orderedHashSet = this.joinCondition.collectAllSubqueries(orderedHashSet);
        }
        if (this.rangeTable instanceof TableDerived) {
            QueryExpression queryExpression = ((TableDerived)this.rangeTable).getQueryExpression();
            if (((TableDerived)this.rangeTable).view != null) {
                if (orderedHashSet == null) {
                    orderedHashSet = new OrderedHashSet();
                }
                orderedHashSet.addAll(((TableDerived)this.rangeTable).view.getSubqueries());
            } else if (queryExpression == null) {
                orderedHashSet = OrderedHashSet.add(orderedHashSet, this.rangeTable.getSubQuery());
            } else {
                OrderedHashSet orderedHashSet2 = queryExpression.getSubqueries();
                orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
                orderedHashSet = OrderedHashSet.add(orderedHashSet, this.rangeTable.getSubQuery());
            }
        }
        return orderedHashSet;
    }

    public void replaceColumnReference(RangeVariable rangeVariable, Expression[] expressionArray) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceColumnReferences(rangeVariable, expressionArray);
        }
    }

    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
    }

    public void resolveRangeTable(Session session, RangeVariable[] rangeVariableArray, int n, RangeVariable[] rangeVariableArray2) {
        Table table = this.rangeTable;
        SubQuery subQuery = table.getSubQuery();
        if (subQuery != null && !subQuery.isResolved()) {
            HsqlList hsqlList;
            if (subQuery.dataExpression != null) {
                hsqlList = subQuery.dataExpression.resolveColumnReferences(session, emptyArray, null);
                if (hsqlList != null) {
                    hsqlList = subQuery.dataExpression.resolveColumnReferences(session, rangeVariableArray, n, null, true);
                }
                if (hsqlList != null) {
                    hsqlList = subQuery.dataExpression.resolveColumnReferences(session, rangeVariableArray2, null);
                }
                if (hsqlList != null) {
                    throw Error.error(5501, ((Expression)hsqlList.get(0)).getSQL());
                }
                subQuery.dataExpression.resolveTypes(session, null);
                this.setRangeTableVariables();
            }
            if (subQuery.queryExpression != null) {
                subQuery.queryExpression.resolveReferences(session, rangeVariableArray2);
                hsqlList = subQuery.queryExpression.getUnresolvedExpressions();
                HsqlList hsqlList2 = Expression.resolveColumnSet(session, rangeVariableArray, n, hsqlList, null);
                if (hsqlList2 != null) {
                    throw Error.error(5501, ((Expression)hsqlList2.get(0)).getSQL());
                }
                subQuery.queryExpression.resolveTypes(session);
                subQuery.prepareTable(session);
                subQuery.setCorrelated();
                this.setRangeTableVariables();
            }
        }
    }

    public String describe(Session session, int n) {
        String string = ValuePool.spaceString.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "INNER";
        if (this.isLeftJoin) {
            string2 = "LEFT OUTER";
            if (this.isRightJoin) {
                string2 = "FULL";
            }
        } else if (this.isRightJoin) {
            string2 = "RIGHT OUTER";
        }
        stringBuffer.append(string).append("join type=").append(string2).append("\n");
        stringBuffer.append(string).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            stringBuffer.append(string).append("alias=").append(this.tableAlias.name).append("\n");
        }
        RangeVariableConditions[] rangeVariableConditionsArray = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            rangeVariableConditionsArray = this.whereConditions;
        }
        boolean bl = !rangeVariableConditionsArray[0].hasIndexCondition();
        stringBuffer.append(string);
        if (rangeVariableConditionsArray == this.whereConditions && this.joinConditions[0].nonIndexCondition != null) {
            stringBuffer.append("join condition = [");
            stringBuffer.append(this.joinConditions[0].nonIndexCondition.describe(session, n));
            stringBuffer.append(string).append("]\n");
            stringBuffer.append(string);
        }
        stringBuffer.append("access=").append(bl ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < rangeVariableConditionsArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string).append("OR condition = [");
            } else {
                stringBuffer.append(string);
                if (rangeVariableConditionsArray == this.whereConditions) {
                    stringBuffer.append("where condition = [");
                } else {
                    stringBuffer.append("join condition = [");
                }
            }
            stringBuffer.append(rangeVariableConditionsArray[i].describe(session, n + 2));
            stringBuffer.append(string).append("]\n");
        }
        if (rangeVariableConditionsArray == this.joinConditions) {
            stringBuffer.append(string);
            if (this.whereConditions[0].nonIndexCondition != null) {
                stringBuffer.append("where condition = [");
                stringBuffer.append(this.whereConditions[0].nonIndexCondition.describe(session, n));
                stringBuffer.append(string).append("]\n");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain rangeIteratorMain = this.isRightJoin ? new RangeIteratorRight(session, this, null) : new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(rangeIteratorMain);
        return rangeIteratorMain;
    }

    public static RangeIterator getIterator(Session session, RangeVariable[] rangeVariableArray) {
        if (rangeVariableArray.length == 1) {
            return rangeVariableArray[0].getIterator(session);
        }
        RangeIteratorMain[] rangeIteratorMainArray = new RangeIteratorMain[rangeVariableArray.length];
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            rangeIteratorMainArray[i] = rangeVariableArray[i].getIterator(session);
        }
        return new RangeIteratorJoined(rangeIteratorMainArray);
    }

    public static class RangeVariableConditions {
        final RangeVariable rangeVar;
        Expression[] indexCond;
        Expression[] indexEndCond;
        int[] opTypes;
        int[] opTypesEnd;
        Expression indexEndCondition;
        int indexedColumnCount;
        Index rangeIndex;
        final boolean isJoin;
        Expression excludeConditions;
        Expression nonIndexCondition;
        Expression terminalCondition;
        int opType;
        int opTypeEnd;
        boolean isFalse;
        boolean reversed;
        boolean hasIndex;

        RangeVariableConditions(RangeVariable rangeVariable, boolean bl) {
            this.rangeVar = rangeVariable;
            this.isJoin = bl;
        }

        RangeVariableConditions(RangeVariableConditions rangeVariableConditions) {
            this.rangeVar = rangeVariableConditions.rangeVar;
            this.isJoin = rangeVariableConditions.isJoin;
            this.nonIndexCondition = rangeVariableConditions.nonIndexCondition;
        }

        boolean hasIndexCondition() {
            return this.indexedColumnCount > 0;
        }

        boolean hasIndex() {
            return this.hasIndex;
        }

        void addCondition(Expression expression) {
            if (expression == null) {
                return;
            }
            if (expression instanceof ExpressionLogical && ((ExpressionLogical)expression).isTerminal) {
                this.terminalCondition = expression;
            }
            this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, expression);
            if (Expression.EXPR_FALSE.equals(this.nonIndexCondition)) {
                this.isFalse = true;
            }
            if (this.rangeIndex == null || this.rangeIndex.getColumnCount() == 0) {
                return;
            }
            if (this.indexedColumnCount == 0) {
                return;
            }
            if (expression.getIndexableExpression(this.rangeVar) == null) {
                return;
            }
            int n = expression.getLeftNode().getColumnIndex();
            int[] nArray = this.rangeIndex.getColumns();
            switch (expression.getType()) {
                case 42: 
                case 43: {
                    if (this.opType == 48) {
                        if (nArray[this.indexedColumnCount - 1] != n) break;
                        this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, this.indexCond[this.indexedColumnCount - 1]);
                        this.indexCond[this.indexedColumnCount - 1] = expression;
                        this.opType = expression.opType;
                        this.opTypes[this.indexedColumnCount - 1] = expression.opType;
                        if (expression.exprSubType != 53 || this.indexedColumnCount != 1) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = ExpressionLogical.andExpressions(this.indexEndCond[this.indexedColumnCount - 1], expression.nodes[2]);
                        break;
                    }
                    this.addToIndexConditions(expression);
                    break;
                }
                case 44: 
                case 45: {
                    if (this.opType == 43 || this.opType == 42 || this.opType == 48) {
                        if (this.opTypeEnd != 74 || nArray[this.indexedColumnCount - 1] != n) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = expression;
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                        this.opTypeEnd = expression.opType;
                        this.opTypesEnd[this.indexedColumnCount - 1] = expression.opType;
                        break;
                    }
                    this.addToIndexEndConditions(expression);
                    break;
                }
            }
        }

        private boolean addToIndexConditions(Expression expression) {
            if ((this.opType == 41 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == expression.getLeftNode().getColumnIndex()) {
                this.indexCond[this.indexedColumnCount] = expression;
                this.opType = expression.opType;
                this.opTypes[this.indexedColumnCount] = expression.opType;
                this.opTypeEnd = 74;
                this.opTypesEnd[this.indexedColumnCount] = 74;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        private boolean addToIndexEndConditions(Expression expression) {
            if ((this.opType == 41 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == expression.getLeftNode().getColumnIndex()) {
                Expression expression2 = expression.getLeftNode();
                expression2 = new ExpressionLogical(47, expression2);
                this.indexCond[this.indexedColumnCount] = expression2 = new ExpressionLogical(48, expression2);
                this.indexEndCond[this.indexedColumnCount] = expression;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                this.opType = 48;
                this.opTypes[this.indexedColumnCount] = 48;
                this.opTypeEnd = expression.opType;
                this.opTypesEnd[this.indexedColumnCount] = expression.opType;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        void addIndexCondition(Expression[] expressionArray, Index index, int n) {
            int n2 = index.getColumnCount();
            this.rangeIndex = index;
            this.indexCond = new Expression[n2];
            this.indexEndCond = new Expression[n2];
            this.opTypes = new int[n2];
            this.opTypesEnd = new int[n2];
            this.opType = expressionArray[0].opType;
            this.opTypes[0] = expressionArray[0].opType;
            switch (this.opType) {
                case 48: {
                    this.indexCond = expressionArray;
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 42: 
                case 43: {
                    this.indexCond = expressionArray;
                    if (expressionArray[0].exprSubType == 53) {
                        this.indexEndCond[0] = this.indexEndCondition = expressionArray[0].nodes[2];
                    }
                    this.opTypeEnd = 74;
                    this.opTypesEnd[0] = 74;
                    break;
                }
                case 44: 
                case 45: {
                    Expression expression = expressionArray[0].getLeftNode();
                    expression = new ExpressionLogical(47, expression);
                    this.indexCond[0] = expression = new ExpressionLogical(48, expression);
                    this.indexEndCond[0] = this.indexEndCondition = expressionArray[0];
                    this.opTypeEnd = this.opType;
                    this.opTypesEnd[0] = this.opType;
                    this.opType = 48;
                    this.opTypes[0] = 48;
                    break;
                }
                case 41: 
                case 47: {
                    this.indexCond = expressionArray;
                    for (int i = 0; i < n; ++i) {
                        Expression expression;
                        this.indexEndCond[i] = expression = expressionArray[i];
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
                        this.opType = expression.opType;
                        this.opTypes[0] = expression.opType;
                    }
                    this.opTypeEnd = this.opType;
                    break;
                }
                default: {
                    Error.runtimeError(201, "RangeVariable");
                }
            }
            this.indexedColumnCount = n;
            this.hasIndex = true;
        }

        void reverseIndexCondition() {
            if (this.opType == 41 || this.opType == 47) {
                return;
            }
            this.indexEndCondition = null;
            for (int i = 0; i < this.indexedColumnCount; ++i) {
                Expression expression = this.indexCond[i];
                this.indexCond[i] = this.indexEndCond[i];
                this.indexEndCond[i] = expression;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression);
            }
            this.opType = this.opTypeEnd;
            this.reversed = true;
        }

        String describe(Session session, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = ValuePool.spaceString.substring(0, n);
            stringBuffer.append("index=").append(this.rangeIndex.getName().name).append("\n");
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    stringBuffer.append(string).append("start conditions=[");
                    for (int i = 0; i < this.indexedColumnCount; ++i) {
                        if (this.indexCond == null || this.indexCond[i] == null) continue;
                        stringBuffer.append(this.indexCond[i].describe(session, n));
                    }
                    stringBuffer.append("]\n");
                }
                if (this.indexEndCondition != null) {
                    String string2 = this.indexEndCondition.describe(session, n);
                    stringBuffer.append(string).append("end condition=[").append(string2).append("]\n");
                }
            }
            if (this.nonIndexCondition != null) {
                String string3 = this.nonIndexCondition.describe(session, n);
                stringBuffer.append(string).append("other condition=[").append(string3).append("]\n");
            }
            return stringBuffer.toString();
        }
    }

    public static class RangeIteratorJoined
    extends RangeIteratorBase {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;

        public RangeIteratorJoined(RangeIteratorMain[] rangeIteratorMainArray) {
            this.rangeIterators = rangeIteratorMainArray;
            this.isBeforeFirst = true;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.currentIndex >= 0) {
                RangeIteratorMain rangeIteratorMain = this.rangeIterators[this.currentIndex];
                if (rangeIteratorMain.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    this.currentRow = this.rangeIterators[this.currentIndex].currentRow;
                    this.currentData = this.currentRow.getData();
                    return true;
                }
                rangeIteratorMain.reset();
                --this.currentIndex;
            }
            this.currentData = this.rangeIterators[this.rangeIterators.length - 1].rangeVar.emptyData;
            this.currentRow = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public int getRangePosition() {
            return 0;
        }
    }

    public static class RangeIteratorRight
    extends RangeIteratorMain {
        boolean isOnRightOuterRows;

        private RangeIteratorRight(Session session, RangeVariable rangeVariable, RangeIteratorMain rangeIteratorMain) {
            super(session, rangeVariable);
            this.isFullIterator = true;
        }

        public void setOnOuterRows() {
            this.conditions = this.rangeVar.whereConditions;
            this.isOnRightOuterRows = true;
            this.hasLeftOuterRow = false;
            this.condIndex = 0;
            this.initialiseIterator();
        }

        @Override
        public boolean next() {
            if (this.isOnRightOuterRows) {
                if (this.it == null) {
                    return false;
                }
                return this.findNextRight();
            }
            return super.next();
        }

        protected boolean findNextRight() {
            boolean bl;
            block2: {
                bl = false;
                do {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block2;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) break block2;
                } while (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session) || !this.lookupAndTest());
                bl = true;
            }
            if (bl) {
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            return bl;
        }

        private boolean lookupAndTest() {
            boolean bl;
            boolean bl2 = bl = !this.lookup.contains(this.currentRow.getPos());
            if (bl) {
                this.currentData = this.currentRow.getData();
                if (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                    bl = false;
                }
            }
            return bl;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasLeftOuterRow;
        boolean isFullIterator;
        RangeVariableConditions[] conditions;
        RangeVariableConditions[] whereConditions;
        RangeVariableConditions[] joinConditions;
        int condIndex = 0;
        OrderedIntHashSet lookup;
        Object[] currentJoinData = null;

        RangeIteratorMain() {
        }

        private RangeIteratorMain(Session session, RangeVariable rangeVariable) {
            this.rangePosition = rangeVariable.rangePosition;
            this.store = rangeVariable.rangeTable.getRowStore(session);
            this.session = session;
            this.rangeVar = rangeVariable;
            this.currentData = rangeVariable.emptyData;
            this.isBeforeFirst = true;
            this.whereConditions = rangeVariable.whereConditions;
            this.joinConditions = rangeVariable.joinConditions;
            if (rangeVariable.isRightJoin) {
                this.lookup = new OrderedIntHashSet();
            }
            this.conditions = rangeVariable.joinConditions;
            if (rangeVariable.whereConditions[0].hasIndexCondition()) {
                this.conditions = rangeVariable.whereConditions;
            }
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.condIndex < this.conditions.length) {
                boolean bl;
                if (this.isBeforeFirst) {
                    this.isBeforeFirst = false;
                    this.initialiseIterator();
                }
                if (bl = this.findNext()) {
                    return true;
                }
                this.reset();
                ++this.condIndex;
            }
            this.condIndex = 0;
            return false;
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentData = this.rangeVar.emptyData;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            if (this.condIndex == 0) {
                this.hasLeftOuterRow = this.rangeVar.isLeftJoin;
            }
            if (this.conditions[this.condIndex].isFalse) {
                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                return;
            }
            SubQuery subQuery = this.rangeVar.rangeTable.getSubQuery();
            if (subQuery != null && subQuery.isCorrelated()) {
                subQuery.materialiseCorrelated(this.session);
            }
            if (this.conditions[this.condIndex].indexCond == null) {
                this.it = this.conditions[this.condIndex].reversed ? this.conditions[this.condIndex].rangeIndex.lastRow(this.session, this.store) : this.conditions[this.condIndex].rangeIndex.firstRow(this.session, this.store);
            } else {
                this.getFirstRow();
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            if (this.currentJoinData == null || this.currentJoinData.length < this.conditions[this.condIndex].indexedColumnCount) {
                this.currentJoinData = new Object[this.conditions[this.condIndex].indexedColumnCount];
            }
            for (int i = 0; i < this.conditions[this.condIndex].indexedColumnCount; ++i) {
                Object object;
                block11: {
                    int n;
                    int n2;
                    block12: {
                        int n3;
                        n2 = 0;
                        int n4 = n3 = i == this.conditions[this.condIndex].indexedColumnCount - 1 ? this.conditions[this.condIndex].opType : this.conditions[this.condIndex].indexCond[i].getType();
                        if (n3 == 47 || n3 == 48 || n3 == 74) {
                            this.currentJoinData[i] = null;
                            continue;
                        }
                        Type type = this.conditions[this.condIndex].indexCond[i].getRightNode().getDataType();
                        object = this.conditions[this.condIndex].indexCond[i].getRightNode().getValue(this.session);
                        Type type2 = this.conditions[this.condIndex].indexCond[i].getLeftNode().getDataType();
                        if (type2 != type && (n2 = type2.compareToTypeRange(object)) == 0 && type2.typeComparisonGroup != type.typeComparisonGroup) {
                            object = type2.convertToType(this.session, object, type);
                        }
                        if (i != 0) break block11;
                        n = this.conditions[this.condIndex].indexCond[0].getType();
                        if (n2 >= 0) break block12;
                        switch (n) {
                            case 42: 
                            case 43: {
                                object = null;
                                break block11;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                    if (n2 > 0) {
                        switch (n) {
                            case 48: {
                                object = null;
                                break;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                }
                this.currentJoinData[i] = object;
            }
            this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, this.currentJoinData, this.conditions[this.condIndex].indexedColumnCount, this.rangeVar.indexDistinctCount, this.conditions[this.condIndex].opType, this.conditions[this.condIndex].reversed, null);
        }

        protected boolean findNext() {
            boolean bl;
            block5: {
                bl = false;
                while (true) {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block5;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].terminalCondition != null && !this.conditions[this.condIndex].terminalCondition.testCondition(this.session)) break block5;
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) {
                        if (!this.conditions[this.condIndex].isJoin) {
                            this.hasLeftOuterRow = false;
                        }
                        break block5;
                    }
                    if (this.joinConditions[this.condIndex].nonIndexCondition != null && !this.joinConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) continue;
                    if (this.whereConditions[this.condIndex].nonIndexCondition != null && !this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                        this.hasLeftOuterRow = false;
                        this.addFoundRow();
                        continue;
                    }
                    Expression expression = this.conditions[this.condIndex].excludeConditions;
                    if (expression == null || !expression.testCondition(this.session)) break;
                }
                this.addFoundRow();
                this.hasLeftOuterRow = false;
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            if (this.hasLeftOuterRow && this.condIndex == this.conditions.length - 1) {
                bl = this.whereConditions[this.condIndex].nonIndexCondition == null || this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session);
                this.hasLeftOuterRow = false;
            }
            return bl;
        }

        protected void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                this.lookup.add(this.currentRow.getPos());
            }
        }
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        RowIterator it;
        PersistentStore store;
        Object[] currentData;
        Row currentRow;
        boolean isBeforeFirst;
        RangeVariable rangeVar;

        private RangeIteratorBase() {
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            this.currentRow = this.it.getNextRow();
            if (this.currentRow == null) {
                return false;
            }
            this.currentData = this.currentRow.getData();
            return true;
        }

        @Override
        public Row getCurrentRow() {
            return this.currentRow;
        }

        @Override
        public Object[] getCurrent() {
            return this.currentData;
        }

        @Override
        public Object getCurrent(int n) {
            return this.currentData == null ? null : this.currentData[n];
        }

        @Override
        public void setCurrent(Object[] objectArray) {
            this.currentData = objectArray;
        }

        @Override
        public long getRowId() {
            return this.currentRow == null ? 0L : ((long)this.rangeVar.rangeTable.getId() << 32) + (long)this.currentRow.getPos();
        }

        @Override
        public Object getRowidObject() {
            return this.currentRow == null ? null : ValuePool.getLong(this.getRowId());
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }

        @Override
        public Row getNextRow() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean hasNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public Object[] getNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public boolean setRowColumns(boolean[] blArray) {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
            }
        }
    }
}

