/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;

public class ArrayResultSetFactory
implements ResultSetFactory {
    private String[] columnNames;
    private String[][] dataMatrix;

    public ArrayResultSetFactory(String[][] stringArray) {
        this.dataMatrix = this.verifyDataMatrixArray(stringArray);
    }

    public ArrayResultSetFactory(String[] stringArray, String[][] stringArray2) {
        this.columnNames = this.verifyColumnNames(stringArray);
        if (stringArray2 != null && stringArray2[0] != null && stringArray2[0].length != this.columnNames.length) {
            throw new IllegalArgumentException("matrix arrays must all contain " + stringArray.length + " elements");
        }
        this.dataMatrix = this.verifyDataMatrixArray(stringArray2);
    }

    public MockResultSet create(String string) {
        if (string != null) {
            int n;
            MockResultSet mockResultSet = new MockResultSet(string);
            if (this.columnNames != null) {
                for (n = 0; n < this.columnNames.length; ++n) {
                    mockResultSet.addColumn(this.columnNames[n]);
                }
            }
            for (n = 0; n < this.dataMatrix.length; ++n) {
                mockResultSet.addRow(this.dataMatrix[n]);
            }
            return mockResultSet;
        }
        throw new IllegalArgumentException("the result set ID cannot be null");
    }

    private String[][] verifyDataMatrixArray(String[][] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    throw new IllegalArgumentException("the data matrix cannot contain any null arrays");
                }
                if (stringArray[i].length != stringArray[0].length) {
                    throw new IllegalArgumentException("arrays in the data matrix must all contain " + stringArray[0].length + " elements");
                }
                for (int j = 0; j < stringArray[i].length; ++j) {
                    if (stringArray[i][j] != null) continue;
                    throw new IllegalArgumentException("arrays in the data matrix must not contain null elements");
                }
            }
            return stringArray;
        }
        throw new IllegalArgumentException("the data matrix cannot be null");
    }

    private String[] verifyColumnNames(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new IllegalArgumentException("the column names array must not contain null elements");
            }
            return stringArray;
        }
        throw new IllegalArgumentException("the column names array cannot be null");
    }
}

