/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractResultSetHandler {
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;
    private MockResultSet globalResultSet;
    private Map resultSetsForStatement = new HashMap();
    private int globalUpdateCount = 0;
    private Map updateCountForStatement = new HashMap();
    private MockResultSet globalGeneratedKeys;
    private Map generatedKeysForStatement = new HashMap();
    private Map returnsResultSetMap = new HashMap();
    private Map throwsSQLException = new HashMap();
    private List executedStatements = new ArrayList();
    private List returnedResultSets = new ArrayList();

    public MockResultSet createResultSet() {
        return new MockResultSet(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String string) {
        return new MockResultSet(string);
    }

    public MockResultSet createResultSet(ResultSetFactory resultSetFactory) {
        return resultSetFactory.create(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String string, ResultSetFactory resultSetFactory) {
        return resultSetFactory.create(string);
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setExactMatch(boolean bl) {
        this.exactMatch = bl;
    }

    public void setUseRegularExpressions(boolean bl) {
        this.useRegularExpressions = bl;
    }

    public void addExecutedStatement(String string) {
        this.executedStatements.add(string);
    }

    public void addReturnedResultSet(MockResultSet mockResultSet) {
        if (null == mockResultSet) {
            return;
        }
        this.returnedResultSets.add(mockResultSet);
    }

    public List getExecutedStatements() {
        return Collections.unmodifiableList(this.executedStatements);
    }

    public List getReturnedResultSets() {
        return Collections.unmodifiableList(this.returnedResultSets);
    }

    public void clearResultSets() {
        this.resultSetsForStatement.clear();
    }

    public void clearUpdateCounts() {
        this.updateCountForStatement.clear();
    }

    public void clearReturnsResultSet() {
        this.returnsResultSetMap.clear();
    }

    public void clearThrowsSQLException() {
        this.throwsSQLException.clear();
    }

    public void clearGeneratedKeys() {
        this.generatedKeysForStatement.clear();
    }

    public void clearGlobalResultSet() {
        this.globalResultSet = null;
    }

    public void clearGlobalGeneratedKeys() {
        this.globalGeneratedKeys = null;
    }

    public void clearGlobalUpdateCount() {
        this.globalUpdateCount = 0;
    }

    public Map getResultSetMap() {
        return Collections.unmodifiableMap(this.resultSetsForStatement);
    }

    public Map getUpdateCountMap() {
        return Collections.unmodifiableMap(this.updateCountForStatement);
    }

    public Map getGeneratedKeysMap() {
        return Collections.unmodifiableMap(this.generatedKeysForStatement);
    }

    public MockResultSet getResultSet(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.resultSetsForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return (MockResultSet)list.get(0);
        }
        return null;
    }

    public MockResultSet getGlobalResultSet() {
        return this.globalResultSet;
    }

    public Integer getUpdateCount(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.updateCountForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return (Integer)list.get(0);
        }
        return null;
    }

    public int getGlobalUpdateCount() {
        return this.globalUpdateCount;
    }

    public MockResultSet getGeneratedKeys(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.generatedKeysForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return (MockResultSet)list.get(0);
        }
        return null;
    }

    public MockResultSet getGlobalGeneratedKeys() {
        return this.globalGeneratedKeys;
    }

    public Boolean getReturnsResultSet(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.returnsResultSetMap, string, true, true);
        if (null != list && list.size() > 0) {
            return (Boolean)list.get(0);
        }
        return null;
    }

    public boolean getThrowsSQLException(String string) {
        return this.getSQLException(string) != null;
    }

    public SQLException getSQLException(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.throwsSQLException, string, true, true);
        if (null == list || list.size() == 0) {
            return null;
        }
        return (SQLException)list.get(0);
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet) {
        this.resultSetsForStatement.put(string, mockResultSet);
    }

    public void prepareGlobalResultSet(MockResultSet mockResultSet) {
        this.globalResultSet = mockResultSet;
    }

    public void prepareUpdateCount(String string, int n) {
        this.updateCountForStatement.put(string, new Integer(n));
    }

    public void prepareGlobalUpdateCount(int n) {
        this.globalUpdateCount = n;
    }

    public void prepareGeneratedKeys(String string, MockResultSet mockResultSet) {
        this.generatedKeysForStatement.put(string, mockResultSet);
    }

    public void prepareGlobalGeneratedKeys(MockResultSet mockResultSet) {
        this.globalGeneratedKeys = mockResultSet;
    }

    public void prepareReturnsResultSet(String string, boolean bl) {
        this.returnsResultSetMap.put(string, new Boolean(bl));
    }

    public void prepareThrowsSQLException(String string) {
        this.throwsSQLException.put(string, new SQLException("Statement " + string + " was specified to throw an exception"));
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException) {
        this.throwsSQLException.put(string, sQLException);
    }

    protected boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    protected boolean getExactMatch() {
        return this.exactMatch;
    }

    protected boolean getUseRegularExpressions() {
        return this.useRegularExpressions;
    }
}

