/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.cdi;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.kie.internal.runtime.cdi.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(ActivateExtension.class);

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        if (javaClass.isAnnotationPresent(Activate.class)) {
            Activate veto = javaClass.getAnnotation(Activate.class);
            String whenAvailable = veto.whenAvailable();
            String whenNotAvailable = veto.whenNotAvailable();
            if (this.isNotEmpty(whenAvailable) && !this.isAvailable(whenAvailable, true)) {
                pat.veto();
            }
            if (this.isNotEmpty(whenNotAvailable) && this.isAvailable(whenNotAvailable, false)) {
                pat.veto();
            }
        }
    }

    protected boolean isAvailable(String classname, boolean expected) {
        ClassLoader cl = this.getClass().getClassLoader();
        boolean result = this.isAvailable(classname, cl);
        if (result != expected) {
            result = this.isAvailable(classname, Thread.currentThread().getContextClassLoader());
        }
        return result;
    }

    protected boolean isAvailable(String classname, ClassLoader classloader) {
        logger.debug("Checking if class {} exists in classloader {}", (Object)classname, (Object)classloader);
        try {
            Class.forName(classname, true, classloader);
            logger.debug("Class {} exists", (Object)classname);
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.debug("Class {} does NOT exists", (Object)classname);
            return false;
        }
    }

    protected boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }
}

