/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.gbif.digester.CallParamNoNSRule;
import org.gbif.digester.ThesaurusHandlingRule;
import org.gbif.dwc.extensions.Extension;
import org.gbif.dwc.extensions.ExtensionProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ExtensionFactory {
    protected static Logger log = LoggerFactory.getLogger(ExtensionFactory.class);
    public static final String EXTENSION_NAMESPACE = "http://rs.gbif.org/extension/";
    private ThesaurusHandlingRule thesaurusRule;
    private SAXParserFactory saxf;

    public ExtensionFactory(ThesaurusHandlingRule thesaurusRule, SAXParserFactory factory) {
        this.thesaurusRule = thesaurusRule;
        this.saxf = factory;
    }

    public Extension build(InputStream is, URL url, boolean dev) throws IOException, SAXException, ParserConfigurationException {
        Digester digester = new Digester(this.saxf.newSAXParser());
        digester.setRuleNamespaceURI(EXTENSION_NAMESPACE);
        Extension e = new Extension(url, dev);
        digester.push((Object)e);
        digester.addCallMethod("*/extension", "setTitle", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "title"));
        digester.addCallMethod("*/extension", "setName", 1);
        digester.addCallParam("*/extension", 0, "name");
        digester.addCallMethod("*/extension", "setNamespace", 1);
        digester.addCallParam("*/extension", 0, "namespace");
        digester.addCallMethod("*/extension", "setRowType", 1);
        digester.addCallParam("*/extension", 0, "rowType");
        digester.addCallMethod("*/extension", "setLink", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "relation"));
        digester.addCallMethod("*/extension", "setDescription", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "description"));
        digester.addCallMethod("*/extension", "setSubject", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "subject"));
        digester.addObjectCreate("*/property", ExtensionProperty.class);
        digester.addCallMethod("*/property", "setQualname", 1);
        digester.addCallParam("*/property", 0, "qualName");
        digester.addCallMethod("*/property", "setName", 1);
        digester.addCallParam("*/property", 0, "name");
        digester.addCallMethod("*/property", "setNamespace", 1);
        digester.addCallParam("*/property", 0, "namespace");
        digester.addCallMethod("*/property", "setGroup", 1);
        digester.addCallParam("*/property", 0, "group");
        digester.addCallMethod("*/property", "setType", 1);
        digester.addCallParam("*/property", 0, "type");
        digester.addCallMethod("*/property", "setRequired", 1);
        digester.addCallParam("*/property", 0, "required");
        digester.addCallMethod("*/property", "setLink", 1);
        digester.addRule("*/property", (Rule)new CallParamNoNSRule(0, "relation"));
        digester.addCallMethod("*/property", "setDescription", 1);
        digester.addRule("*/property", (Rule)new CallParamNoNSRule(0, "description"));
        digester.addCallMethod("*/property", "setExamples", 1);
        digester.addCallParam("*/property", 0, "examples");
        digester.addCallMethod("*/property", "setColumnLength", 1);
        digester.addCallParam("*/property", 0, "columnLength");
        digester.addRule("*/property", (Rule)this.thesaurusRule);
        digester.addSetNext("*/property", "addProperty");
        digester.parse(is);
        return e;
    }
}

