/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.InputStream;
import java.io.Reader;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerDumy;
import net.minidev.json.parser.JSONParserByteArray;
import net.minidev.json.parser.JSONParserInputStream;
import net.minidev.json.parser.JSONParserReader;
import net.minidev.json.parser.JSONParserString;
import net.minidev.json.parser.ParseException;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 400;
    public static final int MODE_JSON_SIMPLE = 448;
    public static final int MODE_STRICTEST = 144;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 448 : -1;
    private int mode;
    private JSONParserReader pStream;
    private JSONParserInputStream pSBintream;
    private JSONParserString pString;
    private JSONParserByteArray pBytes;

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int permissifMode) {
        this.mode = permissifMode;
    }

    public Object parse(String in) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(in);
    }

    public Object parse(String in, ContainerFactory containerFactory) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(in, containerFactory);
    }

    public Object parse(String in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(in, containerFactory, handler);
    }

    public Object parse(byte[] in) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(in);
    }

    public Object parse(byte[] in, ContainerFactory containerFactory) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(in, containerFactory);
    }

    public Object parse(byte[] in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(in, containerFactory, handler);
    }

    public Object parse(byte[] in, int offset, int length) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(in, offset, length, ContainerFactory.FACTORY_SIMPLE, ContentHandlerDumy.HANDLER);
    }

    public Object parse(byte[] in, int offset, int length, ContainerFactory containerFactory) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(in, offset, length, containerFactory, ContentHandlerDumy.HANDLER);
    }

    public Object parse(byte[] in, int offset, int length, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(in, offset, length, containerFactory, handler);
    }

    public Object parse(Reader in) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(in);
    }

    public Object parse(Reader in, ContainerFactory containerFactory) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(in, containerFactory);
    }

    public Object parse(Reader in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(in, containerFactory, handler);
    }

    public Object parse(InputStream in) throws ParseException {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(in);
    }

    public Object parse(InputStream in, ContainerFactory containerFactory) throws ParseException {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(in, containerFactory);
    }

    public Object parse(InputStream in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(in, containerFactory, handler);
    }
}

