/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Candidates;

public final class TagLinkToken
extends AbstractStringMetric
implements Serializable {
    private float matched;
    private float tr;
    private float tSize;
    private float uSize;
    private static final float DEF_TR = 0.3f;
    private String sA;
    private String sB;
    private String tokenT;
    private int largestIndex;
    private final float ESTIMATEDTIMINGCONST = 1.9796386E-4f;

    public TagLinkToken() {
        this(0.3f);
    }

    private TagLinkToken(float tr) {
        this.tr = tr;
    }

    @Override
    public float getUnNormalisedSimilarity(String T, String U) {
        return this.getSimilarity(T, U);
    }

    @Override
    public float getSimilarity(String T, String U) {
        if (T.equals(U)) {
            this.matched = T.length();
            return 1.0f;
        }
        this.tSize = T.length();
        this.uSize = U.length();
        if (this.tSize < this.uSize) {
            String tmp1 = T;
            T = U;
            U = tmp1;
            float tmp2 = this.tSize;
            this.tSize = this.uSize;
            this.uSize = tmp2;
            this.tokenT = U;
        }
        this.tokenT = T;
        ArrayList<Candidates> candidateList = this.algorithm1(T, U);
        this.sortList(candidateList);
        float score = this.getScore(candidateList);
        score = (score / this.tSize + score / this.uSize) / 2.0f;
        return this.winkler(score, T, U);
    }

    @Override
    public String getSimilarityExplained(String T, String U) {
        StringBuffer buff = new StringBuffer();
        buff.append("\n****TagLinkToken****\n");
        buff.append("Ti=").append(T).append(", Uj=").append(U).append("\n");
        float score = 0.0f;
        if (T.equals(U)) {
            this.matched = T.length();
            buff.append("Sij=1.0");
        } else {
            this.tSize = T.length();
            this.uSize = U.length();
            if (this.tSize < this.uSize) {
                String tmp1 = T;
                T = U;
                U = tmp1;
                float tmp2 = this.tSize;
                this.tSize = this.uSize;
                this.uSize = tmp2;
            }
            ArrayList<Candidates> candidateList = this.algorithm1(T, U);
            this.sortList(candidateList);
            buff.append("Common characteres:\n");
            buff.append("Ti\tUj\tSij(Ti,Uj)\n");
            this.matched = 0.0f;
            HashMap tMap = new HashMap();
            HashMap uMap = new HashMap();
            Iterator<Candidates> i$ = candidateList.iterator();
            while (i$.hasNext()) {
                Candidates aCandidateList;
                Candidates actualCandidates = aCandidateList = i$.next();
                Integer tPos = actualCandidates.getTPos();
                Integer uPos = actualCandidates.getUPos();
                if (tMap.containsKey(tPos) || uMap.containsKey(uPos)) continue;
                float actualScore = actualCandidates.getScore();
                score += actualScore;
                tMap.put(tPos, null);
                uMap.put(uPos, null);
                buff.append(T.charAt(tPos)).append("\t").append(U.charAt(uPos)).append("\t").append(this.round(actualScore)).append("\n");
                this.matched += 1.0f;
            }
            score = (score / this.tSize + score / this.uSize) / 2.0f;
            System.out.println("score " + score);
            buff.append("Sij(T,U)=").append(this.round(this.winkler(score, T, U)));
            buff.append("\nMatched characters=").append(this.matched);
        }
        return buff.toString();
    }

    private float getScore(ArrayList<Candidates> candidateList) {
        this.matched = 0.0f;
        this.largestIndex = -1;
        float scoreValue = 0.0f;
        HashMap tMap = new HashMap();
        HashMap uMap = new HashMap();
        Iterator<Candidates> i$ = candidateList.iterator();
        while (i$.hasNext()) {
            Candidates aCandidateList;
            Candidates actualCandidates = aCandidateList = i$.next();
            Integer actualTPos = actualCandidates.getTPos();
            Integer actualUPos = actualCandidates.getUPos();
            if (tMap.containsKey(actualTPos) || uMap.containsKey(actualUPos)) continue;
            scoreValue += actualCandidates.getScore();
            tMap.put(actualTPos, null);
            uMap.put(actualUPos, null);
            if (this.largestIndex < actualTPos) {
                this.largestIndex = actualTPos;
            }
            this.matched += 1.0f;
        }
        return scoreValue;
    }

    private ArrayList<Candidates> algorithm1(String T, String U) {
        ArrayList<Candidates> candidateList = new ArrayList<Candidates>();
        int bound = (int)(1.0 / (double)this.tr);
        for (int t = 0; t < T.length(); ++t) {
            char chT = T.charAt(t);
            float lastTr = -1.0f;
            boolean flag = false;
            for (int u = Math.max(0, t - bound); u < Math.min(t + bound + 1, U.length()) && !flag; ++u) {
                float tr2 = Math.abs(t - u);
                if ((double)lastTr >= 0.0 && lastTr < tr2) {
                    flag = true;
                    continue;
                }
                char chU = U.charAt(u);
                float charScore = 0.0f;
                if (chT == chU) {
                    charScore = 1.0f;
                }
                if (!((double)charScore > 0.0)) continue;
                lastTr = tr2;
                if ((double)(charScore -= this.tr * tr2) == 1.0) {
                    flag = true;
                }
                candidateList.add(new Candidates(t, u, charScore));
            }
        }
        return candidateList;
    }

    private void sortList(ArrayList<Candidates> candidateList) {
        Collections.sort(candidateList, new Comparator(){

            public int compare(Object o1, Object o2) {
                float scoreT = ((Candidates)o1).getScore();
                float scoreU = ((Candidates)o2).getScore();
                if (scoreU > scoreT) {
                    return 1;
                }
                if (scoreU < scoreT) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private float winkler(float score, String T, String U) {
        score += (float)this.getPrefix(T, U) * 0.1f * (1.0f - score);
        return score;
    }

    private int getPrefix(String T, String U) {
        int prefix;
        int bound = Math.min(4, Math.min(T.length(), U.length()));
        for (prefix = 0; prefix < bound && T.charAt(prefix) == U.charAt(prefix); ++prefix) {
        }
        return prefix;
    }

    public float getMatched() {
        return this.matched;
    }

    public float getTr() {
        return this.tr;
    }

    public void setTreshold(float treshold) {
        this.tr = treshold;
    }

    @Override
    public String getShortDescriptionString() {
        return "[TagLinkToken_Tr_" + this.tr + "]";
    }

    public boolean splitWord(float score) {
        boolean answer = true;
        if ((double)score == 1.0) {
            answer = false;
        } else {
            float matchedRate = this.matched / this.uSize;
            int cutUpper = (int)this.tSize - this.largestIndex;
            if (this.largestIndex < 3 || cutUpper < 3 || (double)matchedRate < 0.8 || (double)score < 0.7) {
                answer = false;
            } else {
                this.split();
            }
        }
        return answer;
    }

    private void split() {
        this.sA = "";
        this.sB = "";
        int cutIndex = 0;
        while ((float)cutIndex < this.tSize) {
            if (cutIndex <= this.largestIndex) {
                this.sA = this.sA + this.tokenT.charAt(cutIndex);
            } else {
                this.sB = this.sB + this.tokenT.charAt(cutIndex);
            }
            ++cutIndex;
        }
    }

    public String getSa() {
        return this.sA;
    }

    public String getSb() {
        return this.sB;
    }

    private float round(float number) {
        int round = (int)(number * 1000.0f);
        float rest = number * 1000.0f - (float)round;
        if ((double)rest >= 0.5) {
            ++round;
        }
        return (float)round / 1000.0f;
    }

    @Override
    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return str1Length * str2Length * 1.9796386E-4f;
    }

    @Override
    public String getLongDescriptionString() {
        return this.getShortDescriptionString();
    }
}

