/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gbif.ecat.model.ParsedName;

public class ALAParsedName<T>
extends ParsedName<T> {
    public String locationPhraseDescription = null;
    public String cleanPhrase = null;
    public String phraseVoucher = null;
    public String cleanVoucher = null;
    public String phraseNominatingParty = null;
    public static final Pattern multipleSpaces = Pattern.compile("\\s{2,}");
    public static final Pattern voucherBlacklist = Pattern.compile(" and | AND | And | s.n.| sn ");
    public static final Pattern voucherRemovePattern = Pattern.compile("[^\\w]");
    public static final Pattern potentialVoucherId = Pattern.compile("([^A-Z][A-Z]{1,3} [0-9])");
    public static final Pattern initialOnePattern = Pattern.compile("(?:[A-Z][\\.]){1,3}");
    public static final Pattern initialTwoPattern = Pattern.compile("(?:[^A-Z][A-Z]{1,3} )");
    public static final Pattern phraseBlacklist = Pattern.compile("&| AND | and |Stn|Stn\\.|Station|Mt |Mt\\.|Mount");
    public static final Pattern phrasePunctuationRemoval = Pattern.compile("'|\"");

    public ALAParsedName() {
    }

    public ALAParsedName(ParsedName<T> pn) {
        this.authorsParsed = pn.authorsParsed;
        this.setAuthorship(pn.getAuthorship());
        this.setBracketAuthorship(pn.getBracketAuthorship());
        this.setBracketYear(pn.getBracketYear());
        this.setCode(pn.getCode());
        this.setCultivar(pn.getCultivar());
        this.setGenusOrAbove(pn.getGenusOrAbove());
        this.setId(pn.getId());
        this.setInfraGeneric(pn.getInfraGeneric());
        this.setInfraSpecificEpithet(pn.getInfraSpecificEpithet());
        this.setNomStatus(pn.getNomStatus());
        this.setNotho(pn.getNotho());
        this.setRank(pn.getRank());
        this.setRankMarker(pn.getRankMarker());
        this.setRemarks(pn.getRemarks());
        this.setSensu(pn.getSensu());
        this.setSpecificEpithet(pn.getSpecificEpithet());
        this.setType(pn.getType());
        this.setYear(pn.getYear());
    }

    public String getLocationPhraseDesciption() {
        return this.locationPhraseDescription;
    }

    public String getLocationPhraseDescription() {
        return this.locationPhraseDescription;
    }

    public void setLocationPhraseDescription(String locationPhraseDescription) {
        this.locationPhraseDescription = locationPhraseDescription;
        if (this.rank == "sp") {
            this.specificEpithet = locationPhraseDescription;
        } else {
            this.infraSpecificEpithet = locationPhraseDescription;
        }
        if (locationPhraseDescription != null) {
            this.cleanPhrase = phraseBlacklist.matcher(" " + locationPhraseDescription).replaceAll(" ").trim();
            this.cleanPhrase = phrasePunctuationRemoval.matcher(this.cleanPhrase).replaceAll("");
            this.cleanPhrase = multipleSpaces.matcher(this.cleanPhrase).replaceAll(" ");
        }
    }

    public String getPhraseNominatingParty() {
        return this.phraseNominatingParty;
    }

    public void setPhraseNominatingParty(String phraseNominatingParty) {
        this.phraseNominatingParty = phraseNominatingParty;
    }

    public String getPhraseVoucher() {
        return this.phraseVoucher;
    }

    public void setPhraseVoucher(String phraseVoucher) {
        this.phraseVoucher = phraseVoucher;
        if (phraseVoucher != null) {
            this.cleanVoucher = phraseVoucher;
            Matcher m = potentialVoucherId.matcher(this.cleanVoucher);
            if (m.find()) {
                this.cleanVoucher = m.replaceFirst(" " + m.group().replaceAll(" ", ""));
            }
            this.cleanVoucher = voucherBlacklist.matcher(this.cleanVoucher).replaceAll(" ");
            this.cleanVoucher = initialOnePattern.matcher(this.cleanVoucher).replaceAll(" ");
            this.cleanVoucher = initialTwoPattern.matcher(this.cleanVoucher).replaceAll(" ");
            this.cleanVoucher = voucherRemovePattern.matcher(this.cleanVoucher).replaceAll("");
        }
    }
}

