/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.memory.CollectionSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.GeometryTransformationVisitor;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.filter.visitor.SpatialFilterVisitor;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.StyleLayer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.ScreenMap;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.DelayedBackbufferGraphic;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.renderer.lite.GraphicsAwareDpiRescaleStyleVisitor;
import org.geotools.renderer.lite.IndexedFeatureResults;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.OpacityFinder;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.SimpleGeometryFactory;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.lite.SymbolizerAssociation;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.geometry.BoundingBox;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.LineSymbolizer;
import org.opengis.style.PolygonSymbolizer;

public class StreamingRenderer
implements GTRenderer {
    private static final int REPROJECTION_RASTER_GUTTER = 10;
    private static final int defaultMaxFiltersToSendToDatastore = 5;
    public static final String SCALE_ACCURATE = "ACCURATE";
    public static final String SCALE_OGC = "OGC";
    private static final double TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    int error = 0;
    private static final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
    private static final PropertyName gridPropertyName = filterFactory.property("grid");
    private static final PropertyName paramsPropertyName = filterFactory.property("params");
    private static final PropertyName defaultGeometryPropertyName = filterFactory.property("");
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Operation CROP = PROCESSOR.getOperation("CoverageCrop");
    private static final Operation SCALE = PROCESSOR.getOperation("Scale");
    private MapContent mapContent;
    private boolean interactive = true;
    private boolean concatTransforms = false;
    private ReferencedEnvelope mapExtent;
    private ReferencedEnvelope originalMapExtent;
    private ProjectionHandler projectionHandler;
    private Rectangle screenSize;
    private volatile boolean renderingStopRequested = false;
    protected double scaleDenominator;
    private double generalizationDistance = 0.8;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    protected LabelCache labelCache = new LabelCacheImpl();
    private StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private BlockingQueue<RenderingRequest> requests;
    private IndexedFeatureResults indexedFeatureResults;
    private List<RenderListener> renderListeners = new CopyOnWriteArrayList<RenderListener>();
    private RenderingHints java2dHints;
    private int renderingBufferDEFAULT = 0;
    private String scaleComputationMethodDEFAULT = "OGC";
    public static final String TEXT_RENDERING_STRING = LabelCacheImpl.LabelRenderingMode.STRING.name();
    public static final String TEXT_RENDERING_OUTLINE = LabelCacheImpl.LabelRenderingMode.OUTLINE.name();
    public static final String TEXT_RENDERING_ADAPTIVE = LabelCacheImpl.LabelRenderingMode.ADAPTIVE.name();
    public static final String TEXT_RENDERING_KEY = "textRenderingMethod";
    private String textRenderingModeDEFAULT = TEXT_RENDERING_STRING;
    public static final String LINE_WIDTH_OPTIMIZATION_KEY = "lineWidthOptimization";
    public static final String OPTIMIZE_FTS_RENDERING_KEY = "optimizeFTSRendering";
    public static final String ADVANCED_PROJECTION_HANDLING_KEY = "advancedProjectionHandling";
    public static final String CONTINUOUS_MAP_WRAPPING = "continuousMapWrapping";
    public static final String VECTOR_RENDERING_KEY = "vectorRenderingEnabled";
    private static boolean VECTOR_RENDERING_ENABLED_DEFAULT = false;
    public static final String LABEL_CACHE_KEY = "labelCache";
    public static final String FORCE_EPSG_AXIS_ORDER_KEY = "ForceEPSGAxisOrder";
    public static final String DPI_KEY = "dpi";
    public static final String DECLARED_SCALE_DENOM_KEY = "declaredScaleDenominator";
    public static final String SCALE_COMPUTATION_METHOD_KEY = "scaleComputationMethod";
    private Map rendererHints = null;
    private AffineTransform worldToScreenTransform = null;
    private CoordinateReferenceSystem destinationCrs;
    private boolean canTransform;
    private boolean inMemoryGeneralization = true;
    private ExecutorService threadPool;
    private PainterThread painterThread;
    private int metaBuffer;
    private static final Decimator NULL_DECIMATOR = new Decimator(-1.0, -1.0);

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void setConcatTransforms(boolean flag) {
        this.concatTransforms = flag;
    }

    public boolean getConcatTransforms() {
        return this.concatTransforms;
    }

    @Override
    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    @Override
    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(Object feature) {
        if (!(feature instanceof SimpleFeature)) {
            if (feature instanceof Feature) {
                LOGGER.log(Level.FINE, "Skipping non simple feature rendering notification");
            }
            return;
        }
        if (this.renderListeners.size() > 0) {
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.featureRenderer((SimpleFeature)feature);
            }
        }
    }

    private void fireErrorEvent(Throwable t) {
        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
        if (this.renderListeners.size() > 0) {
            Exception e = t instanceof Exception ? (Exception)t : new Exception(t);
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.errorOccurred(e);
            }
        }
    }

    @Override
    public void stopRendering() {
        this.renderingStopRequested = true;
        this.requests.clear();
        this.painterThread.interrupt();
        try {
            this.requests.put(new EndRequest());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to put the end request in the requests queue, this should never happen", e);
        }
        this.labelCache.stop();
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform worldToScreen) {
        if (worldToScreen == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        try {
            Envelope mapArea = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
            this.paint(graphics, paintArea, mapArea, worldToScreen);
        }
        catch (NoninvertibleTransformException e) {
            this.fireErrorEvent(e);
        }
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea, AffineTransform worldToScreen) {
        this.paint(graphics, paintArea, new ReferencedEnvelope(mapArea, this.mapContent.getCoordinateReferenceSystem()), worldToScreen);
    }

    private double computeScale(ReferencedEnvelope envelope, Rectangle paintArea, AffineTransform worldToScreen, Map hints) {
        if (this.getScaleComputationMethod().equals(SCALE_ACCURATE)) {
            try {
                return RendererUtilities.calculateScale(envelope, paintArea.width, paintArea.height, hints);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        if (XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            return RendererUtilities.calculateOGCScaleAffine(envelope.getCoordinateReferenceSystem(), worldToScreen, hints);
        }
        return RendererUtilities.calculateOGCScale(envelope, paintArea.width, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea, AffineTransform worldToScreen) {
        if (graphics == null) {
            LOGGER.severe("renderer passed null graphics argument");
            throw new NullPointerException("renderer requires graphics");
        }
        if (paintArea == null) {
            LOGGER.severe("renderer passed null paintArea argument");
            throw new NullPointerException("renderer requires paintArea");
        }
        if (mapArea == null) {
            LOGGER.severe("renderer passed null mapArea argument");
            throw new NullPointerException("renderer requires mapArea");
        }
        if (worldToScreen == null && (worldToScreen = RendererUtilities.worldToScreenTransform(mapArea, paintArea)) == null) {
            return;
        }
        this.destinationCrs = mapArea.getCoordinateReferenceSystem();
        this.mapExtent = new ReferencedEnvelope(mapArea);
        this.screenSize = paintArea;
        this.worldToScreenTransform = worldToScreen;
        this.error = 0;
        if (this.java2dHints != null) {
            graphics.setRenderingHints(this.java2dHints);
        }
        Point2D.Double textureAnchor = new Point2D.Double(this.worldToScreenTransform.getTranslateX(), this.worldToScreenTransform.getTranslateY());
        graphics.setRenderingHint(StyledShapePainter.TEXTURE_ANCHOR_HINT_KEY, textureAnchor);
        this.renderingStopRequested = false;
        graphics.setClip(paintArea);
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(this.worldToScreenTransform);
            this.worldToScreenTransform = atg;
            graphics.setTransform(this.worldToScreenTransform);
        }
        this.scaleDenominator = this.computeScale(mapArea, paintArea, this.worldToScreenTransform, this.rendererHints);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Computed scale denominator: " + this.scaleDenominator);
        }
        int buffer = this.getRenderingBuffer();
        this.originalMapExtent = this.mapExtent;
        if (buffer > 0) {
            this.mapExtent = new ReferencedEnvelope(this.expandEnvelope(this.mapExtent, worldToScreen, buffer), this.mapExtent.getCoordinateReferenceSystem());
        }
        this.requests = this.getRequestsQueue();
        this.painterThread = new PainterThread(this.requests);
        ExecutorService localThreadPool = this.threadPool;
        boolean localPool = false;
        if (localThreadPool == null) {
            localThreadPool = Executors.newSingleThreadExecutor();
            localPool = true;
        }
        Future<?> painterFuture = localThreadPool.submit(this.painterThread);
        try {
            if (this.mapContent == null) {
                throw new IllegalStateException("Cannot call paint, you did not set a MapContent in this renderer");
            }
            this.labelCache.start();
            if (this.labelCache instanceof LabelCacheImpl) {
                ((LabelCacheImpl)this.labelCache).setLabelRenderingMode(LabelCacheImpl.LabelRenderingMode.valueOf(this.getTextRenderingMethod()));
            }
            int layersNumber = this.mapContent.layers().size();
            for (int i = 0; i < layersNumber; ++i) {
                Layer layer = this.mapContent.layers().get(i);
                if (!layer.isVisible()) continue;
                if (this.renderingStopRequested) {
                    return;
                }
                this.labelCache.startLayer(i + "");
                if (layer instanceof DirectLayer) {
                    RenderDirectLayerRequest request = new RenderDirectLayerRequest(graphics, (DirectLayer)layer);
                    try {
                        this.requests.put(request);
                    }
                    catch (InterruptedException e) {
                        this.fireErrorEvent(e);
                    }
                } else {
                    MapLayer currLayer = new MapLayer(layer);
                    try {
                        this.processStylers(graphics, currLayer, this.worldToScreenTransform, this.destinationCrs, this.mapExtent, this.screenSize, i + "");
                    }
                    catch (Throwable t) {
                        this.fireErrorEvent(t);
                    }
                }
                this.labelCache.endLayer(i + "", graphics, this.screenSize);
            }
        }
        finally {
            try {
                if (!this.renderingStopRequested) {
                    this.requests.put(new EndRequest());
                    painterFuture.get();
                }
            }
            catch (Exception e) {
                painterFuture.cancel(true);
                this.fireErrorEvent(e);
            }
            finally {
                if (localPool) {
                    localThreadPool.shutdown();
                }
            }
        }
        if (!this.renderingStopRequested) {
            this.labelCache.end(graphics, paintArea);
        } else {
            this.labelCache.clear();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Style cache hit ratio: ").append(this.styleFactory.getHitRatio()).append(" , hits ").append(this.styleFactory.getHits()).append(", requests ").append(this.styleFactory.getRequests()).toString());
        }
        if (this.error <= 0) return;
        LOGGER.warning(new StringBuffer("Number of Errors during paint(Graphics2D, AffineTransform) = ").append(this.error).toString());
    }

    protected BlockingQueue<RenderingRequest> getRequestsQueue() {
        return new RenderingBlockingQueue(10000);
    }

    private Envelope expandEnvelope(Envelope envelope, AffineTransform worldToScreen, int buffer) {
        assert (buffer > 0);
        double bufferX = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleX0((AffineTransform)worldToScreen));
        double bufferY = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleY0((AffineTransform)worldToScreen));
        return new Envelope(envelope.getMinX() - bufferX, envelope.getMaxX() + bufferX, envelope.getMinY() - bufferY, envelope.getMaxY() + bufferY);
    }

    Collection queryLayer(MapLayer currLayer, CollectionSource source) {
        Collection results = null;
        Query query = new Query(Query.ALL);
        Query definitionQuery = currLayer.getQuery();
        if (definitionQuery != Query.ALL) {
            query = query == Query.ALL ? new Query(definitionQuery) : new Query(DataUtilities.mixQueries(definitionQuery, query, "liteRenderer"));
        }
        results = source.content(query.getFilter());
        return results;
    }

    Query getStyleQuery(FeatureSource<FeatureType, Feature> source, FeatureType schema, List<LiteFeatureTypeStyle> styleList, Envelope mapArea, CoordinateReferenceSystem mapCRS, CoordinateReferenceSystem featCrs, Rectangle screenSize, GeometryDescriptor geometryAttribute, AffineTransform worldToScreenTransform, boolean renderingTransformation) throws IllegalFilterException, IOException, FactoryException {
        Query query = new Query(Query.ALL);
        Filter filter = null;
        LiteFeatureTypeStyle[] styles = styleList.toArray(new LiteFeatureTypeStyle[styleList.size()]);
        if (this.getRenderingBuffer() == 0) {
            this.metaBuffer = this.findRenderingBuffer(styles);
            if (this.metaBuffer > 0) {
                mapArea = this.expandEnvelope(mapArea, worldToScreenTransform, this.metaBuffer);
                LOGGER.fine("Expanding rendering area by " + this.metaBuffer + " pixels to consider stroke width");
                for (LiteFeatureTypeStyle lfts : styles) {
                    if (lfts.screenMap == null) continue;
                    lfts.screenMap = new ScreenMap(lfts.screenMap, this.metaBuffer);
                }
            }
        }
        mapArea = this.expandEnvelopeByTransformations(styles, new ReferencedEnvelope(mapArea, mapCRS));
        List<PropertyName> attributes = styles == null ? null : this.findStyleAttributes(styles, schema);
        ReferencedEnvelope envelope = new ReferencedEnvelope(mapArea, mapCRS);
        try {
            List<ReferencedEnvelope> envelopes = null;
            if (this.isAdvancedProjectionHandlingEnabled()) {
                this.projectionHandler = ProjectionHandlerFinder.getHandler(this.mapExtent, featCrs, this.isMapWrappingEnabled());
                if (this.projectionHandler != null) {
                    envelopes = this.projectionHandler.getQueryEnvelopes();
                }
            }
            if (envelopes == null) {
                envelopes = mapCRS != null && featCrs != null && !CRS.equalsIgnoreMetadata((Object)featCrs, (Object)mapCRS) ? Collections.singletonList(envelope.transform(featCrs, true, 10)) : Collections.singletonList(envelope);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Querying layer " + schema.getName() + " with bbox: " + envelope);
            }
            filter = this.createBBoxFilters(schema, attributes, envelopes);
            query = new Query(schema.getName().getLocalPart());
            query.setFilter(filter);
            query.setProperties(attributes);
            this.processRuleForQuery(styles, query);
        }
        catch (Exception e) {
            Exception txException = new Exception("Error transforming bbox", e);
            LOGGER.log(Level.SEVERE, "Error querying layer", txException);
            this.fireErrorEvent(txException);
            this.canTransform = false;
            query = new Query(schema.getName().getLocalPart());
            query.setProperties(attributes);
            ReferencedEnvelope bounds = source.getBounds();
            if (bounds != null && envelope.intersects(bounds)) {
                LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, bboxs intersect therefore using envelope)", e);
                filter = null;
                filter = this.createBBoxFilters(schema, attributes, Collections.singletonList(envelope));
                query.setFilter(filter);
            } else {
                LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, falling back on full data loading (no bbox query)", e);
                query.setFilter((Filter)Filter.INCLUDE);
            }
            this.processRuleForQuery(styles, query);
        }
        LiteCoordinateSequenceFactory csFactory = new LiteCoordinateSequenceFactory();
        SimpleGeometryFactory gFactory = new SimpleGeometryFactory(csFactory);
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)csFactory);
        hints.put((Object)Hints.JTS_GEOMETRY_FACTORY, (Object)gFactory);
        hints.put((Object)Hints.FEATURE_2D, (Object)Boolean.TRUE);
        try {
            CoordinateReferenceSystem crs = this.getNativeCRS(schema, attributes);
            if (crs != null) {
                Set<RenderingHints.Key> fsHints = source.getSupportedHints();
                SingleCRS crs2D = crs == null ? null : CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
                MathTransform mt = this.buildFullTransform((CoordinateReferenceSystem)crs2D, mapCRS, worldToScreenTransform);
                double[] spans = Decimator.computeGeneralizationDistances(mt.inverse(), screenSize, this.generalizationDistance);
                double distance = spans[0] < spans[1] ? spans[0] : spans[1];
                for (LiteFeatureTypeStyle fts : styles) {
                    if (fts.screenMap == null) continue;
                    fts.screenMap.setTransform(mt);
                    fts.screenMap.setSpans(spans[0], spans[1]);
                    if (!fsHints.contains(Hints.SCREENMAP)) continue;
                    hints.put((Object)Hints.SCREENMAP, (Object)fts.screenMap);
                    fts.screenMap = null;
                }
                if (renderingTransformation) {
                    if (fsHints.contains(Hints.GEOMETRY_GENERALIZATION)) {
                        hints.put((Object)Hints.GEOMETRY_GENERALIZATION, (Object)distance);
                        this.inMemoryGeneralization = false;
                    }
                } else if (fsHints.contains(Hints.GEOMETRY_SIMPLIFICATION)) {
                    hints.put((Object)Hints.GEOMETRY_SIMPLIFICATION, (Object)distance);
                    this.inMemoryGeneralization = false;
                } else if (fsHints.contains(Hints.GEOMETRY_DISTANCE)) {
                    hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)distance);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error computing the generalization hints", e);
        }
        if (query.getHints() == null) {
            query.setHints(hints);
        } else {
            query.getHints().putAll((Map)hints);
        }
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        Filter simplifiedFilter = (Filter)query.getFilter().accept((FilterVisitor)simplifier, null);
        query.setFilter(simplifiedFilter);
        return query;
    }

    Query getDefinitionQuery(MapLayer currLayer, FeatureSource<FeatureType, Feature> source, CoordinateReferenceSystem featCrs) throws FactoryException {
        Query definitionQuery = this.reprojectQuery(currLayer.getQuery(), source);
        definitionQuery.setCoordinateSystem(featCrs);
        return definitionQuery;
    }

    ReferencedEnvelope expandEnvelopeByTransformations(LiteFeatureTypeStyle[] styles, ReferencedEnvelope envelope) {
        GeometryTransformationVisitor visitor = new GeometryTransformationVisitor();
        ReferencedEnvelope result = new ReferencedEnvelope(envelope);
        for (LiteFeatureTypeStyle lts : styles) {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            rules.addAll(Arrays.asList(lts.ruleList));
            rules.addAll(Arrays.asList(lts.elseRules));
            for (Rule r : rules) {
                for (Symbolizer s : r.symbolizers()) {
                    ReferencedEnvelope re;
                    if (s.getGeometry() == null || (re = (ReferencedEnvelope)s.getGeometry().accept((ExpressionVisitor)visitor, (Object)envelope)) == null) continue;
                    result.expandToInclude(re);
                }
            }
        }
        return result;
    }

    private MathTransform buildFullTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS, AffineTransform worldToScreenTransform) throws FactoryException {
        Object mt = this.buildTransform(sourceCRS, destCRS);
        mt = mt != null && !mt.isIdentity() ? ConcatenatedTransform.create((MathTransform)mt, (MathTransform)ProjectiveTransform.create((AffineTransform)worldToScreenTransform)) : ProjectiveTransform.create((AffineTransform)worldToScreenTransform);
        return mt;
    }

    private MathTransform buildTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) throws FactoryException {
        MathTransform transform = null;
        if (sourceCRS != null && sourceCRS.getCoordinateSystem().getDimension() >= 3) {
            MathTransform toWgs84_3d = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
            MathTransform toWgs84_2d = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            transform = ConcatenatedTransform.create((MathTransform)toWgs84_3d, (MathTransform)toWgs84_2d);
            sourceCRS = DefaultGeographicCRS.WGS84;
        }
        MathTransform2D mt = sourceCRS == null || destCRS == null || CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)destCRS) ? null : (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        if (transform != null) {
            if (mt == null) {
                return transform;
            }
            return ConcatenatedTransform.create(transform, mt);
        }
        return mt;
    }

    private CoordinateReferenceSystem getNativeCRS(FeatureType schema, List<PropertyName> attNames) {
        CoordinateReferenceSystem crs = null;
        for (PropertyName name : attNames) {
            Object att = name.evaluate((Object)schema);
            if (!(att instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)att;
            CoordinateReferenceSystem gdCrs = gd.getCoordinateReferenceSystem();
            if (crs == null) {
                crs = gdCrs;
                continue;
            }
            if (gdCrs == null) {
                crs = null;
                break;
            }
            if (CRS.equalsIgnoreMetadata((Object)crs, (Object)gdCrs)) continue;
            crs = null;
            break;
        }
        return crs;
    }

    private void processRuleForQuery(LiteFeatureTypeStyle[] styles, Query q) {
        block7: {
            try {
                int maxFilters = this.getMaxFiltersToSendToDatastore();
                ArrayList<Filter> filtersToDS = new ArrayList<Filter>();
                for (LiteFeatureTypeStyle style : styles) {
                    if (style.elseRules.length > 0) {
                        return;
                    }
                    for (Rule r : style.ruleList) {
                        if (r.getFilter() == null) {
                            return;
                        }
                        filtersToDS.add(r.getFilter());
                    }
                }
                if (filtersToDS.size() > maxFilters) {
                    return;
                }
                Object ruleFiltersCombined = filtersToDS.size() == 1 ? (Filter)filtersToDS.get(0) : filterFactory.or(filtersToDS);
                ruleFiltersCombined = filterFactory.and(q.getFilter(), (Filter)ruleFiltersCombined);
                q.setFilter((Filter)ruleFiltersCombined);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                LOGGER.log(Level.SEVERE, "Could not send rules to datastore due to: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private int getMaxFiltersToSendToDatastore() {
        try {
            if (this.rendererHints == null) {
                return 5;
            }
            Integer result = (Integer)this.rendererHints.get("maxFiltersToSendToDatastore");
            if (result == null) {
                return 5;
            }
            return result;
        }
        catch (Exception e) {
            return 5;
        }
    }

    private boolean isOptimizedFTSRenderingEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(OPTIMIZE_FTS_RENDERING_KEY);
        if (result == null) {
            return true;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isAdvancedProjectionHandlingEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(ADVANCED_PROJECTION_HANDLING_KEY);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isMapWrappingEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(CONTINUOUS_MAP_WRAPPING);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isEPSGAxisOrderForced() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(FORCE_EPSG_AXIS_ORDER_KEY);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isVectorRenderingEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(VECTOR_RENDERING_KEY);
        if (result == null) {
            return VECTOR_RENDERING_ENABLED_DEFAULT;
        }
        return (Boolean)result;
    }

    private int findRenderingBuffer(LiteFeatureTypeStyle[] styles) {
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        for (int t = 0; t < styles.length; ++t) {
            int j;
            LiteFeatureTypeStyle lfts = styles[t];
            Rule[] rules = lfts.elseRules;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
            rules = lfts.ruleList;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
        }
        if (!rbe.isEstimateAccurate()) {
            LOGGER.fine("Assuming rendering buffer = " + rbe.getBuffer() + ", but estimation is not accurate, you may want to set a buffer manually");
        }
        return (int)Math.round((double)rbe.getBuffer() / 2.0 + 1.0);
    }

    private List<PropertyName> findStyleAttributes(LiteFeatureTypeStyle[] styles, FeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        for (LiteFeatureTypeStyle lfts : styles) {
            int j;
            Rule[] rules = lfts.elseRules;
            int rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
            rules = lfts.ruleList;
            rulesLength = rules.length;
            for (j = 0; j < rulesLength; ++j) {
                sae.visit(rules[j]);
            }
        }
        if (sae.isUsingDynamincProperties()) {
            return null;
        }
        Set<PropertyName> attributes = sae.getAttributes();
        Set<String> attributeNames = sae.getAttributeNameSet();
        ArrayList<PropertyName> atts = new ArrayList<PropertyName>(attributes);
        Collection attTypes = schema.getDescriptors();
        for (PropertyDescriptor pd : attTypes) {
            Name attName = pd.getName();
            if ((!attName.getLocalPart().equalsIgnoreCase("grid") || attributeNames.contains(attName.getLocalPart())) && (!attName.getLocalPart().equalsIgnoreCase("params") || attributeNames.contains(attName.getLocalPart()))) continue;
            atts.add(filterFactory.property(attName));
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("added attribute " + attName);
        }
        try {
            if (sae.getDefaultGeometryUsed() && !attributeNames.contains(schema.getGeometryDescriptor().getName().toString())) {
                atts.add(filterFactory.property(schema.getGeometryDescriptor().getName()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return atts;
    }

    private Filter createBBoxFilters(FeatureType schema, List<PropertyName> attributes, List<ReferencedEnvelope> bboxes) throws IllegalFilterException {
        Object filter = Filter.INCLUDE;
        int length = attributes.size();
        for (int j = 0; j < length; ++j) {
            Object attType = attributes.get(j).evaluate((Object)schema);
            if (attType == null || !(attType instanceof GeometryDescriptor)) continue;
            FastBBOX gfilter = new FastBBOX(attributes.get(j), bboxes.get(0), (FilterFactory)filterFactory);
            filter = filter == Filter.INCLUDE ? gfilter : filterFactory.or((Filter)filter, (Filter)gfilter);
            if (bboxes.size() <= 0) continue;
            for (int k = 1; k < bboxes.size(); ++k) {
                filter = filterFactory.or((Filter)filter, (Filter)new FastBBOX(attributes.get(j), bboxes.get(k), (FilterFactory)filterFactory));
            }
        }
        return filter;
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    private ArrayList<LiteFeatureTypeStyle> createLiteFeatureTypeStyles(List<FeatureTypeStyle> featureStyles, Object typeDescription, Graphics2D graphics) throws IOException {
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        for (FeatureTypeStyle fts : featureStyles) {
            if (typeDescription == null || typeDescription.toString().indexOf(fts.getFeatureTypeName()) == -1) continue;
            List<Rule> rules = fts.rules();
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
            for (Rule r : rules) {
                if (!this.isWithInScale(r)) continue;
                if (r.isElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            if (ruleList.isEmpty() && elseRuleList.isEmpty()) continue;
            LiteFeatureTypeStyle lfts = result.isEmpty() || !this.isOptimizedFTSRenderingEnabled() ? new LiteFeatureTypeStyle(graphics, ruleList, elseRuleList, fts.getTransformation()) : new LiteFeatureTypeStyle(new DelayedBackbufferGraphic(graphics, this.screenSize), ruleList, elseRuleList, fts.getTransformation());
            result.add(lfts);
        }
        return result;
    }

    private ArrayList<LiteFeatureTypeStyle> createLiteFeatureTypeStyles(List<FeatureTypeStyle> featureStyles, FeatureType ftype, Graphics2D graphics) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("creating rules for scale denominator - " + NumberFormat.getNumberInstance().format(this.scaleDenominator));
        }
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        for (FeatureTypeStyle fts : featureStyles) {
            if (!this.isFeatureTypeStyleActive(ftype, fts)) continue;
            List[] splittedRules = this.splitRules(fts);
            List ruleList = splittedRules[0];
            List elseRuleList = splittedRules[1];
            if (ruleList.isEmpty() && elseRuleList.isEmpty()) continue;
            LiteFeatureTypeStyle lfts = result.isEmpty() || !this.isOptimizedFTSRenderingEnabled() ? new LiteFeatureTypeStyle(graphics, ruleList, elseRuleList, fts.getTransformation()) : new LiteFeatureTypeStyle(new DelayedBackbufferGraphic(graphics, this.screenSize), ruleList, elseRuleList, fts.getTransformation());
            if (this.screenMapEnabled(lfts)) {
                lfts.screenMap = new ScreenMap(this.screenSize.x, this.screenSize.y, this.screenSize.width, this.screenSize.height);
            }
            result.add(lfts);
        }
        return result;
    }

    boolean screenMapEnabled(LiteFeatureTypeStyle lfts) {
        if (this.generalizationDistance == 0.0) {
            return false;
        }
        OpacityFinder finder = new OpacityFinder(new Class[]{PointSymbolizer.class, LineSymbolizer.class, PolygonSymbolizer.class});
        for (Rule r : lfts.ruleList) {
            r.accept(finder);
        }
        for (Rule r : lfts.elseRules) {
            r.accept(finder);
        }
        return !finder.hasOpacity;
    }

    private boolean isFeatureTypeStyleActive(FeatureType ftype, FeatureTypeStyle fts) {
        return fts.featureTypeNames().isEmpty() || ftype.getName().getLocalPart() != null && (ftype.getName().getLocalPart().equalsIgnoreCase(fts.getFeatureTypeName()) || FeatureTypes.isDecendedFrom(ftype, null, fts.getFeatureTypeName()));
    }

    private List[] splitRules(FeatureTypeStyle fts) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
        Rule[] rules = fts.getRules();
        ruleList = new ArrayList();
        elseRuleList = new ArrayList();
        for (int j = 0; j < rules.length; ++j) {
            Rule r = rules[j];
            if (!this.isWithInScale(r)) continue;
            if (r.isElseFilter()) {
                elseRuleList.add(r);
                continue;
            }
            ruleList.add(r);
        }
        return new List[]{ruleList, elseRuleList};
    }

    public int getMaxBackBufferMemory(int width, int height) {
        int maxBuffers = 0;
        for (Layer layer : this.mapContent.layers()) {
            StyleLayer styleLayer;
            if (!layer.isVisible() || !(layer instanceof StyleLayer) || (styleLayer = (StyleLayer)layer).getStyle().featureTypeStyles().size() < 2) continue;
            int currCount = 0;
            MapLayer mapLayer = new MapLayer(layer);
            Object ftype = mapLayer.getFeatureSource().getSchema();
            for (FeatureTypeStyle fts : styleLayer.getStyle().featureTypeStyles()) {
                if (!this.isFeatureTypeStyleActive((FeatureType)ftype, fts)) continue;
                List[] splittedRules = this.splitRules(fts);
                List ruleList = splittedRules[0];
                List elseRuleList = splittedRules[1];
                if (ruleList.isEmpty() && elseRuleList.isEmpty()) continue;
                ++currCount;
            }
            if (--currCount <= maxBuffers) continue;
            maxBuffers = currCount;
        }
        return maxBuffers * width * height * 4;
    }

    private FeatureCollection prepFeatureCollection(FeatureCollection features, CoordinateReferenceSystem sourceCrs) {
        CoordinateReferenceSystem rCS = null;
        try {
            rCS = features.getSchema().getGeometryDescriptor().getType().getCoordinateReferenceSystem();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!(rCS == sourceCrs || sourceCrs == null || rCS != null && CRS.equalsIgnoreMetadata((Object)rCS, (Object)sourceCrs))) {
            try {
                return new ForceCoordinateSystemFeatureResults((SimpleFeatureCollection)features, sourceCrs);
            }
            catch (Exception ee) {
                LOGGER.log(Level.WARNING, ee.getLocalizedMessage(), ee);
            }
        }
        return features;
    }

    private void processStylers(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, Envelope mapArea, Rectangle screenSize, String layerId) throws Exception {
        Style style = currLayer.getStyle();
        FeatureSource featureSource = currLayer.getFeatureSource();
        NumberRange scaleRange = NumberRange.create((double)this.scaleDenominator, (double)this.scaleDenominator);
        if (featureSource != null) {
            ArrayList<LiteFeatureTypeStyle> lfts;
            FeatureCollection features = null;
            Object schema = featureSource.getSchema();
            GeometryDescriptor geometryAttribute = schema.getGeometryDescriptor();
            CoordinateReferenceSystem sourceCrs = geometryAttribute != null && geometryAttribute.getType() != null ? geometryAttribute.getType().getCoordinateReferenceSystem() : null;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Processing " + style.featureTypeStyles().size() + " stylers for " + featureSource.getSchema().getName());
            }
            if ((lfts = this.createLiteFeatureTypeStyles(style.featureTypeStyles(), (FeatureType)schema, graphics)).isEmpty()) {
                return;
            }
            this.reprojectSpatialFilters(lfts, featureSource);
            this.applyUnitRescale(lfts);
            List<List<LiteFeatureTypeStyle>> txClassified = this.classifyByTransformation(lfts);
            for (List<LiteFeatureTypeStyle> uniform : txClassified) {
                Expression transform = uniform.get((int)0).transformation;
                this.inMemoryGeneralization = true;
                boolean hasTransformation = transform != null;
                Query styleQuery = this.getStyleQuery(featureSource, (FeatureType)schema, uniform, mapArea, destinationCrs, sourceCrs, screenSize, geometryAttribute, at, hasTransformation);
                Query definitionQuery = this.getDefinitionQuery(currLayer, featureSource, sourceCrs);
                if (hasTransformation) {
                    GridGeometry2D gridGeometry = this.getRasterGridGeometry(destinationCrs, sourceCrs);
                    features = this.applyRenderingTransformation(transform, featureSource, definitionQuery, styleQuery, gridGeometry, sourceCrs);
                    if (features == null) {
                        return;
                    }
                } else {
                    Query mixed = DataUtilities.mixQueries(definitionQuery, styleQuery, null);
                    this.checkAttributeExistence((FeatureType)featureSource.getSchema(), mixed);
                    features = featureSource.getFeatures(mixed);
                    features = this.prepFeatureCollection(features, sourceCrs);
                }
                if (!(features instanceof SimpleFeatureCollection)) {
                    features.getSchema().getUserData().put("targetCrs", destinationCrs);
                    features.getSchema().getUserData().put("targetVersion", "wms:getmap");
                }
                if (this.isOptimizedFTSRenderingEnabled() && lfts.size() > 1) {
                    this.drawOptimized(graphics, currLayer, at, destinationCrs, layerId, null, features, scaleRange, uniform);
                    continue;
                }
                this.drawPlain(graphics, currLayer, at, destinationCrs, layerId, null, features, scaleRange, uniform);
            }
        } else {
            Collection collection = null;
            CollectionSource source = currLayer.getSource();
            collection = this.queryLayer(currLayer, currLayer.getSource());
            Object sourceCrs = null;
            ArrayList<LiteFeatureTypeStyle> lfts = this.createLiteFeatureTypeStyles(style.featureTypeStyles(), source.describe(), graphics);
            this.applyUnitRescale(lfts);
            if (lfts.isEmpty()) {
                return;
            }
            if (this.isOptimizedFTSRenderingEnabled() && lfts.size() > 1) {
                this.drawOptimized(graphics, currLayer, at, destinationCrs, layerId, collection, null, scaleRange, lfts);
            } else {
                this.drawPlain(graphics, currLayer, at, destinationCrs, layerId, collection, null, scaleRange, lfts);
            }
        }
    }

    List<List<LiteFeatureTypeStyle>> classifyByTransformation(List<LiteFeatureTypeStyle> lfts) {
        ArrayList<List<LiteFeatureTypeStyle>> txClassified = new ArrayList<List<LiteFeatureTypeStyle>>();
        txClassified.add(new ArrayList());
        Expression transformation = null;
        for (int i = 0; i < lfts.size(); ++i) {
            LiteFeatureTypeStyle curr = lfts.get(i);
            if (i == 0) {
                transformation = curr.transformation;
            } else if (transformation != curr.transformation || transformation != null && curr.transformation != null && !curr.transformation.equals(transformation)) {
                txClassified.add(new ArrayList());
            }
            ((List)txClassified.get(txClassified.size() - 1)).add(curr);
        }
        return txClassified;
    }

    void checkAttributeExistence(FeatureType schema, Query query) {
        if (query.getProperties() == null) {
            return;
        }
        for (PropertyName attribute : query.getProperties()) {
            if (attribute.evaluate((Object)schema) != null) continue;
            if (schema instanceof SimpleFeatureType) {
                ArrayList<Name> allNames = new ArrayList<Name>();
                for (PropertyDescriptor pd : schema.getDescriptors()) {
                    allNames.add(pd.getName());
                }
                throw new IllegalFilterException("Could not find '" + attribute + "' in the FeatureType (" + schema.getName() + "), available attributes are: " + allNames);
            }
            throw new IllegalFilterException("Could not find '" + attribute + "' in the FeatureType (" + schema.getName() + ")");
        }
    }

    FeatureCollection applyRenderingTransformation(Expression transformation, FeatureSource featureSource, Query layerQuery, Query renderingQuery, GridGeometry2D gridGeometry, CoordinateReferenceSystem sourceCrs) throws IOException, SchemaException, TransformException, FactoryException {
        Object result = null;
        Object schema = featureSource.getSchema();
        boolean isRasterData = false;
        if (schema instanceof SimpleFeatureType) {
            SimpleFeatureType simpleSchema = (SimpleFeatureType)schema;
            GridCoverage2D coverage = null;
            if (FeatureUtilities.isWrappedCoverage((SimpleFeatureType)simpleSchema) || FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)simpleSchema)) {
                isRasterData = true;
                GridGeometry2D readGG = gridGeometry;
                if (transformation instanceof RenderingTransformation) {
                    RenderingTransformation tx = (RenderingTransformation)transformation;
                    readGG = (GridGeometry2D)tx.invertGridGeometry(renderingQuery, (GridGeometry)gridGeometry);
                }
                FeatureCollection sample = featureSource.getFeatures();
                Object gridWrapper = DataUtilities.first(sample);
                if (FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)simpleSchema)) {
                    MathTransform g2w;
                    Object params = paramsPropertyName.evaluate(gridWrapper);
                    GridCoverage2DReader reader = (GridCoverage2DReader)gridPropertyName.evaluate(gridWrapper);
                    if (CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)gridGeometry.getCoordinateReferenceSystem()) && (g2w = reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER)) instanceof AffineTransform2D && readGG.getGridToCRS2D() instanceof AffineTransform2D) {
                        AffineTransform2D atOriginal = (AffineTransform2D)g2w;
                        AffineTransform2D atMap = (AffineTransform2D)readGG.getGridToCRS2D();
                        if (XAffineTransform.getScale((AffineTransform)atMap) < XAffineTransform.getScale((AffineTransform)atOriginal)) {
                            org.opengis.geometry.Envelope worldEnvelope = gridGeometry.getEnvelope();
                            GeneralEnvelope transformed = CRS.transform((MathTransform)atOriginal.inverse(), (org.opengis.geometry.Envelope)worldEnvelope);
                            int minx = (int)Math.floor(transformed.getMinimum(0));
                            int miny = (int)Math.floor(transformed.getMinimum(1));
                            int maxx = (int)Math.ceil(transformed.getMaximum(0));
                            int maxy = (int)Math.ceil(transformed.getMaximum(1));
                            Rectangle rect = new Rectangle(minx, miny, maxx - minx, maxy - miny);
                            GridEnvelope2D gridEnvelope = new GridEnvelope2D(rect);
                            readGG = new GridGeometry2D((GridEnvelope)gridEnvelope, (MathTransform)atOriginal, worldEnvelope.getCoordinateReferenceSystem());
                        }
                    }
                    coverage = this.readCoverage(reader, params, readGG);
                } else {
                    coverage = (GridCoverage2D)gridPropertyName.evaluate(gridWrapper);
                }
                if (coverage != null) {
                    if (readGG != null) {
                        MathTransform2D coverageTx;
                        ReferencedEnvelope renderingEnvelope = new ReferencedEnvelope(readGG.getEnvelope());
                        CoordinateReferenceSystem coverageCRS = coverage.getCoordinateReferenceSystem2D();
                        if (!CRS.equalsIgnoreMetadata((Object)renderingEnvelope.getCoordinateReferenceSystem(), (Object)coverageCRS)) {
                            renderingEnvelope = renderingEnvelope.transform(coverageCRS, true);
                        }
                        if (coverage.getEnvelope2D().intersects((BoundingBox)renderingEnvelope)) {
                            ParameterValueGroup param = CROP.getParameters();
                            param.parameter("Source").setValue((Object)coverage);
                            param.parameter("Envelope").setValue((Object)renderingEnvelope);
                            coverage = (GridCoverage2D)PROCESSOR.doOperation(param);
                        } else {
                            coverage = null;
                        }
                        if (coverage != null && (coverageTx = readGG.getGridToCRS2D()) instanceof AffineTransform) {
                            AffineTransform coverageAt = (AffineTransform)coverageTx;
                            AffineTransform renderingAt = (AffineTransform)gridGeometry.getGridToCRS2D();
                            double ratioX = coverageAt.getScaleX() / renderingAt.getScaleX();
                            double ratioY = coverageAt.getScaleY() / renderingAt.getScaleY();
                            if (ratioX < 0.7 && ratioY < 0.7) {
                                ParameterValueGroup param = SCALE.getParameters();
                                param.parameter("Source").setValue((Object)coverage);
                                param.parameter("xScale").setValue(ratioX);
                                param.parameter("yScale").setValue(ratioY);
                                Interpolation interpolation = (Interpolation)this.java2dHints.get(JAI.KEY_INTERPOLATION);
                                if (interpolation != null) {
                                    param.parameter("Interpolation").setValue((Object)interpolation);
                                }
                                coverage = (GridCoverage2D)PROCESSOR.doOperation(param);
                            }
                        }
                    }
                    result = coverage != null ? transformation.evaluate((Object)coverage) : null;
                }
            }
        }
        if (result == null && !isRasterData) {
            Query optimizedQuery = null;
            if (transformation instanceof RenderingTransformation) {
                RenderingTransformation tx = (RenderingTransformation)transformation;
                optimizedQuery = tx.invertQuery(renderingQuery, (GridGeometry)gridGeometry);
            }
            if (optimizedQuery == null) {
                Envelope bounds = (Envelope)renderingQuery.getFilter().accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null);
                FastBBOX bbox = new FastBBOX(filterFactory.property(""), bounds, (FilterFactory)filterFactory);
                optimizedQuery = new Query(null, bbox);
                optimizedQuery.setHints(layerQuery.getHints());
            }
            Query mixedQuery = DataUtilities.mixQueries(layerQuery, optimizedQuery, null);
            FeatureCollection originalFeatures = featureSource.getFeatures(mixedQuery);
            this.prepFeatureCollection(originalFeatures, sourceCrs);
            result = transformation.evaluate(originalFeatures);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof FeatureCollection) {
            return (FeatureCollection)result;
        }
        if (result instanceof GridCoverage2D) {
            return FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)result));
        }
        if (result instanceof GridCoverage2DReader) {
            return FeatureUtilities.wrapGridCoverageReader((GridCoverage2DReader)((GridCoverage2DReader)result), null);
        }
        throw new IllegalArgumentException("Don't know how to handle the results of the transformation, the supported result types are FeatureCollection, GridCoverage2D and GridCoverage2DReader, but we got: " + result.getClass());
    }

    void applyUnitRescale(ArrayList<LiteFeatureTypeStyle> lfts) {
        double standardDpi;
        double dpi = RendererUtilities.getDpi(this.getRendererHints());
        if (dpi != (standardDpi = RendererUtilities.getDpi(Collections.emptyMap()))) {
            double scaleFactor = dpi / standardDpi;
            GraphicsAwareDpiRescaleStyleVisitor dpiVisitor = new GraphicsAwareDpiRescaleStyleVisitor(scaleFactor);
            for (LiteFeatureTypeStyle fts : lfts) {
                this.rescaleFeatureTypeStyle(fts, dpiVisitor);
            }
        }
        double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio(this.scaleDenominator, this.rendererHints);
        UomRescaleStyleVisitor rescaleVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
        for (LiteFeatureTypeStyle fts : lfts) {
            this.rescaleFeatureTypeStyle(fts, rescaleVisitor);
        }
    }

    void reprojectSpatialFilters(ArrayList<LiteFeatureTypeStyle> lfts, FeatureSource fs) throws FactoryException {
        Object schema = fs.getSchema();
        CoordinateReferenceSystem declaredCRS = this.getDeclaredSRS((FeatureType)schema);
        for (LiteFeatureTypeStyle fts : lfts) {
            this.reprojectSpatialFilters(fts, declaredCRS, (FeatureType)schema);
        }
    }

    private CoordinateReferenceSystem getDeclaredSRS(FeatureType schema) throws FactoryException {
        Integer code;
        CoordinateReferenceSystem declaredCRS = schema.getCoordinateReferenceSystem();
        if (this.isEPSGAxisOrderForced() && (code = CRS.lookupEpsgCode((CoordinateReferenceSystem)declaredCRS, (boolean)false)) != null) {
            declaredCRS = CRS.decode((String)("urn:ogc:def:crs:EPSG::" + code));
        }
        return declaredCRS;
    }

    private Query reprojectQuery(Query query, FeatureSource<FeatureType, Feature> source) throws FactoryException {
        if (query == null || query.getFilter() == null) {
            return query;
        }
        Filter original = query.getFilter();
        CoordinateReferenceSystem declaredCRS = this.getDeclaredSRS(source.getSchema());
        Filter reprojected = this.reprojectSpatialFilter(declaredCRS, source.getSchema(), original);
        if (reprojected == original) {
            return query;
        }
        Query rq = new Query(query);
        rq.setFilter(reprojected);
        return rq;
    }

    void reprojectSpatialFilters(LiteFeatureTypeStyle fts, CoordinateReferenceSystem declaredCRS, FeatureType schema) {
        int i;
        for (i = 0; i < fts.ruleList.length; ++i) {
            fts.ruleList[i] = this.reprojectSpatialFilters(fts.ruleList[i], declaredCRS, schema);
        }
        if (fts.elseRules != null) {
            for (i = 0; i < fts.elseRules.length; ++i) {
                fts.elseRules[i] = this.reprojectSpatialFilters(fts.elseRules[i], declaredCRS, schema);
            }
        }
    }

    private Rule reprojectSpatialFilters(Rule rule, CoordinateReferenceSystem declaredCRS, FeatureType schema) {
        Filter filter = rule.getFilter();
        if (filter == null) {
            return rule;
        }
        Filter reprojected = this.reprojectSpatialFilter(declaredCRS, schema, filter);
        if (reprojected == filter) {
            return rule;
        }
        RuleImpl rr = new RuleImpl(rule);
        rr.setFilter(reprojected);
        return rr;
    }

    private Filter reprojectSpatialFilter(CoordinateReferenceSystem declaredCRS, FeatureType schema, Filter filter) {
        if (filter == null) {
            return null;
        }
        SpatialFilterVisitor sfv = new SpatialFilterVisitor();
        filter.accept((FilterVisitor)sfv, null);
        if (!sfv.hasSpatialFilter()) {
            return filter;
        }
        DefaultCRSFilterVisitor defaulter = new DefaultCRSFilterVisitor(filterFactory, declaredCRS);
        Filter defaulted = (Filter)filter.accept((FilterVisitor)defaulter, null);
        ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(filterFactory, schema);
        Filter reprojected = (Filter)defaulted.accept((FilterVisitor)reprojector, null);
        return reprojected;
    }

    void rescaleFeatureTypeStyle(LiteFeatureTypeStyle fts, DuplicatingStyleVisitor visitor) {
        int i;
        for (i = 0; i < fts.ruleList.length; ++i) {
            visitor.visit(fts.ruleList[i]);
            fts.ruleList[i] = (Rule)visitor.getCopy();
        }
        if (fts.elseRules != null) {
            for (i = 0; i < fts.elseRules.length; ++i) {
                visitor.visit(fts.elseRules[i]);
                fts.elseRules[i] = (Rule)visitor.getCopy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPlain(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId, Collection<?> collection, FeatureCollection<?, ?> features, NumberRange<?> scaleRange, List<LiteFeatureTypeStyle> lfts) {
        LiteFeatureTypeStyle[] fts_array;
        for (LiteFeatureTypeStyle liteFeatureTypeStyle : fts_array = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()])) {
            Iterator<?> iterator = null;
            if (collection != null) {
                iterator = collection.iterator();
                if (iterator == null) {
                    return;
                }
            } else if (features != null) {
                FeatureIterator<?> featureIterator = features.features();
                if (featureIterator == null) {
                    return;
                }
                iterator = DataUtilities.iterator(featureIterator);
            } else {
                return;
            }
            try {
                boolean clone = this.isCloningRequired(currLayer, fts_array);
                RenderableFeature rf = new RenderableFeature(currLayer, clone);
                rf.setScreenMap(liteFeatureTypeStyle.screenMap);
                while (iterator.hasNext() && !this.renderingStopRequested) {
                    try {
                        rf.setFeature(iterator.next());
                        this.process(rf, liteFeatureTypeStyle, scaleRange, at, destinationCrs, layerId);
                    }
                    catch (Throwable tr) {
                        this.fireErrorEvent(tr);
                    }
                }
            }
            finally {
                DataUtilities.close(iterator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOptimized(Graphics2D graphics, MapLayer currLayer, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId, Collection collection, FeatureCollection features, NumberRange scaleRange, List lfts) {
        RenderableFeature rf;
        boolean clone;
        Object iterator;
        LiteFeatureTypeStyle[] fts_array = lfts.toArray(new LiteFeatureTypeStyle[lfts.size()]);
        if (collection != null) {
            iterator = collection.iterator();
            if (iterator == null) {
                return;
            }
            try {
                clone = this.isCloningRequired(currLayer, fts_array);
                rf = new RenderableFeature(currLayer, clone);
                while (iterator.hasNext() && !this.renderingStopRequested) {
                    try {
                        rf.setFeature(iterator.next());
                        for (LiteFeatureTypeStyle liteFeatureTypeStyle : fts_array) {
                            rf.setScreenMap(liteFeatureTypeStyle.screenMap);
                            this.process(rf, liteFeatureTypeStyle, scaleRange, at, destinationCrs, layerId);
                        }
                    }
                    catch (Throwable tr) {
                        this.fireErrorEvent(tr);
                    }
                }
                this.requests.put(new MergeLayersRequest(graphics, fts_array));
            }
            catch (InterruptedException e) {
                this.fireErrorEvent(e);
            }
            finally {
                DataUtilities.close(iterator);
            }
        }
        if (features != null) {
            iterator = features.features();
            if (iterator == null) {
                return;
            }
            try {
                clone = this.isCloningRequired(currLayer, fts_array);
                rf = new RenderableFeature(currLayer, clone);
                while (iterator.hasNext() && !this.renderingStopRequested) {
                    try {
                        rf.setFeature(iterator.next());
                        for (LiteFeatureTypeStyle liteFeatureTypeStyle : fts_array) {
                            rf.setScreenMap(liteFeatureTypeStyle.screenMap);
                            this.process(rf, liteFeatureTypeStyle, scaleRange, at, destinationCrs, layerId);
                        }
                    }
                    catch (Throwable tr) {
                        this.fireErrorEvent(tr);
                    }
                }
                this.requests.put(new MergeLayersRequest(graphics, fts_array));
            }
            catch (InterruptedException e) {
                this.fireErrorEvent(e);
            }
            finally {
                iterator.close();
            }
        }
    }

    private boolean isCloningRequired(MapLayer layer, LiteFeatureTypeStyle[] lfts) {
        Set<RenderingHints.Key> hints = layer.getFeatureSource().getSupportedHints();
        if (!hints.contains(Hints.FEATURE_DETACHED)) {
            return true;
        }
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        Object featureType = layer.getFeatureSource().getSchema();
        HashSet<String> plainGeometries = new HashSet<String>();
        HashSet<String> txGeometries = new HashSet<String>();
        for (LiteFeatureTypeStyle lft : lfts) {
            for (Rule r : lft.ruleList) {
                for (Symbolizer s : r.symbolizers()) {
                    String attribute;
                    if (s.getGeometry() == null) {
                        attribute = featureType.getGeometryDescriptor().getName().getLocalPart();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    if (s.getGeometry() instanceof PropertyName) {
                        attribute = ((PropertyName)s.getGeometry()).getPropertyName();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    Expression g = s.getGeometry();
                    extractor.clear();
                    g.accept((ExpressionVisitor)extractor, null);
                    Set<String> attributes = extractor.getAttributeNameSet();
                    for (String attribute2 : attributes) {
                        if (plainGeometries.contains(attribute2)) {
                            return true;
                        }
                        if (txGeometries.contains(attribute2)) {
                            return true;
                        }
                        txGeometries.add(attribute2);
                    }
                }
            }
        }
        return false;
    }

    private void process(RenderableFeature rf, LiteFeatureTypeStyle fts, NumberRange scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId) throws Exception {
        boolean doElse = true;
        Rule[] elseRuleList = fts.elseRules;
        Rule[] ruleList = fts.ruleList;
        Graphics2D graphics = fts.graphics;
        for (Rule r : ruleList) {
            Filter filter = r.getFilter();
            if (filter != null && !filter.evaluate(rf.content)) continue;
            doElse = false;
            this.processSymbolizers(graphics, rf, r.symbolizers(), scaleRange, at, destinationCrs, layerId);
        }
        if (doElse) {
            for (Rule r : elseRuleList) {
                this.processSymbolizers(graphics, rf, r.symbolizers(), scaleRange, at, destinationCrs, layerId);
            }
        }
    }

    private void processSymbolizers(Graphics2D graphics, RenderableFeature drawMe, List<Symbolizer> symbolizers, NumberRange scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs, String layerId) throws Exception {
        int paintCommands = 0;
        for (Symbolizer symbolizer : symbolizers) {
            if (symbolizer instanceof RasterSymbolizer) {
                GridCoverage2D coverage = null;
                boolean disposeCoverage = false;
                try {
                    Object grid = gridPropertyName.evaluate(drawMe.content);
                    if (grid instanceof GridCoverage2D) {
                        coverage = (GridCoverage2D)grid;
                    } else if (grid instanceof GridCoverage2DReader) {
                        Object params = paramsPropertyName.evaluate(drawMe.content);
                        GridCoverage2DReader reader = (GridCoverage2DReader)grid;
                        CoordinateReferenceSystem sourceCRS = reader.getCoordinateReferenceSystem();
                        GridGeometry2D readGG = this.getRasterGridGeometry(destinationCrs, sourceCRS);
                        coverage = this.readCoverage(reader, params, readGG);
                        disposeCoverage = true;
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    this.fireErrorEvent(e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    this.fireErrorEvent(e);
                }
                if (coverage == null) continue;
                this.requests.put(new RenderRasterRequest(graphics, coverage, disposeCoverage, (RasterSymbolizer)symbolizer, destinationCrs, at));
                ++paintCommands;
                continue;
            }
            LiteShape2 shape = drawMe.getShape(symbolizer, at);
            if (shape == null) continue;
            if (symbolizer instanceof TextSymbolizer && drawMe.content instanceof Feature) {
                this.labelCache.put(layerId, (TextSymbolizer)symbolizer, (Feature)drawMe.content, shape, (NumberRange<Double>)scaleRange);
                ++paintCommands;
                continue;
            }
            Style2D style = this.styleFactory.createStyle(drawMe.content, symbolizer, (Range)scaleRange);
            double size = RendererUtilities.getStyle2DSize(style);
            double clipBuffer = Math.max(size / 2.0, (double)this.metaBuffer) + 10.0;
            Envelope env = new Envelope(this.screenSize.getMinX(), this.screenSize.getMaxX(), this.screenSize.getMinY(), this.screenSize.getMaxY());
            env.expandBy(clipBuffer);
            GeometryClipper clipper = new GeometryClipper(env);
            Geometry g = clipper.clip(shape.getGeometry(), false);
            if (g == null) continue;
            if (g != shape.getGeometry()) {
                shape = new LiteShape2(g, null, null, false);
            }
            PaintShapeRequest paintShapeRequest = new PaintShapeRequest(graphics, shape, style, this.scaleDenominator);
            if (symbolizer.hasOption("labelObstacle")) {
                paintShapeRequest.setLabelObstacle(true);
            }
            this.requests.put(paintShapeRequest);
            ++paintCommands;
        }
        if (paintCommands > 0) {
            this.requests.put(new FeatureRenderedRequest(drawMe.content));
        }
    }

    GridGeometry2D getRasterGridGeometry(CoordinateReferenceSystem destinationCrs, CoordinateReferenceSystem sourceCRS) throws NoninvertibleTransformException {
        GridGeometry2D readGG;
        if (sourceCRS == null || destinationCrs == null || CRS.equalsIgnoreMetadata((Object)destinationCrs, (Object)sourceCRS)) {
            readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.screenSize), (org.opengis.geometry.Envelope)this.originalMapExtent);
        } else {
            Rectangle bufferedTargetArea = (Rectangle)this.screenSize.clone();
            bufferedTargetArea.add(this.screenSize.x + this.screenSize.width + 10, this.screenSize.y + this.screenSize.height + 10);
            bufferedTargetArea.add(this.screenSize.x - 10, this.screenSize.y - 10);
            readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(bufferedTargetArea), PixelInCell.CELL_CORNER, (MathTransform)new AffineTransform2D(this.worldToScreenTransform.createInverse()), this.originalMapExtent.getCoordinateReferenceSystem(), null);
        }
        return readGG;
    }

    private Geometry findGeometry(Object drawMe, Symbolizer s) {
        Expression geomExpr = s.getGeometry();
        Geometry geom = geomExpr == null ? (drawMe instanceof SimpleFeature ? (Geometry)((SimpleFeature)drawMe).getDefaultGeometry() : (drawMe instanceof Feature ? (Geometry)((Feature)drawMe).getDefaultGeometryProperty().getValue() : (Geometry)defaultGeometryPropertyName.evaluate(drawMe, Geometry.class))) : (Geometry)geomExpr.evaluate(drawMe, Geometry.class);
        return geom;
    }

    private CoordinateReferenceSystem findGeometryCS(MapLayer currLayer, Object drawMe, Symbolizer s) {
        if (drawMe instanceof Feature) {
            Feature f = (Feature)drawMe;
            FeatureType schema = f.getType();
            Expression geometry = s.getGeometry();
            Object geomName = null;
            if (geometry instanceof PropertyName) {
                return this.getAttributeCRS((PropertyName)geometry, schema);
            }
            if (geometry == null) {
                return this.getAttributeCRS(null, schema);
            }
            StyleAttributeExtractor attExtractor = new StyleAttributeExtractor();
            geometry.accept((ExpressionVisitor)attExtractor, null);
            for (PropertyName name : attExtractor.getAttributes()) {
                if (!(name.evaluate((Object)schema) instanceof GeometryDescriptor)) continue;
                return this.getAttributeCRS(name, schema);
            }
        }
        if (currLayer.getSource() != null) {
            return currLayer.getSource().getCRS();
        }
        return null;
    }

    CoordinateReferenceSystem getAttributeCRS(PropertyName geomName, FeatureType schema) {
        if (geomName == null || "".equals(geomName.getPropertyName())) {
            GeometryDescriptor geom = schema.getGeometryDescriptor();
            return geom.getType().getCoordinateReferenceSystem();
        }
        GeometryDescriptor geom = (GeometryDescriptor)geomName.evaluate((Object)schema);
        return geom.getType().getCoordinateReferenceSystem();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    private int getRenderingBuffer() {
        if (this.rendererHints == null) {
            return this.renderingBufferDEFAULT;
        }
        Number result = (Number)this.rendererHints.get("renderingBuffer");
        if (result == null) {
            return this.renderingBufferDEFAULT;
        }
        return result.intValue();
    }

    private String getScaleComputationMethod() {
        if (this.rendererHints == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        String result = (String)this.rendererHints.get(SCALE_COMPUTATION_METHOD_KEY);
        if (result == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        return result;
    }

    private String getTextRenderingMethod() {
        if (this.rendererHints == null) {
            return this.textRenderingModeDEFAULT;
        }
        String result = (String)this.rendererHints.get(TEXT_RENDERING_KEY);
        if (result == null) {
            return this.textRenderingModeDEFAULT;
        }
        return result;
    }

    public double getGeneralizationDistance() {
        return this.generalizationDistance;
    }

    public void setGeneralizationDistance(double d) {
        this.generalizationDistance = d;
    }

    @Override
    public void setJava2DHints(RenderingHints hints) {
        this.java2dHints = hints;
        this.styleFactory.setRenderingHints(hints);
    }

    @Override
    public RenderingHints getJava2DHints() {
        return this.java2dHints;
    }

    public void setRendererHints(Map hints) {
        if (hints != null && hints.containsKey(LABEL_CACHE_KEY)) {
            LabelCache cache = (LabelCache)hints.get(LABEL_CACHE_KEY);
            if (cache == null) {
                throw new NullPointerException("Label_Cache_Hint has a null value for the labelcache");
            }
            this.labelCache = cache;
        }
        if (hints != null && hints.containsKey(LINE_WIDTH_OPTIMIZATION_KEY)) {
            this.styleFactory.setLineOptimizationEnabled(Boolean.TRUE.equals(hints.get(LINE_WIDTH_OPTIMIZATION_KEY)));
        }
        this.rendererHints = hints;
        this.styleFactory.setVectorRenderingEnabled(this.isVectorRenderingEnabled());
    }

    public Map getRendererHints() {
        return this.rendererHints;
    }

    @Override
    public void setContext(MapContext context) {
        this.mapContent = context;
    }

    @Override
    public MapContext getContext() {
        if (this.mapContent instanceof MapContext) {
            return (MapContext)this.mapContent;
        }
        MapContext context = new MapContext(this.mapContent);
        return context;
    }

    @Override
    public void setMapContent(MapContent mapContent) {
        this.mapContent = mapContent;
    }

    @Override
    public MapContent getMapContent() {
        return this.mapContent;
    }

    public boolean isCanTransform() {
        return this.canTransform;
    }

    public static MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) {
        try {
            return CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        }
        catch (OperationNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    GridCoverage2D readCoverage(GridCoverage2DReader reader, Object params, GridGeometry2D readGG) throws IOException {
        GridCoverage2D coverage;
        Parameter readGGParam = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        readGGParam.setValue((Object)readGG);
        if (params != null) {
            GeneralParameterValue[] readParams = (GeneralParameterValue[])params;
            int length = readParams.length;
            if (length > 0) {
                int i;
                String name = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
                for (i = 0; i < length && !readParams[i].getDescriptor().getName().toString().equalsIgnoreCase(name); ++i) {
                }
                if (i < length) {
                    ((Parameter)readParams[i]).setValue((Object)readGGParam);
                    coverage = reader.read(readParams);
                } else {
                    GeneralParameterValue[] readParams2 = new GeneralParameterValue[length + 1];
                    System.arraycopy(readParams, 0, readParams2, 0, length);
                    readParams2[length] = readGGParam;
                    coverage = reader.read(readParams2);
                }
            } else {
                coverage = reader.read(new GeneralParameterValue[]{readGGParam});
            }
        } else {
            coverage = readGG != null ? reader.read(new GeneralParameterValue[]{readGGParam}) : reader.read(null);
        }
        return coverage;
    }

    class RenderingBlockingQueue
    extends ArrayBlockingQueue<RenderingRequest> {
        public RenderingBlockingQueue(int capacity) {
            super(capacity);
        }

        @Override
        public void put(RenderingRequest e) throws InterruptedException {
            if (!StreamingRenderer.this.renderingStopRequested) {
                super.put(e);
                if (StreamingRenderer.this.renderingStopRequested) {
                    this.clear();
                }
            }
        }

        @Override
        public RenderingRequest take() throws InterruptedException {
            if (!StreamingRenderer.this.renderingStopRequested) {
                return (RenderingRequest)super.take();
            }
            return new EndRequest();
        }
    }

    class PainterThread
    implements Runnable {
        BlockingQueue<RenderingRequest> requests;
        Thread thread;

        public PainterThread(BlockingQueue<RenderingRequest> requests) {
            this.requests = requests;
        }

        public void interrupt() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            boolean done = false;
            while (!done) {
                try {
                    RenderingRequest request = this.requests.take();
                    if (request instanceof EndRequest || StreamingRenderer.this.renderingStopRequested) {
                        done = true;
                        continue;
                    }
                    request.execute();
                }
                catch (InterruptedException e) {
                    if (!StreamingRenderer.this.renderingStopRequested) continue;
                    done = true;
                }
                catch (Throwable t) {
                    StreamingRenderer.this.fireErrorEvent(t);
                }
            }
        }
    }

    class EndRequest
    extends RenderingRequest {
        EndRequest() {
        }

        @Override
        void execute() {
        }
    }

    class RenderDirectLayerRequest
    extends RenderingRequest {
        private final Graphics2D graphics;
        private final DirectLayer layer;

        public RenderDirectLayerRequest(Graphics2D graphics, DirectLayer layer) {
            this.graphics = graphics;
            this.layer = layer;
        }

        @Override
        void execute() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering DirectLayer: " + this.layer);
            }
            try {
                this.layer.draw(this.graphics, StreamingRenderer.this.mapContent, StreamingRenderer.this.mapContent.getViewport());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Layer rendered");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
        }
    }

    public class RenderRasterRequest
    extends RenderingRequest {
        private Graphics2D graphics;
        private boolean disposeCoverage;
        private GridCoverage2D coverage;
        private RasterSymbolizer symbolizer;
        private CoordinateReferenceSystem destinationCRS;
        private AffineTransform worldToScreen;

        public RenderRasterRequest(Graphics2D graphics, GridCoverage2D coverage, boolean disposeCoverage, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS, AffineTransform worldToScreen) {
            this.graphics = graphics;
            this.coverage = coverage;
            this.disposeCoverage = disposeCoverage;
            this.symbolizer = symbolizer;
            this.destinationCRS = destinationCRS;
            this.worldToScreen = worldToScreen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void execute() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering Raster " + this.coverage);
            }
            try {
                GridCoverageRenderer gcr = new GridCoverageRenderer(this.destinationCRS, StreamingRenderer.this.originalMapExtent, StreamingRenderer.this.screenSize, this.worldToScreen, StreamingRenderer.this.java2dHints);
                try {
                    gcr.paint(this.graphics, this.coverage, this.symbolizer);
                }
                finally {
                    if (this.coverage != null && this.disposeCoverage) {
                        this.coverage.dispose(true);
                        RenderedImage image = this.coverage.getRenderedImage();
                        if (image instanceof PlanarImage) {
                            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)image));
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Raster rendered");
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
            catch (TransformException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
            catch (NoninvertibleTransformException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
        }
    }

    class MergeLayersRequest
    extends RenderingRequest {
        Graphics2D graphics;
        LiteFeatureTypeStyle[] fts_array;

        public MergeLayersRequest(Graphics2D graphics, LiteFeatureTypeStyle[] ftsArray) {
            this.graphics = graphics;
            this.fts_array = ftsArray;
        }

        @Override
        void execute() {
            this.graphics.setComposite(AlphaComposite.getInstance(3));
            for (int t = 0; t < this.fts_array.length; ++t) {
                BufferedImage image;
                Graphics2D ftsGraphics = this.fts_array[t].graphics;
                if (!(ftsGraphics instanceof DelayedBackbufferGraphic) || (image = ((DelayedBackbufferGraphic)ftsGraphics).image) == null) continue;
                this.graphics.drawImage((Image)image, 0, 0, null);
                ftsGraphics.dispose();
            }
        }
    }

    class FeatureRenderedRequest
    extends RenderingRequest {
        Object content;

        public FeatureRenderedRequest(Object content) {
            this.content = content;
        }

        @Override
        void execute() {
            StreamingRenderer.this.fireFeatureRenderedEvent(this.content);
        }
    }

    class PaintShapeRequest
    extends RenderingRequest {
        Graphics2D graphic;
        LiteShape2 shape;
        Style2D style;
        double scale;
        boolean labelObstacle;

        public PaintShapeRequest(Graphics2D graphic, LiteShape2 shape, Style2D style, double scale) {
            this.labelObstacle = false;
            this.graphic = graphic;
            this.shape = shape;
            this.style = style;
            this.scale = scale;
        }

        public void setLabelObstacle(boolean labelObstacle) {
            this.labelObstacle = labelObstacle;
        }

        @Override
        void execute() {
            if (this.graphic instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphic).init();
            }
            try {
                StreamingRenderer.this.painter.paint(this.graphic, this.shape, this.style, this.scale, this.labelObstacle);
            }
            catch (Throwable t) {
                StreamingRenderer.this.fireErrorEvent(t);
            }
        }
    }

    abstract class RenderingRequest {
        RenderingRequest() {
        }

        abstract void execute();
    }

    private class RenderableFeature {
        Object content;
        private MapLayer layer;
        private IdentityHashMap symbolizerAssociationHT = new IdentityHashMap();
        private List geometries = new ArrayList();
        private List shapes = new ArrayList();
        private boolean clone;
        private IdentityHashMap decimators = new IdentityHashMap();
        private ScreenMap screenMap;

        public RenderableFeature(MapLayer layer, boolean clone) {
            this.layer = layer;
            this.clone = clone;
        }

        public void setScreenMap(ScreenMap screenMap) {
            this.screenMap = screenMap;
        }

        public void setFeature(Object feature) {
            this.content = feature;
            this.geometries.clear();
            this.shapes.clear();
        }

        public LiteShape2 getShape(Symbolizer symbolizer, AffineTransform at) throws FactoryException {
            Geometry g = StreamingRenderer.this.findGeometry(this.content, symbolizer);
            if (g == null) {
                return null;
            }
            try {
                Envelope env;
                if (this.screenMap != null && !(symbolizer instanceof PointSymbolizer) && !(g instanceof Point) && this.getGeometryIndex(g) == -1 && this.screenMap.canSimplify(env = g.getEnvelopeInternal())) {
                    if (this.screenMap.checkAndSet(env)) {
                        return null;
                    }
                    g = this.screenMap.getSimplifiedShape(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), g.getFactory(), g.getClass());
                }
                SymbolizerAssociation sa = (SymbolizerAssociation)this.symbolizerAssociationHT.get(symbolizer);
                MathTransform crsTransform = null;
                MathTransform2D atTransform = null;
                MathTransform fullTransform = null;
                if (sa == null) {
                    sa = new SymbolizerAssociation();
                    sa.crs = StreamingRenderer.this.findGeometryCS(this.layer, this.content, symbolizer);
                    try {
                        crsTransform = StreamingRenderer.this.buildTransform(sa.crs, StreamingRenderer.this.destinationCrs);
                        atTransform = (MathTransform2D)ProjectiveTransform.create((AffineTransform)StreamingRenderer.this.worldToScreenTransform);
                        fullTransform = StreamingRenderer.this.buildFullTransform(sa.crs, StreamingRenderer.this.destinationCrs, at);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                    sa.xform = fullTransform;
                    sa.crsxform = crsTransform;
                    sa.axform = atTransform;
                    sa.rxform = StreamingRenderer.this.projectionHandler != null ? StreamingRenderer.this.projectionHandler.getRenderingTransform(sa.crsxform) : sa.crsxform;
                    this.symbolizerAssociationHT.put(symbolizer, sa);
                }
                if (symbolizer instanceof PointSymbolizer) {
                    if (!this.clone && g.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory) {
                        LiteShape2 first = this.getTransformedShape(g, sa);
                        if (first != null) {
                            if (StreamingRenderer.this.projectionHandler != null) {
                                Geometry tx = JTS.transform(first.getGeometry(), sa.xform.inverse());
                                return this.getTransformedShape(RendererUtilities.getCentroid(tx), sa);
                            }
                            return this.getTransformedShape(RendererUtilities.getCentroid(g), null);
                        }
                        return null;
                    }
                    return this.getTransformedShape(RendererUtilities.getCentroid(g), sa);
                }
                return this.getTransformedShape(g, sa);
            }
            catch (TransformException te) {
                LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                StreamingRenderer.this.fireErrorEvent(te);
                return null;
            }
            catch (AssertionError ae) {
                LOGGER.log(Level.FINE, ((Throwable)((Object)ae)).getLocalizedMessage(), (Throwable)((Object)ae));
                StreamingRenderer.this.fireErrorEvent((Throwable)((Object)ae));
                return null;
            }
        }

        private int getGeometryIndex(Geometry g) {
            for (int i = 0; i < this.geometries.size(); ++i) {
                if (this.geometries.get(i) != g) continue;
                return i;
            }
            return -1;
        }

        private LiteShape2 getTransformedShape(Geometry originalGeom, SymbolizerAssociation sa) throws TransformException, FactoryException {
            LiteShape2 shape;
            int idx = this.getGeometryIndex(originalGeom);
            if (idx != -1) {
                return (LiteShape2)this.shapes.get(idx);
            }
            Geometry geom = originalGeom;
            if (this.clone || !(geom.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory)) {
                int dim = sa.crs != null ? sa.crs.getCoordinateSystem().getDimension() : 2;
                geom = LiteCoordinateSequence.cloneGeometry(geom, dim);
            }
            if (StreamingRenderer.this.projectionHandler != null && sa != null) {
                geom = StreamingRenderer.this.projectionHandler.preProcess(geom);
                if (geom == null) {
                    shape = null;
                } else {
                    Decimator d = this.getDecimator(sa.xform);
                    d.decimateTransformGeneralize(geom, sa.rxform);
                    geom.geometryChanged();
                    MathTransform reverse = null;
                    if (sa.crsxform != null) {
                        if (sa.crsxform instanceof ConcatenatedTransform && ((ConcatenatedTransform)sa.crsxform).transform1.getTargetDimensions() >= 3 && ((ConcatenatedTransform)sa.crsxform).transform2.getTargetDimensions() == 2) {
                            reverse = null;
                        } else {
                            try {
                                reverse = sa.crsxform.inverse();
                            }
                            catch (Exception cannotReverse) {
                                reverse = null;
                            }
                        }
                    }
                    if ((geom = StreamingRenderer.this.projectionHandler.postProcess(reverse, geom)) == null) {
                        shape = null;
                    } else {
                        d = new Decimator(-1.0, -1.0);
                        d.decimateTransformGeneralize(geom, sa.axform);
                        geom.geometryChanged();
                        shape = new LiteShape2(geom, null, null, false, false);
                    }
                }
            } else {
                MathTransform xform = null;
                if (sa != null) {
                    xform = sa.xform;
                }
                shape = new LiteShape2(geom, xform, this.getDecimator(xform), false, false);
            }
            this.geometries.add(originalGeom);
            this.shapes.add(shape);
            return shape;
        }

        private Decimator getDecimator(MathTransform mathTransform) {
            if (StreamingRenderer.this.generalizationDistance == 0.0 || !StreamingRenderer.this.inMemoryGeneralization) {
                return NULL_DECIMATOR;
            }
            Decimator decimator = (Decimator)this.decimators.get(mathTransform);
            if (decimator == null) {
                try {
                    decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator(mathTransform.inverse(), StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance) : new Decimator(null, StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance);
                }
                catch (org.opengis.referencing.operation.NoninvertibleTransformException e) {
                    decimator = new Decimator(null, StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance);
                }
                this.decimators.put(mathTransform, decimator);
            }
            return decimator;
        }
    }
}

