/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.index.SolrIndexDAO;
import au.org.ala.biocache.index.SolrIndexDAO$;
import au.org.ala.biocache.tool.IndexLocalRecords$;
import au.org.ala.biocache.util.ZookeeperUtil$;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0011<Q!\u0001\u0002\t\u00025\t\u0011#\u00138eKbdunY1m%\u0016\u001cwN\u001d3t\u0015\t\u0019A!\u0001\u0003u_>d'BA\u0003\u0007\u0003!\u0011\u0017n\\2bG\",'BA\u0004\t\u0003\r\tG.\u0019\u0006\u0003\u0013)\t1a\u001c:h\u0015\u0005Y\u0011AA1v\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011\u0011#\u00138eKbdunY1m%\u0016\u001cwN\u001d3t'\ry!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m!\u0011aA2nI&\u0011QD\u0007\u0002\u0005)>|G\u000eC\u0003 \u001f\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!)1d\u0004C\u0001EU\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\rM#(/\u001b8h\u0011\u0015as\u0002\"\u0001#\u0003\u0011!Wm]2\t\u000b9zA\u0011A\u0018\u0002\t5\f\u0017N\u001c\u000b\u0003aM\u0002\"aE\u0019\n\u0005I\"\"\u0001B+oSRDQ\u0001N\u0017A\u0002U\nA!\u0019:hgB\u00191C\u000e\u001d\n\u0005]\"\"!B!se\u0006L\bCA\u001d=\u001d\t\u0019\"(\u0003\u0002<)\u00051\u0001K]3eK\u001aL!AK\u001f\u000b\u0005m\"b\u0001\u0002\t\u0003\u0001}\u001a\"A\u0010\n\t\u000b}qD\u0011A!\u0015\u0003\t\u0003\"A\u0004 \t\u000f\u0011s$\u0019!C\u0001\u000b\u00061An\\4hKJ,\u0012A\u0012\t\u0003\u000f.k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bQa\u001d7gi)T\u0011!C\u0005\u0003\u0019\"\u0013a\u0001T8hO\u0016\u0014\bB\u0002(?A\u0003%a)A\u0004m_\u001e<WM\u001d\u0011\t\u000bAsD\u0011A)\u0002\u0019%tG-\u001a=SK\u000e|'\u000fZ:\u0015\u000fA\u0012v+W.aE\")1k\u0014a\u0001)\u00069A\u000f\u001b:fC\u0012\u001c\bCA\nV\u0013\t1FCA\u0002J]RDQ\u0001W(A\u0002a\n\u0001b]8me\"{W.\u001a\u0005\u00065>\u0003\r\u0001O\u0001\u0012g>d'oQ8oM&<\u0007,\u001c7QCRD\u0007\"\u0002/P\u0001\u0004i\u0016\u0001C8qi&l\u0017n]3\u0011\u0005Mq\u0016BA0\u0015\u0005\u001d\u0011un\u001c7fC:DQ!Y(A\u0002u\u000bAb\u001c9uS6L7/Z(oYfDQaY(A\u0002a\nab\u00195fG.\u0004x.\u001b8u\r&dW\r")
public class IndexLocalRecords {
    private final Logger logger = LoggerFactory.getLogger((String)"IndexLocalRecords");

    public static String help() {
        return IndexLocalRecords$.MODULE$.help();
    }

    public static void main(String[] stringArray) {
        IndexLocalRecords$.MODULE$.main(stringArray);
    }

    public static String desc() {
        return IndexLocalRecords$.MODULE$.desc();
    }

    public static String cmd() {
        return IndexLocalRecords$.MODULE$.cmd();
    }

    public Logger logger() {
        return this.logger;
    }

    public void indexRecords(int threads, String solrHome, String solrConfigXmlPath, boolean optimise, boolean optimiseOnly, String checkpointFile) {
        ZookeeperUtil$.MODULE$.setStatus("INDEXING", "STARTING", 0);
        long start = System.currentTimeMillis();
        SolrIndexDAO indexer = new SolrIndexDAO(solrHome, Config$.MODULE$.excludeSensitiveValuesFor(), Config$.MODULE$.extraMiscFields(), SolrIndexDAO$.MODULE$.$lessinit$greater$default$4());
        indexer.solrConfigPath_$eq(solrConfigXmlPath);
        System.setProperty("tokenRangeCheckPointFile", checkpointFile);
        if (new File(checkpointFile).exists()) {
            Object object;
            this.logger().info("Checkpoint file detected. Will attempt to restart indexing process.....");
            File solrWriteLockFile = new File(new StringBuilder().append((Object)solrHome).append((Object)"/biocache/data/index/write.lock").toString());
            if (solrWriteLockFile.exists()) {
                this.logger().info("Removing SOLR lock file....");
                object = BoxesRunTime.boxToBoolean((boolean)solrWriteLockFile.delete());
            } else {
                object = BoxedUnit.UNIT;
            }
            ObjectRef indexedTokenRanges = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            indexer.pageOverFacet((Function2<String, Object, Object>)new Serializable(this, indexedTokenRanges){
                public static final long serialVersionUID = 0L;
                private final ObjectRef indexedTokenRanges$1;

                public final boolean apply(String tokenRangeIdx, int count) {
                    ((ListBuffer)this.indexedTokenRanges$1.elem).$plus$eq((Object)tokenRangeIdx);
                    return true;
                }
                {
                    this.indexedTokenRanges$1 = indexedTokenRanges$1;
                }
            }, "batch_id_s", "*:*", (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            ObjectRef completedTokenRanges = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            Source$.MODULE$.fromFile(checkpointFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this, completedTokenRanges){
                public static final long serialVersionUID = 0L;
                private final ObjectRef completedTokenRanges$1;

                public final Object apply(String line) {
                    String[] parts = line.split(",");
                    return parts.length == 2 ? ((ListBuffer)this.completedTokenRanges$1.elem).$plus$eq((Object)parts[0]) : BoxedUnit.UNIT;
                }
                {
                    this.completedTokenRanges$1 = completedTokenRanges$1;
                }
            });
            System.setProperty("completedTokenRanges", ((ListBuffer)completedTokenRanges.elem).mkString(","));
            ((ListBuffer)indexedTokenRanges.elem).foreach((Function1)new Serializable(this, indexer, completedTokenRanges){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IndexLocalRecords $outer;
                private final SolrIndexDAO indexer$1;
                private final ObjectRef completedTokenRanges$1;

                public final void apply(String indexedTokenRange) {
                    if (!((ListBuffer)this.completedTokenRanges$1.elem).contains((Object)indexedTokenRange)) {
                        this.$outer.logger().info(new StringBuilder().append((Object)"Removing records in token range: ").append((Object)indexedTokenRange).toString());
                        this.indexer$1.removeByQuery(new StringBuilder().append((Object)"batch_id_s:").append((Object)indexedTokenRange).toString(), this.indexer$1.removeByQuery$default$2());
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.indexer$1 = indexer$1;
                    this.completedTokenRanges$1 = completedTokenRanges$1;
                }
            });
        }
        IntRef count = new IntRef(0);
        if (!optimiseOnly) {
            int total = Config$.MODULE$.persistenceManager().pageOverLocal("occ", (Function3<String, scala.collection.immutable.Map<String, String>, String, Object>)new Serializable(this, indexer, count){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IndexLocalRecords $outer;
                private final SolrIndexDAO indexer$1;
                private final IntRef count$1;

                public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map, String tokenRangeIdx) {
                    try {
                        String x$1 = guid;
                        scala.collection.immutable.Map<String, String> x$2 = map;
                        String x$3 = tokenRangeIdx;
                        boolean x$4 = this.indexer$1.indexFromMap$default$3();
                        Option<Date> x$5 = this.indexer$1.indexFromMap$default$4();
                        boolean x$6 = this.indexer$1.indexFromMap$default$5();
                        Seq<String> x$7 = this.indexer$1.indexFromMap$default$6();
                        Seq<String> x$8 = this.indexer$1.indexFromMap$default$7();
                        boolean x$9 = this.indexer$1.indexFromMap$default$8();
                        FileWriter x$10 = this.indexer$1.indexFromMap$default$10();
                        FileWriter x$11 = this.indexer$1.indexFromMap$default$11();
                        this.indexer$1.indexFromMap(x$1, (Map<String, String>)x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$3, x$10, x$11);
                        ++this.count$1.elem;
                        if (this.count$1.elem % 100000 == 0) {
                            ZookeeperUtil$.MODULE$.setStatus("INDEXING", "INDEXING", this.count$1.elem);
                        }
                    }
                    catch (Exception exception) {
                        this.$outer.logger().error(new StringBuilder().append((Object)"Problem indexing record: ").append((Object)guid).append((Object)" - ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                    }
                    return true;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.indexer$1 = indexer$1;
                    this.count$1 = count$1;
                }
            }, threads, (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            indexer.finaliseIndex(false, false);
            long end = System.currentTimeMillis();
            this.logger().info(new StringBuilder().append((Object)"Indexing completed. Total indexed : ").append((Object)BoxesRunTime.boxToInteger((int)total)).append((Object)" in ").append((Object)BoxesRunTime.boxToFloat((float)((float)(end - start) / 1000.0f / 60.0f))).append((Object)" minutes").toString());
            indexer.commit();
        }
        new File(checkpointFile).renameTo(new File(new StringBuilder().append((Object)checkpointFile).append((Object)".complete").toString()));
        if (optimise) {
            ZookeeperUtil$.MODULE$.setStatus("INDEXING", "OPTIMISING", count.elem);
            this.logger().info("Optimising index....");
            indexer.optimise();
            this.logger().info("Optimising complete.");
        } else {
            this.logger().info("Optimisation skipped....");
        }
        ZookeeperUtil$.MODULE$.setStatus("INDEXING", "COMPLETE", count.elem);
        indexer.shutdown();
        Config$.MODULE$.persistenceManager().shutdown();
    }
}

