/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.concurrency;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.scale7.concurrency.IResetEvent;

public class AutoResetEvent
implements IResetEvent {
    private final Semaphore event;
    private final Integer mutex;

    public AutoResetEvent(boolean signalled) {
        this.event = new Semaphore(signalled ? 1 : 0);
        this.mutex = new Integer(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set() {
        Integer n = this.mutex;
        synchronized (n) {
            if (this.event.availablePermits() == 0) {
                this.event.release();
            }
        }
    }

    @Override
    public void reset() {
        this.event.drainPermits();
    }

    @Override
    public void waitOne() throws InterruptedException {
        this.event.acquire();
    }

    @Override
    public boolean waitOne(int timeout, TimeUnit unit) throws InterruptedException {
        return this.event.tryAcquire(timeout, unit);
    }

    @Override
    public boolean isSignalled() {
        return this.event.availablePermits() > 0;
    }
}

