/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.tool.SampleLocalRecords;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class SampleLocalRecords$
implements Tool {
    public static final SampleLocalRecords$ MODULE$;
    private final Logger logger;

    static {
        new SampleLocalRecords$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "sample-local-node";
    }

    @Override
    public String desc() {
        return "Sample coordinates against geospatial layers for this node";
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public void main(String[] args) {
        BooleanRef allNodes;
        ObjectRef taxaFile;
        IntRef startTokenRangeIdx;
        BooleanRef useFullScan;
        ObjectRef skipDrs;
        ObjectRef drs;
        ObjectRef layers;
        IntRef numThreads;
        IntRef batchSize;
        ObjectRef locFilePath = new ObjectRef((Object)"");
        BooleanRef keepFiles = new BooleanRef(false);
        BooleanRef loadOccOnly = new BooleanRef(false);
        BooleanRef sampleOnly = new BooleanRef(false);
        ObjectRef workingDir = new ObjectRef((Object)Config$.MODULE$.tmpWorkDir());
        OptionParser parser = new OptionParser(locFilePath, keepFiles, loadOccOnly, sampleOnly, workingDir, batchSize = new IntRef(100000), numThreads = new IntRef(1), layers = new ObjectRef((Object)Nil$.MODULE$), drs = new ObjectRef((Object)Nil$.MODULE$), skipDrs = new ObjectRef((Object)Nil$.MODULE$), useFullScan = new BooleanRef(false), startTokenRangeIdx = new IntRef(0), taxaFile = new ObjectRef((Object)""), allNodes = new BooleanRef(false)){
            {
                this.opt("cf", "coordinates-file", "the file containing coordinates", (Function1<String, BoxedUnit>)new Serializable(this, locFilePath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef locFilePath$1;

                    public final void apply(String v) {
                        this.locFilePath$1.elem = v;
                    }
                    {
                        this.locFilePath$1 = locFilePath$1;
                    }
                });
                this.opt("keep", "Keep the files produced from the sampling", (Function0<BoxedUnit>)new Serializable(this, keepFiles$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef keepFiles$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.keepFiles$1.elem = true;
                    }
                    {
                        this.keepFiles$1 = keepFiles$1;
                    }
                });
                this.opt("wd", "working-dir", new StringBuilder().append((Object)"the directory to write temporary files too. Defaults to ").append((Object)Config$.MODULE$.tmpWorkDir()).toString(), (Function1<String, BoxedUnit>)new Serializable(this, workingDir$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef workingDir$1;

                    public final void apply(String v) {
                        this.workingDir$1.elem = v;
                    }
                    {
                        this.workingDir$1 = workingDir$1;
                    }
                });
                this.intOpt("bs", "batch-size", new StringBuilder().append((Object)"Batch size when processing points. Defaults to ").append((Object)BoxesRunTime.boxToInteger((int)batchSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, batchSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef batchSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.batchSize$1.elem = v;
                    }
                    {
                        this.batchSize$1 = batchSize$1;
                    }
                });
                this.intOpt("t", "threads", new StringBuilder().append((Object)"The number of threads for the unique coordinate extract. The default is ").append((Object)BoxesRunTime.boxToInteger((int)numThreads$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, numThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.numThreads$1.elem = v;
                    }
                    {
                        this.numThreads$1 = numThreads$1;
                    }
                });
                this.opt("load-occ-only", "Just run the step that loads occ with values from loc", (Function0<BoxedUnit>)new Serializable(this, loadOccOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef loadOccOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.loadOccOnly$1.elem = true;
                    }
                    {
                        this.loadOccOnly$1 = loadOccOnly$1;
                    }
                });
                this.opt("sample-only", "Just run the step that samples and loads loc table", (Function0<BoxedUnit>)new Serializable(this, sampleOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef sampleOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.sampleOnly$1.elem = true;
                    }
                    {
                        this.sampleOnly$1 = sampleOnly$1;
                    }
                });
                this.opt("l", "layers", "Comma separated list of el and cl layer names to sample", (Function1<String, BoxedUnit>)new Serializable(this, layers$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef layers$1;

                    public final void apply(String v) {
                        this.layers$1.elem = (Seq)Predef$.MODULE$.refArrayOps((Object[])v.trim().split(",")).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$1) {
                                return x$1.trim();
                            }
                        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                    }
                    {
                        this.layers$1 = layers$1;
                    }
                });
                this.opt("dr", "data-resource-list", "comma separated list of drs to process", (Function1<String, BoxedUnit>)new Serializable(this, drs$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef drs$1;

                    public final void apply(String v) {
                        this.drs$1.elem = (Seq)Predef$.MODULE$.refArrayOps((Object[])v.trim().split(",")).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$2) {
                                return x$2.trim();
                            }
                        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                    }
                    {
                        this.drs$1 = drs$1;
                    }
                });
                this.opt("edr", "skip-data-resource-list", "comma separated list of drs to NOT process", (Function1<String, BoxedUnit>)new Serializable(this, skipDrs$1, useFullScan$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef skipDrs$1;
                    private final BooleanRef useFullScan$1;

                    public final void apply(String v) {
                        this.skipDrs$1.elem = (Seq)Predef$.MODULE$.refArrayOps((Object[])v.trim().split(",")).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$3) {
                                return x$3.trim();
                            }
                        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                        this.useFullScan$1.elem = true;
                    }
                    {
                        this.skipDrs$1 = skipDrs$1;
                        this.useFullScan$1 = useFullScan$1;
                    }
                });
                this.opt("tl", "taxa-list", "file containing a list of taxa to reprocess", (Function1<String, BoxedUnit>)new Serializable(this, taxaFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef taxaFile$1;

                    public final void apply(String v) {
                        this.taxaFile$1.elem = v;
                    }
                    {
                        this.taxaFile$1 = taxaFile$1;
                    }
                });
                this.opt("use-full-scan", "Use a full table scan. This is faster if most of the data needs to be processed. When not used the default is to scan by data resource which is faster for smaller datasets (< 5 million records). ", (Function0<BoxedUnit>)new Serializable(this, useFullScan$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef useFullScan$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.useFullScan$1.elem = true;
                    }
                    {
                        this.useFullScan$1 = useFullScan$1;
                    }
                });
                this.intOpt("stk", "start-token-range-idx", "the idx of the token range to start at. Typically a value between 0 and 1024.This is useful when a long running process fails for some reason.", (Function1<Object, BoxedUnit>)new Serializable(this, startTokenRangeIdx$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef startTokenRangeIdx$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.startTokenRangeIdx$1.elem = v;
                    }
                    {
                        this.startTokenRangeIdx$1 = startTokenRangeIdx$1;
                    }
                });
                this.opt("all-nodes", "Run on all nodes, not just the local node. For use with --sampling-only to reduce load on the sampling service when many records (> 5 million records).", (Function0<BoxedUnit>)new Serializable(this, allNodes$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef allNodes$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.allNodes$1.elem = true;
                    }
                    {
                        this.allNodes$1 = allNodes$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            new SampleLocalRecords().sampleRecords((String)workingDir.elem, numThreads.elem, keepFiles.elem, loadOccOnly.elem, sampleOnly.elem, (Seq<String>)((Seq)drs.elem), (Seq<String>)((Seq)skipDrs.elem), useFullScan.elem, startTokenRangeIdx.elem, (Seq<String>)((Seq)layers.elem), allNodes.elem);
        }
    }

    private SampleLocalRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"SampleLocalRecords");
    }
}

