/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.AttributionDAO$;
import au.org.ala.biocache.caches.ClassificationDAO$;
import au.org.ala.biocache.caches.CommonNameDAO$;
import au.org.ala.biocache.caches.TaxonProfileDAO$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Attribution;
import au.org.ala.biocache.model.Classification;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.TaxonProfile;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.BiocacheConversions$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.DwC$;
import au.org.ala.biocache.vocab.Kingdoms$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.names.model.ErrorType;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.MetricsResultDTO;
import au.org.ala.names.model.NameSearchResult;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Null$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u00015\u0011qc\u00117bgNLg-[2bi&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\r!\u0011!\u00039s_\u000e,7o]8s\u0015\t)a!\u0001\u0005cS>\u001c\u0017m\u00195f\u0015\t9\u0001\"A\u0002bY\u0006T!!\u0003\u0006\u0002\u0007=\u0014xMC\u0001\f\u0003\t\tWo\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u001di\u0002A1A\u0005\u0002y\ta\u0001\\8hO\u0016\u0014X#A\u0010\u0011\u0005\u0001\"S\"A\u0011\u000b\u0005\t\u001a\u0013!B:mMRR'\"A\u0005\n\u0005\u0015\n#A\u0002'pO\u001e,'\u000f\u0003\u0004(\u0001\u0001\u0006IaH\u0001\bY><w-\u001a:!\u0011\u001dI\u0003A1A\u0005\u0002)\n!E\\1uS>t\u0017\r\\\"iK\u000e\\G.[:u\u0013\u0012,g\u000e^5gS\u0016\u0014\b+\u0019;uKJtW#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001C7bi\u000eD\u0017N\\4\u000b\u0005A\u0002\u0012\u0001B;uS2L!AM\u0017\u0003\u000bI+w-\u001a=\t\rQ\u0002\u0001\u0015!\u0003,\u0003\rr\u0017\r^5p]\u0006d7\t[3dW2L7\u000f^%eK:$\u0018NZ5feB\u000bG\u000f^3s]\u0002BqA\u000e\u0001C\u0002\u0013\u0005!&A\brk\u0016\u001cH/[8o!\u0006$H/\u001a:o\u0011\u0019A\u0004\u0001)A\u0005W\u0005\u0001\u0012/^3ti&|g\u000eU1ui\u0016\u0014h\u000e\t\u0005\bu\u0001\u0011\r\u0011\"\u0001+\u0003)\tgM\u001a)biR,'O\u001c\u0005\u0007y\u0001\u0001\u000b\u0011B\u0016\u0002\u0017\u00054g\rU1ui\u0016\u0014h\u000e\t\u0005\b}\u0001\u0011\r\u0011\"\u0001+\u0003%\u0019g\rU1ui\u0016\u0014h\u000e\u0003\u0004A\u0001\u0001\u0006IaK\u0001\u000bG\u001a\u0004\u0016\r\u001e;fe:\u0004\u0003\"\u0002\"\u0001\t\u0003\u0019\u0015A\u00039beN,\u0007*\u001b8ugR\u0011A)\u0015\t\u0005\u000b\"[eJ\u0004\u0002\u0010\r&\u0011q\tE\u0001\u0007!J,G-\u001a4\n\u0005%S%aA'ba*\u0011q\t\u0005\t\u0003\u000b2K!!\u0014&\u0003\rM#(/\u001b8h!\r)ujS\u0005\u0003!*\u00131aU3u\u0011\u0015\u0011\u0016\t1\u0001T\u0003)!\u0018\r_8o\u0011&tGo\u001d\t\u0004)r[eBA+[\u001d\t1\u0016,D\u0001X\u0015\tAF\"\u0001\u0004=e>|GOP\u0005\u0002#%\u00111\fE\u0001\ba\u0006\u001c7.Y4f\u0013\tifL\u0001\u0003MSN$(BA.\u0011\u0011\u0015\u0001\u0007\u0001\"\u0001b\u00031I7/T1uG\"4\u0016\r\\5e)\r\u0011\u0007N\u001d\t\u0005\u001f\r,7*\u0003\u0002e!\t1A+\u001e9mKJ\u0002\"a\u00044\n\u0005\u001d\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006S~\u0003\rA[\u0001\u0003G2\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\u000b5|G-\u001a7\u000b\u0005=4\u0011!\u00028b[\u0016\u001c\u0018BA9m\u0005ia\u0015N\u001c8bK\u0006t'+\u00198l\u00072\f7o]5gS\u000e\fG/[8o\u0011\u0015\u0019x\f1\u0001E\u0003\u001dA\u0017N\u001c;NCBDQ!\u001e\u0001\u0005\nY\f1\u0002[1t\u0007>tg\r\\5diR!Qm^=|\u0011\u0015AH\u000f1\u0001L\u0003\u0011\u0011\u0018M\\6\t\u000bi$\b\u0019A&\u0002\u000bQ\f\u0007p\u001c8\t\u000bM$\b\u0019\u0001#\t\u000bu\u0004A\u0011\u0002@\u0002#!\f7/T1uG\"$v\u000eR3gCVdG\u000f\u0006\u0004f\u007f\u0006\u0005\u00111\u0001\u0005\u0006qr\u0004\ra\u0013\u0005\u0006ur\u0004\ra\u0013\u0005\b\u0003\u000ba\b\u0019AA\u0004\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:\u0004B!!\u0003\u0002\u000e5\u0011\u00111\u0002\u0006\u0003[\u0012IA!a\u0004\u0002\f\tq1\t\\1tg&4\u0017nY1uS>t\u0007bBA\n\u0001\u0011%\u0011QC\u0001\u000eg\u0016$X*\u0019;dQN#\u0018\r^:\u0015\u0011\u0005]\u0011QDA\u0014\u0003c\u00012aDA\r\u0013\r\tY\u0002\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002 \u0005E\u0001\u0019AA\u0011\u0003-q\u0017-\\3NKR\u0014\u0018nY:\u0011\u0007-\f\u0019#C\u0002\u0002&1\u0014\u0001#T3ue&\u001c7OU3tk2$H\tV(\t\u0011\u0005%\u0012\u0011\u0003a\u0001\u0003W\t\u0011\u0002\u001d:pG\u0016\u001c8/\u001a3\u0011\t\u0005%\u0011QF\u0005\u0005\u0003_\tYA\u0001\u0006Gk2d'+Z2pe\u0012D\u0001\"a\r\u0002\u0012\u0001\u0007\u0011QG\u0001\u000bCN\u001cXM\u001d;j_:\u001c\bCBA\u001c\u0003\u0003\n)%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u001diW\u000f^1cY\u0016T1!a\u0010\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0007\nIDA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0003BA\u0005\u0003\u000fJA!!\u0013\u0002\f\t\u0001\u0012+^1mSRL\u0018i]:feRLwN\u001c\u0005\b\u0003\u001b\u0002A\u0011BA(\u00039!w.U;bY&$\u0018\u0010V3tiN$\u0002\"a\u0006\u0002R\u0005U\u0013q\u000b\u0005\t\u0003'\nY\u00051\u0001\u0002,\u0005\u0019!/Y<\t\u0011\u0005%\u00121\na\u0001\u0003WA\u0001\"a\r\u0002L\u0001\u0007\u0011Q\u0007\u0005\b\u00037\u0002A\u0011AA/\u0003\u001d\u0001(o\\2fgN$\"\"a\u0018\u0002f\u0005%\u00141NA7!\u0015y\u0011\u0011MA#\u0013\r\t\u0019\u0007\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003O\nI\u00061\u0001L\u0003\u00119W/\u001b3\t\u0011\u0005M\u0013\u0011\fa\u0001\u0003WA\u0001\"!\u000b\u0002Z\u0001\u0007\u00111\u0006\u0005\u000b\u0003_\nI\u0006%AA\u0002\u0005E\u0014!\u00047bgR\u0004&o\\2fgN,G\rE\u0003\u0010\u0003g\nY#C\u0002\u0002vA\u0011aa\u00149uS>t\u0007bBA=\u0001\u0011\u0005\u00111P\u0001\u0005g.L\u0007\u000f\u0006\u0006\u0002`\u0005u\u0014qPAA\u0003\u0007Cq!a\u001a\u0002x\u0001\u00071\n\u0003\u0005\u0002T\u0005]\u0004\u0019AA\u0016\u0011!\tI#a\u001eA\u0002\u0005-\u0002BCA8\u0003o\u0002\n\u00111\u0001\u0002r!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0015aB4fi:\u000bW.Z\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0003mC:<'BAAK\u0003\u0011Q\u0017M^1\n\u00075\u000by\tC\u0005\u0002\u001c\u0002\t\n\u0011\"\u0011\u0002\u001e\u0006\t\u0002O]8dKN\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005}%\u0006BA9\u0003C[#!a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[\u0003\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011WAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003k\u0003\u0011\u0013!C!\u0003;\u000bab]6ja\u0012\"WMZ1vYR$C\u0007")
public class ClassificationProcessor
implements Processor {
    private final Logger logger;
    private final Regex nationalChecklistIdentifierPattern;
    private final Regex questionPattern;
    private final Regex affPattern;
    private final Regex cfPattern;

    public Logger logger() {
        return this.logger;
    }

    public Regex nationalChecklistIdentifierPattern() {
        return this.nationalChecklistIdentifierPattern;
    }

    public Regex questionPattern() {
        return this.questionPattern;
    }

    public Regex affPattern() {
        return this.affPattern;
    }

    public Regex cfPattern() {
        return this.cfPattern;
    }

    public Map<String, Set<String>> parseHints(List<String> taxonHints) {
        HashMap rankSciNames = new HashMap();
        List pairs = (List)taxonHints.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x) {
                return x.split(":");
            }
        }, List$.MODULE$.canBuildFrom());
        pairs.foreach((Function1)new Serializable(this, rankSciNames){
            public static final long serialVersionUID = 0L;
            private final HashMap rankSciNames$1;

            public final Option<Set<String>> apply(String[] pair) {
                Set values = (Set)this.rankSciNames$1.getOrElse((Object)pair[0], (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<String> apply() {
                        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                    }
                });
                return this.rankSciNames$1.put((Object)pair[0], (Object)values.$plus((Object)pair[1].trim().toLowerCase()));
            }
            {
                this.rankSciNames$1 = rankSciNames$1;
            }
        });
        return rankSciNames.toMap(Predef$.MODULE$.conforms());
    }

    public Tuple2<Object, String> isMatchValid(LinnaeanRankClassification cl, Map<String, Set<String>> hintMap) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Tuple2 tuple2;
            Object object = new Object();
            try {
                hintMap.keys().foreach((Function1)new Serializable(this, cl, hintMap, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ClassificationProcessor $outer;
                    private final LinnaeanRankClassification cl$1;
                    private final Map hintMap$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String rank) {
                        Tuple2 tuple2;
                        String string;
                        String string2 = string = rank;
                        if (!("kingdom" != null ? !"kingdom".equals(string2) : string2 != null)) {
                            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.au$org$ala$biocache$processor$ClassificationProcessor$$hasConflict(rank, this.cl$1.getKingdom(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Kingdom:").append((Object)this.cl$1.getKingdom()).toString());
                        } else {
                            String string3 = string;
                            if (!("phylum" != null ? !"phylum".equals(string3) : string3 != null)) {
                                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.au$org$ala$biocache$processor$ClassificationProcessor$$hasConflict(rank, this.cl$1.getPhylum(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Phylum:").append((Object)this.cl$1.getPhylum()).toString());
                            } else {
                                String string4 = string;
                                if (!("class" != null ? !"class".equals(string4) : string4 != null)) {
                                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.au$org$ala$biocache$processor$ClassificationProcessor$$hasConflict(rank, this.cl$1.getKlass(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Class:").append((Object)this.cl$1.getKlass()).toString());
                                } else {
                                    String string5 = string;
                                    if (!("order" != null ? !"order".equals(string5) : string5 != null)) {
                                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.au$org$ala$biocache$processor$ClassificationProcessor$$hasConflict(rank, this.cl$1.getOrder(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Order:").append((Object)this.cl$1.getOrder()).toString());
                                    } else {
                                        String string6 = string;
                                        tuple2 = !("family" != null ? !"family".equals(string6) : string6 != null) ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.au$org$ala$biocache$processor$ClassificationProcessor$$hasConflict(rank, this.cl$1.getFamily(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Family:").append((Object)this.cl$1.getFamily()).toString()) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"");
                                    }
                                }
                            }
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 != null) {
                            Tuple2 tuple23;
                            boolean conflict = tuple22._1$mcZ$sp();
                            String comment = (String)tuple22._2();
                            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)conflict), (Object)comment);
                            boolean conflict2 = tuple24._1$mcZ$sp();
                            String comment2 = (String)tuple24._2();
                            if (conflict2) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)comment2));
                            }
                            return;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cl$1 = cl$1;
                        this.hintMap$1 = hintMap$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                tuple2 = (Tuple2)nonLocalReturnControl2.value();
            }
            return tuple2;
        }
        throw nonLocalReturnControl2;
    }

    public boolean au$org$ala$biocache$processor$ClassificationProcessor$$hasConflict(String rank, String taxon, Map<String, Set<String>> hintMap) {
        return taxon != null && !((SetLike)hintMap.get((Object)rank).get()).contains((Object)taxon.toLowerCase());
    }

    private boolean hasMatchToDefault(String rank, String taxon, Classification classification) {
        return taxon != null && taxon.equalsIgnoreCase((String)classification.getProperty(this.field$1(rank)).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    private void setMatchStats(MetricsResultDTO nameMetrics, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        processed.classification().nameParseType_$eq(nameMetrics.getNameType() == null ? null : nameMetrics.getNameType().toString());
        processed.classification().taxonomicIssue_$eq(nameMetrics.getErrors() == null ? (String[])((Object[])new String[]{"noIssue"}) : (String[])((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(nameMetrics.getErrors()).toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ErrorType x$2) {
                return x$2.toString();
            }
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
        String string = processed.classification().nameParseType();
        String string2 = "blacklisted";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_SCIENTIFIC_NAME()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_SCIENTIFIC_NAME(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    private void doQualityTests(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = StringUtils.isBlank((String)raw.classification().taxonRank()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_TAXONRANK(), "Missing taxonRank")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_TAXONRANK(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = StringUtils.isBlank((String)raw.classification().scientificName()) && StringUtils.isBlank((String)raw.classification().vernacularName()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_SUPPLIED(), "No scientificName or vernacularName has been supplied. Name match will be based on a constructed name.")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()));
        if (StringUtils.isNotBlank((String)raw.classification().kingdom())) {
            Option<Term> matchedKingdom = Kingdoms$.MODULE$.matchTerm(raw.classification().kingdom());
            if (matchedKingdom.isDefined()) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_KINGDOM(), AssertionStatus$.MODULE$.PASSED()));
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_KINGDOM(), "The supplied kingdom is not recognised"));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        BoxedUnit boxedUnit;
        ArrayBuffer assertions = new ArrayBuffer();
        this.doQualityTests(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        try {
            MetricsResultDTO nameMetrics;
            if (processed.defaultValuesUsed()) {
                if (raw.classification().kingdom() == null && processed.classification().kingdom() != null) {
                    raw.classification().kingdom_$eq(processed.classification().kingdom());
                }
                if (raw.classification().phylum() == null && processed.classification().phylum() != null) {
                    raw.classification().phylum_$eq(processed.classification().phylum());
                }
                if (raw.classification().classs() == null && processed.classification().classs() != null) {
                    raw.classification().classs_$eq(processed.classification().classs());
                }
                if (raw.classification().order() == null && processed.classification().order() != null) {
                    raw.classification().order_$eq(processed.classification().order());
                }
                if (raw.classification().family() == null && processed.classification().family() != null) {
                    raw.classification().family_$eq(processed.classification().family());
                }
            }
            if ((nameMetrics = (MetricsResultDTO)ClassificationDAO$.MODULE$.get(raw.classification(), ClassificationDAO$.MODULE$.get$default$2()).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            })) == null) {
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] No match for record, classification for Kingdom: ").append((Object)raw.classification().kingdom()).append((Object)", Family:").append((Object)raw.classification().family()).append((Object)", Genus:").append((Object)raw.classification().genus()).append((Object)", Species: ").append((Object)raw.classification().species()).append((Object)", Epithet: ").append((Object)raw.classification().specificEpithet()).toString());
                }
                processed.classification().nameMatchMetric_$eq("noMatch");
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOTRECOGNISED(), "Name not recognised"));
                return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
            } else {
                NameSearchResult nsr = nameMetrics.getResult();
                if (nsr == null) {
                    if (nameMetrics.getErrors().contains(ErrorType.HOMONYM)) {
                        if (this.logger().isDebugEnabled()) {
                            this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] A homonym was detected (with  no higher level match), classification for Kingdom: ").append((Object)raw.classification().kingdom()).append((Object)", Family:").append((Object)raw.classification().family()).append((Object)", Genus:").append((Object)raw.classification().genus()).append((Object)", Species: ").append((Object)raw.classification().species()).append((Object)", Epithet: ").append((Object)raw.classification().specificEpithet()).toString());
                        }
                        processed.classification().nameMatchMetric_$eq("noMatch");
                        this.setMatchStats(nameMetrics, processed, (ArrayBuffer<QualityAssertion>)assertions);
                        boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.HOMONYM_ISSUE(), "A homonym was detected in supplied classification."));
                        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
                    } else {
                        if (this.logger().isDebugEnabled()) {
                            this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] No match for record, classification for Kingdom: ").append((Object)raw.classification().kingdom()).append((Object)", Family:").append((Object)raw.classification().family()).append((Object)", Genus:").append((Object)raw.classification().genus()).append((Object)", Species: ").append((Object)raw.classification().species()).append((Object)", Epithet: ").append((Object)raw.classification().specificEpithet()).toString());
                        }
                        processed.classification().nameMatchMetric_$eq("noMatch");
                        this.setMatchStats(nameMetrics, processed, (ArrayBuffer<QualityAssertion>)assertions);
                        boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOTRECOGNISED(), "Name not recognised"));
                    }
                    return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
                } else {
                    boolean hasDefaultMatch;
                    Object object;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOTRECOGNISED(), AssertionStatus$.MODULE$.PASSED()));
                    LinnaeanRankClassification classification = nsr.getRankClassification();
                    Option<Attribution> attribution = AttributionDAO$.MODULE$.getDataResourceByUid(raw.attribution().dataResourceUid());
                    if (attribution.isDefined() && ((Attribution)attribution.get()).hasMappedCollections()) {
                        attribution = AttributionDAO$.MODULE$.getByCodes(raw.occurrence().institutionCode(), raw.occurrence().collectionCode());
                    }
                    boolean hintsPassed = true;
                    if (attribution.isEmpty()) {
                        object = BoxedUnit.UNIT;
                    } else {
                        this.logger().debug("Checking taxonomic hints");
                        String[] taxonHints = ((Attribution)attribution.get()).taxonomicHints();
                        if (taxonHints != null && !Predef$.MODULE$.refArrayOps((Object[])taxonHints).isEmpty()) {
                            Tuple2 tuple2;
                            Tuple2<Object, String> tuple22 = this.isMatchValid(classification, ((Attribution)attribution.get()).retrieveParseHints());
                            if (tuple22 == null) throw new MatchError(tuple22);
                            boolean isValid = tuple22._1$mcZ$sp();
                            String comment = (String)tuple22._2();
                            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isValid), (Object)comment);
                            boolean isValid2 = tuple23._1$mcZ$sp();
                            String comment2 = (String)tuple23._2();
                            if (isValid2) {
                                object = ((Attribution)attribution.get()).retrieveParseHints().isEmpty() ? BoxedUnit.UNIT : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RESOURCE_TAXONOMIC_SCOPE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                            } else {
                                if (this.logger().isDebugEnabled()) {
                                    String taxonHintDebug = Predef$.MODULE$.refArrayOps((Object[])taxonHints).mkString(",");
                                    String dataResourceUid = raw.attribution().dataResourceUid();
                                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conflict in matched classification. [", "] GUID: ", ", Matched: ", ", Taxonomic hints in use: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataResourceUid, guid, comment2, taxonHintDebug})));
                                }
                                hintsPassed = false;
                                processed.classification().nameMatchMetric_$eq("matchFailedHint");
                                object = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RESOURCE_TAXONOMIC_SCOPE_MISMATCH(), comment2));
                            }
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                    boolean bl = hasDefaultMatch = processed.defaultValuesUsed() && nsr.getRank() != null && this.hasMatchToDefault(nsr.getRank().getRank(), nsr.getRankClassification().getScientificName(), processed.classification());
                    if (hintsPassed) {
                        processed.classification_$eq(BiocacheConversions$.MODULE$.asClassification(nsr));
                    }
                    if (hasDefaultMatch) {
                        processed.classification().nameMatchMetric_$eq("defaultHigherMatch");
                    }
                    processed.classification().vernacularName_$eq((String)CommonNameDAO$.MODULE$.getByGuid(nsr.getLsid()).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    Option<TaxonProfile> taxonProfile = TaxonProfileDAO$.MODULE$.getByGuid(nsr.getLsid());
                    if (!taxonProfile.isEmpty()) {
                        if (((TaxonProfile)taxonProfile.get()).habitats() != null) {
                            processed.classification().speciesHabitats_$eq(((TaxonProfile)taxonProfile.get()).habitats());
                        }
                        if (((TaxonProfile)taxonProfile.get()).commonName() != null && processed.classification().vernacularName() == null) {
                            processed.classification().vernacularName_$eq(((TaxonProfile)taxonProfile.get()).commonName());
                        }
                    }
                    String scientificName = raw.classification().scientificName() == null ? (raw.classification().species() == null ? (raw.classification().specificEpithet() == null || raw.classification().genus() == null ? null : new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).toString()) : raw.classification().species()) : raw.classification().scientificName();
                    this.setMatchStats(nameMetrics, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    String string = Config$.MODULE$.nationalChecklistIdentifierPattern();
                    String string2 = "";
                    boxedUnit = (string == null ? string2 != null : !string.equals(string2)) && this.nationalChecklistIdentifierPattern().findFirstMatchIn((CharSequence)nsr.getLsid()).isEmpty() ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_IN_NATIONAL_CHECKLISTS(), "Record not attached to concept in national species lists")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_IN_NATIONAL_CHECKLISTS(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
            return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Exception during classification match for record ").append((Object)guid).toString(), (Throwable)exception);
            boxedUnit = BoxedUnit.UNIT;
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    @Override
    public QualityAssertion[] skip(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions = new ArrayBuffer();
        if (lastProcessed.isDefined()) {
            assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])((FullRecord)lastProcessed.get()).findAssertions(new int[]{AssertionCodes$.MODULE$.HOMONYM_ISSUE().code(), AssertionCodes$.MODULE$.NAME_NOTRECOGNISED().code(), AssertionCodes$.MODULE$.NAME_NOT_IN_NATIONAL_CHECKLISTS().code(), AssertionCodes$.MODULE$.INVALID_SCIENTIFIC_NAME().code(), AssertionCodes$.MODULE$.MISSING_TAXONRANK().code(), AssertionCodes$.MODULE$.NAME_NOT_SUPPLIED().code(), AssertionCodes$.MODULE$.UNKNOWN_KINGDOM().code(), AssertionCodes$.MODULE$.RESOURCE_TAXONOMIC_SCOPE_MISMATCH().code()})));
            processed.classification_$eq(((FullRecord)lastProcessed.get()).classification());
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> skip$default$4() {
        return None$.MODULE$;
    }

    @Override
    public String getName() {
        return FullRecordMapper$.MODULE$.taxonomicalQa();
    }

    private final Option term$1(String rank$1) {
        return DwC$.MODULE$.matchTerm(rank$1);
    }

    private final String field$1(String rank$1) {
        return this.term$1(rank$1).isDefined() ? ((Term)this.term$1(rank$1).get()).canonical() : rank$1;
    }

    public ClassificationProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ClassificationProcessor");
        this.nationalChecklistIdentifierPattern = new StringOps(Predef$.MODULE$.augmentString(Config$.MODULE$.nationalChecklistIdentifierPattern())).r();
        this.questionPattern = new StringOps(Predef$.MODULE$.augmentString("([\\x00-\\x7F\\s]*)\\?([\\x00-\\x7F\\s]*)")).r();
        this.affPattern = new StringOps(Predef$.MODULE$.augmentString("([\\x00-\\x7F\\s]*) aff[#!?\\\\.]?([\\x00-\\x7F\\s]*)")).r();
        this.cfPattern = new StringOps(Predef$.MODULE$.augmentString("([\\x00-\\x7F\\s]*) cf[#!?\\\\.]?([\\x00-\\x7F\\s]*)")).r();
    }
}

