use portal;

DROP TABLE IF EXISTS sensitive_species;

CREATE TABLE sensitive_species (
    id INTEGER(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
    scientific_name VARCHAR(255) NOT NULL,
    kingdom VARCHAR(32) NOT NULL,
    family VARCHAR(255) NOT NULL,
    common_name VARCHAR(255) NOT NULL);

-- Conservation sensitive species

INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia atrox','Plantae','Fabaceae','Myall Creek Wattle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia dangarensis','Plantae','Fabaceae','Acacia Dangarensis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pendula','Plantae','Fabaceae','Boree');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus amplexicaulis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus borealis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus caudatus','Plantae','Orchidaceae','mayfly orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus exsertus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus fornicatus','Plantae','Orchidaceae','pixie caps');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus ledwardii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus pusillus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus sp. (Lightning Falls M.T.Mathieson MTM606)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus sublestus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acianthus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acriopsis emarginata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acriopsis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina portuensis','Plantae','Casuarinaceae','Nielsen Park She-oak');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amphineuron immersum','Plantae','Thelypteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amytornis barbatus','Animalia','Maluridae','Grey Grasswren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amytornis dorotheae','Animalia','Maluridae','Carpentarian Grasswren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amytornis housei','Animalia','Maluridae','Black Grasswren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amytornis textilis modestus','Animalia','Maluridae','Thick-billed Grasswren (eastern subspecies)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amytornis woodwardi','Animalia','Maluridae','White-throated Grasswren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anas eatoni','Animalia','Anatidae','Kerguelen Pintail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angiopteris evecta','Plantae','Marattiaceae','Bersarm (palauan)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angophora exul','Plantae','Myrtaceae','Gibraltar Rock Apple');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoectochilus yatesiae','Plantae','Orchidaceae','jewel orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoectochilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthochaera phrygia','Animalia','Meliphagidae','Regent Honeyeater');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Antrophyum austroqueenslandicum','Plantae','Vittariaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Antrophyum plantagineum','Plantae','Vittariaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Antrophyum subfalcatum','Plantae','Vittariaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphyllorchis anomala','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphyllorchis queenslandica','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton bullosus','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton cuneatus','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton elongatus subsp. elongatus','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton elongatus subsp. fluitans','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton elongatus','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton lancesmithii','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton proliferus','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton queenslandicus','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton vanbruggenii','Plantae','Aponogetonaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apostasia wallichii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apostasia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Appendicula australiensis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Appendicula reflexa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Archontophoenix myolensis','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arenga australasica','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus apectus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus aquilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus corinnae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus dockrillii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus irritabilis','Plantae','Orchidaceae','leafy elbow orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus lavarackianus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus oreophilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus prolixus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus rosulatus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus sabulosus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus stenophyllus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrochilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthropteris palisotii','Plantae','Davalliaceae','Lesser Creeping Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arundina graminifolia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aspidites ramsayi','Animalia','Boidae','woma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium athertonense','Plantae','Aspleniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium excisum','Plantae','Aspleniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium normale','Plantae','Aspleniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium pellucidum','Plantae','Aspleniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium unilaterale','Plantae','Aspleniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium wildii','Plantae','Aspleniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atrichornis clamosus','Animalia','Atrichornithidae','Noisy Scrub-bird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atrichornis rufescens','Animalia','Atrichornithidae','Rufous Scrub-bird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrogammarus australis','Animalia','Paramelitidae','Dandenong Freshwater Amphipod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrogammarus haasei','Animalia','Paramelitidae','Sherbrooke Amphipod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austropyrgus grampianensis','Animalia','Hydrobiidae','Dairy Creek Austropyrgus Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea kandos','Plantae','Myrtaceae','Baeckea Kandos');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia conferta','Plantae','Proteacaea','Banksia conferta');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baumea arthrophylla','Plantae','Cyperaceae','Swamp Twig-rush');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blandfordia grandiflora','Plantae','Blandfordiaceae','Christmas bells');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blechnum ambiguum','Plantae','Blechnaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia boliviensis','Plantae','Rutaceae','Bolivia Hill Boronia');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Borya mirabilis','Plantae','Boryaceae','Grampians Pincushion-lily');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Botaurus poiciloptilus','Animalia','Ardeidae','Australasian Bittern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bowenia serrulata','Plantae','Zamiaceae','Byfield fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bowenia spectabilis','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachionichthys hirsutus','Animalia','Brachionichthyidae','Spotted handfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachychiton sp. (Ormeau L.H.Bird AQ435851)','Plantae','Sterculiaceae','Ormeau bottle tree');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bromheadia finlaysoniana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bromheadia pulchra','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bromheadia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum argyropus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum baileyi','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum blumei','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum boonjee','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum bowkettiae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum bracteatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum elisae','Plantae','Orchidaceae','pineapple orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum evasum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum exiguum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum gadgarrense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum globuliforme','Plantae','Orchidaceae','Hoop Pine Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum gracillimum','Plantae','Orchidaceae','graceful orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum grandimesense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum johnsonii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum lageniforme','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum lamingtonense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum lewisense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum lilianae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum longiflorum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum macphersonii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum minutissimum','Plantae','Orchidaceae','grain-of-wheat orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum nematopodum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum newportii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum radicans','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum schillerianum','Plantae','Orchidaceae','red rope orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum shepherdii','Plantae','Orchidaceae','wheat-leaved orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum sladeanum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum wadsworthii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum weinthalii subsp. striatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum weinthalii subsp. weinthalii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum weinthalii','Plantae','Orchidaceae','blotched bulbophyllum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum wilkianum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum windsorense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum wolfei','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbophyllum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacatua pastinator','Animalia','Cacatuidae','Western Corella');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadellia pentastylis','Plantae','Surianaceae','ooline');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia clausa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia collinsii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia funiformis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia maideniana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia taylorii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia uniflos','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia wariana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cadetia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia alata','Plantae','Orchidaceae','fairy orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia amnicola','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia arenaria','Plantae','Orchidaceae','Spider Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia atroclavia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia audasii','Plantae','Orchidaceae','McIvor Spider-orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia caerulea var. caerulea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia caerulea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia carnea var. carnea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia carnea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia catenata var. catenata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia catenata var. gigantea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia catenata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia chamaephylla','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia concolor','Plantae','Orchidaceae','Crimson Spider Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia filamentosa var. filamentosa','Plantae','Orchidaceae','daddy long legs');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia filamentosa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia flaccida','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia fuscata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia gracillima','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia picta','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia porphyrea','Plantae','Orchidaceae','Caladenia Porphyrea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia pumila','Plantae','Orchidaceae','Dwarf Spider-orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia rosella','Plantae','Orchidaceae','Little Pink Spider-orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia sp. (Kilcoy Creek R.Crane 1286)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia sp. (Stanthorpe R.Crane 1448)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia sp. aff. fragrantissima (Central Victoria)','Plantae','Orchidaceae','Bendigo Spider-orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia sp. aff. venusta (Kilsyth South)','Plantae','Orchidaceae','Kilsyth South Spider-orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia tessellata','Plantae','Orchidaceae','Tessellated Spider Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calamus aruensis','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calamus warburgii','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calanthe triplicata','Plantae','Orchidaceae','christmas orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caleana major','Plantae','Orchidaceae','flying duck orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caleana minor','Plantae','Orchidaceae','small duck orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caleana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Callistemon linearifolius','Plantae','Myrtaceae','Netted Bottle Brush');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Callocephalon fimbriatum','Animalia','Cacatuidae','Gang Gang Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus ammobius','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus caeruleus','Plantae','Orchidaceae','Wiry Beard Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus campestris','Plantae','Orchidaceae','copper beard orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus cleistanthus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus gracillimus','Plantae','Orchidaceae','slender beard orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus grandiflorus','Plantae','Orchidaceae','giant beard orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus holtzei','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus imperiosus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus metallicus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus paludosus','Plantae','Orchidaceae','red beard orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus psednus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus pulchellus','Plantae','Orchidaceae','Pretty Beard Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus richiae','Plantae','Orchidaceae','Bald-tip Beard-orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus robertsonii','Plantae','Orchidaceae','purplish beard orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus sp. (Weipa B.R.Jahnke 5)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochlaena villosa','Plantae','Dicksoniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus banksii graptogyne','Animalia','Cacatuidae','Red-tailed Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus banksii','Animalia','Cacatuidae','Red-tailed Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus baudinii','Animalia','Cacatuidae','Baudin\'s Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus funereus','Animalia','Cacatuidae','Yellow-tailed Black Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus lathami lathami','Animalia','Cacatuidae','Glossy Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus lathami halmaturinus','Animalia','Cacatuidae','Glossy Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus lathami','Animalia','Cacatuidae','Glossy Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus latirostris','Animalia','Cacatuidae','Carnaby\'s Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Casuarius casuarius','Animalia','Casuariidae','Southern Cassowary');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caustis blakei subsp. macrantha','Plantae','Cyperaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cheilanthes sieberi subsp. pseudovellea','Plantae','Sinopteridaceae','Rock Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cheirostylis notialis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cheirostylis ovata','Plantae','Orchidaceae','caterpillar orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cheirostylis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis anaticeps','Plantae','Orchidaceae','Bird Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis diphylla','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis formicifera','Plantae','Orchidaceae','ant orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis longiclavata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis platyptera','Plantae','Orchidaceae','Barrington Tops Ant Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis reflexa','Plantae','Orchidaceae','autumn bird orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis sp. (Mango Flat D.L.Jones 2547)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis sp. (Maryborough A.E.Logan AQ673312)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis sphyrnoides','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis sylvestris','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis trullata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis truncata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloglottis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloschista phyllorhiza','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chiloschista','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chingia australis','Plantae','Thelypteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chionis minor','Animalia','Chionidae','Black-faced Sheathbill');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chlamydogobius micropterus','Animalia','Gobiidae','Elizabeth Springs goby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chlamydogobius squamigenus','Animalia','Gobiidae','Edgbaston goby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Choricarpia subargentea','Plantae','Myrtaceae','Giant Ironwood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Collocalia esculenta','Animalia','Apodidae','Glossy Swiftlet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colubotelson joyneri','Animalia','Phreatoicidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colubotelson searli','Animalia','Phreatoicidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conopophila whitei','Animalia','Meliphagidae','Grey Honeyeater');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cooktownia robertsii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cooktownia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas abellianus','Plantae','Orchidaceae','nodding helmet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas aconitiflorus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas barbarae','Plantae','Orchidaceae','helmet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas cerasinus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas dowlingii','Plantae','Orchidaceae','Red Helmet Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas fimbriatus','Plantae','Orchidaceae','fringed helmet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas fordhamii','Plantae','Orchidaceae','banded helmet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas hispidus','Plantae','Orchidaceae','bristly helmet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas montanus','Plantae','Orchidaceae','small helmet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas undulatus','Plantae','Orchidaceae','tailed helmet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas unguiculatus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corymborkis veratrifolia','Plantae','Orchidaceae','cinnamon orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corymborkis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crepidium fimbriatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crepidium flavovirens','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crepidium lawleri','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crepidium marsupichilum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crepidium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crepidomanes aphlebioides','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crepidomanes majoriae','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crex crex','Animalia','Rallidae','Corncrake');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptostylis erecta','Plantae','Orchidaceae','bonnet orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptostylis hunteriana','Plantae','Orchidaceae','Leafless Tongue Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptostylis leptochila','Plantae','Orchidaceae','small tongue orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptostylis subulata','Plantae','Orchidaceae','large tounge orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenopteris blechnoides','Plantae','Grammitidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenopteris walleri','Plantae','Grammitidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyanoramphus cookii','Animalia','Psittacidae','Tasman Parakeet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathea baileyana','Plantae','Cyatheaceae','wig tree fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathea celebica','Plantae','Cyatheaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathea cunninghamii','Plantae','Cyatheaceae','slender tree fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathea exilis','Plantae','Cyatheaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathea felina','Plantae','Cyatheaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas angulata','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas badensis','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas brunnea','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas cairnsiana','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas candida','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas couttsiana','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas cupida','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas desolata','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media - C.platyphylla','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media subsp. banksii - C.media subsp. media','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media subsp. banksii x C.platyphylla','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media subsp. banksii','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media subsp. ensata','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media subsp. media - C.ophiolitica','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media subsp. media','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas media','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas megacarpa','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas ophiolitica','Plantae','Cycadaceae','Marlborough blue');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas platyphylla','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas scratchleyana','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas semota','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas silvestris','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas tuckeri','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas xipholepis','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas yorkiana','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas','Plantae','Cycadaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyclopsitta diophthalma coxeni','Animalia','Psittacidae','Double-eyed Fig-parrot [Coxen�s Fig-parrot]');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyclopsitta diophthalma','Animalia','Psittacidae','Double-eyed Fig-Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cymbidium canaliculatum','Plantae','Orchidaceae','Black Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cymbidium madidum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cymbidium suave','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cymbidium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyrtodactylus tuberculatus','Animalia','Gekkonidae','ring-tailed gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyrtostylis reniformis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyrtostylis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasyornis brachypterus','Animalia','Pardalotidae','Eastern Bristlebird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasyornis broadbenti','Animalia','Pardalotidae','Rufous Bristlebird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Davidsonia jerseyana','Plantae','Davidsoniaceae','Davidson\'s Plum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Davidsonia johnsonii','Plantae','Cunoniaceae','smooth Davidsonia');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Demorchis queenslandica','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium adae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium aemulum','Plantae','Orchidaceae','ironbark orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium agrostophyllum','Plantae','Orchidaceae','buttercup orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium antennatum','Plantae','Orchidaceae','antelope orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium aphyllum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium atroviolaceum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium bifalce','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium bigibbum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium cacatua','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium callitrophilum','Plantae','Orchidaceae','cypress orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium canaliculatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium capitis-york','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium carrii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium carronii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium discolor','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium falcorostrum','Plantae','Orchidaceae','beech orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium fellowsii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium finniganense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium fleckeri','Plantae','Orchidaceae','apricot orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium gracilicaule','Plantae','Orchidaceae','slender orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium johannis','Plantae','Orchidaceae','brown antelope orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium jonesii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium kingianum subsp. carnarvonense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium kingianum subsp. kingianum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium kingianum x D.speciosum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium kingianum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium lichenastrum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium litorale','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium lobbii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium malbrownii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium melaleucaphilum','Plantae','Orchidaceae','spider orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium mirbelianum','Plantae','Orchidaceae','mangrove orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium monophyllum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium nindii','Plantae','Orchidaceae','blue orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium prenticei','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium schneiderae var. majus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium schneiderae var. schneiderae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium schneiderae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium smillieae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium speciosum subsp. capricornicum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium speciosum subsp. curvicaule','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium speciosum subsp. grandiflorum x D.speciosum subsp. hillii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium speciosum subsp. grandiflorum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium speciosum subsp. hillii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium speciosum subsp. pedunculatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium speciosum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium tetragonum','Plantae','Orchidaceae','tree spider orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium toressae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium x delicatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium x gracillimum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium x lavarackianum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium x ruppiosum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium x superbiens','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium x vinicolor','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrobium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Didymoglossum exiguum','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Didymoglossum mindorense','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Didymoplexis pallens','Plantae','Orchidaceae','crystal bells');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Didymoplexis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dienia montana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dienia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dinotoperla walkeri','Animalia','Gripopterygidae','Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplazium cordifolium','Plantae','Athyriaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplazium pallidum','Plantae','Athyriaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplocaulobium glabrum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplocaulobium stelliferum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diploglottis campbellii','Plantae','Sapindaceae','Small-leaved Tamarind');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium atropurpureum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium elegantulum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium ensifolium','Plantae','Orchidaceae','leafy hyacinth orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium hamiltonianum','Plantae','Orchidaceae','yellow hyacinth orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium pictum','Plantae','Orchidaceae','brittle climbing orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium punctatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium stenochilum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium variegatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipodium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dipteris conjugata','Plantae','Dipteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris abbreviata','Plantae','Orchidaceae','lemon doubletail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris aequalis','Plantae','Orchidaceae','Buttercup Doubletail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris alba x D.chrysantha','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris alba','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris arenaria','Plantae','Orchidaceae','Sand Doubletail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris aurea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris bracteata','Plantae','Orchidaceae','Diuris Bracteata');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris chrysantha','Plantae','Orchidaceae','double yellow tails');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris disposita','Plantae','Orchidaceae','Willawarrin Doubletail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris exitela','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris flavescens','Plantae','Orchidaceae','Pale Yellow Doubletail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris lanceolata','Plantae','Orchidaceae','snake orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris luteola','Plantae','Orchidaceae','northern yellow donkeys tails');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris maculata','Plantae','Orchidaceae','leopard orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris ochroma','Plantae','Orchidaceae','Pale Golden Moths');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris oporina','Plantae','Orchidaceae','northern white donkeys tails');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris parvipetala','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris pedunculata','Plantae','Orchidaceae','Small Snake Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris platichila','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris praecox','Plantae','Orchidaceae','Newcastle Doubletail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris punctata var. punctata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris sp. (Byfield R.Melzer+ RM651A)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris sp. (Jollys Falls J.Loveday 31)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris sp. (Oaklands, D.L. Jones 5380)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris sp. aff. chrysantha (Byron Bay) (D.L. Jones ORG 2761)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris sulphurea','Plantae','Orchidaceae','tiger orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris tricolor','Plantae','Orchidaceae','Painted Diuris');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris unica','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris venosa','Plantae','Orchidaceae','Goat Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris x palachila','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia bowmanii','Plantae','Orchidaceae','scrub pencil orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia brevicauda','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia calamiformis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia cucumerina','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia dolichophylla','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia fairfaxii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia linguiformis','Plantae','Orchidaceae','tongue orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia mortii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia nugentii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia pugioniformis','Plantae','Orchidaceae','dagger orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia racemosa','Plantae','Orchidaceae','tableland pencil orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia rigida','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia schoenina','Plantae','Orchidaceae','pencil orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia teretifolia','Plantae','Orchidaceae','rat\'s tail orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia wassellii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia x foederata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia x grimesii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dockrillia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drymoanthus minutus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drymoanthus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drynaria rigidula','Plantae','Polypodiaceae','Basket Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drynaria x dumicola','Plantae','Polypodiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryopteris hasseltii','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryopteris sparsa','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ducula whartoni','Animalia','Columbidae','Christmas Island Imperial-Pigeon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eclectus roratus','Animalia','Psittacidae','Eclectus Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eidothea hardeniana','Plantae','Proteacaea','Nightcap Oak');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elaeocarpus sp. Rocky Creek','Plantae','Elaeocarpaceae','Minyon Quandong');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elaeocarpus williamsianus','Plantae','Elaeocarpaceae','Hairy Quandong');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elanus scriptus','Animalia','Accipitridae','Letter-winged Kite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elaphoglossum callifolium','Plantae','Lomariopsidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elseya irwini','Animalia','Chelidae','Irwin\'s turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Empusa habenarina','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Emydura macquarii emmotti','Animalia','Chelidae','Emmott\'s short-neck turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus australis','Animalia','Parastacidae','Lilly Pilly Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus fultoni','Animalia','Parastacidae','Otway Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus mallacoota','Animalia','Parastacidae','Mallacoota Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus phyllocercus','Animalia','Parastacidae','Narracan Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus rostrogaleatus','Animalia','Parastacidae','Strezelecki Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus sericatus','Animalia','Parastacidae','Hairy Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus sternalis','Animalia','Parastacidae','Warragul Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus strictifrons','Animalia','Parastacidae','Portland Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaeus urostrictus','Animalia','Parastacidae','Dandenong Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epidendrum ibaguense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epidendrum x obrienianum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epipogium roseum','Plantae','Orchidaceae','leafless nodding orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eria dischorensis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eria eriaeoides','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eria fitzalanii','Plantae','Orchidaceae','red beech orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eria irukandjiana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eria kingii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eria queenslandica','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriochilus cucullatus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriochilus petricola','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriochilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erythrorchis cassythoides','Plantae','Orchidaceae','climbing orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erythrorchis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erythrotriorchis radiatus','Animalia','Accipitridae','Red Goshawk');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erythrura gouldiae','Animalia','Passeridae','Gouldian Finch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euastacus bidawalus','Animalia','Parastacidae','East Gippsland Spiny Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euastacus bispinosa','Animalia','Parastacidae','Glenelg River Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euastacus claytoni','Animalia','Parastacidae','Spiny Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euastacus crassus','Animalia','Parastacidae','Alpine Spiny Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euastacus yanga','Animalia','Parastacidae','Variable Spiny Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalliax tooradin','Animalia','Callianassidae','Ghost shrimp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus copulans','Plantae','Myrtaceae','Eucalyptus Copulans');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus dissita','Plantae','Myrtaceae','Gibraltar Mallee');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus imlayensis','Plantae','Myrtaceae','Imlay Mallee');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus pachycalyx subsp. banyabba','Plantae','Myrtaceae','Banyabba Shiny-barked Gum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucosia umbrosa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eulophia bicallosa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eulophia pelorica','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eulophia zollingeri','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Falco hypoleucos','Animalia','Falconidae','Grey Falcon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Falcunculus frontatus','Animalia','Pachycephalidae','Crested Shrike-tit');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Flickingeria clementsii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Flickingeria convexa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fontainea oraria','Plantae','Euphorbiaceae','Coastal Fontainea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fregata andrewsi','Animalia','Fregatidae','Christmas Island Frigatebird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fregetta tropica','Animalia','Hydrobatidae','Black-bellied Storm-Petrel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Galaxias fontanus','Animalia','Galaxiidae','Swan galaxias');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gallus varius','Animalia','Phasianidae','Green Junglefowl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gariwerdeus beehivensis','Animalia','Phreatoicidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gariwerdeus ingletonensis','Animalia','Phreatoicidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gariwerdeus turretensis','Animalia','Phreatoicidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrodia crebriflora','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrodia sesamoides','Plantae','Orchidaceae','cinnamon bells');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrodia urceolata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrodia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gaultheria hispida','Plantae','Ericaceae','Snow-berry');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium acuminatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium alticola','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium archeri','Plantae','Orchidaceae','variable midge orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium baueri','Plantae','Orchidaceae','Bauer\'s Midge Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium confertum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium cranei','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium filiforme','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium fimbriatum','Plantae','Orchidaceae','fringed midge orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium insignis','Plantae','Orchidaceae','Variable Midge Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium littorale','Plantae','Orchidaceae','Tuncurry Midge Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium nudiscapum','Plantae','Orchidaceae','dense midge orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium parvicallum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium pedersonii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium plumosum','Plantae','Orchidaceae','Tallong Midge Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium psammophilum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium pumilum','Plantae','Orchidaceae','green midge orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium rhyoliticum','Plantae','Orchidaceae','Rhyolite Midge Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium rufum','Plantae','Orchidaceae','red midge orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium sagittiferum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium sigmoideum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium sp. (Fraser Island NP R.Crane 2063)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium sp. (Raby Bay J.Elsol AQ462423)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium sp. (Wyberba D.L.Jones+ 2557)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium superbum','Plantae','Orchidaceae','Superb Midge Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium tectum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium validum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium vernale','Plantae','Orchidaceae','East Lynne Midge Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genoplesium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gentiana bredboensis','Plantae','Gentianaceae','Bredbo Gentian');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gentiana wingecarribiensis','Plantae','Gentianaceae','Wingecarribee Gentian');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geodorum densiflorum','Plantae','Orchidaceae','Pink Nodding Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geodorum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geophaps scripta','Animalia','Columbidae','Squatter Pigeon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geophaps smithii','Animalia','Columbidae','Partridge Pigeon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gerygone modesta','Animalia','Pardalotidae','Norfolk Island Gerygone');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gingidia montana','Plantae','Apiaceae','Broad-leafed Carrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glossodia major','Plantae','Orchidaceae','wax-lip orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glossodia minor','Plantae','Orchidaceae','small wax lip orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glossodia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glossopsitta porphyrocephala','Animalia','Psittacidae','Purple-crowned Lorikeet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodyera grandis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodyera viridiflora','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gramastacus insolitus','Animalia','Parastacidae','Western Swamp Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grammitis albosetosa','Plantae','Grammitidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grammitis leonardii','Plantae','Grammitidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grammitis reinwardtii','Plantae','Grammitidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grammitis stenophylla','Plantae','Grammitaceae','Narrow-leaf Finger Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grastidium baileyi','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grastidium cancroides','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grastidium insigne','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grastidium luteocilium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grastidium tozerense','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grastidium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea beadleana','Plantae','Proteaceae','Beadle\'s Grevillea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea divaricata','Plantae','Proteaceae','Grevillea Divaricata');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea iaspicula','Plantae','Proteaceae','Wee Jasper Grevillea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea masonii','Plantae','Proteaceae','Mason\'s Grevillea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea mollis','Plantae','Proteaceae','Soft Grevillea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostemon thesioides','Plantae','Gyrostemonaceae','Gyrostemon Thesioides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria chloroleuca','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria chlorosepala','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria elongata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria euryloba','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria exilis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria fuscina','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria harroldii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria hymenophylla','Plantae','Orchidaceae','rainforest habenaria');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria macraithii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria praecox','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria propinquior','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria rumphii','Plantae','Orchidaceae','Stiff Rein Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria triplonema','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria xanthantha','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Habenaria','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea archaeoides','Plantae','Proteaceae','Big Nellie Hakea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea pulvinifera','Plantae','Proteaceae','Lake Keepit Hakea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hamirostra melanosternon','Animalia','Accipitridae','Black-breasted Buzzard');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiphlebia mirabilis','Animalia','Hemiphlebiidae','Ancient Greenling');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hetaeria oblongifolia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homoranthus porteri','Plantae','Myrtaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplocephalus bungaroides','Animalia','Elapidae','Broad-headed Snake');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplocephalus stephensii','Animalia','Elapidae','Stephens\' banded snake');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia carinata','Plantae','Lycopodiaceae','keeled tassel fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia dalhousieana','Plantae','Lycopodiaceae','blue tassel fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia filiformis','Plantae','Lycopodiaceae','rat\'s tail tassel fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia lockyeri','Plantae','Lycopodiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia marsupiiformis','Plantae','Lycopodiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia phlegmaria','Plantae','Lycopodiaceae','coarse tassel fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia phlegmarioides','Plantae','Lycopodiaceae','layered tassel fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia serrata','Plantae','Lycopodiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia squarrosa','Plantae','Lycopodiaceae','rock tassel fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia tetrastichoides','Plantae','Lycopodiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia varia','Plantae','Lycopodiaceae','long clubmoss');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Huperzia','Plantae','Lycopodiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydnophytum ferrugineum','Plantae','Rubiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydnophytum moseleyanum var. moseleyanum','Plantae','Rubiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydnophytum papuanum','Plantae','Rubiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydriastele costata','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenophyllum digitatum','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenophyllum eboracense','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenophyllum gracilescens','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenophyllum kerianum','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenophyllum lobbii','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenophyllum pallidum','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenophyllum whitei','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypochrysops apollo apollo','Animalia','Lycaenidae','Apollo jewel (Wet Tropics subspecies)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypochrysops piceata','Animalia','Lycaenidae','bulloak jewel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypsela sessiliflora','Plantae','Lobeliaceae','Hypsela Sessiliflora');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hyridella glenelgensis','Animalia','Hyriidae','Glenelg Freshwater Mussel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indigofera efoliata','Plantae','Fabaceae','Leafless Indigo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ixobrychus dubius','Animalia','Ardeidae','Australian Little Bittern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jalmenus eubulus','Animalia','Lycaenidae','Pale Imperial Hairstreak');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lastreopsis grayi','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lastreopsis hispida','Plantae','Dryopteridaceae','Bristly Shield Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lastreopsis silvestris','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lastreopsis tinarooensis','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lastreopsis walleri','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lathamus discolor','Animalia','Psittacidae','Swift Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leionema lamprophyllum','Plantae','Rutaceae','Shiny Phebalium');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leipoa ocellata','Animalia','Megapodiidae','Malleefowl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lemmaphyllum accedens','Plantae','Polypodiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidozamia hopei','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidozamia peroffskyana','Plantae','Zamiaceae','shining burrawang');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidozamia','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptoperla kallistae','Animalia','Gripopterygidae','Kallista Flightless Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista allanae','Animalia','Scincidae','Allan\'s lerista');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon confertus','Plantae','Epacridaceae','Torrington Beard-heath');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindsaea brachypoda','Plantae','Lindsaeaceae','Short-footed Screw Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindsaea fraseri','Plantae','Lindsaeaceae','Fraser\'s Screw Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindsaea incisa','Plantae','Lindsaeaceae','Slender Screw Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindsaea pulchella var. blanda','Plantae','Lindsaeaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindsaea terrae-reginae','Plantae','Lindsaeaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindsaea walkerae','Plantae','Lindsaeaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Linospadix microcarya','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Linospadix palmeriana','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis angustilabris','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis bracteata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis coelogynoides','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis collinsii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis condylobulbon','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis fleckeri','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis nugentiae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis petricola','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis simmondsii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis swenssonii','Plantae','Orchidaceae','rock orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Livistona concinna','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Livistona drudei','Plantae','Arecaceae','Halifax fan palm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Livistona fulva','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Livistona lanuginosa','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Livistona nitida','Plantae','Arecaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lomatia tasmanica','Plantae','Proteaceae','King\'s lomatia');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lophochroa leadbeateri','Animalia','Cacatuidae','Major Mitchell\'s Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lophoictinia isura','Animalia','Accipitridae','Square-tailed Kite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Luisia teretifolia','Plantae','Orchidaceae','Grooved Velvet Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lyperanthus suaveolens','Plantae','Orchidaceae','brown beaks');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lyperanthus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lysimachia vulgaris var. davurica','Plantae','Primulaceae','Yellow Loosestrife');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia cardiacensis','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia conferta','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia cranei','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia crassifolia','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia douglasii','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia fearnsidei x M.moorei','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia fearnsidei','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia lomandroides - M.pauli-guilielmi','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia lomandroides x M.pauli-guilielmi','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia lomandroides','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia longispina - M.macleayi','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia longispina','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia lucida x M.macleayi','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia lucida','Plantae','Zamiaceae','pineapple zamia');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia machinii','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia macleayi','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia miquelii','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia moorei','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia mountperriensis','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia occidua','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia parcifolia','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia pauli-guilielmi','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia platyrhachis','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia serpentina','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia viridis','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrozamia','Plantae','Zamiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malaxis latifolia','Plantae','Orchidaceae','Yellow Spur Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malaxis marsupichila','Plantae','Orchidaceae','Puoched Spur Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malaxis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malurus coronatus','Animalia','Maluridae','Purple-crowned Fairy-wren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Manorina melanotis','Animalia','Meliphagidae','Black-eared Miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Menura alberti','Animalia','Menuridae','Albert\'s Lyrebird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Michelea microphylla','Animalia','Micheleidae','Ghost shrimp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus grandis','Plantae','Myrtaceae','Severn River Heath-myrtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micropera fasciculata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micropera','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microsorum membranifolium','Plantae','Polypodiaceae','pimple fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis angusii','Plantae','Orchidaceae','Angus\' Onion Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis parviflora','Plantae','Orchidaceae','slender onion orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis rara','Plantae','Orchidaceae','scented onion orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis unifolia','Plantae','Orchidaceae','common onion orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mixophyes balbus','Animalia','Myobatrachidae','Stuttering Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mixophyes fleayi','Animalia','Myobatrachidae','Fleay�s Barred Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mixophyes iteratus','Animalia','Myobatrachidae','Giant Barred Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mobilabium hamatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mobilabium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monogramma dareicarpa','Plantae','Vittariaceae','grass fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Morelia spilota metcalfei','Animalia','Boidae','Carpet Python');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Morelia spilota spilota','Animalia','Boidae','Diamond Python');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Morus capensis','Animalia','Sulidae','Cape Gannet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriophyllum implicatum','Plantae','Haloragaceae','Myriophyllum implicatum Orchard');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myrmecodia beccarii','Plantae','Rubiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myrmecodia platytyrea subsp. antoinii','Plantae','Rubiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myrmecodia platytyrea','Plantae','Rubiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myrmecodia tuberosa','Plantae','Rubiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Naiopegia xiphagrostis','Animalia','Phreatoicidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nangura spinosa','Animalia','Scincidae','Nangur skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nannoperca oxleyana','Animalia','Nannopercidae','Oxleyan pygmy perch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neochmia phaeton evangelinae','Animalia','Estrildidae','crimson finch (white-bellied subspecies)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neochmia phaeton','Animalia','Passeridae','Crimson Finch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neochmia ruficauda','Animalia','Passeridae','Star Finch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neophema chrysogaster','Animalia','Psittacidae','Orange-bellied Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neophema pulchella','Animalia','Psittacidae','Turquoise Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neophema splendida','Animalia','Psittacidae','Scarlet-chested Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nephrurus deleani','Animalia','Gekkonidae','Pernatty Knob-tailed Gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nephrurus sphyrurus','Animalia','Gekkonidae','border thick-tailed gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nervilia aragoana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nervilia crociformis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nervilia holochila','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nervilia peltata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nervilia plicata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nervilia uniflora','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nervilia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ninox connivens','Animalia','Strigidae','Barking Owl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ninox rufa','Animalia','Strigidae','Rufous Owl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ninox strenua','Animalia','Strigidae','Powerful Owl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Northiella haematogaster','Animalia','Psittacidae','Blue Bonnet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notopala sublineata','Animalia','Viviparidae','River Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notoperata sparsa','Animalia','Leptoceridae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nurus atlas','Animalia','Carabidae','Atlas Rainforest Ground-beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nurus brevis','Animalia','Carabidae','Shorter Rainforest Ground-beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oberonia attenuata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oberonia carnosa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oberonia complanata','Plantae','Orchidaceae','Yellow-flowered King');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oberonia palmicola','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oberonia titania','Plantae','Orchidaceae','Red-flowered King');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oberonia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Octarrhena pusilla','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oeceoclades pulchra','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oeceoclades','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oecetis quadrula','Animalia','Leptoceridae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oenotrichia dissecta','Plantae','Dennstaedtiaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orraya occultus','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orthoceras strictum','Plantae','Orchidaceae','horned orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pachycephala rufogularis','Animalia','Pachycephalidae','Red-lored Whistler');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pachystoma pubescens','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pachystoma','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pandion haliaetus','Animalia','Accipitridae','Osprey');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Papasula abbotti','Animalia','Sulidae','Abbott\'s Booby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Papillilabium beckleri','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Papillilabium','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pararistolochia praevenosa','Plantae','Aristolochiaceae','Richmond birdwing vine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pardalotus quadragintus','Animalia','Pardalotidae','Forty-spotted Pardalote');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pedionomus torquatus','Animalia','Pedionomidae','Plains-wanderer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peristeranthus hillii','Plantae','Orchidaceae','Brown Fairy-chain Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peristeranthus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peristylus banfieldii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peristylus candidus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peristylus chlorandrellus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peristylus papuanus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia pauciflora','Plantae','Proteaceae','North Rothbury Persoonia');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petalochilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petroica multicolor','Animalia','Petroicidae','Pacific Robin');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pezoporus occidentalis','Animalia','Psittacidae','Night Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pezoporus wallicus wallicus','Animalia','Psittacidae','Ground Parrot (eastern subsp.)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaethon lepturus','Animalia','Phaethontidae','White-tailed Tropicbird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaius australis','Plantae','Orchidaceae','Southern Swamp Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaius bernaysii','Plantae','Orchidaceae','yellow swamp orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaius pictus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaius tankarvilleae','Plantae','Orchidaceae','Lady Tankarville\'s Swamp Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phalaenopsis amabilis subsp. rosenstromii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phalaenopsis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philoria kundagungan','Animalia','Myobatrachidae','Mountain Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philoria loveridgei','Animalia','Myobatrachidae','Loveridge\�s Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philoria pughi','Animalia','Myobatrachidae','Pugh\'s Sphagnum Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philoria richmondensis','Animalia','Myobatrachidae','Richmond Range Sphagnum Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pholidota imbricata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pholidota','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phreatoicopsis raffae','Animalia','Phreatoicopsidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phreatoicopsis terricola','Animalia','Phreatoicopsidae','Phreatoicopsis Isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus amnicola','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus caudiannulatus','Animalia','Gekkonidae','ringed thin-tailed gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus championae','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus gulbaru','Animalia','Gekkonidae','Gulbaru gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus isis','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus kabikabi','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus nepthys','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus ossa','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllurus sp.','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pilularia novae-hollandiae','Plantae','Marsileaceae','Austral Pillwort');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea axiflora','Plantae','Thymelaeaceae','Pimelea axiflora');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea venosa','Plantae','Thymelaeaceae','Bolivia Hill Pimelea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platyzoma microphyllum','Plantae','Platyzomataceae','Braid fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plectorrhiza brevilabris','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plectorrhiza tridentata','Plantae','Orchidaceae','tangle orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plectorrhiza','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plesioneuron tuberculatum','Plantae','Thelypteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plexaure crassiuscula','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pneumatopteris costata','Plantae','Thelypteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pneumatopteris pennigera','Plantae','Thelypteridaceae','lime fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Poephila cincta cincta','Animalia','Estrildidae','black-throated finch (white-rumped subspecies)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Poephila cincta','Animalia','Passeridae','Black-throated Finch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polyphlebium endlicherianum','Plantae','Hymenophyllaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polytelis alexandrae','Animalia','Psittacidae','Princess Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polytelis anthopeplus monarchoides','Animalia','Psittacidae','Regent Parrot (eastern subsp.)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polytelis anthopeplus','Animalia','Psittacidae','Regent Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polytelis swainsonii','Animalia','Psittacidae','Superb Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomaderris adnata','Plantae','Rhamnaceae','Sublime Point Pomaderris');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomaderris walshii','Plantae','Rhamnaceae','Carrington Falls Pomaderris');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomatocalpa macphersonii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomatocalpa marsupiale','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum affine','Plantae','Orchidaceae','Jervis Bay Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum australe','Plantae','Orchidaceae','austral leek orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum bagoensis','Plantae','Orchidaceae','Bago Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum brevilabre','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum campestre','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum canaliculatum','Plantae','Orchidaceae','Summer Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum elatum','Plantae','Orchidaceae','tall leek orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum exilis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum flavum','Plantae','Orchidaceae','yellow leek orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum fuscum','Plantae','Orchidaceae','Slaty Leek-orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum incompositum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum innubum','Plantae','Orchidaceae','Prasophyllum Innubum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum keltonii','Plantae','Orchidaceae','Kelton\'s Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum morganii','Plantae','Orchidaceae','Cobungra Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum pallens','Plantae','Orchidaceae','Slaty Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum petilum','Plantae','Orchidaceae','Tarengo Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum retroflexum','Plantae','Orchidaceae','Kiandra Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum sp. Majors Creek (Jones 11084)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum sp. Moama (D.L. Jones 19276)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum uroglossum','Plantae','Orchidaceae','Wingecarribee Leek Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum wallum','Plantae','Orchidaceae','Wallum leek orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Procelsterna cerulea','Animalia','Laridae','Grey Ternlet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera palustris','Plantae','Lamiaceae','Swamp Mint-bush');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera staurophylla','Plantae','Lamiaceae','Torrington Mint-bush');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psephotus chrysopterygius','Animalia','Psittacidae','Golden-shouldered Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psephotus dissimilis','Animalia','Psittacidae','Hooded Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudocloeon hypodelum','Animalia','Baetidae','Mayfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomugil mellis','Animalia','Pseudomugilidae','honey blue-eye');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudophryne corroboree','Animalia','Myobatrachidae','Southern Corroboree Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudophryne pengilleyi','Animalia','Myobatrachidae','Northern Corroboree Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudovanilla foliata','Plantae','Orchidaceae','giant climbing orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psilotum complanatum','Plantae','Psilotaceae','Flat Fork Fern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psophodes nigrogularis','Animalia','Psophodidae','Western Whipbird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pteridoblechnum acuminatum','Plantae','Blechnaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterodroma cervicalis','Animalia','Procellariidae','White-necked Petrel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterodroma mollis','Animalia','Procellariidae','Soft-plumaged Petrel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterodroma occulta','Animalia','Procellariidae','Vanuatu Petrel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterodroma solandri','Animalia','Procellariidae','Providence Petrel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis acuminata','Plantae','Orchidaceae','sharp greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis anatona','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis aquilonia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis baptistii','Plantae','Orchidaceae','king greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis bicolor','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis bicornis','Plantae','Orchidaceae','horned greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis boormanii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis chaetophora','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis cobarensis','Plantae','Orchidaceae','Greenhood Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis crassichila','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis cucullata','Plantae','Orchidaceae','Leafy Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis curta','Plantae','Orchidaceae','blunt greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis cycnocephala','Plantae','Orchidaceae','swan greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis daintreana','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis depauperata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis despectans','Plantae','Orchidaceae','Lowly Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis elegans','Plantae','Orchidaceae','Elegant Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis erecta','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis fischii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis furcata','Plantae','Orchidaceae','sickle greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis gibbosa','Plantae','Orchidaceae','Illawarra Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis grandiflora','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis hildae','Plantae','Orchidaceae','rainforest greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis hispidula','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis longicurva','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis longifolia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis longipetala','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis metcalfei','Plantae','Orchidaceae','Metcalfe\'s Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis mitchellii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis mutica','Plantae','Orchidaceae','midget greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis nigricans','Plantae','Orchidaceae','Dark Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis nutans','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis obtusa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis ophioglossa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis oreophila','Plantae','Orchidaceae','Blue-tongued Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis parviflora','Plantae','Orchidaceae','tiny greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis pedunculata','Plantae','Orchidaceae','maroonhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis procera','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis pulchella','Plantae','Orchidaceae','Waterfall Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis reflexa','Plantae','Orchidaceae','dainty greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis revoluta','Plantae','Orchidaceae','autumn greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis rufa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis russellii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis saxicola','Plantae','Orchidaceae','Sydney Plains Greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis scoliosa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis setifera','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. (Gundiah W.W.Abell AQ72188)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. (Joyners Ridge R.Crane 17)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. (Lake Manchester R.Crane 45)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. (Mt Maroon J.R.Clarkson+ 1114)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. (Mt Moffatt NP R.Crane 2037)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. Botany Bay (A. Bishop J221/1 13)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis stricta','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis taurus','Plantae','Orchidaceae','charging bull orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis vitrea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis woollsii','Plantae','Orchidaceae','long-tailed greenhood');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus brachyanthus','Plantae','Amaranthaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puffinus assimilis','Animalia','Procellariidae','Little Shearwater');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea parrisiae subsp. elusa','Plantae','Fabaceae','Elusive Bush-pea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea sp. Genowlan Point (NSW 417813)','Plantae','Fabaceae','Genowlan Point Pultenaea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea sp. Olinda (R.G. Coveny 6616)','Plantae','Fabaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramiheithrus virgatus','Animalia','Philorheithridae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Revwattsia fragilis','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhadinocentrus ornatus','Animalia','Melanotaeniidae','ornate rainbowfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rheodytes leukops','Animalia','Chelidae','Fitzroy River turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhinerrhiza divitiflora','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhinerrhiza','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhinerrhizopsis matutina','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhinerrhizopsis moorei','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhinolophus philippinensis','Animalia','Rhinolophidae','greater large-eared horseshoe bat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhipidorchis micrantha','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizanthella omissa','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizanthella slateri','Plantae','Orchidaceae','Eastern Australian Underground Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizanthella','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchophreatia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Riekoperla darlingtoni','Animalia','Gripopterygidae','Mt Donna Buang Wingless Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Riekoperla intermedia','Animalia','Gripopterygidae','Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Riekoperla isosceles','Animalia','Gripopterygidae','Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Robiquetia gracilistipes','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Robiquetia wassellii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Romnalda strobilacea','Plantae','Laxmanniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rostratula australis','Animalia','Rostratulidae','Australian Painted Snipe');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saccolabiopsis armitii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saccolabiopsis rectifolia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saccolabiopsis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saltuarius cornutus','Animalia','Gekkonidae','northern leaf-tailed gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saltuarius salebrosus','Animalia','Gekkonidae','rough-throated leaf-tailed gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saltuarius sp.','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saltuarius swaini','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saltuarius wyberba','Animalia','Gekkonidae','granite leaf-tailed gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus borealis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus ceciliae','Plantae','Orchidaceae','fairy bells');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus dilatatus','Plantae','Orchidaceae','Brown Butterfly Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus eriochilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus falcatus','Plantae','Orchidaceae','orange blossom orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus fitzgeraldii','Plantae','Orchidaceae','Ravine Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus hartmannii','Plantae','Orchidaceae','Hartman\'s Sarcochilus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus hillii','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus hirticalcar','Plantae','Orchidaceae','harlequin orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus minutiflos','Plantae','Orchidaceae','white bells');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus olivaceus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus serrulatus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus spathulatus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus weinthalii','Plantae','Orchidaceae','Blotched Sarcochilus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcochilus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaturiginichthys vermeilipinnis','Animalia','Pseudomugilidae','red-finned blue-eye');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schistotylus purpuratus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schistotylus','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenorchis micrantha','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenorchis sarcophylla','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenorchis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selenocosmia crassipes','Animalia','Theraphosidae','coastal whistling spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selenocosmia strenua','Animalia','Theraphosidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selenotypus plumipes','Animalia','Theraphosidae','tarantula');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spathoglottis paulinae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spathoglottis plicata','Plantae','Orchidaceae','New Guinea ground orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spiranthes sinensis','Plantae','Orchidaceae','austral ladies tresses');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stagonopleura guttata','Animalia','Estrildidae','diamond firetail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sticherus milnei','Plantae','Gleicheniaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stiphodon sp.','Animalia','Gobiidae','Daintree cling-goby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stipiturus mallee','Animalia','Maluridae','Mallee Emu-wren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sula dactylatra','Animalia','Sulidae','Masked Booby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synamphisopus ambiguus','Animalia','Amphisopodidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synamphisopus doegi','Animalia','Amphisopodidae','Phreatoicid isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tachybaptus ruficollis','Animalia','Podicipedidae','Little Grebe');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taeniophyllum confertum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taeniophyllum lobatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taeniophyllum malianum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taeniophyllum muelleri','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taeniophyllum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tainia trinervis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tainia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tamasia furcilla','Animalia','Calocidae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taskiria otwayensis','Animalia','Kokiriidae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tectaria devexa var. devexa','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tectaria siifolia','Plantae','Dryopteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumatoperla alpina','Animalia','Eustheniidae','Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumatoperla flaveola','Animalia','Eustheniidae','Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumatoperla robusta','Animalia','Eustheniidae','Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumatoperla timmsi','Animalia','Eustheniidae','Stonefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelasis carinata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra adorata','Plantae','Orchidaceae','Thelymitra adorata');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra angustifolia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra aristata','Plantae','Orchidaceae','great sun orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra atronitida','Plantae','Orchidaceae','Black-hooded Sun Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra carnea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra epipactoides','Plantae','Orchidaceae','Metallic Sun Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra fragrans','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra ixioides var. ixioides','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra ixioides','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra longifolia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra longiloba','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra malvina','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra media var. media','Plantae','Orchidaceae','tall sun orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra nuda','Plantae','Orchidaceae','scented sun orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra pauciflora','Plantae','Orchidaceae','slender sun orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra purpurata','Plantae','Orchidaceae','wallum sun orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra sp. (Toy Creek P.I.Forster+ PIF21217)','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra x merraniae','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra x truncata','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelypteris confluens','Plantae','Thelypteridaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thinornis rubricollis','Animalia','Charadriidae','Hooded Plover');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thrixspermum congestum','Plantae','Orchidaceae','Cupped Hairseed');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thrixspermum platystachys','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tmesipteris lanceolata','Plantae','Psilotaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachoma papuanum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachoma speciosum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachoma stellatum','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachoma','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene scapigera','Plantae','Apiaceae','Mountain Trachymene');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triaenodes resima','Animalia','Leptoceridae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triaenodes uvida','Animalia','Leptoceridae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trichoglottis australiensis','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triunia robusta','Plantae','Proteaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turdus poliocephalus','Animalia','Muscicapidae','Island Thrush');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turnix melanogaster','Animalia','Turnicidae','Black-breasted Button-quail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turnix olivii','Animalia','Turnicidae','Buff-breasted Button-quail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Typhonium brownii','Plantae','Araceae','Typhonium brownii');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tyto capensis','Animalia','Tytonidae','Grass Owl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tyto longimembris','Animalia','Tytonidae','Eastern Grass Owl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tyto novaehollandiae','Animalia','Tytonidae','Masked Owl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tyto tenebricosa','Animalia','Tytonidae','Sooty Owl');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vanda hindsii','Plantae','Orchidaceae','Cape York vanda');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vanda','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vanilla planifolia','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Varanus keithhornei','Animalia','Varanidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Varanus semiremex','Animalia','Varanidae','rusty monitor');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Varanus storri','Animalia','Varanidae','Storr\'s monitor');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Victaphanta compacta','Animalia','Rhytididae','Otway Black Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Viola cleistogamoides','Plantae','Violaceae','Hidden Violet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vrydagzynea grayi','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vrydagzynea','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westriplectes angelae','Animalia','Leptoceridae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westriplectes pedderensis','Animalia','Leptoceridae','Caddisfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wodyetia bifurcata','Plantae','Arecaceae','foxtail palm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wollemia nobilis','Plantae','Araucariaceae','Wollemi Pine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wundacaenis flabellum','Animalia','Caenidae','Mayfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zeuxine oblonga','Plantae','Orchidaceae','Common Jewel Orchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zeuxine polygonoides','Plantae','Orchidaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zieria adenophora','Plantae','Rutaceae','Araluen Zieria');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zieria buxijugum','Plantae','Rutaceae','Box Range Zieria');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zieria formosa','Plantae','Rutaceae','Shapely Zieria');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zieria parrisiae','Plantae','Rutaceae','Parris\' Zieria');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zosterops albogularis','Animalia','Zosteropidae','White-chested White-eye');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zosterops natalis','Animalia','Zosteropidae','Christmas Island White-eye');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zosterops tenuirostris','Animalia','Zosteropidae','Slender-billed White-eye');

-- WA Flora
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abutilon pritzelianum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abutilon sp. Hamelin (AM Ashby 2196)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abutilon sp. Quobba (H Demarz 3858)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abutilon sp. Warburton (AS George 8164)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abutilon sp.Cape Range (A.S. George 1312)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abutilon trudgenii ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abutilon uncinatum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia acanthoclada subsp. glaucescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia adinophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia aemula subsp. aemula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia alata var. platyptera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia alexandri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ampliata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia amyctica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia anarthros','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ancistrophylla var. perarcuata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia anomala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia aphanoclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia aphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia aprica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia arcuatilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia argutifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia aristulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ascendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia asepala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ataxiphylla subsp. ataxiphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ataxiphylla subsp. magna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia atopa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia auratiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia auricoma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia auripila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia awestoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia balsamea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia barrettiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia bartleana ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia benthamii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia bifaria','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia botrydion','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia brachyphylla var. recurvata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia brachypoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia bromilowiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia browniana var. glaucescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia burrowsiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia caesariata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia calcicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia campylophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia carens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia carnosula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia castanostegia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cerastes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia chapmanii subsp. australis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia chapmanii subsp. chapmanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia clydonophora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cochlocarpa subsp. cochlocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cochlocarpa subsp. velutinosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cockertoniana ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia concolorans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia congesta subsp. cliftoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia congesta subsp. wonganensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cowaniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia crenulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cummingiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cuneifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cylindrica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia cyperophylla var. omearana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia daweana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia declinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia deflexa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia deltoidea subsp. ampla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia denticulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia depressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia desertorum var. nudipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia diallaga','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia diaphana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia dictyoneura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia didyma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia diminuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia dissona var. indoloria','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia disticha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia dorsenna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia drepanophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia drewiana subsp. minor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia drummondii subsp. affinis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia drummondii subsp. elegans Porongurup variant (RJ Cumming 938)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia dura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia durabilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia effusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia empelioclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia epacantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia epedunculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia eremophila numerous-nerved variant','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia eremophila var. variabilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia errabunda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia euthyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia fecunda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia filifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia flabellifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia flagelliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia formidabilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia forrestiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia gelasina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia gemina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia glaucissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia glaucocaesia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia gloeotricha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia graciliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia grisea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia guinetii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia heterochroa subsp. heterochroa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia heterochroa subsp. robertii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia heteroclita subsp. valida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia horridula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia hystrix subsp. continua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia imitans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia imparilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia improcera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia incanicarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia inceana subsp. conformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia inceana subsp. latifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia inophloia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia inops','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia insolita subsp. efoliolata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia insolita subsp. recurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia isoneura subsp. isoneura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia isoneura subsp. nimia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia kalgoorliensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia karina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia kenneallyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia kerryana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia kimberleyensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia kingiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lanceolata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lanei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lanuginophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia laricina var. crassifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lasiocarpa var. bracteolata long peduncle variant (GJ Keighery 5026)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lasiocarpa var. lasiocarpa Cockleshell Gully variant (EA Griffin 2039)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lateriticola glabrous variant (BR Maslin 6765)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia latipes subsp. licina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia leeuweniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia leioderma Fitzgerald River National Park variant (AS George 9922)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia leptalea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia leptoneura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia leptospermoides subsp. obovata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia leptospermoides subsp. psammophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia levata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lineolata subsp. multilineata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lirellata subsp. compressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lirellata subsp. lirellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lobulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia lullfitziorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia manipularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia megacephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia merrickiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia microneura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia moirii subsp. dasycarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia mooreana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia muriculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia mutabilis subsp. incurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia mutabilis subsp. rhynchophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia mutabilis subsp. stipulifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia nigripilosa subsp. latifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia nitidula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia nodiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia obesa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia octonervia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia oncinophylla subsp. oncinophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia oncinophylla subsp. patulifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ophiolithica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia papulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia paula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pelophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia phaeocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pharangites','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia phlebopetala var. phlebopetala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia phlebopetala var. pubescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pinguiculosa subsp. pinguiculosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia plautella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia plicata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia prismifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pritzeliana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia profusa ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pterocaulon','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pulchella var. reflexa acuminate bracteole variant (RJ Cumming 882)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pusilla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia pygmaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia recurvata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia repanda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia retrorsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia rhamphophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia richardsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ridleyana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia ryaniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia scalena','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sciophanes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sclerophylla var. pilosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sclerophylla var. teretiuscula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sclerosperma subsp. glaucescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sedifolia subsp. pulvinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia semicircinalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia semitrullata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia setulifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia simulans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia singula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Marble Bar (J.G. & M.H. Simmons 3499)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Bungalbin Hill (JJ Alford 1119)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Esperance (MA Burgman 1833b)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Goodlands (BR Maslin 7761) [aff. resinosa]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Jack Hills (R Meissner & Y Caruso 4)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Kalannie North (BR Maslin 7702) [aff. baxteri]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Kalannie North East (BR Maslin 7519) [aff. rigens]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Kulin (S Murray 504)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Manmanning (BR Maslin 7711) [aff. multispicata]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Mt Jackson (B Ryan 176)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Muggon Station (S Patrick & D Edinger SP 3235)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Nullagine (B.R. Maslin 4955)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Petruder Rocks (BR Maslin 7714) [aff. ancistrophylla]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sp. Ravensthorpe Range (BR Maslin 5463)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia speckii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia spectra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia splendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia stanleyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia startii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia stereophylla var. cylindrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia subflexuosa subsp. capillata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia subracemosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia subrigida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia subsessilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia subtiliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia sulcaticaulis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia synoria','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia tayloriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia telmica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia tetraneura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia tetraptera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia torticarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia trinalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia truculenta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia trulliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia tuberculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia undosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia unguicula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia varia var. parviflora villous variant (KM Allan 345)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia vassalii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia veronica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia vincentii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia vittata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia volubilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia websteri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia wilcoxii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia willingii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia wilsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acacia woodmaniorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acanthocarpus parviflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acanthocarpus rupestris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrostichum aureum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrotriche dura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrotriche parviflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrotriche patula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrotriche sp. Ravensthorpe (S. Kern et al. LCH 16953)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Actinoschoenus sp. C Kimberley Flora (P.G. Wilson s.n. 12/5/72)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Actinoschoenus sp. D Kimberley Flora (K.F. Kenneally 4789)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Actinostachys digitata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Actinotus rhomboideus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Actinotus sp. Walpole (JR Wheeler 3786)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Actinotus whicheranus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos cacomorphus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos cunninghamii x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos cygnorum subsp. chamaephyton','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos detmoldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos dobagii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos ellipticus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos eyrei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos filifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos glabrescens subsp. exasperatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos gracilipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos ileticos','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos labillardierei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos linearis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos pamela x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos pungens subsp. effusus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos pungens subsp. pungens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adenanthos velutinus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adiantum capillus-veneris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adiantum hispidulum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agonis undulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agrostocrinum scabrum subsp. littorale','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ailanthus triphysa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aldrovanda vesiculosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alexgeorgea ganopoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina eriochlamys subsp. grossa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina fibrosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina globosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina grevilleoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina hystricosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina ramosissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina tessellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Allocasuarina tortiramula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aluta aspera subsp. localis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aluta quadrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aluta teres','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alysicarpus major','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alysicarpus suffruticosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alyxia tetanifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amanita carneiphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amanita griseibrunnea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amaranthus centralis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amaranthus cuspidifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amorphophallus galbra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ampelopteris prolifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amperea micrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amperea protensa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amperea simulans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amphibromus vickeryae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amyema sp. Fortescue (M Trudgen 5358)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anacampseros sp. Eremaean (F Hort, J Hort & J Shanks 3248)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia amabile ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia annelsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia audax ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia auriculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia axilliflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia barbata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia bifida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia caerulea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia carinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia depressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia echinocephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia ferricola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia grandiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia hammersleyana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia jamesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia longifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia macranthera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia pinaster','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia redolens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia saxatilis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia setifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia sp. Mitchell River (BG Hammersley 925)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andersonia virolens ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angasomyrtus salina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus halophilus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus microcephalus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus micropodioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus prostratus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus sp. Altham (M.N. Lyons 2623)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Angianthus uniflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anigozanthos bicolor subsp. exstans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anigozanthos bicolor subsp. minor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anigozanthos humilis subsp. Badgingarra (SD Hopper 7114)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anigozanthos humilis subsp. chrysanthus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anigozanthos viridis subsp. terraspectans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthocercis fasciculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthocercis gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthocercis intricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthocercis sylvicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonium sp. Darling Range (F. Hort & B.Hort 2431)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthotium junciforme','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthotium junciforme subsp. Scott River (C Robinson 494)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthotroche myoporoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthotroche walcottii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aotus carinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aotus cordifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aotus franklandii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aotus lanea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aotus prosacris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aotus sp. Cunderdin (B.J. Lepschi et al. 3587)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apatophyllum macgillivrayi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphyllodium glossocarpum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphyllodium parvifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apium prostratum subsp. phillipii ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apodasmia ceramophila ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton hexatepalus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aponogeton kimberleyensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida calycina var. calycina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida dominii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida jerichoensis var. subspinulifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida kimberleyensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida lazaridis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida perniciosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida polyclados','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida ramosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aristida sciuroides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arnocrinum drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arnocrinum gracillimum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthropodium sp. Yenyenning (G.J. Keighery & N. Gibson 2957)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arthrostylis aphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium aethiopicum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asplenium obtusatum subsp. northlandicum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea arbuscula ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Bungalbin Hill (KR Newbey 8989)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Esperance (A Fairall 2431)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Fitzgerald (KR Newbey 10844)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Hopetoun area (A.S. George 10594)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Jerdacuttup (A Strid 21898)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Jyndabinbin Rocks (KR Newbey 7689)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Mt Dimer (C McChesney TRL4/72)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Mt Johnston (AR Annels 5645)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Red Hill (KR Newbey 8462)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astartea sp. Scott River (D Backshall 88233)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asteridea archeri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asteridea gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asterolasia drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asterolasia grandiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asterolasia nivea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asterolasia pallida subsp. hyalina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asterolasia sp. Kalgan River (S Barrett 1522)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astrebla lappacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma foliosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma microcalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma microphyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma pedicellatum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma recurvum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma sp. Cataby (EA Griffin 1022)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma sp. Fitzgerald (GJ Keighery 8376)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma sp. Grass Patch (AJG Wilson 110)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astroloma sp. Nannup (RD Royce 3978)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astus duomilius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Astus wittweri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atiplex eremitis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atriplex flabelliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atriplex lindleyi subsp. conduplicata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atriplex muelleri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atriplex sp. Yeelirrie Station (L. Trotter & A. Douglas LCH 25025)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atriplex spinulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Auranticarpa resinosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrostipa blackii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrostipa exilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrostipa geoffreyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrostipa juncifolia subsp. Southern River (B. J. Keighery 2160)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Backhousia sp. Prince Regent (W. O\'Sullivan & D. Dureau WODD 42)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea crassifolia var. icosandra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea crispiflora subsp. Corrigin (A.S. George 14431)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea crispiflora subsp. Ongerup (A Scougall & C Garawanta E35)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea decipiens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea grandibracteata subsp. Parker Range (K. Newbey 9270)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Baladjie (PJ Spencer 24)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Beringbooding (AR Main 11/9/1957)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Billeranga Hills (ME Trudgen 2206)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Blue Haze Mine (P.Armstrong 06/910)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Bulla Bulling (DJE Whibley 4648)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Bullfinch (K.R. Newbey 5838)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Bungalbin Hill (BJ Lepschi, LA Craven 4586)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Bunjil (BR Maslin 5067)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Bunney Road (S Patrick 4059)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Calingiri (F Hort 1710)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Crossroads (B.L. Rye & M.E. Trudgen 241186)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Darling Range (RJ Cranfield 1673)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Die Hardy Range (E Mattiske J91)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. East Yuna (R Spjut & C Edson 7077)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Elsewhere Road (ME Trudgen 5420','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Eujinyn (J Buegge D99)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Exclamation Lake (ME Trudgen 1524)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Forrestania (KR Newbey 1105)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Gibson (KR Newbey 11084)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Great Victoria Desert (AS Weston 14813)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Hatter Hill (KR Newby 3284)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Helena and Aurora Range (GJ Keighery 4424)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Hyden (JM Brown 141)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Jaurdi Station (LW Sage & F Hort 2229)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Kellerberrin (CA Gardner sn PERTH 03351009)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Koorda (WE Blackall 3371)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Lake Cronin (KR Newbey 9191)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. London Bridge (Trudgen 5393)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Melita Stn. (Pringle 2738)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Merredin (K.R. Newbey 2506)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Moora (R Bone 1993/1)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Morawa (MA Langley MA4177)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Mount Barloweerie (JZ Weber 5079)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Mt Gibbs (G.F. Craig 7031)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Mt Glasse (PG Wilson 5717)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Muntadgin (ET Bailey 231)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Narembeen (GJ Keighery & N Gibson 3010)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Narrogin (R Hnatiuk 780011)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Nolba (ME Trudgen MET21632)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. North Ironcap (RJ Cranfield 10580)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Parker Range (M Hislop & F Hort MH2968)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Paynes Find (S Patrick 1095)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Perenjori (JW Green 1516)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Perth Region (RJ Cranfield 444)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Pigeon Rocks (D Grace DJP 281)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Sandstone (CA Gardner s.n. 26 Oct 1963)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Sheoaks Rocks (ME Trudgen MET5452)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Stockton Road (ME Trudgen MET22077 & B Rye)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Tammin (R Coveny 8319 & B Habberley)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Tampia Hill (J.C. Anway 327)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Three Springs (ME Trudgen 5368)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Upper Swan (Miss M Eaton s.n. 1888)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Walkaway (AS George 11249)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Western Australia (Drummond s.n.)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Whelarra (AC Burns 7)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Wialki (GM Storr 4/10/1958)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Yacke Yackine Dam (KR Newbey 9195)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Youndegin Hill (AS George 15772)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea sp. Yuna (M Trudgen 2224)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea staminosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baeckea subcuneata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Balaustion microphyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia acanthopoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia aculeata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia acuminata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia anatona','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia arborea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia aurantia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia baxteri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia bella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia benthamiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia borealis subsp. elatior','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia brownii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia calophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia catoglypta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia chamaephyton','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia coccinea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia columnaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia comosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia concinna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia conferta var. parva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia corvijuga','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia cuneata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia cynaroides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia cypholoba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia dallanneyi subsp. agricola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia dallanneyi subsp. pollosta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia drummondii subsp. hiemalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia drummondii subsp. macrorufa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia echinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia elegans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia elegans Fraser Road variant (AC Burns 27)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia epica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia epimicta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia erythrocephala var. inopinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia fasciculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia foliolata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia foliosissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia formosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia fraseri var. crebra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia fraseri var. effusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia fraseri var. oxycedra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia fuscobractea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia goodii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia hirta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia hookeriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia horrida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia idiogenes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia insulanemorecincta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia ionthocarpa subsp. chrysophoenix','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia ionthocarpa subsp. ionthocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia kippistiana var. paenepeccata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia laevigata subsp. laevigata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia lepidorhiza','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia lullfitzii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia meganotia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia meisneri subsp. ascendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia micrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia mimica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia montana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia mucronulata subsp. retrorsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia nivea subsp. Morangup (M Pieroni 94/2)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia nivea subsp. uliginosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia nobilis subsp. fragrans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia occidentalis subsp. formosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia octotriginta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia oligantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia platycarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia plumosa subsp. denticulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia polycephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia porrecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia prionophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia prolata subsp. archeos','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia prolata subsp. calcicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia prolata subsp. prolata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia pseudoplumosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia pteridifolia subsp. inretita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia pteridifolia subsp. vernalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia recurvistylis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rosserae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rufa subsp. chelomacarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rufa subsp. flavescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rufa subsp. magna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rufa subsp. obliquiloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rufa subsp. pumila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rufa subsp. tutanningensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia rufistylis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia scabrella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia sclerophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia seminuda subsp. remanens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia seneciifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia serra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia serratuloides subsp. perissa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia serratuloides subsp. serratuloides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia sessilis var. cordata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia shanklandiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia solandri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia sphaerocarpa var. dolichostyla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia sphaerocarpa var. latifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia splendida subsp. macrocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia splendida subsp. splendida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia squarrosa subsp. argillacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia strictifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia subpinnatifida var. imberbis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia subpinnatifida var. subpinnatifida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia subulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia tortifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia tricuspis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia trifontinalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia undata var. undata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia undata var. splendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia verticillata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia viscida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia wonganensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banksia xylothemelia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Barbula ehrenbergii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beaufortia bicolor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beaufortia eriocephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beaufortia sp. column (JS Beard 8119) [aff. heterophylla]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bentleya diminuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bentleya spinescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bergia auriculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria apiculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria cinerea subsp. cinerea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria cockertonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria constellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria disciformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria gardneri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria lapdicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria lepidopetala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria physaphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria rostellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria similis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria simplex','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria sulcata var. truncata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beyeria villosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Billardiera drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blackallia nudiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blechnum indicum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blennospora doliiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blennospora phlegmatocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blumea pungens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia acanthoclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia adamsiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia anceps','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia baeckeacea subsp. patula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia barrettiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia capitata subsp. capitata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia capitata subsp. gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia clavata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia coriacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia corynophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia crassipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia crenulata subsp. crenulata var. angustifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia ericifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia exilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia fabianoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia filicifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia heterophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia humifusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia jucunda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia juncea subsp. juncea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia kalumburuensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia megastigma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia minutipinna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia oxyantha var brevicalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia oxyantha var oxyantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia pauciflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia penicillata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia ramosa subsp. lesueurana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia revoluta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia scabra subsp. attenuata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia scabra subsp. condensata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia sp. Location 4264 (R. Turner s.n.)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia tenuis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia tetragona','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia virgata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Boronia westringioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Borya longiscapa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Borya sp. Synnot Range (M.D. Barrett MDB 444)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Borya sp. Wheatbelt (A.S. George 16470)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Borya subulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea arcuata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea atrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea aurantiaca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea barrettiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea calcicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea celata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea concinna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea cucullata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea disticha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea divaricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea eremaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea flexuosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea inundata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea laxa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea modesta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea oxyclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea saxosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea simulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea sp. Frankland (EM Sandiford EMS896)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea sp. Jackson Range (G. Cockerton & S. McNee LCS 13614)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea spinosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bossiaea strigillosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriochloa decipens var. cloncurrensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachychiton acuminatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachychiton incanus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachychiton obtusilobus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachychiton tridentatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachychiton tuberculatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachychiton xanthophyllus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyloma delbi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyloma mogin','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyloma nguba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyloma sp. Forrestania White (M Hislop & F Hort MH2591)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyscias verecundus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyscome billardierei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyscome halophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachyscome sp. Wanna Munna Flats (S. van Leeuwen 4662)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachysema sp. Boulder Hill (G Wardell-Johnson 111)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachysola halganiacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brunonia sp. Long hairs (D.E. Symon 2440)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Buellia epigdea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbine pendula ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbostylis burbidgeae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Byblis gigantea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caesia rigidifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caesia setifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caesia sp. Ennuin (N. Gibson & M.N. Lyons 2737)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caesia sp. Koolanooka Hills (R. Meissner & Y. Caruso 78)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caesia viscida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia abbreviata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia arrecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia barbarella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia bryceana subsp. bryceana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia bryceana subsp. cracens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia busselliana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia caesarea subsp. maritima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia caesarea subsp. transiens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia christineae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia cristata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia dorrienii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia drakeoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia dundasiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia elegans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia erythrochila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia evanescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia excelsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia exstans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia graniticola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia granitora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia harringtoniae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia hoffmanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia huegelii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia integra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia interjacens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia lodgeana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia longicauda subsp. clivicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia longicauda subsp. rigidula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia longifimbriata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia luteola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia melanema','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia ornata x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia plicata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia postea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia procera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia speciosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia startiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia thinicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia triangularis x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia uliginosa subsp. patulens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia viridescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia voigtii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia wanosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia williamsiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caladenia winfieldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calamphoreus inflatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia dielsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia kalanniensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia porifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia sp. Coolcalalaya (G Keighery & N Gibson 698)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia sp. Kenwick (GJ Keighery 10905) [aff. composita]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia sp. Mt Clere (R.J. Dadd 5)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia sp. Piawaning (A.C.Beauglehole 12257)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calandrinia sp. Woodleigh (G.J. Keighery & N. Gibson 961)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calectasia browneana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calectasia cyanea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calectasia keigheryi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calectasia obtusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calectasia palustris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calectasia pignattiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calectasia sp. Pinjar (C Tauss 557)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calocephalus aervoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calocephalus beardii ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calochilus pruinosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus accedens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus affinis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus brevifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus crassus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus graniticus subsp. graniticus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus graniticus subsp. leptophyllus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus macrocarpus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus microcarpus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus pachystachyus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus pallidifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus robustus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus rupestris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus sp Junga (S.D. Hopper 1293)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus sp. Kundip (A.S. George & E.G.H. Oliver ASG 17657)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus sp. Mt Lindesay (BG Hammersley 439)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus sp. Scott River (RD Royce 84) [aff. crassus]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus sp. Whicher (BJ Keighery & N Gibson 230)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calothamnus superbus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calotis latiuscula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calotis sp. Perrinvale Station (R.J. Cranfield 7906)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calotis squamigera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calycopeplus marginatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calymperastrum latifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix acutifolia subsp. brevifolia ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix breviseta subsp. breviseta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix chrysantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix creswellii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix ecalycata subsp. brevis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix ecalycata subsp. ecalycata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix ecalycata subsp. pubescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix eneabbensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix erosipetala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix formosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix gomphrenoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix harvestiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix nematoclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix oncophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix parvivallis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix paucicostata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix pimeleoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix platycheiridia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix plumulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix praecipua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix pulchella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix purpurea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix simplex subsp. simplex','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix sp. Dragon Rocks (K Kershaw & L Kerrigan 2180)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix sp. Jingaring (Obbens, Davis & Sage LWS 1332)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix sp. Tutunup (GJ Keighery & N Gibson 2953)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix superba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix sylvana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix uncinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix verruculosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calytrix warburtonensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cardamine paucijuga','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carex tereticaulis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carpobrotus pulcher ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carpobrotus sp. Thevenard Island (MR White 050)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassinia arcuata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Catacolea enodis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caustis gigas ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caustis sp. Boyanup (GS McCutcheon 1706)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Centrolepis caespitosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Centrolepis cephaloformis subsp. murrayi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cephalotus follicularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamaescilla gibsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamaexeros longicaulis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium floriferum subsp. diffusum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium floriferum subsp. floriferum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium forrestii subsp. forrestii ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium forrestii subsp. orarium ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium griffinii ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium lullfitzii ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium marchantii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium roycei ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Bunjil (M.E. Ballingall 1970)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Cape Riche (C.A. Gardner 2153)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Coolcalalaya (A.H. Burbidge 4233)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Dryandra (D. Rose 446)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Hamersley (N McQuoid 379)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Koolyanobbing (V. Clarke 644)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Warriedar (A.P. Brown & S. Patrick APB 1100)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Waychinicup (D. Davidson s.n. PERTH 01486527)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Wongan Hills (B.H. Smith 1140)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Yalgoo (Y Chadwick 1816)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Yoongarillup (G.J. Keighery 3635)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp. Yuna (A. C. Burns 53)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamelaucium sp.Canna (G. Keighery s.n. PERTH 02236435)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cheyniana rhodella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex abortivus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex chaunocoleus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex gracilior','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex isomorphus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex jacksonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex leucoblepharus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex ornatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex reseminans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chordifex stenandrus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizandra multiarticulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema carinatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema circinale','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema humile','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema nervosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema reticulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema trigonum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema ulotropis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chorizema varium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Christella dentata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chthonocephalus muellerianus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chthonocephalus multiceps','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chthonocephalus oldfieldianus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chthonocephalus spathulatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chthonocephalus tomentellus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cladium procerum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cleome kenneallyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colcasia esculenta var. aquatilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coleanthera coelophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coleanthera virgata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colubrina asiatica var. asiatica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Comesperma acerosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Comesperma calcicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Comesperma griffinii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Comesperma lanceolatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Comesperma pallidum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Comesperma rhadinocarpum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Comesperma viscidulum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commelina sp. Roe River R.L. Barrett & M.D. Barrett RLB 4633)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commersonia adenothalia ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commersonia bivillosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commersonia microphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commersonia sp. Bindoon (CF Wilkins & F & J Hort CW 2155)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commersonia sp. Mt Groper (RJ Cranfield & D Kabay 9157)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum caeruleum subsp. contortum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum coerulescens subsp. coerulescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum densiflorum subsp. unicephalatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum eatoniae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum galeatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum paniculatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum quadripetalum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum scaposum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum sigmoideum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum sp. Scott River (Wittwer 1242)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum spectabile','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum toddii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conospermum undulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostephium magnum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostephium marchantiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostephium minus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostephium pungens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostephium uncinatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis albescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis bracteata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis caricina subsp. elachys','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis dielsii subsp. teres','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis lepidospermoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis micrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis misera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis pauciflora subsp. euryrhipis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis pauciflora subsp. pauciflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis rogeri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis seorsiflora subsp. Nyabing (A Coates s.n. 2/10/88)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis seorsiflora subsp. trichophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis setigera subsp. dasys','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conostylis wonganensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coopernookia georgei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corchorus capsularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corchorus congener','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corchorus sp. Barrow (B Clay & M Yardar s.n. 21.11.65)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corchorus trilocularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corybas limpidus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corymbia cadophora subsp. polychroma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corymbia chlorolampra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corymbia paractia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corynanthera flava','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Craspedia argillicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crassula colorata var. miriamiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crassula decumbens subsp. macrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crassula helmsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cratystylis centralis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crinum flaccidum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crinum sp. West Kimberley (J.A. Smith s.n. 7/1/1979)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crinum uniflorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crotalaria smithiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crotalaria spectabilis subsp. spectabilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra arbutiflora var. pygmaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra beverleyensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra congesta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra craigiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra crispula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra dielsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra exserta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra glabrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra glabriflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra imbricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra inconspicua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra intonsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra nola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra pendula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra polyclada subsp. polyclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra scoparia var. microcephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra sp. Ravensthorpe (GF Craig 6309)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptandra stellulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cucumis sp. Barrow Island (D.W. Goodall 1264)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cullen candidum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cuphonotus humistratus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyanicula fragrans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyanicula ixioides subsp. candida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyanicula ixioides subsp. ixioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathochaeta stipoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathochaeta teretifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathostemon sp. Dowak (JM Fox 86/271)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathostemon sp. Lake King (ME & ME Trudgen 1462)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyathostemon sp. Salmon Gums (B Archer 769)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cymbonotus preissianus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cynanchum sp. Hamersley (M Trudgen 2302)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyperus digitatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyperus flaccidus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyperus haspan subsp. haspan','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyperus sulcinux','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyperus victoriensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyphanthera odgersii subsp. occidentalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera anonyma ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera atriplicina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera decurrens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera deltoidea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera dielsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera eriantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera fitzgeraldensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera glabrescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera heteroptera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera krauseana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera metallorum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera orchardii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera plumosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera ramosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera restiacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera scaevolina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera sericantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera sp. Jurien (G. Lullfitz s.n. 10/7/1986)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera sp. Ravensthorpe (G.F. Craig 8277)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera tephrea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dampiera triloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia acerosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia apiculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia calothamnoides ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia carnea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia chapmaniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia collina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia divisa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia ferricola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia foetida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia hypericifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia leiostyla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia luehmannii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia macrostegia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia masonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia meeboldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia nubigena','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia oxylepis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia pimelioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia polycephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia polychroma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sanguinea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Billyacatting Hill (E Wittwer 1229)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Canna (R. Davis 11241)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Chiddarcooping (SD Hopper 6944) [aff. purpurea]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Dryandra (GJ Keighery 9295)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Gibson (RD Royce 3569)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Morawa (CA Gardner 2662) [aff. purpurea]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Mt Baring (KR Newbey 9775)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Mt Burdett (NG Marchant 80/42)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Mt Ney (MA Burgman & S McNee 1274)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Mt Ragged (S Barrett 663)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Peak Charles (AS George 10627)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Thumb Peak (KR Newbey 4847) [aff. diosmoides]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Wandering (F. Hort 3273)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Westdale (F Hort 864)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia sp. Wyalgima Hill (L.W.Sage et al LWS 1549)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia squarrosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia thymoides subsp. St Ronans (J.J. Alford & G.J. Keighery 64)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia whicherensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darwinia wittwerorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia arthropoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia bursarioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia campephylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia chapmanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia crassa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia cunderdin','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia debilior subsp. debilior','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia debilior subsp. sinuans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia dielsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia elongata subsp. elongata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia elongata subsp. implexa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia epiphyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia eremaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia euphorbioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia glossosema','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia lineata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia megacalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia mesophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia microcarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia microphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia obovata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia oppositifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia ovata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia oxylobium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia pauciflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia pleurophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia pseudaphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia pteroclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia purpurascens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia rhizomata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia sarissa subsp. redacta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia smithiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia speciosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia spiralis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia tortuosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daviesia uncinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Decaschistia byrnesii subsp. lavandulacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Degelia flabellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrolobium cheelii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dentella pulvinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmocladus biformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmocladus elongatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmocladus glomeratus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmocladus semiplanus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmodium campylocaulon','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmodium flagellare','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmodium pullenii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Deyeuxia drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Deyeuxia inaequalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicarpidium sp. A Kimberley Flora (K. F. Kenneally 8686)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicarpidium sp. B Kimberley Flora (G.J. Keighery 10138)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dichanthium annulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicladanthera glabra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis archeri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis capitellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis corymbosa narrow-leaved variant (CA Gardner s.n. Dec 1926)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis cundeeleensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis exsuccosa subsp. wilsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis gilesii var. bagotensis forma brevipila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis gilesii var. bagotensis forma irregularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis gilesii var. laxa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis incana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis linearifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis micrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis microphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis mitchellii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis morrisonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis nicholasii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis obovata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis reticulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis sp. Cue (AA Mitchell 764)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis sp. Denham (M Lewis 42/92)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis subterminalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dicrastylis velutina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dillwynia acerosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dillwynia dillwynioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dillwynia sp. Capel (P.A. Jurjevich 1771)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diocirea acutifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diocirea microphylla ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diocirea ternata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplolaena andrewsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplopeltis sp. Wooroloo (B Rowley & S Beck s.n. 28.9.90)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dithyrostegia gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris eburnea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris heberlei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris micrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris purdiei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuris recurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dodonaea amplisemina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dodonaea hackettiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dodonaea hexandra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dodonaea scurra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dodonaea trifida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Doodia caudata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drakaea andrewsiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drakaea concolor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drakaea confluens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drakaea elastica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drakaea isolata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drakaea micrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drepanocladus aduncus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera allantostigma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera binata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera enodes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera fimbriata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera gibsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera graniticola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera grievei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera marchantii subsp. marchantii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera marchantii subsp. prophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera occidentalis subsp. occidentalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera pedicellaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera salina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera sewelliae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drosera sidjamesii x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drummondita ericoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drummondita fulva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drummondita longifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drummondita miniata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drummondita rubroviridis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drummondita sp. Trayning (AM George 97)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drummondita wilsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryandra sp. 31 (AS George 16754) [aff. conferta]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryandra sp. Fitzgerald (M Burgman s.n.) [aff. pteridifolia]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Echinochloa kimberleyensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Echinopogon ovatus var. pubiglumis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eclipta sp. Perth (S. Lloyd s.n. 3/4/1998)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ectrosia lasioclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elachanthus pusillus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elatine macrocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eleocharis acutangula subsp. acutangula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eleocharis keigheryi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eleocharis ochrostachys','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eleocharis papillosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eleocharis philippinensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enekbatus bounites','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enekbatus cristatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enekbatus dualis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enekbatus longistylus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enekbatus planifolius ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enekbatus roseus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enteropogon minutus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epiblema grandiflorum var. cyaneum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epitriche demissus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis confertiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis crateriformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis filicaulis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis lanicaulis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis petraea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis rigidiuscula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis schultzii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis sp.Mt Robinson (S.van Leeuwen 4109)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eragrostis spartinioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremaea acutifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremaea asterocarpa subsp. brachyclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremaea blackwelliana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremaea sp. Cairn Hill (B. Morgan 532)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremaea violacea subsp.Dobaderry Swamp (M.E. Trudgen 3909)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila accrescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila adenotricha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila annosocaulis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila anomala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila appressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila arachnoides subsp. arachnoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila arachnoides subsp. tenera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila arguta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila attenuata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila aureivisca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila biserrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila brevifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila caerulea subsp. merrallii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila caespitosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila campanulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila chamaephila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila ciliata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila coacta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila complanata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila compressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila conferta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila congesta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila cryptothrix','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila cuneata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila decussata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila demissa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila dendritica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila denticulata subsp. denticulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila denticulata subsp. trisulcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila eversa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila fasciata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila flaccida subsp. attenuata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila forrestii subsp. capensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila forrestii subsp. Pingandy (M.E. Trudgen 2662)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila forrestii subsp. viridis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila glabra subsp. chlorella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila glabra subsp. Kokeby (R. Davis 5080)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila glabra subsp. psammophora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila glabra subsp. Scaddan (C Turley sn 2005)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila glabra subsp. York (P.G. Wilson 12172 B)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila graciliflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila gracillima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila grandiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila hillii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila humilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila koobabbiensis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila lactea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila lanata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila lucida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila maculata subsp. filifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila magnifica subsp. magnifica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila magnifica subsp. velutina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila micrantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila microtheca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila mirabilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila muelleriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila nivea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila obliquisepala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila oblonga','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila occidens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila ostrina ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila pallida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila parvifolia subsp. auricampa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila parvifolia subsp. parvifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila pensilis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila perglandulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila petrophila subsp. densa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila physocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila pilosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila pinnatifida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila praecox','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila prolata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila pungens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila purpurascens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila pustulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila racemosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila recurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila resinosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila retropila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila revoluta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila rhegos','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila rigens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila rigida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila ringens ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila rostrata subsp. rostrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila rostrata subsp. trifida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sargentii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila scaberula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila serpens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila shonae subsp. diffusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila simulans subsp. megacalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp. Fitzgerald River (CJ Robinson 928)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp. Lake Magenta (MS Graham s.n. 7/3/90) [aff. serpens]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp. Mt Jackson (GJ Keighery 4372)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp. Ophthalmia Range (D Brearley sn 20/3/2004)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp. Tallering (J.D. Start & M.J. Greeve D516)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp. West Angelas (S. van Leeuwen 4086)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp. Zanthus (J.D. Start & M.J. Greeve D 8-25)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp.Beverley (K. Kershaw KK 2438)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila sp.Snowy Mountain (S. van. Leeuwen 3737)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila splendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila spongiocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila subteretifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila succinea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila tenella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila ternifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila undulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila veneta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila vernicosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila veronica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila verticillata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila virens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila viscida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila viscimarginata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila warnesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eremophila youngii subsp. lepidota','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne armitii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne burkettii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne filiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne imbricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne minuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne scleranthoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne semiciliata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne sp. Carson Escarpment (R.L. Barrett & M.D. Barrett RLB 4884)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne sp. Hamersley Range hilltops (S.van Leeuwen 4199)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne sp. Mitchell Plateau (M.D. Barrett & R.L. Barrett MDB 1517)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne sp. Morgan River (R.L. Barrett & M.D. Barrett RLB 3282)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne sp. North Kimberley (M.D. Barrett & R.L. Barrett MDB 1779)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne sp. Theda (R.L. Barrett & M.D. Barrett RLB 3275)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriachne tenuiculmis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriocaulon inapertum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriocaulon patericola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriocaulon sp. E Kimberley Flora (A.S. George 12635)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriocaulon sp. Theda (M.D. Barrett MDB 203)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriochilus dilatatus subsp. orientalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriochilus pulchellus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriochilus scaber subsp. orbifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriochloa fatmensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erpodium coronatum var. australiense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erymophyllum hemisphaericum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eryngium ferox ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eryngium pinnatifidum subsp. palustre ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eryngium pinnatifidum subsp. umbraphilum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eryngium sp. Lake Muir (E Wittwer 2293)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eryngium subdecumbens ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus abdita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus absita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus absita x loxophleba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus acies','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus angularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus annuliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus aquilina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus arachnaea subsp. arrecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus arborella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus argutifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus articulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus aspersa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus astringens x occidentalis subsp. redacta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus balanites','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus balanopelex','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus beardiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus bennettiae x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus blaxellii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus brachyphylla x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus brandiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus brevipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus brevistylis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus brockwayi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus buprestium x erectifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus buprestium x ligulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus buprestium x marginata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus buprestium x staeri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus burdettiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus caesia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus caesia subsp. magna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus calcicola subsp. calcicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus calcicola subsp. unita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus calyerup','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus carnabyi x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus ceracea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus cerasiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus chrysantha x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus clivicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus coronata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus creta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus crispata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus crucis subsp. crucis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus crucis subsp. praecipua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus cuprea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus deflexa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus delicata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus depauperata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus desmondensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus dielsii x platypus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus diminuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus distuberosa subsp. aerata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus dolichorhyncha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus dolorosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus ebbanoensis subsp. photina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus educta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus erectifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus erythrandra x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus exigua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus exilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus famelica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus fitzgeraldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus foecunda subsp. Coolimba (MIH Brooker 9556)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus foliosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus formanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus fraseri subsp. melanobasis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus frenchiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus gardneri subsp. ravensthorpensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus georgei subsp. fulgida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus georgei subsp. georgei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus goniantha subsp. goniantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus griffithsii subsp. Widgiemooltha (CA Gardner B1674)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus histophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus impensa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus insularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus jimberlanica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus johnsoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus jutsonii subp. kobela','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus jutsonii subsp. jutsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus kalganensis x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus kenneallyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus kruseana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus latens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus lateritica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus leprophloia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus ligulata subsp. ligulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus ligulata subsp. stirlingica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus litorea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus loxophleba x wandoo','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus lucens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus macrocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus macrocarpa subsp. elachantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus macrocarpa x pyriformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus marginata subsp. elegantella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus marginata x megacarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus marginata x pachyloma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus marginata x preissiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus mcquoidii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus melanophitra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus merrickiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus microschema','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus mimica subsp. continens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus mimica subsp. mimica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus misella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus missilis x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus mooreana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus mundijongensis x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus myriadena subsp. parviflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus nigrifunda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus nutans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus oleosa subsp. corvina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus olivacea ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus ordiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus ovularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus pendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus phenax subsp. compressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus phylacis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus pilbarensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus pimpiniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus platydisca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus praetermissa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus preissiana subsp. lobata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus preissiana x staeri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus proxima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus pruiniramis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus pterocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus purpurata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus quaerenda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus rameliana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus recta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus relicta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus retusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus rhodantha var. petiolaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus rhodantha var. rhodantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus rhomboidea ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus rudis subsp. cratyantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus rugulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sargentii subsp. fallens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sargentii subsp. onesia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus semiglobosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus semota','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sinuosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sp. Esperance (ME French 1579)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sp. Marandoo (M Trudgen 10362) [aff. coolibah var. rhodoclada]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sp. Mukinbudin (D.Nicole & M. French DN 3486)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sp. Wagerup (L. Johnson 9127 & B. Briggs)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sp. Wedge Hill (SD Hopper 2170)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sparsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sparsicoma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus spathulata subsp. salina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus spreta ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus steedmanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus stoataptera x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus stoatei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus striaticalyx subsp. delicata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus subangusta subsp. virescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus suberea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus surgens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus sweedmaniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus synandra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus varia subsp. salsuginosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus vesiculosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus virginea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus websteriana subsp. norsemanica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eucalyptus zopherophloia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euchiton collinus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia clementii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia inappendiculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia parvicaruncula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia sarcostemmoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia sp. Mt Bruce Flats (S. van Leeuwen 3861)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia stevenii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphrasia scabra','Plantae','Scrophulariaceae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euryomyrtus ciliata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euryomyrtus inflata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euryomyrtus leptospermoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euryomyrtus patrickiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euryomyrtus recurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eutaxia acanthoclada ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eutaxia actinophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eutaxia andocada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eutaxia lasiocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eutaxia nanophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eutaxia rubricarina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fabronia hampeana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ficus leucotricha var. sessilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ficus lilliputiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ficus obliqua var. puberula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis dictyocolea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis laxiglumis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis pachptera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis pilifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis rupestris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sieberiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. Bachsten Creek (M.D. Barrett MDB 695)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. D Kimberley Flora (A.C. Bueglehole 52448)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. E Kimberley Flora (C.R. Dunlop 5403)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. G Kimberley Flora (A.C. Bueglehole 51810)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. H Kimberley Flora (Carr 3944 & Bueglehole 47722)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. I Kimberley Flora (R.J. Hnatiuk 112)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. King Edward Falls (M.D. Barrett MDB 2205)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. L Kimberley Flora (K.F. Kenneally 11167)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis sp. Shay Gap (KR Newbey 10293)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fimbristylis subaristata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fitzwillia axilliflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Flaveria australasica subsp. gilgai','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Flaveria sp. Tom Price (M Trudgen 11246)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia brachyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia bracteata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia conferta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia confusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia decurrens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia georgei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia glomerata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia parvula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankenia sp. Southern gypsum (M.N. Lyons 2864)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Franklandia triaristata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fuirena incrassata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fuirena nudiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gahnia sclerioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gahnia sp. Grass Patch (MA Burgman 4431)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Galium leptogonium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gardenia gardneri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gardenia sericea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium acrocaroli','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium alternifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium appressum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium axillare','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium brownii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium callistachys','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium crenulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium crispatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium cruciatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium densifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium diabolophyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium effusum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium elegans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium euryphyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium ferrugineum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium formosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium glabratum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium glaucum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium graniticum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium hamulosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium heterophyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium hians','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium humile','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium involutum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium leakeanum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium lehmannii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium luteifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium modestum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium mondurup','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium nudum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium ovalifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium papilio','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium propinquum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium pycnostachyum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium rigidum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium rotundifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium semiteres','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium sp. crenulatum capitate (E & S Pignatti 1588)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium sp. East Peak (ED Middleton EDM43)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium sp. Harvey (G.J. Keighery 16821)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium sp. Prostrate Boddington (M.Hislop 2130)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium sp. Yoongarillup (S Dilkes s.n. 1/9/1969)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium spectabile','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium stenophyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium stipulare','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium subcordatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium tenue','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium tergiversum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium tomentosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium vestitum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium whicherense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gastrolobium wonganense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geijera salicifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geleznowia verrucosa subsp. Kalbarri (L.M. Broadhurst 123)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geleznowia verrucosa subsp. verrucosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Genus sp. Hamersley Range hilltops (S van Leeuwen 4345)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Georgeantha hexandra ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glossostigma trichodes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glyceria drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glycine albicans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glycine falcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glycine lactovirens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glycine pindanica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glycine sp. Pitta Creek (M.D. Barrett 1201)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnephosis cassiniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnephosis intonsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnephosis multiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnephosis setifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnephosis sp. Billabong (B Noldenstam and A Anderberg 203)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnephosis sp. Norseman (KR Newbey 8096)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gompholobium cinereum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gompholobium gairdnerianum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gompholobium roseum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gompholobium wonganense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gomphrena cucullata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gomphrena Leptophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gomphrena pusilla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus benthamii subsp. Stirling (CJ Robinson 1080)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus ephemerus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus ericifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus hispidus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus intricatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus pusillus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus pycnostachyus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus rudis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus simplex','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonocarpus trichostachyus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia anfracta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia arthrotricha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia berringbinensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia brachypoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia byrnesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia corralina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia crenata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia drummondii subsp. megaphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia durackiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia filiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia gibbosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia gloeophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia grandiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia granitica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia hartiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia heatheriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia integerrima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia inundata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia jaurdiensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia katabudjar','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia laevis subsp. laevis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia lunata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia lyrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia modesta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia neogoodenia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia nuda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia pallida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia pascua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia pedicellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia perryi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia phillipsiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia psammophila subsp. hiddinsiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia psammophila subsp. psammophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia purpurascens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia pusilliflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia quadrilocularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia salina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia salmoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia scapigera subsp. graniticola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia schwerinensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia sepalosa var. glandulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia sericostachya','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia sp. East Pilbara (AA Mitchell PRP 727)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia sp. Pilbara calcrete (A.A. Mitchell PRP 1436)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia sp. South Coast (AR Annels 1846)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia stellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia stenophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia strangfordii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia suffrutescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia trichophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia turleyae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia varia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia virgata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goodenia xanthotricha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gossypium enthyle','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gossypium marchantii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gossypium pilosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gossypium pulchellum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grammosolen sp. Mt Ridley (W.R. Archer 1210911)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gratiola pedunculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea acropogon','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea adenotricha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea althoferorum subsp. althoferorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea althoferorum subsp. fragilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea aneura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea annulifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea asparagoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea aspera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea asteriscosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea batrachioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea baxteri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea biformis subsp. cymbiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea bipinnatifida subsp. pagna ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea brachystylis subsp. australis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea brachystylis subsp. brachystylis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea brachystylis subsp. Busselton (GJ Keighery s.n. 28/8/1985)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea bracteosa subsp. bracteosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea bracteosa subsp. howatharra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea bronwenae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea calcicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea calliantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea candicans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea candolleana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea christineae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea cirsiifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea coccinea subsp. lanata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea corrugata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea costata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea crowleyae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea curviloba subsp. curviloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea curviloba subsp. incurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea delta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea dissecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea donaldiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea dryandroides subsp. dryandroides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea dryandroides subsp. hirsuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea elongata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea endlicheriana subsp. Wongan Hills (G.J. Keighery 15351)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea erectiloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea erinacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea eriobotrya','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea evanescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea fastigiata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea fililoba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea fistulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea flexuosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea florida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea fulgens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea fuscolutea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea georgeana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea globosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea granulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea haplantha subsp. recedens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea hirtella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea hislopii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea humifusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea inconspicua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea infundibularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea insignis subsp. elliotii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea involucrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea kenneallyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea kirkalocka','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea latifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea leptopoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea lissopleura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea lullfitzii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea maccutcheonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea makinsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea manglesii subsp. dissectifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea manglesii subsp. ornithopoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea manglesioides subsp. ferricola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea marriottii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea maxwellii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea metamorpha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea miniata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea minutiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea murex','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea nana subsp. abbreviata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea nivea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea olivacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea papillosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea patentiloba subsp. platypoda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea phanerophlebia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea phillipsiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea pilosa subsp. redacta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea pimeleoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea pinifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea plurijuga subsp. superba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea prominens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea prostrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea psilantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea punctata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea pythara','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea rara','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea ripicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea rogersoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea rosieri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea roycei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea rudis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea saccata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea scabra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea scabrida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea scapigera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea secunda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea sp. Gunapin (F. Hort 305)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea sp. Harrismith (GJ Keighery & N Gibson 7094)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea sp. Ocean Reef (D. Pike Joon 4)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea sp. Stirling Range (DJ McGillivray 3488 & AS George)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea sp. Toodyay West (F. Hort et al. 3296)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea sp. Trayning (W. Johnston WJ 071)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea spinosissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea squiresiae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea stenogyne','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea stenomera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea stenostachya','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea subterlineata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea subtiliflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea sulcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea synapheae subsp. A Flora of Australia (SD Hopper 6333)]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea synapheae subsp. Minyulo','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea tenuiloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea tetrapleura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea thelemanniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea Thelemanniana subsp. Cooljarloo (B.J. Keighery 28 B)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea thyrsoides subsp. pustulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea thyrsoides subsp. thyrsoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea triloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea uniformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grevillea wittweri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia alba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia anota','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia apetala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia asteriskos ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia glandulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia impudica ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia quasicalva ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia seorsiflora ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guichenotia tuberculata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gunniopsis divisa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gunniopsis propinqua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gunniopsis rubra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gunniopsis sp. Fortescue (M Trudgen 11019)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gunniopsis sp. Nuytsland (G.J. Keighery & J.J. Alford 522)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gymnanthera cunninghamii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostemon ditrigynus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostemon prostratus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostemon reticulatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostemon sessilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostemon sp. Bandalup (G Cockerton & N Evelegh 7751)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostemon sp. Ravensthorpe (G Cockerton & N Evelegh 9467)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haegiela tatei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haemodorum gracile','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haemodorum loratum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haemodorum sp. Gardner Plateau (R.L. Barrett & M.D. Barrett RLB 1008)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haemodorum sp. Prince Regent River (M.D. Barrett MDB 1185)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea aculeata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea acuminata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea bicornata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea brachyptera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea chromatropa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea crassinervia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea cygna subsp. needlei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea hookeriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea lasiocarpha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea longiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea megalosperma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea myrtoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea neurophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea oldfieldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea oligonuera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea pendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea polyanthema','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea rigida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea serrata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea sp. Walyunga (L Penn s.n.) [aff. lasiantha]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea sp. Williamson (BJ Keighery & N Gibson 226)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea spathulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hakea tuberculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Halgania corymbosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Halgania gustafsenii var. Murchinson (R. Meissner & B. Bayliss 743)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Halgania sp. Peak Eleanora (M.A. Burgman 3547 B)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Halgania tomentosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haloragis aculeolata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haloragis foliosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haloragis platycarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haloragis scoparia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haloragis sp. Ravensthorpe (KR Newbey 8269)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haloragodendron glandulosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Halosarcia koobabbiensis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Harnieria kempeana subsp. rhadinophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Harperia confertospicata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Harperia eyreana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Harperia ferruginipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helichrysum oligochaetum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heliotropium murinum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heliotropium muticum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heliotropium parviantrum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helminthostachys zeylanica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiandra australis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiandra bellairsiana ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiandra coccinea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiandra gardneri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiandra hancocksiana ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiandra rutilans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiandra sp. Eneabba (H Demarz 3687)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia brachyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia conferta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia curvifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia dulca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia exilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia glabrescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia microphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia obovata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia obtusa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia pachyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia pimelifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia platyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia podalyrina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia ramosissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia rigida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia saligna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia sp. Tallering (H. Pringle 3323)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia sp. Three Springs (S. Patrick 4043 A)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia tenelliflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia tysonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia virescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemigenia viscida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hensmania chapmanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hensmania stoniella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterachne gulliveri var. major','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia abyssa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia acrotrichion','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia argentea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia atrichosepala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia axillibarba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia carinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia charlesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia chartacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia fitzgeraldensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia glaberrima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia glabriuscula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia glomerata subsp. ginginensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia glomerata subsp. wandoo','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia glomerosa var. bistrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia graniticola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia hamata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia helianthemoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia lepidocalyx subsp. tuberculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia miniata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia montana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia pachyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia papillata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia porongurupensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia priceana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia propinqua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia silvestris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia spicata subsp. leptotheca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibbertia turleyana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibiscus brachysiphonius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalocalyx chapmanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalocalyx echinulatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalocalyx grandiflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalocalyx inerrabundus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hopkinsia adscendens ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hopkinsia anoectocolea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hyalosperma stoveae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hybanthus cymulosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hybanthus floribundus subsp. chloroxanthus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hybanthus volubilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydatella leptogyne','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydatella sessilis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle coorowensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle coraginaensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle corynophora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle decipiens ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle grammatocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle hamelinensis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle hexaptera ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle lemnoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle muriculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle sp. Truslove (MA Burgman 4419)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle sp. Warriedar (PG Wilson 12267)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle striata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrocotyle vigintimilia ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hygrochloa aquatica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma connatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma cordifolium subsp. minus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma gardneri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma linifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma longifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma melaleucoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma phillipsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma puniceum subsp. Cadoux (H Demarz 10533)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma serrulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma sp. Cascade (R. Bruhn 20896)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma sp. Cataby (GJ Keighery 5151) [aff. tetrapterum]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma sp. Dandaragan (CA Gardner 9014)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma sp. Gairdner Range (CA Gardner 9091)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma sp.Tea Tree Road (O. Davies OD 171)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma sylvestre','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma tenuatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypocalymma tetrapterum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypolaena robusta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypoxis salina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypoxis sp. Beaufort (V. Crowley DKN629)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypoxis sp. Prince Regent River (M. D. Barrett 924 B)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indigofera ammobia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indigofera gilesii subsp. gilesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indigofera ixocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indigofera sp.Bungaroo Creek (S. van Leeuwen 4301)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Iotasperma sessilifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ipomoea sp. A Kimberley Flora (L.J. Penn 84)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ischaemum albovillosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ischaemum rugosum var. rugosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Iseilema trichopus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isoetes brevicula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isolepis australiensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isolepis hookeriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isolepis humillima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon alcicornis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon formosus subsp. dasylepis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon latifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon robustus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon sp. Badgingarra (A.S George 14200)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon sp. Brookton Hwy (H Demarz 444)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon sp. Canning Reservoir (M D Tindale 121 & BR Maslin)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon tridens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isopogon uncinatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isotropis canescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isotropis cuneifolia subsp. glabra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isotropis parviflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isotropis winneckei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia anthoclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia calycina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia carduacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia compressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia debilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia dendrospinosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia elongata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia epiphyllum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia gracillima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia intricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia jackson','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia lanicarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia pungens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia quairading','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia remota','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia rubra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia sericea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia sp. Badgingarra (H Demarz D6601) [sp. 14]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia sp. Hyden (JS Beard 3852) [sp.27]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia sparsa ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia tarinensis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia velutina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia velveta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacksonia venosa ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jacquemontia sp. Keep River (J.L. Egan 5051)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Johnsonia inconspicua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Johnsonia pubescens subsp. cygnorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Josephinia sp. Marandoo (M Trudgen 1554)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Juncus meianthus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kennedia beckxiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kennedia glabrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kennedia lateritia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Keraudrenia adenogyna ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Keraudrenia cacaobrunnea subsp. undulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Keraudrenia exastia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Keraudrenia katatona','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Keraudrenia saxatilis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kohautia australiensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Korthalsella arthroclada','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Korthalsella leucothrix','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kulinia eludens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea acicularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea cincinnata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea ericifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea ericifolia subsp. subulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea glabrescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea incognita ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea micrantha subsp. hirtiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea pauciflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea similis subsp. mediterranea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea similis subsp. similis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kunzea sp. Dragon Rocks (K. Kershaw 2184)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Labichea deserticola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Labichea eremaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Labichea obtrullata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lachnostachys ferruginea var. ferruginea forma reticulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lachnostachys ferruginea var. paniculata forma obtusifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lachnostachys ferruginea var. paniculata forma paniculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia echinata subsp. echinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia echinata subsp. occidentalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia fairallii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia multiflora var darlingensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia orbifolia subsp. orbifolia ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia orbifolia subsp. Scott River Plains (LW Sage 684)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia rariflora subsp. lutea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lambertia rariflora subsp. rariflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum bracteatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum cardiophyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum dielsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum fitzgibbonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum glabratum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum lineare','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum maxwellii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum membranaceum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum membraniflorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum monticola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum ogilvieanum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum oldfieldii subsp. biloculatum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum oldfieldii subsp. oldfieldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum oppositifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum parvuliflorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum pterocarpum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum rotundifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum sp. Badgingarra (E.A. Griffin 5278)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum sp. Denmark (B.G. Hammersley 2012)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum sp. Desmond (N. McQuoid 653)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum sp. Hill River (T.N. Stoate 5)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum sp. Ironcaps (PG Wilson 7024)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum sp. Northam (F Hort 1196)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasiopetalum sp. Toodyay (F. Hort 2689)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Latrobea colophona','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Latrobea pinnacula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Latrobea recurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Laxmannia grandiflora subsp. brendae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Laxmannia grandiflora subsp. stirlingensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Laxmannia jamesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lecania sylvestris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lecania turicensis var. turicensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia acutiloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia aphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia chlorantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia divaricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia galactites','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia hortii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia juncea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia laricina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia longiloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia magnifica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia pulvinaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lechenaultia superba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium amelum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium aschersonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium biplicatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium catapycnon','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium desvauxii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium fasciculatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium genistoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium merrallii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium pseudohyssopifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium pseudotasmanicum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium puberulum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium sagittulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium scandens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium sp. Pannawonica (J.E. Wajon 1065)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidium xylodes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidobolus basiflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidobolus densus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidobolus deserti','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidobolus quadratus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidobolus spiralis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma amansiferrum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma bungalbin','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma diurnum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma ferricola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma ferriculmen','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma gahnioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma gibsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma jacksonense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma lyonsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma obtusum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma pruinosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma rostratum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma rupestre','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma sp. Billyacatting (S.D. Hopper 8630)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma sp. Blue Hills (A. Markey & S. Dillon 3468)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma sp. Koolanooka (K.R. Newbey 9336)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma sp. Moresby Range (R. J. Cranfield 2751)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosperma sp. Parker Range (N. Gibson & M. Lyons 2094)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptinella drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptomeria dielsiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptomeria furtiva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptomeria laxa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptomeria lehmannii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptospermum confertum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptospermum exsertum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptospermum macgillivrayi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptospermum sp. Bandalup Hill (G Cockerton 11001)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepturus copeanus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepturus repens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepturus xerophilus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepyrodia curvescens ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepyrodia extensa ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepyrodia fortunata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepyrodia heleocharoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon acicularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon alternifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon altissimus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon amplectens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon apiculatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon blepharolepis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon borealis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon bossiaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon bracteolaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon brevicuspis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon breviflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon compactus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon compressicarpus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon cryptanthus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon cymbiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon denticulatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon elegans subsp. psorophyllus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon florulentus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon gilbertii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon glaucifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon gnaphalioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon interruptus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon lasiophyllus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon marginatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon multiflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon obtectus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon oliganthus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon ozothamnoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon plumuliflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon pogonocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon polystachyus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon psammophilus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon psilopus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon remotus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon rotundifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon rugulosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Badgingarra (R Davis 421)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Barren Range (AS George 10092)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Bindoon (F Hort 2766)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Bonnie Hill (KR Newbey 9831)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Brookton (K.Kershaw & L.Kerrigan KK 2192)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Bungulla (RD Royce 3435)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. ciliate Eneabba (F Obbens & C Godden sn 3/7/2003','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Clyde Hill(MA Burgman 1207) [aff. breviflorus]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Collie (E.M. Bennett BUC 063)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Condingup (MA Burgman 1377) [aff. concinnus]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Coujinup (MA Burgman 1085)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Dudawa (M. Hislop & J. Borger MH 3829)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Flynn (F Hort, J Hort & A Lowrie 859)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Howatharra (D & N McFarland 1046)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Ironcaps (N Gibson & K Brown 3070)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Kambalda (J. Williams s.n. PERTH 07305028)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Kau Rock (MA Burgman 1126) [aff. allittii]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Kojarena (J. Brooker 232)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Moresby Range (S Patrick 2614)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Mount Heywood (MA Burgman 1211) [aff. hamulosus]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Munglinup (KR Newbey 8123)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Ongerup (AS George 16682)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Perth coastal (AS George 17305)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Port Gregory (C Page 33)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Tutanning (K Kershaw 2132)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sp. Yanchep (M. Hislop 1986)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon spectabilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon sulcatus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon tamariscinus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon validus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopogon wheelerae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Levenhookia octomaculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Levenhookia pulcherrima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lilaeopsis polyantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindernia macrosiphonia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lindsaea orbiculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liparis habenarina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lissanthe pleurandroides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lissanthe scabra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lissanthe synandra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Livistona alfredii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Livistona victoriae ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lobelia heterophylla subsp. Pilbara (R Meissner & Y Caruso 1)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Logania exilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Logania wendyae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lomandra ordii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lomandra whicherensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Loxocarya albipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Loxocarya gigas','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Loxocarya magna','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lyginia excelsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lygodium flexuosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lysinema elegans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lysinema lasianthum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lysiosepalum abollatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lysiosepalum aromaticum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lythrum paradoxum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lythrum sp. Towrana (RJ Cranfield 2183)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macarthuria apetala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macarthuria georgeana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macarthuria intricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macarthuria keigheryi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macarthuria sp. Harvey (MET Trudgen & A Tingay)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macropidia fuliginosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrothelypteris torresiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maireana murrayana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maireana prosthecochaeta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maireana sp. Patience (C. P. Campbell 1052)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Adelong (GJ Keighery 11825)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Cooljarloo (B Backhouse s.n. 16.11.88)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Cooloomia (SD Hopper 1353)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Erangy Springs (M Trudgen 12030)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Hardabutt Rapids (Bellairs 1654A)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Kalbarri (LA Craven 7083)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Moonyoonooka (RJ Cranfield 2947)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Mullewa (P Winson B7365)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Nerren Nerren (A Payne 360)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Officer Basin (D Pearson 350)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Unmade Road (Griffin 7537)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Woodacurrie Rd (S Patrick 3364)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Woolgorong Station (M Officer 100)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Yalgoo Road (Morawa Tree Committee 329)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malleostemon sp. Yerina (SJ Patrick 2728)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marianthus aquilonaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marianthus dryandra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marianthus granulatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marianthus mollis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marianthus paralius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marianthus sylvaticus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meeboldina crassipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meeboldina decipens subsp. decipens ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meeboldina decipens subsp. depilata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meeboldina scariosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meeboldina thysanantha ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meionectes tenuifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca agathosmoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca apostiba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca araucarioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca barlowii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca basicephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca boeophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca clavifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca cliffortioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca coccinea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca dempta ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca diosmifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca eximia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca filifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca fissurata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca grieveana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca huegelii subsp. pristicensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca huttensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca incana subsp. Gingilup (N Gibson & M Lyons 593)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca incana subsp. tenella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca macronychia subsp. trygonoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca manglesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca micromera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca nanophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca oldfieldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca ordinifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca papillosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca penicula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca polycephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca pomphostoma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca pritzelii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca ringens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sciotostyla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sclerophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sculponeata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sericea subsp. gracilis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca similis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sp. Kundip (GF Craig 6020)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sp. Ravensthorpe (MA Burgmen 4018)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sp. Wanneroo (G.J.Keighery 16705)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca sp. Yanchep (GJ Keighery 11242)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca stramentosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca tuberculata var. arenaria ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca viminea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melaleuca viminea subsp. appressa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Menkea draboides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Menkea lutea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mesomelaena stygia subsp. deflexa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Metzgeria decipiens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meziella trifida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micraira brevis subsp. brevis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micraira brevis subsp. Theda (M.D. Barrett 1505)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micraira sp. Harding Range (M.D. Barrett & R.L. Barrett MDB 1827)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micraira sp. Purnululu (M.D. Barrett & R.L. Barrett 1507)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys cephalantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys eremophiloides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys lenticularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys longiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys longifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys macredieana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys pimeleoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys sp. Boxwood (KR Newbey 4200)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys sp. Forrestania (V English 2004)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys sp. Stirling Range (S. Barrett 1392)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys sp. Tarin Rock (EJ Croxford 5251)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys tenuifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys virgata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcorys wilsoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcybe pauciflora subsp. grandis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microlepidium alatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus acuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus chrysodema','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus elobata subsp. scopula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus greeniana ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus helmsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus imbricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus navicularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus ninghanensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus papillosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus placoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus racemosa var. latifolia ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus racemosa var. mucronata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus redita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus rogeri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus rubricalyx ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus serrulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus sp. Arrowsmith River (LA Craven 6873 & C Chapman)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus stenocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus trudgenii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Micromyrtus uniovula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microseris scapigera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microsorum grossum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis globula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis pulchella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microtis quadrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia depauperata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia dimorpha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia falcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia jacksonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia pilosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia steetziana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Millotia tenuifolia var. laevis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mimulus clementii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mimulus repens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Minuria macrorhiza','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Minuria sp. Little Sandy Desert (S. van Leeuwen 4919)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Minuria tridens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirbelia cordifolia ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirbelia densiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirbelia sp. Helena & Aurora Range (BJ Lepschi 2003)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirbelia sp. Kalbarri (MD Crisp 6261)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirbelia stipitata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirbelia taxifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirbelia ternata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mitrasacme phascoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mitreola minima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monotaxis sp. Ravensthorpe (MA Burgman 2154)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monotoca aristata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monotoca leucantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Montia australasica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Muehlenbeckia horrida subsp. abdita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Muelleranthus crenulatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Muiriantha hassellii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Murchisonia fragrans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myoporum cordifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myoporum turbinatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myoporum velutinum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriocephalus appendiculatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriocephalus biflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriocephalus nudus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriocephalus scalpellus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriophyllum balladoniense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriophyllum callitrichoides subsp. striatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriophyllum costatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriophyllum echinatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriophyllum lapidicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myriophyllum petraeum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nemcia acuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nemcia alternifolia ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nemcia cyanophylla ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nemcia epacridoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nemcia sp. Ellen Peak (S Barrett 245)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nemcia sp. Mt Magog (S Barrett 55)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neotysonia phyllostegia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neurachne annularis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neurachne lanigera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Newcastelia insignis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nicotiana heterantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nicotiana umbratica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nymphoides beaglensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olax scalariformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olax spartea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oldenlandia sp. Hamersley Station (A.A. Mitchell PRP 1479)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olearia arida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olearia fluvialis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olearia laciniifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olearia mucronata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olearia newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olearia occidentissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ondinea purpurea subsp. petaloidea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Onychosepalum microcarpum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Onychosepalum nodatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Opercularia acolytantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Opercularia hirsuta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Opercularia loganioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Opercularia rubioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oplismenus hirtellus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orthrosanthus muelleri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Otion rigidum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Owenia acidula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oxalis sp. Pilbara (M.E. Trudgen 12725)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oxymyrrhine cordata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oxymyrrhine coronata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oxymyrrhine plicata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ozothamnus sp. Northampton (J Brooker & M Weir 913)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pachynema sp. Prince Regent (M.D. Barrett & R.L. Barrett 1342)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pandanus spiralis var. flammeus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Papistylus grandiflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Papistylus intropubens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracaleana alcockii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracaleana dixonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracaleana gracilicordata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracaleana granitica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracaleana parvula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parmeliopsis macrospora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parsonsia diaphanophleba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paspalidium distans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paspalidium retiglume','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Patersonia argyrea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Patersonia inaequalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Patersonia spirifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pentalepis sp. Mt House (E.M. Bennett 1877)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pentapeltis silvatica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pentapogon quadrifidus var. quadrifidus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peplidium sp. Fortescue marsh (S. van Leeuwen 4865','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pericalymma megaphyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia baeckeoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia brachystylis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia brevirhachis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia chapmaniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia cymbifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia filiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia hakeiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia kararae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia leucopogon','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia micranthera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia papillosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia pentasticha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia pungens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia rudis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia scabra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia sp. Peak Charles (K Newbey 6473)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Persoonia sulcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pertusaria trachyspora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile biternata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile chrysantha subsp. Watheroo (K.M. Allan 57)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile clavata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile crispata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile filifolia subsp. laxa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile latericola ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile longifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile nivea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile pauciflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile pilostyla subsp. syntoma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile plumosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile sp. Coorow (W.E. Blackall 2595)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile sp. Pithara (P. Armstrong s.n. PERTH 06592090)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile trifurcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrophile vana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phebalium appressum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phebalium brachycalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phebalium clavatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phebalium drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pheidochloa gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca apiculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca basistyla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca citrina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca coateana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca cymbiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca deserti subsp. brevifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca eremicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca falcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca gardneri subsp. Bandalup form (G Cockerton & A Kalotas 7259)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca gardneri subsp. globosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca gardneri subsp. Ravensthorpe (G.F. Craigh 6902)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca kalbarriensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca langei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca linearis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca nutans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca sp. Bremer Range (GF Craig 5909)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca sp. Mukinbudin (M. Hancook s.n. 08/09/1999)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca tubiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philotheca wonganensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philydrella pygmaea subsp. minima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phlebocarya pilosissima subsp. pilosissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phlebocarya pilosissima subsp. teretifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phlegmatospermum drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phlegmatospermum eremaeum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phlegmatospermum richardsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phragmites karka','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllangium palustre','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllanthus aridus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllanthus baeckeoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllanthus indigoferoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllanthus sp. D Kimberley Flora (C.R. Dunlop 5302)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllota gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Physopsis chrysophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Physopsis chrysotricha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Picris compacta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Picris drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Picris wagenitzii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pilbara trudgenii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pileanthus aurantiacus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pileanthus bellus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pilostyles collina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea ciliata subsp. longituba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea cracens subsp. glabra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea graniticola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea halophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea longiflora subsp. eyrei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea neokyrea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea pelinos','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea physodes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea rara','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea rosea subsp. annelsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pimelea sp. Tarin Rock (E.J. Croxford 2118)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pithocarpa achilleoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pithocarpa corymbulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pittosporum moluccanum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia augustensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia axillaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia canaliculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia chorisepala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia chrysocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia cuneata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia glutinosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia iphthima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia obliqua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia scabra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia sp. Dalwallinu (M Hislop 1860)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia sp. Yilgarn (AP Brown 2679)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityrodia viscida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Placynthium nigrum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plantago sp. Hamersley (M Trudgen 11207)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plantago sp. Kondinin hairy (M.N. Lyons 2917)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platychorda rivalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace cirrosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace dissecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace eatoniae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace filiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace haplosciadea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace ramosissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace saxatilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace sp. Kalbarri (D & B Bellairs 1383)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace sp. Kennedy (PG Wilson 8450)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platysace sp. Stirling (JM Fox 88/262)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platytheca anasima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platytheca sp. Sabina (G.J> & B.J. Keighery 295)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pleurophascum occidentale','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plumatichilos turfosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Poa billardierei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Podotheca pritzelii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Podotheca uniseta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polianthion biloculare','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polianthion collinum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polycarpaea sp. A Kimberley Flora (K.F. Kenneally 8887)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polymeria distigma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polymeria sp. Hamersley (ME Trudgen 11353)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomaderris grandis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomaderris paniculosa subsp. paralia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomax rupestris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Poranthera sp. Kings Park (RL Barrett 2958)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potamogeton crispus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potamogeton octandrus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prasophyllum paulineae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Proiphys alba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Proiphys amboinensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera carrickiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera centralis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera ferricola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera magnifica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera nanophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera pedicellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera petrophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera scutata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera splendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera tysoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostanthera verticillaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psammomoya implexa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudactinia sp. Bruce Rock (J Buegge D36)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudactinia sp. Bungalbin Hill (FH & MP Mollemans 3069)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psilotum nudum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterocaulon sp. A Kimberley Flora (B.J. Carter 599)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis frenchii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis macrocalymma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. laterite (D.L. Jones 3081 & M.A. Clements)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. Northampton (SD Hopper 3349)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. Ongerup (KR Newbey 4874) [aff. pusilla]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterostylis sp. Striped sepal greenhood (G. Brockman GBB355 )','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus alexandri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus aphyllus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus appendiculatus var. minor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus beardii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus blackii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus caespitulosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus chortophytum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus chrysocomus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus crispus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus crosslandii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus daphne','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus fasciculatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus halophilus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus lazaridis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus luteolus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus marduguru','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus mitchellii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus mollis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus procumbens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus pyramidatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus rigidus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus sericostachyus subsp. roseus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus stipitatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus stirlingii var. pumilus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus subspinescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus tetrandrus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilotus trichocephalus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptychosema pusillum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinellia vassica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea adunca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea brachyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea calycina subsp. calycina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea calycina subsp. proxena','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea craigiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea daena','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea indira subsp. monstrosita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea indira subsp. pudoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea pauciflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea pinifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea radiata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea skinneri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea sp. Mt Lesueur (Beard 7827)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea vestita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pultenaea wudjariensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Reedia spathacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Regelia cymbifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Regelia megacephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhacocarpus rehmannianus var. webbianus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhadinothamnus rudis subsp. linearis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagodia acicularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagodia sp.Hamersley (M. Trudgen 17794)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhetinocarpha suffruticosa ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizanthella gardneri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe ascendens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe collina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe frenchii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe fuscescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe oppositifolia subsp. ornata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe pyrethrum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe sp. Overlander (PS Short 2096)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodanthe sphaerocephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchosia bungarensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchosia rostrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchospora gracillima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ricinocarpos brevis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ricinocarpos marginatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ricinocarpos oliganthus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ricinocarpos pilifer','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ricinocarpos trichophorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ricinocarpos trichophyllus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rinodina bischoffii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rinzia affinis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rinzia crassifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rinzia longifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rorippa cygnorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rostellularia adscendens var.latifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rothia indica subsp. australis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Roycea pycnophylloides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ruellia sp. A Kimberley Flora (K.F. Kenneally 9007)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rulingia apella ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rulingia sp. Trigwell Bridge (R Smith s.n. 20/6/89)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rulingia tratmannii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rumex crystallinus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rumex drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rumicastrum chamaecladum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Santalum spicatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcocornia globosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sarcozona bicarinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sauropus arenosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sauropus ramosissimus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sauropus salignus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sauropus sp. A Kimberley Flora (T.E.H. Aplin et al. 929)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sauropus sp. Woolgorong (M Officer s.n. 10/8/94)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sauropus torridus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola acacioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola archeriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola ballajupensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola brookeana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola chrysopogon','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola eneabba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola globosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola kallophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola macrophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola oldfieldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola paludosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola sp. Cockburn Range (G.W. Carr 3369 & A.C. Beauglehole 47147)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola sp. Golden hairs (D. & B. Bellairs 1450 A)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola sp. Hamersley Range basalts (S. van Leeuwen 3675)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola sp. Isabella Range (R.D. Royce 1918)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola sp. Lake Cairlocup (K. Newbey 9834)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola sp. Swallow Rock (KR Newbey 9677)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola sp.Waychinnicup (E.M Sandiford EMS 1336)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaevola tortuosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schizachyrium mitchelliana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schizaea dichotoma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schizaea rupestris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenia filifolia subsp. arenicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenia filifolia subsp. subulifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus acuminatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus andrewsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus badius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus benthamii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus calcatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus capillifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus centralis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus fluitans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus griffinianus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus indutus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus loliaceus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus multiglumis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus natans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus pennisetis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus punctatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Beaufort (GJ Keighery 6291)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Bullsbrook (JJ Alford 915)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Eneabba (F.Obbens & C.Godden 1154)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Grassy (Gude and Harvey 250)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Grey Rhizome (K.L. Wilson 2922)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Harrismith (GJ Keighery 6475)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Jindong (RD Royce 2485)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Kalbarri (K Newbey 9352)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Mt Barker (GJ Keighery 9679)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. St Ronans (GJ Keighery and JJ Alford 47) [aff. clandestinus]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Stirling (GJ Keighery 3427)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Theda (M.D.Barrett 1578 B)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Toodyay (G.J. Keighery & N. Gibson 2918)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Waroona (GJ Keighery 12235)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schoenus sp. Warradarge (EA Griffin 3842) [aff. indutus]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia cordata ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia eatoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Ajana (TA Halliday 137)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Bickley (W.H.Loaring s.n.)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Binnu (M Trudgen 2218)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Binnu East Road (ME Trudgen 12013)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Bungabandi Creek (M Quicke EURA 48)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. East Yuna (AC Burns 6)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Eradu (RD Royce 8016)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Eurardy (JS Beard 6886)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Folly Hill (ME Trudgen 12097)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Galena (WE Blackall 4728)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Geraldton (F Lullfitz L 3216)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Gunyidi (JD Briggs 1721)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Kojarena (AM Ashby 1904)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Murchison River (AS George 7098)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Nolba (E Place s.n. Jan 1964)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Prowaka Springs (RJ Cranfield & P Spencer 8083)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Ross Graham Lookout (S Maley 6)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Valentine Road (S Patrick 2142)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Whelarra (ME Trudgen 12018)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Yandanooka (R. Soullier 646)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scholtzia sp. Z-Bend (Bellairs-Kalflora 912A)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scleria annularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scleria levis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scleria poiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scleria polycarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scleria psilorrhiza','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scleria sp. B Kimberley Flora (C. R. Dunlop 5409)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scleria sp. C Kimberley Flora (K.F. Kenneally 4873)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sclerolaena stylosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selaginella pygmaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selliera radicans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Senecio gilbertii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Senecio leucoglossus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Senna sp. Barlee Range (S. van Leeuwen 1520)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Senna sp. Millstream (E. Leyland s.n. 30/8/1990)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Seorsus clavifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Serichonus gracilipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sida sp. Barlee Range (S van Leeuwen 1642)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sida sp. Hamersley Range (K. Newbey 10692)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sida sp. Marandoo (ME Trudgen 10976)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sida sp. Wittenoom (WR Barker 1962)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Siegfriedia darwinioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum carduiforme','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum cataphractum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum leopoldense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum oedipus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum oligandrum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum sp. Boomerang Bay (K.F. Kenneally10021)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum tudununggae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solanum vansittartense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sondottia glabrata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sorghum plumosum var. teretifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sowerbaea alliacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sowerbaea multicaulis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spartothamnella puberula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spartothamnella sp. Helena & Aurora Range (PG Armstrong 155-109)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spergularia nesophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphaerolobium benetectum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphaerolobium pubescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphaerolobium rostratum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphaerolobium validum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphagnum novozelandicum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphenotoma drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphenotoma parviflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphenotoma sp. Stirling Range (PG Wilson 4235)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spirogardnera rubescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sporadanthus rivularis ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sporobolus blakei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sporobolus pulchellus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium glaucum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium montanum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium mucronatum subsp. multiflorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium mucronatum subsp. recurvum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium oligocephalum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium riparium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium sp. Jerdacuttup (A. Williams 332)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium sp. Mason Bay Road (G Cockerton & A Kalotas 8151)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium spadiceum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium subochreatum var. subochreatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spyridium villosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stachystemon axillaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stachystemon nematophorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stachystemon sp. Keysbrook (R. Archer 17/11/99)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stachystemon vinosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stackhousia clementii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stackhousia sp. Stirling Range (WR Barker 2399)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stackhousia umbellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stawellia dimorphantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stemodia linophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stemodia sp. Battle Hill (A.L. Payne 1006)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stemona australiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum bilobum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum bremerense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum coronatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum cristatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum divaricatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum liberum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum limitatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum mediale','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum nanum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum newbeyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum patens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum poicilum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum pumilum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum pumilum subsp. pumilum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum radiatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum reissekii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum sublineare','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum tridentatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenanthemum yorkense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stirlingia divaricatissima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium aceratum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium aeonioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium amabile','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium applanatum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium articulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium barleei','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium bellum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium carlquistii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium carnosum subsp. narrow leaves (JA Wege 490)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium chiddarcoopingense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium choreanthum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium clavatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium coatesianum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium coroniforme subsp. amblyphyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium coroniforme subsp. coroniforme','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium corymbosum var. proliferum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium costulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium cymiferum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium daphne','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium diceratum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium diplectroglossum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium diplotrichum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium diuroides subsp. paucifoliatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium drummondianum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium emarginatum subsp. exappendiculatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium expeditionis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium falcatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium ferricola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium fimbriatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium galioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium glabrifolium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium glandulosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium gloeophyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium hortiorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium hygrophilum ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium hymenocraspedum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium inversiflorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium ireneae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium keigheryi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium korijekup','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium leeuwinense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium lepidum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium leptocalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium longitubum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium maritimum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium marradongense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium merrallii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium mimeticum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium neglectum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium nonscandens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium paulineae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium pendulum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium perizostera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium perplexum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium plantagineum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium prophyllum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium pseudocaespitosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium pseudohirsutum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium pseudosacculatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium pulviniforme','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium rhipidium','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium rosulatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium rubicalyx','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium rubriscapum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sacculatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium scabridum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sejunctum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium semaphorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Banovich Road (F. & J. Hort 1884)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Bluff Knoll (S Barrett s.n. 8/11/94)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Boulder Rock (AH Burbidge 2536)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Dewars Pool (K.F. Kenneally 11400)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. fleshy annual (F. & J. Hort 885)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Scott River Plain (N.G. Marchant 74/23)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Three Springs (J.A. Wge & C. Wilkins JAW 600)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Whicher (BJ Keighery & N Gibson 706)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp. Yalgoo (D. Coultas et al. Opp 01)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium sp.Moora (J.A. Wege 713)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium squamellosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium striatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium tenuicarpum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium thylax','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium tinkeri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium torticarpum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium trudgenii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium tylosum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium validum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium verticillatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium weeliwolli','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium wilroyense','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stylidium xanthopis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stypandra jamesii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Styphelia pulchella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Styphelia sp. Bullfinch (M. Hislop 3574)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Swainsona sp. Hamersley Station (A.A. Mitchell 196)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Swainsona sp. Millstream (AA Mitchell PRP 798)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Symonanthus bancroftii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea acutiloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea aephynsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea bifurcata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea boyaginensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea brachyceras','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea canaliculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea cervifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea constricta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea cuneata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea damopsis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea decumbens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea diabolica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea divaricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea endothrix','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea flabelliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea flexuosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea grandis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea hians','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea incurva','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea intricata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea lesueurensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea macrophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea nexosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea odocoileops','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea otiostigma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea oulopha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea pandurata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea panhesya','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea parviflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea petiolaris subsp. simplex','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea pinnata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea platyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea polypodioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea preissii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea quartzitica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea rangiferops','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Argyle (R. Butcher RB 1323)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Darkin (F. Hort et al. 586)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Fairbridge Farm (D Papenfus 696)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Kwornicup (D. Trenowden 429)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Moora (AS George 17055)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Pinjarra (R Davis 6578)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Pinjarra plain (AS George 17182)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sp. Serpentine (G.R. Brand 103)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea sparsiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea stenoloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea tamminensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea trinacriformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea tripartita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea whicherensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synaphea xela','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tadehagi robustum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taenitis pinnata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taraxacum cygnorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia annelida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia bibenda','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia bulbosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia cymbiformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia entrichoma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia fimbriata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia flabelliformis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia indefessa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia mellaria','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia papilllata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia sp. Christmas Creek (K.A. Shepherd and T. Colmer et al. KS 1063)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia sp. Fortescue Marsh (KA Shepherd et al. KS1055)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia sp. Lake Way (P. Armstrong 05/961)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia sp. Roy Hill (H Pringle 62)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecticornia uniflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Templetonia drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tephrosia andrewii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tephrosia bidwillii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tephrosia rosea var. venulosa ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tephrosia sp. Cathedral Gorge (FH Mollemans 2420)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tephrosia sp. Pilbara Ranges (S. van Leeuwen 4246)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tephrosia valleculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Terminalia supranitifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetragonia coronata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetraria australiensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetraria sp. Nannup (P.A. Jurjevich 1133)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca angulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca aphylla subsp aphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca aphylla subsp. megacarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca applanata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca chapmanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca deltoidea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca elliptica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca erubescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca exasperata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca fasciculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca fordiana ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca harperi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca nephelioides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca parvifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca paynterae subsp. cremnobata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca paynterae subsp. paynterae','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca phoenix','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca pilata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca pilifera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca remota','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca retrorsa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca similis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca sp. Boonanarring (F. Hort 1509)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca sp. Granite (S Patrick 1224) [aff. hirsuta]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca sp. Kent River (BG Hammersley 1791)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetratheca spartea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetrathecea plumosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Teucrium grandiusculum subsp. grandiusculum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Teucrium sp. Dwarf (R. Davis 8813)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Teucrium sp. Hutt River (W.H. Butler 54)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Teucrium sp. Sturt Creek (A.A. Mitchell 5536)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumastochloa brassii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra apiculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra dedmaniarum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra jacksonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra magnifica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra psammophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra stellata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thelymitra yorkensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Themeda sp. Hamersley Station (ME Trudgen 11431)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Themeda sp. Mt Barricade (ME Trudgen 2471)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia brachystachys','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia dielsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia discolor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia formosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia gardneri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia glabripetala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia laxiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia montana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia multiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia purpurea x solanacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia pygmaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia quercifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia solanacea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia sp. Arthur River (HF & M Broadbent 1409)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia sp. Gingin (F & J Hort 1511)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia sp. Green Hill (Paust 1322)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia sp. New Norcia (Cayser s.n. Nov 1918)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia sp. Toolbrunup (GJ Keighery 9895)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia tenuivestita','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thomasia triloba','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene aspera subsp. Mukinbudin (N & P Moyle s.n. 6/11/88)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene duplicata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene eremaea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene johnsonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene nealensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene salina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Carnamah (J. Borger, A. Dring & F. Falconer AD 1510-25)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Carrarang (ME Trudgen 7420)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Eagle Gorge (AG Gunness 2360)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. East Yuna (JW Green 4639)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Eneabba (RJ Cranfield 8433)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Eurardy (Bellairs 1649)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Kalbarri limestone (D. & B. Bellairs 1652A)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Lancelin (ME Trudgen 14000)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Leinster (BJ Lepschi & LA Craven 4362)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Mingenew (Diels & Pritzel 332)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Moresby Range (AS George 14873)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Mt Clara (R.J. Cranfield 11702)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Steep Point (ME Trudgen 7421)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Tamala (ME Trudgen 7384)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Wandana (M.E. Trudgen MET 22016)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene sp. Yuna Reserve (AC Burns 100)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene stenophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene striata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thryptomene wittweri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus acerosifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus anceps','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus banksii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus baueri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus brachiatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus brachyantherus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus brevifolius','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus cymosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus fastigiatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus formosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus gageoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus glaucus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus isantherus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus lavanduliflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus parviflorus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus sabulosus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus sp. Badgingarra (EA Griffin 2511) [aff. sparteus]','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus sp. Desert East of Newman (RP Hart 964)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus sp. Kalbarri (D & B Bellairs 1523A)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus tenuis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus unicupensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thysanotus vernalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tinospora esiangkara','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Torrendia grandis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Torrendia inculta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene anisocarpa var. trichocarpa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene croniniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene dusenii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene moorei subsp. moorei ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene moorei subsp. Tutanning (AS George 12867)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene oleracea subsp. sedimenta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene pyrophila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachymene villosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tremulina cracens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trianthema kimberleyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribonanthes minor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribonanthes purpurea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribonanthes sp. Lake Muir (GJ Keighery & N Gibson 2134)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribulus adelacanthus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribulus minutus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trichocline sp. Treeton (BJ Keighery & N Gibson 564)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tricoryne sp. Eneabba (EA Griffin 1200)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tricoryne sp. Geraldton (GJ Keighery 10461)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tricoryne sp. Morawa (GJ Keighery & N Gibson 6759)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tricoryne sp. Wongan Hills (BH Smith 794)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tricoryne trudgeniana ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triglochin protuberans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triglochin stowardii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia acutispicula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia aeria','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia biflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia bromoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia bunglensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia caelestialis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia cunninghamii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia dielsii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia fissura','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia fitzsgeraldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia pascoeana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia prona','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia racemigera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia roscida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia sp. Mt. Ella (ME Trudgen 12739)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia sp. Prince Regent River (R.L. Barrett & M.D. Barrett RLB 3680)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia sp. Theda (M.D. Barrett & R.L. Barrett MDB 2143)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triodia triticoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tripterococcus brachylobus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tripterococcus paniculatus ms','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trithuria australis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trithuria occidentalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trithuria polybracteata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta appendiculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta aspera','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta echinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta hapala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta leptacantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta maconochieana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta rubiginosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta saccata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta sp. Wittenoom (ME Trudgen 1118)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Triumfetta trisecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trymalium densiflorum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trymalium litorale','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trymalium monospermum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trymalium myrtillus subsp. pungens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trymalium urceolare','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Typhonium nudibaccatum','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Typhonium peltandroides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Typhonium sp. Kununurra (AN Start 1467)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Typhonium sp. Morgan River (M.D. Barrett & R.L. Barrett MDB 2265)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Typhonium sp. Prince Regent River (R.L. Barrett & M.D. Barrett RLB 1716)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Typhonium sp. Theda (M.D. Barrett & R.L. Barrett MDB 1504)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tyrbastes glaucescens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urochloa polyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urodon capitatus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urodon sp. Narkal (BH Smith 1440)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Usnea pulvinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Utricularia aurea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Velleia exigua','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Velleia foliosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verreauxia verreauxii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia aereiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia albida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia amphigia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia apecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia argentea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia attenuata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia aurea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia bifimbriata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia blepharophylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia brevifolia subsp. brevifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia brevifolia subsp. stirlingensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia capillaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia carinata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia chrysostachys var. pallida','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia citrella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia comosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia cooloomia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia coronata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia crebra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia dasystylis subsp. dasystylis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia dasystylis subsp. kalbarriensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia dasystylis subsp. oestopoia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia densiflora var. pedunculata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia densiflora var. roseostella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia dichroma var. dichroma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia dichroma var. syntoma','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia endlicheriana var. angustifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia eriocephala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia eurardyensis x','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia fimbrilepis subsp. australis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia fimbrilepis subsp. fimbrilepis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia fragrans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia galeata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia gracilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia harveyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia helichrysantha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia huegelii var. decumbens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia huegelii var. tridens','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia hughanii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia insignis subsp. eomagis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia integra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia interioris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia jamiesonii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia lehmannii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia lepidophylla var. quantula','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia lindleyi subsp. lindleyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia lindleyi subsp. purpurea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia longistylis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia luteola var. luteola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia luteola var. rosea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia mirabilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia mitodes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia muelleriana subsp. minor','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia muelleriana subsp. muelleriana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia multiflora subsp. multiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia multiflora subsp. solox','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia paludosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia penicillaris','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia pityrhops','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia plumosa var. ananeotes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia plumosa var. pleiobotrya','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia plumosa var. vassensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia polytricha','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia pulchella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia roei subsp. meiogona','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia rutilastra','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia serotina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia serrata var. linearis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia serrata var. Udumung (D Hunter & B Yarran 941006)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia sieberi var. pachyphylla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia sp. Warburton (EA George 1/99)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia spicata subsp. squamosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia staminosa subsp. cylindracea var. cylindracea','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia staminosa subsp. cylindracea var. erecta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia staminosa subsp. staminosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia stenopetala','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia venusta','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia verticordina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia vicinella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticordia wonganensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vigna sp. Central (M.E. Trudgen 1626)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vigna sp.Silver leaf (T.E.H. Aplin 6300)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Villarsia calthifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Villarsia congestiflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Villarsia marchantii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Villarsia submersa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vittadinia cervicularis var. occidentalis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vittadinia cervicularis var. oldfieldii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vittadinia pustulata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vittadinia sp. Coondewanna Flats (s. van Leeuwen 4684)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Walteranthus erectus','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Warnstorfia fluitans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westringia acifolia','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Whitechloa sp. Hann River (Aplin et al. 917)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Whiteochloa capillipes','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea calcicola','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea drummondii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea murchisoniana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea saccata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea sp. Cranbrook (AR Annels 3819)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea sp. Frankland National Park (TD Macfarlane 2238)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea sp. Thomas River (A. Case & B. Cole 58)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wurmbea tubulosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia darlingensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia dayiana','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia fumigata','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia gerhardii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia hypoleiella','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia kondininensis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia louisii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia nashii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia norpraegnans','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia norpumila','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia sammyi','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia sargentii','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia scabrosina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia subalpina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia subbarbatica','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia subimitatrix','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthoparmelia xanthomelanoides','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthorrhoea brevistyla','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthosia collina','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthosia eichleri','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthosia peduncularis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthosia rotundifolia var. hypoleuca','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthosia singuliflora','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthosia sp. Fitzgerald (RD Royce 9266)','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthosia tomentosa','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyris exilis','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyris maxima','Plantae','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zygophyllum sp. Karratha (JS Beard 3508) [aff. retivalve]','Plantae','','');

-- WA Fauna
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bunderia misophaga','Animalia','Epacteriscidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cherax tenuimanus','Animalia','Parastacidae','Margaret River Marron');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum buryillum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum grossum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum monodon','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum primum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum rectum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum simplex','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum solitudum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Danielopolina kornickeri','Animalia','Thaumatocyprididae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diomedea amsterdamensis','Animalia','Diomedeidae','Amsterdam Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaewa pseudoreducta','Animalia','Parastacidae','Margaret River Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geocrinia alba','Animalia','Myobatrachidae','White-bellied Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hurleya sp (WAM642-97)','Animalia','Parameliditae','Crystal Cave Crangonyctoid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indohya damocles','Animalia','Hyidae','Cameron\'s Cave Pseudoscorpion');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kwonkan eboracum','Animalia','Nemesiidae','Yorkrakine Trapdoor Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lasionectes exleyi','Animalia','Speleonectidae','Cape Range Remipede');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mouldingia occidentalis','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ningbingia australis australis','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ningbingia australis elongata','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ningbingia bulla','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ningbingia dentiens','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ningbingia laurina','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ningbingia octava','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ningbingia res','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ogyris subterrestris petrina','Animalia','Lycaenidae','Arid Bronze Azure Butterfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ordtrachia elegans','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pezoporus wallicus flaviventrus','Animalia','Psittacidae','Western Ground Parrot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potorous gilbertii','Animalia','Potoroidae','Gilbert\'s Potoroo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prionospio thalanji','Animalia','Spionidae','(bristle worm)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudemydura umbrina','Animalia','Cheluidae','Western Swamp Tortoise');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhytidid sp Undescribed (WAM2295-69)','Animalia','Rhytididae','Stirling Range Rhytidid Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Speleophria bunderae','Animalia','Speleophriidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stygiochiropus peculiaris','Animalia','Paradoxosomatidae','Camerons Cave Millipede');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stygocyclopia australis','Animalia','Pseudocyclopiidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Teyl sp (BY Main 1953/2683, 1984/13)','Animalia','Nemesiidae','Minnivale Trapdoor Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turgenitubulus costus','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turgenitubulus depressus','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turgenitubulus foramenus','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turgenitubulus opiranus','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turgenitubulus tanmurrana','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zyzomys pedunculatus','Animalia','Muridae','"Central Rock-rat, Antina"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aganippe castellum','Animalia','Idiopidae','Tree-stem Trapdoor Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Balaenoptera musculus','Animalia','Balaenopteridae','Blue Whale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bamazomus subsolanus','Animalia','Hubbardiidae','Eastern Cape Range Bamazomus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bamazomus vespertinus','Animalia','Hubbardiidae','Western Cape Range Bamazomus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bettongia penicillata ogilbyi','Animalia','Potoroidae','Woylie');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacatua pastinator pastinator','Animalia','Psittacidae','Muir\'s Corella');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caretta caretta','Animalia','Cheloniidae','Loggerhead Turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum bubulum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum isolatum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cristilabrum spectaculum','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cynotelopus notablis','Animalia','Sphaerotheriidae','WA Pill Millipede');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasyurus hallucatus','Animalia','Dasyuridae','Northern Quoll');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diomedea dabbenena','Animalia','Diomedeidae','Tristan Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diomedea sanfordi','Animalia','Diomedeidae','Northern Royal Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Draculoides brooksi','Animalia','Hubbardiidae','Northern Cape Range Draculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Draculoides julianneae','Animalia','Hubbardiidae','Western Cape Range Draculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaewa reducta','Animalia','Parastacidae','Dunsborough Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Falcunculus frontatus whitei','Animalia','Pachycephalidae','Crested Shrike-tit (northern subsp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Galaxias truttaceus hesperius','Animalia','Galaxiidae','Western Trout Minnow');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lagorchestes hirsutus ssp (NTM U2430)','Animalia','Macropodidae','"Rufous Hare-wallaby, Mala (NT ssp)"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leioproctus douglasiellus','Animalia','Colletidae','(bee)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidochelys olivacea','Animalia','Cheloniidae','Olive Ridley Turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liagoceradocus branchialis','Animalia','Hadziidae','Cape Range Liagoceradocus Amphipod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macronectes giganteus','Animalia','Procellariidae','Southern Giant Petrel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Moggridgea sp (BY Main 1990/24,25)','Animalia','Migidae','Stirling Range Moggridgea Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Moggridgea tingle','Animalia','Migidae','Tingle Trapdoor Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neopasiphe simplicior','Animalia','Colletidae','(bee)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notoryctes caurinus','Animalia','Notoryctidae','"Northern Marsupial Mole, Kakarratul"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notoryctes typhlops','Animalia','Notoryctidae','"Southern Marsupial Mole, Itjaritjari"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parantechinus apicalis','Animalia','Dasyuridae','Dibbler');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perameles bougainville bougainville','Animalia','Peramelidae','"Western Barred Bandicoot, Marl"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phascogale calura','Animalia','Dasyuridae','"Red-tailed Phascogale, Kenngoor"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psophodes nigrogularis nigrogularis','Animalia','Orthonychidae','Western Whipbird (western heath subsp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sminthopsis psammophila','Animalia','Dasyuridae','Sandhill Dunnart');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synemon gratiosa','Animalia','Castniidae','Graceful Sunmoth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turgenitubulus christenseni','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bettongia pusilla','Animalia','Potoroidae','Nullarbor Dwarf Bettong');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriembryon praecelsus','Animalia','Bulimulidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriembryon whitleyi','Animalia','Bulimulidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chaeropus ecaudatus','Animalia','Peramelidae','"Pig-footed Bandicoot, Kantjilpa"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasyornis broadbenti litoralis','Animalia','Dasyornithidae','Rufous Bristlebird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helicarion castanea','Animalia','Glacidorbidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hesperocolletes douglasi','Animalia','Colletidae','Short-tongued Native Bee');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lagorchestes asomatus','Animalia','Macropodidae','"Central Hare-wallaby, Kuluwarri"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leporillus apicalis','Animalia','Muridae','Lesser Stick-nest Rat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrotis leucura','Animalia','Peramelidae','"Lesser Bilby, Tjunpi"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notomys amplus','Animalia','Muridae','"Short-tailed Hopping Mouse, Yoontoo"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notomys longicaudatus','Animalia','Muridae','"Long-tailed Hopping Mouse, Koolawa"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notomys macrotis','Animalia','Muridae','"Big-eared Hopping Mouse, Noompa"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Occirhenea georgiana','Animalia','Rhytididae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Onychogalea lunata','Animalia','Macropodidae','Crescent Nailtail Wallaby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perameles eremiana','Animalia','Peramelidae','"Desert Bandicoot, Walilya"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potorous platyops','Animalia','Potoroidae','Broad-faced Potoroo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rallus pectoralis clelandi','Animalia','Rallidae','Lewin\'s Rail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abebaioscia troglodytes','Animalia','Isopod','Pannikin Plains Cave Isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Abelaioscia troglodytes','Animalia','Isopod','Pannikin Plains Cave Isopod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amplirhagada astuta','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anous tenuirostris melanops','Animalia','Laridae','Lesser Noddy');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aprasia rostrata','Animalia','Pygopodidae','Hermite Island Worm Lizard');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrarchaea mainae','Animalia','Archaeidae','Western Archaeid Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austroassiminea letha','Animalia','Assimineidae','Cape Leeuwin Freshwater Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Balaenoptera borealis','Animalia','Balaenopteridae','Sei Whale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Balaenoptera physalus','Animalia','Balaenopteridae','Fin Whale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bettongia lesueur lesueur','Animalia','Potoroidae','Boodie (Shark Bay)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bettongia lesueur ssp. (WAM M10733)','Animalia','Potoroidae','Boodie (Barrow Island)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bogidomma australis','Animalia','Bogidiellidae','Barrow Island Bogidomma Amphipod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calamanthus campestris dorrie','Animalia','Acanthizidae','Rufous Fieldwren (Dorre Is)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calamanthus campestris hartogi','Animalia','Acanthizidae','Rufous Fieldwren (Dirk Hartog Is)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calyptorhynchus banksii naso','Animalia','Psittacidae','Forest Red-tailed Black-Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carcharias taurus','Animalia','Odontaspididae','Grey Nurse Shark');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carcharodon carcharias','Animalia','Lamnidae','Great White Shark');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carinotrachia carsoniana','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Catharacta lonnbergi lonnbergi','Animalia','Laridae','Subantarctic Skua (southern)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cereopsis novaehollandiae grisea','Animalia','Anatidae','Recherche Cape Barren Goose');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chelonia mydas','Animalia','Cheloniidae','Green Turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenophorus yinnietharra','Animalia','Agamidae','Yinnietharra Rock Dragon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus angusticeps','Animalia','Scincidae','Airlie Island Ctenotus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus lancelini','Animalia','Scincidae','Lancelin Island Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus zastictus','Animalia','Scincidae','Hamelin Ctenotus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cyclodomorphus branchialis','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasycercus cristicauda','Animalia','Dasyuridae','"Crest-tailed Mulgara, Minyiminyi"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasyornis longirostris','Animalia','Dasyornithidae','Western Bristlebird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasyurus geoffroii','Animalia','Dasyuridae','Chuditch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dermochelys coriacea','Animalia','Dermochelyidae','Leatherback Turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diomedea epomophora','Animalia','Diomedeidae','Southern Royal Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diomedea exulans','Animalia','Diomedeidae','Wandering Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diomedea gibsoni','Animalia','Diomedeidae','Gibson\'s Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Draculoides bramstokeri','Animalia','Hubbardiidae','Barrow Island Draculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Draculoides mesozeirus','Animalia','Hubbardiidae','Middle Robe Draculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Egernia kintorei','Animalia','Scincidae','Giant Desert Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Egernia pulchra longicauda','Animalia','Scincidae','Jurien Bay Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Egernia stokesii aethiops','Animalia','Scincidae','Baudin Island Spiny-tailed Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Egernia stokesii badia','Animalia','Scincidae','Western Spiny-tailed Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Engaewa walpolea','Animalia','Parastacidae','Walpole Burrowing Crayfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epicyliosoma sarahae','Animalia','Sphaerotheriidae','Sarah\'s Pill Millipede');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eretmochelys imbricata bissa','Animalia','Cheloniidae','Hawksbill Turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erythrotriorchus radiatus','Animalia','Accipitridae','Red Goshawk');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eubalaena australis','Animalia','Balaenidae','Southern Right Whale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Galaxiella munda','Animalia','Galaxiidae','Western Mud Minnow');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geocrinia vitellina','Animalia','Myobatrachidae','Orange-bellied Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geophaps smithii blaauwi','Animalia','Columbidae','Partridge Pigeon (western ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Idiosoma nigrum','Animalia','Idiopidae','Shield-backed Trapdoor Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isoodon auratus auratus','Animalia','Peramelidae','"Golden Bandicoot, Wintarru"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isoodon auratus barrowensis','Animalia','Peramelidae','Barrow Island Golden Bandicoot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lagorchestes conspicillatus conspicillatus','Animalia','Macropodidae','Barrow Is. Spectacled Hare-wallaby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lagorchestes hirsutus bernieri','Animalia','Macropodidae','Rufous Hare-wallaby (Bernier & Dorre Is)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lagostrophus fasciatus fasciatus','Animalia','Macropodidae','"Banded Hare-wallaby, Mernine"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leporillus conditor','Animalia','Muridae','"Greater Stick-nest Rat, Wopilkara"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista praefrontalis','Animalia','Scincidae','Buccaneer Burrowing Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liagoceradocus subthalassicus','Animalia','Hadziidae','Barrow Island Liagoceradocus Amphipod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liasis olivaceus barroni','Animalia','Boidae','Pilbara Olive Python');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macropus robustus isabellinus','Animalia','Macropodidae','Barrow Island Euro');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macrotis lagotis','Animalia','Peramelidae','"Bilby, Dalgyte, Ninu"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malurus lamberti bernieri','Animalia','Maluridae','Variegated Fairy-wren (Shark Bay)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malurus leucopterus edouardi','Animalia','Maluridae','Barrow Is Black and White Fairy-wren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malurus leucopterus leucopterus','Animalia','Maluridae','Dirk Hartog Black and White Fairy-wren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Megaptera novaeangliae','Animalia','Balaenopteridae','Humpback Whale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Milyeringa veritas','Animalia','Eleotridae','Blind Gudgeon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mouldingia orientalis','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myrmecobius fasciatus','Animalia','Myrmecobiidae','"Numbat, Walpurti"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nannatherina balstoni','Animalia','Nannopercidae','Balston\'s Pygmy Perch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Natator depressus','Animalia','Cheloniidae','Flatback Turtle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia fragilis','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia humphreysi','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia hurlberti','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia macrosculptilis','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia sculptilis','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia straskraba','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia urifimbriata','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophisternon candidum','Animalia','Synbranchidae','Blind Cave Eel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paradraculoides anachoretus','Animalia','Schizomid?','Mesa A Paradraculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paradraculoides bythius','Animalia','Schizomid?','Mesa B Paradraculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paradraculoides gnophicola','Animalia','Schizomid?','Mesa G Paradraculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paradraculoides kryptus','Animalia','Schizomid?','Mesa K Paradraculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrogale lateralis hacketti','Animalia','Macropodidae','Recherche Rock-wallaby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrogale lateralis lateralis','Animalia','Macropodidae','Black-flanked Rock-wallaby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrogale lateralis ssp. (ANWC CM15314)','Animalia','Macropodidae','"Black-footed Rock-wallaby, Warru (McDonnell Range ssp)"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrogale lateralis ssp. (WAM M15135)','Animalia','Macropodidae','West Kimberley Rock-wallaby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phascogale tapoatafa ssp. (WAM M434)','Animalia','Dasyuridae','"Brush-tailed Phascogale, Wambenger"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoebetria fusca','Animalia','Diomedeidae','Sooty Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoebetria palpebrata','Animalia','Diomedeidae','Light-mantled Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platycercus icterotis xanthogenys','Animalia','Psittacidae','Western Rosella (inland ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pogona minor minima','Animalia','Agamidae','Abrolhos Dwarf Bearded Dragon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pristis zijsron','Animalia','Pristidae','Green Sawfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Procellaria aequinoctialis aequinoctialis','Animalia','Procellariidae','White-chinned Petrel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudocheirus occidentalis','Animalia','Pseudocheiridae','Western Ringtail Possum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomys australis','Animalia','Muridae','Plains Rat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomys fieldi','Animalia','Muridae','"Shark Bay Mouse, Djoongari"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomys shortridgei','Animalia','Muridae','"Heath Mouse, Dayang"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudonaja affinis exilis','Animalia','Elapidae','Rottnest Dugite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudonaja affinis tanneri','Animalia','Elapidae','Recherche Dugite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhinonicteris aurantius','Animalia','Hipposideridae','Orange Leaf-nosed Bat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rostratula benghalensis australis','Animalia','Rostratulidae','Australian Painted Snipe');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Setonix brachyurus','Animalia','Macropodidae','Quokka');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sminthopsis butleri','Animalia','Dasyuridae','Butler\'s Dunnart');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Speleostrophus nesiotes','Animalia','Pachybolidae','Barrow Island Millipede');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spicospina flammocaerulea','Animalia','Myobatrachidae','Sunset Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stipiturus malachurus hartogi','Animalia','Maluridae','Southern Emu-wren (Dirk Hartog Is)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stygiocaris lancifera','Animalia','Atyidae','Lance-beaked Cave Shrimp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stygiochiropus isolatus','Animalia','Paradoxosomatidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stygiochiropus sympatricus','Animalia','Paradoxosomatidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sula dactylatra bedouti','Animalia','Sulidae','Masked Booby (eastern Indian Ocean)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tartarus mullamullangensis','Animalia','Stiphidiidae','Mullamullang Cave Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tartarus murdochensis','Animalia','Stiphidiidae','Murdoch Sink Cave Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tartarus nurinensis','Animalia','Stiphidiidae','Nurina Cave Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tartarus thampannensis','Animalia','Stiphidiidae','Thampanna Cave Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thalassarche carteri','Animalia','Diomedeidae','Indian Yellow-nosed Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thalassarche cauta','Animalia','Diomedeidae','Shy Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thalassarche chlororhynchos','Animalia','Diomedeidae','Atlantic Yellow-nosed Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thalassarche chrysostoma','Animalia','Diomedeidae','Grey-headed Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thalassarche melanophrys','Animalia','Diomedeidae','Black-browed Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thalassarche salvini','Animalia','Diomedeidae','Salvin\'s Albatross');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tiliqua adelaidensis','ANIMLAIA','SCINCIDAE','Pygmy Blue-tongue');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tiliqua rugosa konowi','Animalia','Scincidae','Rottnest Bobtail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Troglodiplura lowryi','Animalia','Dipluridae','Nullarbor Cave Trapdoor Spider');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turgenitubulus pagodula','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turnix varia scintillans','Animalia','Turnicidae','Abrolhos Painted Button-quail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westraltrachia alterna','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westraltrachia inopinata','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westraltrachia turbinata','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Morelia spilota imbricata','Animalia','Boidae','Carpet Python');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arctocephalus forsteri','Animalia','Otariinae','New Zealand Fur-seal');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacatua leadbeateri','Animalia','Psittacidae','Major Mitchell\'s Cockatoo');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crocodylus johnstoni','Animalia','Crocodylidae','Freshwater Crocodile');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crocodylus porosus','Animalia','Crocodylidae','Salt-water Crocodile');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dugong dugon','Animalia','Dugongidae','Dugong');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Falco peregrinus','Animalia','Falconidae','Peregrine Falcon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neophoca cinerea','Animalia','Otariinae','Australian Sea-lion');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Northiella haematogaster narethae','Animalia','Psittacidae','Naretha Blue Bonnet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tadorna radjah rufitergum','Animalia','Anatidae','Burdekin Duck');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aclys concinna major','Animalia','Pygopodidae','Javelin Legless Lizard');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amplirhagada herbertena','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amplirhagada montalivetensis','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amplirhagada novelta','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amplirhagada questroana','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aprasia haroldi','Animalia','Pygopodidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arbanitis inornatus','Animalia','Idiopidae','(trapdoor spider)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriembryon bradshawi','Animalia','Bulimulidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriembryon perobesus','Animalia','Bulimulidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Branchinella apophysata','Animalia','Thamnocephalidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Branchinella basispina','Animalia','Thamnocephalidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Branchinella denticulata','Animalia','Thamnocephalidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Branchinella simplex','Animalia','Thamnocephalidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Branchinella wellardi','Animalia','Thamnocephalidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Budginmaya eulae','Animalia','Flatidae','Eula\'s planthopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calamoecia elongata','Animalia','Centropagidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptagama aurita','Animalia','Agamidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus nigrilineatus','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Damochlora millepunctata','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daphnia jollyi','Animalia','Daphniidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daphnia occidentalis','Animalia','Daphniidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geotria australis','Animalia','Geotriidae','Pouched Lamprey');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glaphyromorphus \'koontoolasi\'','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glyphis garricki','Animalia','Carcharhinidae','Northern River Shark');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hannia greenwayi','Animalia','Teraponidae','Greenway\'s Grunter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ixalodectes flectocercus','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jalmenus aridus','Animalia','Lycaenidae','(butterfly)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kawaniphila pachomai','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kimboraga yammerana','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista eupoda','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista haroldi','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista maculosa','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista planiventralis maryani','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista quadrivincula','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista robusta','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista talpina','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista viduata','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Morelia carinata','Animalia','Boidae','Rough-scaled Python');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mormopterus loriae cobourgiana','Animalia','Molossidae','Little North-western Mastiff Bat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pachysaga strobila','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parartemia contracta','Animalia','Branchipodidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parasuta spectabilis bushi','Animalia','Elapidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pilsbrycharopa tumida','Animalia','Charopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pristis clavata','Animalia','Pristidae','Dwarf Sawfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psacadonotus seriatus','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops ganei','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops micromma','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops sp \'Cape Range\'','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops troglodytes','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagada gibbensis','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Throscodectes xiphos','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Torresitrachia thedana','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trichosternus relictus','Animalia','Carabidae','(beetle)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tyto novaehollandiae kimberli','Animalia','Tytonidae','Masked Owl (Kimberly ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uperoleia marmorata','Animalia','Myobatrachidae','Marbled Toadlet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uperoleia minima','Animalia','Myobatrachidae','Small Toadlet');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westraltrachia lievreana','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westraltrachia recta','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westraltrachia subtila','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Windbalea viride','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acercella poorginup','Animalia','Pionidae','Poorginup Swamp Watermite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Antipodogomphus hodgkini','Animalia','Gomphidae','(dragonfly)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austroconops mcmillani','Animalia','Ceratopogonidae','(a biting midge)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austromerope poultoni','Animalia','Meropeidae','(scorpionfly)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriembryon brazieri','Animalia','Bulimulidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriembryon glauerti','Animalia','Bulimulidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bothriembryon irvineanus','Animalia','Bulimulidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Craterocephalus helenae','Animalia','Atherinidae','Drysdale Hardyhead');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Craterocephalus lentiginosus','Animalia','Atherinidae','Prince Regent Hardyhead');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crenadactylus sp \'Cape Range\'','Animalia','Gekkonidae','\'Cape Range Crenadactylus\'');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus uber johnstonei','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus yampiensis','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplodactylus capensis','Animalia','Gekkonidae','Cape Range Stone Gecko');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplodactylus fulleri','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplodactylus kenneallyi','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diporiphora convergens','Animalia','Agamidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dupucharopa millestriata','Animalia','Charopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elapognathus minor','Animalia','Elapidae','Short-nosed Snake');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fibulacamptus bisetosus','Animalia','Canthocamptidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Glacidorbis occidentalis','Animalia','Glacidorbidae','(a freshwater snail)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hadra wilsoni','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemisaga lucifer','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hephaestus epirrhinos','Animalia','Teraponidae','Long-nose Sooty Grunter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hipposideros stenotis','Animalia','Hipposideridae','Northern Leafnosed-bat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypseleotris aurea','Animalia','Eleotridae','Golden Gudgeon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kimberleyeleotris hutchinsi','Animalia','Eleotridae','Mitchell Gudgeon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kimberleyeleotris notata','Animalia','Eleotridae','Drysdale Gudgeon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kimboraga micromphala','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kwonkan moriartii','Animalia','Nemesiidae','(trapdoor spider)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leiopotherapon macrolepis','Animalia','Teraponidae','Large-scale Grunter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leioproctus bilobatus','Animalia','Colletidae','(bee)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista axillaris','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista bunglebungle','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista kalumburu','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista macropisthopus remota','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista puncticauda','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista separanda','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melanotaenia pygmaea','Animalia','Melanotaeniidae','Pygmy Rainbowfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nedsia chevronia','Animalia','Hadziidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ninox connivens connivens','Animalia','Strigidae','Barking Owl (southwest pop)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nocticola flabella','Animalia','Nocticolidae','Cape Range Blind Cockroach');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nososticta pilbara','Animalia','Protoneuridae','(dragonfly)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phasmodes jeeba','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phycodurus eques','Animalia','Syngnathidae','Leafy Sea Dragon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllodactylus sp. \'Cape Le Grand\'','Animalia','Gekkonidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudohydraphantes doegi','Animalia','Mite?','Doeg\'s Watermite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops howi','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops longissimus','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops margaretae','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops splendidus','Animalia','Typhlopidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramphotyphlops yampiensis','Animalia','Typhlopidae','Koolan Blind Snake');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagada harti','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Simoselaps minimus','Animalia','Elapidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Syncomistes rastellus','Animalia','Teraponidae','Drysdale Grunter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vespadelus douglasorum','Animalia','Vespertilionidae','Yellow-lipped Cave Bat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acanthophis antarcticus','Animalia','Elapidae','Southern Death Adder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Austrosaga spinifer','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baudinella baudinensis','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus gemmula (Swan Coastal Plain popn)','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Damochlora spina','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Galaxiella nigrostriata','Animalia','Galaxiidae','Black-stripe Minnow');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemisaga vepreculae','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylaeus globuliferus','Animalia','Colletidae','(bee)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ixobrychus flavicollis australis','Animalia','Ardeidae','Black Bittern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kimboraga exanimus','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lagorchestes conspicillatus leichardti','Animalia','Macropodidae','Spectacled Hare-wallaby (mainland)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leioproctus contrarius','Animalia','Colletidae','(bee)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista allochira','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista humphriesi','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista lineata','Animalia','Scincidae','Lined Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lerista yuna','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neelaps calonotos','Animalia','Elapidae','Black-striped Snake');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pachysaga munggai','Animalia','Tettigoniidae','(cricket)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paroplocephalus atriceps','Animalia','Elapidae','Lake Cronin Snake');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petropseudes dahli','Animalia','Pseudocheiridae','Rock Ringtail Possum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pletholax gracilis edelensis','Animalia','Pygopodidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pristis microdon','Animalia','Pristidae','Freshwater Sawfish');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prymnbriareus nimberlinus','Animalia','Camaenidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Throscodectes xederoides','Animalia','Tettigoniidae','Mogumber Bush Cricket');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tyto novaehollandiae novaehollandiae','Animalia','Tytonidae','Masked Owl (SW ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wyulda squamicaudata','Animalia','Phalangeridae','Scaly-tailed Possum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amytornis striatus striatus','Animalia','Maluridae','Striated Grasswren');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amytornis textilis textilis','Animalia','Maluridae','Thick-billed Grass-wren (western ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ardeotis australis','Animalia','Otididae','Australian Bustard');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Burhinus grallarius','Animalia','Burhinidae','Bush Stonecurlew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calamanthus campestris montanellus','Animalia','Acanthizidae','Rufous Fieldwren (western wheatbelt)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Charadrius rubricollis','Animalia','Charadriidae','Hooded Plover');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cinclosoma alisteri','Animalia','Orthonychidae','Nullarbor Quail-thrush');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenotus delli','Animalia','Scincidae','Dell\'s Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasycercus blythi','Animalia','Dasyuridae','"Brush-tailed Mulgara, Ampurta"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Draculoides vinei','Animalia','Hubbardiidae','Cape Range Draculoides');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Egernia stokesii stokesii','Animalia','Scincidae','Houtman Abrolhos Spiny-tailed Skink');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Falcunculus frontatus leucogaster','Animalia','Pachycephalidae','Crested Shrike-tit (south-western ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Falsistrellus mackenziei','Animalia','Vespertilionidae','Western False Pipistrelle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geocrinia lutea','Animalia','Myobatrachidae','Nornalup Frog');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Geophaps smithii smithii','Animalia','Columbidae','Partridge Pigeon (eastern ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heteromunia pectoralis','Animalia','Passeridae','Pictorella Mannikin');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydromys chrysogaster','Animalia','Muridae','"Water-rat, Rakali"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylacola cauta whitlocki','Animalia','Acanthizidae','Shy Heathwren (western ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ixobrychus minutus','Animalia','Ardeidae','Little Bittern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leggadina lakedownensis','Animalia','Muridae','"Lakeland Downs Mouse, Kerakenga"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leiopotherapon aheneus','Animalia','Teraponidae','Fortescue Grunter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macroderma gigas','Animalia','Megadermatidae','Ghost Bat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macropus irma','Animalia','Macropodidae','Western Brush Wallaby');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malurus coronatus coronatus','Animalia','Maluridae','Purple-crowned Fairy-wren (western ssp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mesembriomys gouldii gouldii','Animalia','Muridae','Black-footed Tree-rat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mesembriomys macrurus','Animalia','Muridae','Golden-backed Tree-rat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neochmia ruficauda subclarescens','Animalia','Passeridae','Star Finch (western)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Notoscincus butleri','Animalia','Scincidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Numenius madagascariensis','Animalia','Scolopacidae','Eastern Curlew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nyctophilus timoriensis (central form)','Animalia','Vespertilionidae','Central Long-eared Bat');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orcaella heinsohni','Animalia','Delphinidae','Australian Snubfin Dolphin');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oreoica gutturalis gutturalis','Animalia','Pachycephalidae','Crested Bellbird (southern)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Petrogale burbidgei','Animalia','Macropodidae','Monjon');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaps elegans (Abrolhos pop)','Animalia','Columbidae','Brush Bronzewing (Abrolhos pop)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaps histrionica','Animalia','Columbidae','Flock Bronzewing');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Physeter macrocephalus','Animalia','Physeteridae','Sperm Whale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomatostomus superciliosus ashbyi','Animalia','Pomatostomatidae','White-browed Babbler (western wheatbelt)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomys chapmani','Animalia','Muridae','"Western Pebble-mound Mouse, Ngadji"');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomys occidentalis','Animalia','Muridae','Western Mouse');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psophodes nigrogularis oberon','Animalia','Orthonychidae','Western Whipbird (sthn WA subsp)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sminthopsis longicaudata','Animalia','Dasyuridae','Long-tailed Dunnart');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sousa chinensis','Animalia','Delphinidae','Indo-Pacific Humpback Dolphin');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stennella longirostris longirostris','Animalia','Delphinidae','Spinner Dolphin');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stygiocaris stylifera','Animalia','Atyidae','Spear-beaked Cave Shrimp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Turnix castanota magnifica','Animalia','Turnicidae','Chestnut-backed Button-quail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Westralunio carteri','Animalia','Hyriidae','(bivalve)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Isoodon obesulus fusciventer','Animalia','Peramelidae','Quenda');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Macropus eugenii derbianus','Animalia','Macropodidae','Tammar Wallaby');

-- Plant pest species

-- Cat1 RWG7 (Forest Pests)
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes formosanus','Animalia','Rhinotermitidae','Formosan subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes gestroi','Animalia','Rhinotermitidae','Asian subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterobostrychus aequalis','Animalia','Bostrychidae','powder post beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylotrupes bajulus','Animalia','Cerambycidae','European house borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Incisitermes minor','Animalia','Termitidae','western drywood termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lyctus africanus','Animalia','Bostrychidae','powder post beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stromatium barbartum','Animalia','Cerambycidae','drywood longicorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coryphodema tristis','Animalia','Cossidae','South African cossid Goat Moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agrilus planipennis','Animalia','Buprestidae','emerald ash borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoplophora glabripennis','Animalia','Cerambycidae','Asian longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilecomadia valdiviana','Animalia','Cossidae','carpenterworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria dispar','Animalia','Lymantriidae','Asian gypsy moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orgyia thyellina','Animalia','Lymantriidae','white spotted tussock moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arhopalus ferus','Animalia','Cerambycidae','burnt pine longicorn');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bursaphelenchus xylophilus','Animalia','Parasitaphelenchidae','pine wood nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus frontalis','Animalia','Curculionidae','southern pine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus ponderosae','Animalia','Curculionidae','mountain pine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus valens','Animalia','Curculionidae','red turpentine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylurdrectonus araucariae','Animalia','Scolytidae','bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips typographus','Animalia','Curculionidae','European spruce bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria monacha','Animalia','Lymantriidae','nun moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhyacionia buolian','Animalia','Tortricidae','pine shoot moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urocerus gigas','Animalia','Siricidae','giant woodwasp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryphonectria parasitica','Fungi','Cryphonectriaceae','chestnut blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coniothyrium zuluense','Fungi','Mycosphaerellaceae','Coniothyrium eucalypt canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophiostoma novi-ulmi','Fungi','Ophiostomataceae','Dutch elm disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaeophleospora destructans','Fungi','Pleosporaceae','eucalypt leaf blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora ramorum','Fungi','Phthiaceae','sudden oak death');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia psidii','Fungi','Pucciniaceae','eucalyptus (guava) rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Subramanianospora vesiculosa','Fungi','Ascomycota \'incertae sedis\'','Casuarina blister bark');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Armillaria ostoyae','Fungi','Physalacriaceae','Armillaria root disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Endocronartium harknessii','Fungi','Cronartiaceae','western gall rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium circinatum','Fungi','Nectriaceae','pine pitch canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterobasidion annosum sensu lato','Fungi','Bondarzewiaceae','annosus root & butt rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nectria fuckeliana','Fungi','Nectriaceae','Nectria Canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophiostoma grosmannia','Fungi','Ophiostomataceae','black stain root disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phellinus weirii','Fungi','Hymenochaetaceae','laminated root rot');

-- Cat1 PHA IBP-HPP Pests
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acleris comariana','Animalia','Tortricidae','Strawberry tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adoxophyes orana','Animalia','Tortricidae','Summer fruit tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agrotis segetum','Animalia','Noctuidae','Turnip moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurolobus barodensis','Animalia','Aleyrodidae','Sugarcane whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alternaria triticina','Fungi','','Leaf blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amblypelta cocophaga','Animalia','','Coconut bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amrasca biguttula','Animalia','','Cotton jassid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amyelois transitella','Animalia','Pyralidae','Navel orangeworm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha fraterculus','Animalia','','South American fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha ludens','Animalia','Tephritidae','Mexican fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anisogramma anomala','Fungi','Valsaceae','Hazelnut blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus bisignatus','Animalia','','Strawberry bud weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus grandis','Animalia','','Boll weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphis gossypii','Animalia','','Cotton aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apiosporina morbosa','Fungi','Venturaceae','Black knot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apple proliferation phytoplasma','Bacteria','','Apple proliferation');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atherigona soccata','Animalia','','Sorghum shoot fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Avocado blackstreak disease','Unknown','','Avocado blackstreak disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Avocado sunblotch viroid (Avsunviroid)','Viruses','','Sunblotch');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera albistrigata','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera carambolae','Animalia','Tephritidae','Carambola fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera caryae','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera correcta','Animalia','Tephritidae','Guava fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera cucurbitae','Animalia','Tephritidae','Melon fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera curvipennis','Animalia','Tephritidae','Banana fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera dorsalis','Animalia','Tephritidae','Oriental fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera facialis','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera invadens','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera kandiensis','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera kirki','Animalia','Tephritidae','Fijian fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera melanotus','Animalia','','Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera minax','Animalia','','Chinese citrus fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera occipitalis','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera oleae','Animalia','Tephritidae','Olive fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera papayae','Animalia','Tephritidae','Papaya fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera passiflorae','Animalia','Tephritidae','Fijian fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera philippinensis','Animalia','Tephritidae','Philippine fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera psidii','Animalia','Tephritidae','South sea guava fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera trilineola','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera trivialis','Animalia','Tephritidae','New Guinea fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera tsuneonis','Animalia','','Japanese orange fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera xanthodes','Animalia','Tephritidae','Pacific fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera zonata','Animalia','Tephritidae','Peach fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banana bract mosaic virus (Potyvirus)','Viruses','Potyviridae','Banana bract mosaic disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean common mosaic virus (Potyvirus), peanut stripe strain','Viruses','','Bean common mosaic virus, peanut stripe strain');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bemisia tabaci','Animalia','','Silverleaf whitefly (exotic strains)');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banana Blood disease bacterium','Bacteria','','Banana Blood Disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Botryotinia squamosa','Fungi','','Leaf blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Burkholderia glumae','Bacteria','','Panicle blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bursaphelenchus mucronatus','Animalia','','Pinewood nematode (species complex)');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bursaphelenchus xylophilus','Animalia','Parasitaphelenchidae','Pinewood nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacopsylla pyricola','Animalia','','Pear psylla (group considered)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter africanus','Bacteria','','Huanglongbing (african strain)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter americanus','Bacteria','','Huanglongbing (american strain)');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter asiaticus','Bacteria','Rhizobiaceae','Huanglongbing (asiatic strain)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cephus pygmeus','Animalia','Cephidae','European wheat stem sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratitis capitata','Animalia','Tephritidae','Mediterranean fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratitis rosa','Animalia','','Natal fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratocystis ulmi','Fungi','','Dutch elm disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratovacuna lanigera','Animalia','','Sugarcane woolly aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cercospora longipes','Fungi','','Brown spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceutorhynchus assimilis','Animalia','Curculionidae','Cabbage seedpod weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cherry leaf roll virus (Nepovirus)','Viruses','','Blackline');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilo auricilius','Animalia','','Sugarcane internode borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilo infuscatellus','Animalia','','Yellow top borer of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilo partellus','Animalia','','Spotted stalk borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilo sacchariphagus','Animalia','','Sugarcane internode borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilo terrenellus','Animalia','Pyralidae','Sugarcane stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chlumetia transversa','Animalia','','Mango shoot borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Choristoneura rosaceana','Animalia','Tortricidae','Oblique banded leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chromatomyia horticola','Animalia','','Leafminer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ciborinia camelliae','Fungi','Sclerotiniaceae','Camellia petal blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cicadulina mbila','Animalia','','South African maize leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citripestis sagittiferella','Animalia','','Citrus fruit borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus leprosis virus (Unassigned)','Viruses','','Citrus leprosis disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus tristeza (Closterovirus), mandarin stem-pitting strain','Viruses','Closteroviridae','Mandarin stem-pitting');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cladosporium caryigenum','Fungi','','Pecan scab');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clavibacter michiganensis subsp. sepedonicus','Bacteria','','Bacterial ring rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colletotrichum acutatum KLA strain','','','Lime Anthracnose');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colletotrichum acutatumSGO strain','Fungi','','Post bloom fruit drop');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colletotrichum truncatumlentil strain','Fungi','','Lentil anthracnose');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conotrachelus aguacatae','Animalia','','Small avocado seed weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conotrachelus nenuphar','Animalia','Curculionidae','Plum weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes curvignathus','Animalia','Rhinotermitidae','Rubber termite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes formosanus','Animalia','Rhinotermitidae','Formosan subterranean termite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes gestroi','Animalia','Rhinotermitidae','Asian subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cotton leaf curl virus (Begomovirus)','Viruses','','Cotton leaf curl disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryphonectria parasitica','Fungi','Cryphonectriaceae','Chestnut blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptophlebia leucotreta','Animalia','','False codling moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenopseustis obliquana','Animalia','','Brown headed leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia latiferreana','Animalia','Tortricidae','Filbertworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daktulosphaira vitifoliae(biotype B)','Animalia','','Grape phylloxera');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Daktulosphaira vitifoliae(exotic strains)','Animalia','','Grapevine phyloxera');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Deanolis sublimbalis','Animalia','Pyralidae','Red-banded mango caterpillar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Delia antiqua','Animalia','','Onion fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Delia florilega','Animalia','','Bean seed maggot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dialeurodes citri','Animalia','Aleyrodidae','Citrus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaphorina citri','Animalia','','Asian citrus psyllid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuraphis noxia','Animalia','Aphididae','Russian wheat aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dorysthenes buqueti','Animalia','','Sugarcane longhorn stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drechslera tetramera','Fungi','','Leaf spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Duke 6 stem pitting','Unknown','','Duke 6 stem pitting');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dysaphis plantaginea','Animalia','','Rosy apple aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dysmicoccus neobrevipes','Animalia','Pseudococcidae','Grey pineapple mealybug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Endocronartium harknessii','Fungi','Cronartiaceae','Western gall rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eotetranychus carpini','Animalia','Tetranychidae','Yellow vine mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erionota thrax','Animalia','Hesperiidae','Banana skipper butterfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia amylovora','Bacteria','Enterobacteriaceae','Fire blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia chrysanthemi','Bacteria','','Bacterial fruit collapse and heart rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia herbicola','Bacteria','Enterobacteriaceae','Avocado blast complex');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia pyrifoliae','Bacteria','Enterobacteriaceae','Black stem blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eumerus strigatus','Animalia','','Lesser bulb fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('European stone fruit yellows phytoplasma','Bacteria','','European stone fruit yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fulmekiola serrata','Animalia','','Oriental sugar cane thrips');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium circinatum','Fungi','Nectriaceae','Pitch canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium guttiforme','Fungi','','Fusariosis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium mangiferae','Fungi','','Mango malformation');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. ciceris','Fungi','','Fusarium wilt of chickpea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. conglutinans','Fungi','','Fusarium wilt of canola');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. cubense Tropical race 4','Fungi','','Panama disease Tropical race 4');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. lentis','Fungi','','Fusarium wilt of lentil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. lupini','Fungi','','Fusarium wilt of lupin');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. vasinfectum','Fungi','','Fusarium wilt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gibberella fujikuroi','Fungi','','Bakanae');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Globodera pallida','Animalia','','Potato cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Globodera rostochiensis','Animalia','Heteroderidae','Potato cyst nematode');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine flavescence doree phytoplasma','Bacteria','','Flavescence dor�e');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Groundnut bud necrosis virus (Tospovirus)','Viruses','','Peanut bud necrosis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guignardia bidwellii','Fungi','Botryosphaeriaceae','Black rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guignardia musae','Fungi','Botryosphaeriaceae','Freckle disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helipus lauri','Animalia','','Large seed weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helopeltis antonii','Animalia','','Tea mosquito bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helopeltis collaris','Animalia','','Mirid bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helopeltis schoutedeni','Animalia','','Cotton helopeltis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera avenae','Animalia','','Cereal cyst nematode (exotic strains)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera carotae','Animalia','','Carrot cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera filipjevi','Animalia','','Cereal cyst nematode (exotic strains)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera glycines','Animalia','','Soybean cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera latipons','Animalia','','Cereal cyst nematode (exotic strains)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('High plains virus','Viruses','','High plains virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalodisca vitripennis','Animalia','Cicadellidae','Glassy-winged sharpshooter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homoeosoma electellum','Animalia','','Sunflower moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypothenemus obscurus','Animalia','Curculionidae','Tropical nut borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidiota blanchardi','Animalia','','Blanchard\'s canegrub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidiota discedens','Animalia','','Canegrub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidiota pruinosa','Animalia','','Pruinose canegrub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidiota reuleauxi','Animalia','','Ramu canegrub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidiota stigma','Animalia','','White canegrub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptinotarsa decemlineata','Animalia','Chrysomelidae','Colorado potato beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucopholis sp.nr. armata','Animalia','','Canegrub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liothrips oleae','Animalia','','Olive thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza bryoniae','Animalia','','Tomato leaf miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza huidobrensis','Animalia','Agromyzidae','Potato leafminer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza sativae','Animalia','Agromyzidae','American leafminer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza trifolii','Animalia','Agromyzidae','American serpentine leafminer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lissorhoptrus oryzophilus','Animalia','Curculionidae','Rice water weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Little cherry virus 1 (Ampelovirus)','Viruses','','Little cherry virus 1');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Little cherry virus 2 (Closteroviridae)','Viruses','','Little cherry virus 2');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cotton leaf roll dwarf virus (Polerovirus)','Viruses','','Cotton blue disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lyctus africanus','Animalia','Bostrichidae','Powder post beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lygus hesperus','Animalia','Miridae','Western plant bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lygus lineolaris','Animalia','Miridae','Tarnished plant bug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria dispar','Animalia','','Asian gypsy moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Magnaporthe grisea','Fungi','','Rice blast');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize dwarf mosaic virus (Potyvirus)','Viruses','Potyviridae','Maize dwarf mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mayetiola destructor','Animalia','Cecidomyiidae','Hessian fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mayetiola hordei','Animalia','','Barley stem gall midge');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meromyza saltatrix','Animalia','','Wheat stem maggot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monilinia fructigena','Fungi','Sclerotiniaceae','Brown rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus alternatus','Animalia','','Japanese pine sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus galloprovinicialis','Animalia','',' Pine sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus titillator','Animalia','','Southern pine sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus scutellatus','Animalia','','White-spotted sawyer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella eumusae','Fungi','','Eumusae leaf spot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella fijiensis','Fungi','','Black sigatoka');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mythimna unipuncta','Animalia','','Armyworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nectria galligena','Fungi','','European canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Numonia pirivorella','Animalia','','Pear fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Odium citri','Fungi','','Powdery mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Odium tingitanium','Fungi','','Powdery mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus perseae','Animalia','','Persea mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Otiorhynchus rugosostriatus','Animalia','Curculionidae','Rough strawberry weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pandemis cerasana','Animalia','','Cherry brown tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parasa lepida','Animalia','Limacodidae','Blue-striped nettle grub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peridroma saucia','Animalia','Notodontidae','Variegated cutworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella bicoloris','Animalia','','Sugarcane sidewinder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella diagoras','Animalia','','Sugarcane sidewinder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella lalokensis','Animalia','','Sugarcane sidewinder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella papuensis','Animalia','','Sugarcane sidewinder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella rattlei','Animalia','','Sugarcane sidewinder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella saccharivora','Animalia','','Sugarcane sidewinder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella vastatrix','Animalia','','Sugarcane sidewinder');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella vitiensis','Animalia','','Sugarcane sidewinder');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora philippinensis','Fungi','','Philippine downy mildew of maize');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sacchari','Fungi','','Sugarcane downy mildew');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sorghi','Fungi','','Sorghum downy mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora spontanea','Fungi','','Downy mildew');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phakopsora euvitis','Fungi','','Grapevine leaf rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoma tracheiphila','Fungi','Incertae sedis','Mal Secco');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phomopsis helianthi','Fungi','','Sunflower stem canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phymatotrichum omnivorum','Fungi','','Texas root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytomyza gymnostoma','Animalia','','Allium leaf miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora fragariae var. fragariae','Fungi','','Red steele root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora infestans A2 mating type','Fungi','','Potato late blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora ramorum','Fungi','Pythiaceae','Sudden oak death');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planococcus ficus','Animalia','Pseudococcidae','Vine mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planotortrix excessana','Animalia','','Green headed leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planotortrix octo','Animalia','','Green headed leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plasmopara halstedii','Fungi','','Sunflower downy mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platynota stultana','Animalia','Tortricidae','Omnivorous leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plum pox virus (Potyvirus)','Viruses','Potyviridae','Plum pox virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomacea canaliculata','Animalia','','Golden apple snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato mop top virus (Pomovirus)','Viruses','','Potato mop top virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato spindle tuber viroid (Pospiviroidae)','Viruses','','Potato spindle tuber viroid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prays oleae','Animalia','','Olive moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Procontarinia matteiana','Animalia','','Mango leaf-gall midge');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Protopulvinaria pyriformis','Animalia','','Pyriform scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudocercospora purpurea','Fungi','','Cercospora spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus maritimus','Animalia','Pseudococcidae','Grape mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas syringae pv papulans','Bacteria','','Blister spot of apples');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas syringae pv. syringae','Bacteria','','Avocado blast complex');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudopezicula tetraspora','Fungi','','Angular leaf scorch');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudopezicula tracheiphila','Fungi','','Rotbrenner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Psila rosae','Animalia','','Carrot rust fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia allii','Fungi','','Rust of allium');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia allii-cepulae','Fungi','','Rust of allium');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia alliorum','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia asparagi','Fungi','Pucciniaceae','Asparagus rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia coronata f. sp. hordei','Fungi','','Barley crown rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia cylodontis','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia graminis f. sp. hordei','Fungi','','Barley stem rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia graminis f. sp. tritici','Fungi','','Wheat stem rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia mixta','Fungi','','Rust of allium');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia permixta','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia porri','Fungi','','');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia psidii','Fungi','','Guava rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia reconditia','Fungi','','Brown wheat rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia schisma','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia sessilis','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia striiformis f. sp. hordei','Fungi','','Barley stripe rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia striiformis f. sp. tritici','Fungi','','Wheat stripe rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia triticina','Fungi','','Brown wheat rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pulvinaria iceryi','Animalia','Coccidae','Pulvinaria scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pyrenophora teres f. sp. teres','Fungi','','Net form of net blotch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pyrilla perpusilla','Animalia','Lophopidae','Sugarcane pyrilla');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ralstonia solanacearum sequevar 3 (Multilocus genotype24)','Bacteria','','Moko disease Cavendish bananas and Bugtok disease of cooking bananas');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Raspberry ringspot virus (Nepovirus)','Viruses','','Raspberry ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Red clover vein mosaic virus (Carlavirus)','Viruses','','Red clover vein mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis completa','Animalia','Tephritidae','Walnut husk fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis fausta','Animalia','Tephritidae','Black cherry fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis indifferens','Animalia','Tephritidae','Western cherry fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis pomonella','Animalia','Tephritidae','Apple maggot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizoglyphus callae','Animalia','','Bulb mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizoglyphus setosus','Animalia','','Bulb mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Roesleria subterranea','Fungi','','Grape root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scirpophaga excerptalis','Animalia','','Top shoot borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scirtothrips aurantii','Animalia','Thripidae','South African citrus thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scirtothrips perseae','Animalia','','Avocado thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia grisescens','Animalia','Noctuidae','Stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia inferens','Animalia','','Pink stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sitobion avenae','Animalia','Aphididae','Wheat aphid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sorghum mosaic virus (Potyvirus)','Viruses','','Sorghum mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphaceloma perseae','Fungi','','Avocado scab');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spiroplasma citri','Bacteria','','Stubborn');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stagonospora sacchari','Fungi','Incertae sedis','Leaf scorch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenoma catenifer','Animalia','','Avocado seed moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sternochetus frigidus','Animalia','Curculionidae','Mango pulp weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Strawberry latent ringspot virus (Nepovirus)','Viruses','','Strawberry latent ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stromatium barbatum','Animalia','Cerambycidae','Drywood longicorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Strymon megarus','Animalia','','Pineapple fruit borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane grassy shoot phytoplasma','Bacteria','','Grassy shoot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane mosaic virus (Potyvirus) (exotic strains)','Viruses','','Sugarcane mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane streak mosaic virus (Potyviridae)','Viruses','','Sugarcane streak mosaic');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane white leaf phytoplasma','Bacteria','','White leaf');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synchytrium endobioticum','Fungi','','Potato wart');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetramoera schistaceana','Animalia','','Sugarcane shoot borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetranychus piercei','Animalia','Tetranychidae','Spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetranychus turkestani','Animalia','Tetranychidae','Strawberry spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia barclayana','Fungi','','Kernel smut of rice');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia indica','Fungi','Tilletiaceae','Karnal bunt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato black ring virus (Nepovirus)','Viruses','','Tomato black ring virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato ringspot virus (Nepovirus)','Viruses','','Tomato ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribolium castaneum phosphine resistant strain','Animalia','','Rust red flour beetle (phosphine resistant)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma granarium','Animalia','Dermestidae','Khapra beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramu stunt','Unknown','','Ramu stunt of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urocystis cepulae','Fungi','','Onion smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uromyces scirpi','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uromyces viciae-fabaelentil strain','Fungi','','Lentil rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticillium dahliae defoliating strain','Fungi','','Verticillium wilt (defoliating strain)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticillium longisporum','Fungi','','Canola verticillium wilt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Watermelon bud virus (Tospovirus)','Viruses','','Watermelon bud necrosis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Watermelon silver mottle virus (Tospovirus)','Viruses','','Watermelon silver mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wheat spindle streak mosaic virus (Bymovirus)','Viruses','','Wheat spindle streak mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach X disease phytoplasma','Bacteria','','Peach X disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas alfalfae subsp. citrumelonis','Bacteria','','Bacterial spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas ampelina','Bacteria','','Bacterial blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas campestris','Bacteria','','Black chaff');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas campestris avocado strain','Bacteria','','Bacterial canker complex (avocado strain)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas campestris pv. musacearum','Bacteria','','Bacterial wilt');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas citri subsp. citri','Bacteria','','Citrus canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas citri subsp. malvacearum','Bacteria','','Angular leaf spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas fragariae','Bacteria','','Strawberry angular leaf spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas translucens','Bacteria','','Black chaff');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylella fastidiosa','Bacteria','Xanthomonadaceae','Pierce\'s disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylosandrus compactus','Animalia','Scolytidae','Black twig borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zucchini lethal chlorosis virus (Tospovirus)','Viruses','','Zucchini lethal chlorosis virus');

-- Cat1 NAQS Target Lists (Exotics)
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chrysoporthe cubensis','Fungi','Cryphonectriaceae','Chrysoporthe canker, Cryphonectria canker, eucalyptus canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elsino� fawcettii','Fungi','Elsinoaceae','Citrus scab');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elsino� australis','Fungi','Elsinoaceae','Citrus scab');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guignardia musae','Fungi','Botryosphaeriaceae','Banana freckle (on clones within the Cavendish sub-group)');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemileia vastatrix','Fungi','Pucciniaceae','Coffee rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella fijiensis','Fungi','Mycosphaerellaceae','Black Sigatoka');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella eumusae','Fungi','Mycosphaerellaceae','Eumusae leaf spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oidium tingitaninum','Fungi','Erysiphaceae','Citrus powdery mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oidium citri','Fungi','Erysiphaceae','Citrus powdery mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phakopsora euvitis','Fungi','Phakopsoraceae','Grapevine rust');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia psidii','Fungi','Pucciniaceae','Eucalyptus rust, Guava rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stagonospora sacchari','Fungi','Incertae sedis','Leaf scorch of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synchytrium phaseoli','Fungi','Synchtriaceae','False rust, wart');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia heliconiae','Fungi','Pucciniaceae','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora infestans','Fungi','Peronosporaceae','Potato late blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora philippinensis','Fungi','Peronosporaceae','Philippine downy mildew of maize');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sacchari','Fungi','Peronosporaceae','Downy mildew of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sorghi','Fungi','Peronosporaceae','Downy mildew of sorghum');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banana blood disease bacterium','Bacteria','Pseudomonodaceae','Blood disease of bananas');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter asiaticus','Bacteria','Rhizobiaceae','Huanglongbing, Citrus greening');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas syzygii','Bacteria','Pseudomonodaceae','Sumatra disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ralstonia solanacearum race 1, biovar III','Bacteria','Ralstoniaceae','Bacterial wilt of eucalyptus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ralstonia solanacearum sequevar 3 (Multilocus genotype24)','Bacteria','Ralstoniaceae','Moko disease Cavendish bananas and Bugtok disease of cooking bananas');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas albilineans','Bacteria','Xanthomonadaceae','Leaf scald of sugarcane, maize etc');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas citri subsp. citri','Bacteria','Xanthomonadaceae','Citrus canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia papayae','Bacteria','','Bacterial crown rot of papaya');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banana bract mosaic virus (Potyvirus)','Viruses','Potyviridae','Banana bract mosaic');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus tristeza virus (Closterovirus)','Viruses','Closteroviridae','Citrus tristeza');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean common mosaic virus (Potyvirus), peanut stripe strain','Viruses','Potyviridae','Peanut stripe');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sorghum mosaic virus (Potyvirus)','Viruses','Potyviridae','Sorghum mosaic');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane mosaic virus (Potyvirus)','Viruses','Potyviridae','Sugarcane mosaic');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fiji disease virus (Fijivirus)','Viruses','Reoviridae','Fiji disease of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Palm Lethal yellowing phytoplasma','Bacteria','Acholeplasmataceae','Lethal yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pepper yellow leaf curl Indonesia virus (Geminivirus)','Viruses','Geminiviridae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane Ramu stunt virus (unknown)','Viruses','','Ramu stunt of sugarcane');

-- Cat1 MAWilliams List
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tropilaelaps koenigerum','Animalia','Laelapidae','Asian bee mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter psyllaurous','Bacteria','','psylid yellowing');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ralstonia solanacearum race 3 biovar 2','Bacteria','','potato brown rot, tomato bacterial and geranium southern wilt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiberlesia neodiffinis','Animalia','','scale insect');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eumetopina flavipes','Animalia','Delphacidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas fuscanssubsp. aurantifolii','Bacteria','','Citrus canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas alfalfaesubsp. citrumelonis','Bacteria','','Citrus canker');

-- Cat1 Country Regulated Pests
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acalolepta cervina','Animalia','','Coffee longhorn');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acanthocinus carinulatus','Animalia','','Longhorned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acanthoscelides pallidipennis','Animalia','','Bruchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acarapis woodi','Animalia','Tarsonemidae','Honey bee tracheal mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Achatina achatina','Animalia','','Tiger snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acidovorax konjaci','Bacteria','','Leaf spot and leaf blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acleris gloverana','Animalia','','Western blackheaded budworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acleris variana','Animalia','','Eastern blackheaded budworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrogonia terminalis','Animalia','','Leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrolepiopis assectella','Animalia','','Leek moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aculops fuchsiae','Animalia','','Fuchsia mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acusta despecta','Animalia','','Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acutaspis albopicta','Animalia','','Whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adelges tsugae','Animalia','','Hemlock woolly adelgid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adoretus sinicus','Animalia','','Rose beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adoxophyes orana','Animalia','Tortricidae','Summer fruit tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aecidium hydrangeae-paniculatae','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aecidium mori','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aeolesthes sarta','Animalia','','City longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('African cassava mosaic virus (Begomovirus)','Viruses','','African cassava mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ageratum yellow vein virus (Begomovirus)','Viruses','','Abutilon mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agrilus mali','Animalia','','Apple wood borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agrilus planipennis','Animalia','Buprestidae','Emerald ash borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agropyron mosaic virus (Rymovirus)','Viruses','','Agropyron mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('alder yellows phytoplasma','Bacteria','','Alder yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurocanthus woglumi','Animalia','Aleyrodidae','Citrus blackfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alfalfa cryptic virus 1 (Alphacryptovirus)','Viruses','','Alfalfa cryptic virus 1');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alfalfa enation virus (Rhabdovirus)','Viruses','','Alfalfa enation virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alsike clover vein mosaic virus (Unassigned)','Viruses','','Alsike clover vein mosaic virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Alternaria triticina','Fungi','','Leaf blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amaranthus leaf mottle virus (Potyvirus)','Viruses','','Amaranthus leaf mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amauromyza maculosa','Animalia','','Chrysanthemum leaf miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('American aster yellows phytoplasma','Bacteria','','American aster yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amorbia emigratella','Animalia','','Mexican leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ampedus basalis','Animalia','','Click beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amphitetranychus viennensis','Animalia','','Hawthorn spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anarsua lineatella','Animalia','','Peach twig borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha distincta','Animalia','','Pois-doux fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha fraterculus','Animalia','','South American fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha grandis','Animalia','','South American cucurbit fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha ludens','Animalia','Tephritidae','Mexican fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha obliqua','Animalia','','West Indian fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha pseudoparallela','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha schiner','Animalia','','South American cucurbit fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha serpentina','Animalia','','Orange fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha striata','Animalia','Tephritidae','Guava fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha suspensa','Animalia','Tephritidae','Carribean fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anchastus swezeyi','Animalia','','Click beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andean potato latent virus (Tymovirus)','Viruses','','Andean potato latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Andean potato mottle virus (Comovirus)','Viruses','','Andean potato mottle virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anisogramma anomala','Fungi','Valsaceae','Eastern filbert disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Annual blue grass white leaf phytoplasma','Bacteria','','Annual blue grass white leaf');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anomala sulcatula','Animalia','','Scarab beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoplophora chinensis','Animalia','Cerambycidae','Longicorn beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoplophora glabripennis','Animalia','','Asian longhorned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoplophora malasiaca','Animalia','','Boll weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus bisignifer','Animalia','Curculionidae','Boll weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus eugenii','Animalia','','Pepper weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus grandis','Animalia','','Cotton boll weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus quadrigibbus','Animalia','Curculionidae','Apple curculio weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus signatus','Animalia','','Strawberry bud weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthoxanthum latent blanching virus (Hordeivirus)','Viruses','','Anthoxanthum latent blanching virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthriscus yellows virus (Waikavirus)','Viruses','','Anthriscus yellows virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aonidiella lauretorum','Animalia','','Scale insect');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aonidiella tinerfinensis','Animalia','','Scale insect');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apate monachus','Animalia','','Black borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphanostigma piri','Animalia','','Pear phylloxera');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphelenchoides arachidis','Animalia','','Groundnut testa nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphelenchoides suipingensis','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphis laburni','Animalia','','African bean aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphis ruborum','Animalia','','Raspberry leaf-curling aphid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apiosporina morbosa','Fungi','Venturaceae','Blackknot of cherry');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apple proliferation phytoplasma','Bacteria','','Apple proliferation phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apple scar skin viroid (Apscaviroid)','Viruses','Prospiviroidae','Apple scar skin viroid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apricot chlorotic leaf roll phytoplasma','Bacteria','','Apricot chlorotic leaf roll phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Araujia mosaic virus (Potyvirus)','Viruses','','Araujia mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Archachatina degneri','Animalia','','African land snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Archachatina purpurea','Animalia','','Giant African land snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Archachatina ventricosa','Animalia','','Giant African land snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Archips micaceanus','Animalia','Tortricidae','Soybean leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Archips xylosteanus','Animalia','','Apple leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Argyrotaenia ljungiana','Animalia','','Grey red barred tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Argyrotaenia pulchellana','Animalia','','Tortricid moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arracacha virus A (Nepovirus)','Viruses','','Arracacha virus A');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arracacha virus B (Comoviridae)','Viruses','','Arracacha virus B');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arracacha virus Y (Potyviridae)','Viruses','','Arracacha virus Y');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Artichoke Italian latent virus (Nepovirus)','Viruses','','Artichoke Italian latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Artichoke mottled crinkle virus (Tombusvirus)','Viruses','','Artichoke mottled crinkle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Artichoke yellow ringspot virus (Nepovirus)','Viruses','','Artichoke yellow ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Artitropa comus','Animalia','','Skipper butterfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus\' Phytoplasma fraxini','Bacteria','Tenericutes','Ash yellows phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asparagus virus 1 (Potyvirus)','Viruses','','Asparagus virus 1');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asparagus virus 2 (Ilarvirus)','Viruses','','Asparagus virus 2');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Asparagus 3 virus (Potexvirus)','Viruses','','Asparagus virus 3');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aspidiotus spinosus','Animalia','','Spinose scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atomaria lewisi','Animalia','','Fungus beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atropellis pinicola','Fungi','','Branch canker of pine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atropellis piniphila','Fungi','','Branch canker of pine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Atropellis spp.','Fungi','','Branch canker of pine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Autographa gamma','Animalia','','Beet worm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactericera cockerelli','Animalia','','Potato/Tomato psyllid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera albistrigata','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera carambolae','Animalia','Tephritidae','Carambola fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera caryae','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera correcta','Animalia','Tephritidae','Guava fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera cucurbitae','Animalia','Tephritidae','Melon fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera decipiens','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera depressa','Animalia','','Pumpkin fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera diversa','Animalia','Tephritidae','Three striped fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera dorsalis','Animalia','Tephritidae','Oriental fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera fascialis','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera kandiensis','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera kirki','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera latifons','Animalia','','Solanum fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera melanota','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera minax','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera occipitalis','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera oleae','Animalia','Tephritidae','Olive fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera papayae','Animalia','Tephritidae','Papaya fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera passiflorae','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera philippinsis','Animalia','','Papaya fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera psidii','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera pyrifoliae','Animalia','','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera tau','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera trivialis','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera tsuneonis','Animalia','','Chinese fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera tuberculata','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera umbrosa','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera xanthodes','Animalia','Tephritidae','Pacific fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera zonata','Animalia','Tephritidae','Peach fruir fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Balansia oryzae-sativae','Fungi','','Udbatte disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banana bract mosaic virus (Potyvirus)','Viruses','Potyviridae','Banana bract mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Baris granulipennis','Animalia','','Melon weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Barley mild mosaic virus (Bymovirus)','Viruses','','Barley mild mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Barley mosaic virus (Unassigned)','Viruses','','Barley mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Barley yellow mosaic virus (Bymovirus)','Viruses','','Barley yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean calico mosaic virus (Begomovirus)','Viruses','','Bean calico mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean golden mosaic virus (Begomovirus)','Viruses','','Bean golden mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean mild mosaic virus (Carmovirus)','Viruses','','Bean mild mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean pod mottle virus (Comovirus)','Viruses','','Bean pod mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean rugose mosaic virus (Comovirus)','Viruses','','Bean rugose mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Southern bean mosaic virus (Sobemovirus)','Viruses','','Bean southern mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bean yellow vein banding virus (Umbravirus)','Viruses','','Bean yellow vein banding virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet black scorch virus (Necovirus)','Viruses','','Beet black scorch virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet curly top virus (Curtovirus)','Viruses','Geminiviridae','Beet curly top virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet distortion mosaic virus (Unassigned)','Viruses','','Beet distortion mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet leaf curl virus (Rhabdoviridae)','Viruses','','Beet leaf curl virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet mild yellowing virus (Polerovirus)','Viruses','','Beet mild yellowing virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet necrotic yellow vein virus (Benyvirus)','Viruses','','Beet necrotic yellow vein virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet soil-borne virus (Pomovirus)','Viruses','','Beet soil-borne virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Beet yellow stunt virus (Closterovirus)','Viruses','','Beet yellow stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Belladonna mottle virus (Tymovirus)','Viruses','','Belladonna mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Belonolaimus gracilis','Animalia','','Pine sting nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bemisia cordylinidis','Animalia','','Whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bermuda grass etched-line virus (Marafivirus)','Viruses','','Bermuda grass etched-line virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bhendi yellow vein mosaic virus (Begomovirus)','Viruses','','Bhendi yellow vein mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bidens mosaic virus (Potyviridae)','Viruses','','Bidens mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bidens mottle virus (Potyvirus)','Viruses','','Bidens mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Black alder witches\'-broom phytoplasma','Bacteria','','Black alder witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blackberry chlorotic ringspot virus (Ilarvirus)','Viruses','','Blackberry chlorotic ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blackcurrant reversion virus (Nepovirus)','Viruses','','Blackcurrant reversion virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blitopertha orientalis','Animalia','','Oriental beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blueberry leaf mottle virus (Nepovirus)','Viruses','','Blueberry leaf mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blueberry necrotic shock virus (Caulimovirus)','Viruses','','Blueberry necrotic shock virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blueberry red ringspot virus (Ilarvirus)','Viruses','','Blueberry red ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blueberry scorch virus (Carlavirus)','Viruses','','Blueberry scorch virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blueberry shock virus (Ilarvirus)','Viruses','','Blueberry shock virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blueberry shoestring virus (Sobemovirus)','Viruses','','Blueberry shoestring virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blueberry stunt phytoplasma','Bacteria','','Blueberry stunt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bois noir phytoplasma','Bacteria','','Bois noir');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bolitophagus reticulates','Animalia','','Saproxylic beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Botryosphaeria berengeriana f. sp. piricola','Fungi','','Physalospora canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Botryosphaeria laricina','Fungi','','Shoot blight of larch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachycerus spp.','Animalia','','Garlic borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brachydactyla discoidea','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brevipalpus chilensis','Animalia','','Chilean False Red Mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Broad bean B virus (Unassigned)','Viruses','','Broad bean B virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Broad bean necrosis virus (Pomovirus)','Viruses','','Broad bean necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Broad bean severe chlorosis virus (Closteroviridae)','Viruses','','Broad bean severe chlorosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Broad bean yellow ringspot virus (Unassigned)','Viruses','','Broad bean yellow ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Broad bean yellow vein virus (Rhabdoviridae)','Viruses','','Broad bean yellow vein virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Brome streak mosaic virus (Tritimovirus)','Viruses','','Brome streak mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchidius incarnatus','Animalia','','Seed beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchidius ptilinoides','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bryobia eharai','Animalia','','Mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bulbifer homeorhynchus','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Burdock mosaic virus (Unassigned)','Viruses','','Burdock mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Burdock mottle virus (Unassigned)','Viruses','','Burdock mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Burdock yellows virus (Closterovirus)','Viruses','','Burdock yellows virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bursaphelenchus muconatus','Animalia','','Pine wood nematode');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bursaphelenchus xylophilus','Animalia','Parasitaphelenchidae','Pine wood nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cocoa necrosis virus (Nepovirus)','Viruses','','Cacao necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacao swollen shoot virus (Badnavirus)','Viruses','','Cacao swollen shoot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacao yellow mosaic virus (Tymovirus)','Viruses','','Cacao yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacoecimorpha pronubana','Animalia','','Carnation tortix moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacopsylla pyri','Animalia','','Pear sucker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacyreus marshalli','Animalia','','Pelargonium butterfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Calitys scabra','Animalia','','Bark-gnawing beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Callidiellum rufipenne','Animalia','Cerambycidae','Japanese cedar longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Callidium villosulum','Animalia','','Brown fir longhorned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Callipogon relictus','Animalia','','Long horn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cameraria ohridella','Animalia','','Horsechestnut leaf miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caper latent virus (Carlavirus)','Viruses','','Caper latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Capua tortrix','Animalia','','Leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caralaspis minima','Animalia','','Cedar scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cardamom mosaic virus (Potyvirus)','Viruses','','Cardamom mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carnation Italian ringspot virus (Tombusvirus)','Viruses','','Carnation Italian ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carpomya incompleta','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carpomya paradalina','Animalia','','Baluchistan melon fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carpomya vesuviana','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carposina niponensis','Animalia','','Apple fruit borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carrot latent virus (Rhabdoviridae)','Viruses','','Carrot latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carrot temperate virus 1 (Alphacryptovirus)','Viruses','','Carrot temperate virus 1');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carrot temperate virus 2 (Betacrypotvirus)','Viruses','','Carrot temperate virus 2');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carrot temperate virus 3 (Alphacrypotvirus)','Viruses','','Carrot temperate virus 3');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carrot temperate virus 4 (Alphacrypotvirus)','Viruses','','Carrot temperate virus 4');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Carrot thin leaf virus (Potyvirus)','Viruses','','Carrot thin leaf virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('African cassava mosaic virus (Begomovirus)','Viruses','','Cassava African mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassava brown streak virus (Potyviridae)','Viruses','','Cassava brown streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassava common mosaic virus (Potexvirus)','Viruses','','Cassava common mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassava green mottle virus (Nepovirus)','Viruses','','Cassava green mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indian cassava mosaic virus (Begomovirus)','Viruses','','Cassava Indian mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassava Ivorian bacilliform virus (Unassigned)','Viruses','','Cassava Ivorian bacilliform virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassava virus X (Potexvirus)','Viruses','','Cassava virus X');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassia mosaic virus (Unassigned)','Viruses','','Cassia mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassia ringspot virus (Unassigned)','Viruses','','Cassia ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cassia yellow spot virus (Potyviridae)','Viruses','','Cassia yellow spot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cataenococcus hispidus','Animalia','','Citrus mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Catamacta lotinana','Animalia','','Leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cathartosilvanus opaculus','Animalia','','Silvanid flat bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caulophilus oryzae','Animalia','','Avocado seed weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cepaea hortensis','Animalia','','White-lipped snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cephalcia lariciphila','Animalia','','Larch sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratitis cosyra','Animalia','','Mango fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratitis quinaria','Animalia','','Rhodesian fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratitis rosa','Animalia','','Natel fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratocystis fagacearum','Fungi','','Oak wilt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratocystis fimbriata f. sp. platani','Fungi','','Canker stain of plane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratocystis virescens','Fungi','','Sapstreak disease of maple');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cercospora batatae','Fungi','','Sweet potato leaf spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cercospora papayae','Fungi','','Black spot disease of papaya');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Northern cereal mosaic virus (Cytorhabdovirus)','Viruses','','Cereal chlorotic mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cereal northern mosaic virus','Viruses','','Cereal northern mosaic virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceroplastes japonicus','Animalia','','Tortoise wax scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cherry little cherry virus (Unassigned)','Viruses','','Little cherry');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chickpea bushy dwarf virus (Potyviridae)','Viruses','','Chickpea bushy dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chickpea distortion mosaic virus (Potyviridae)','Viruses','','Chickpea distortion mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chichory virus','Viruses','','Chicory virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chicory yellow mottle virus (Nepovirus)','Viruses','','Chicory yellow mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilli veinal mottle virus (Potyvirus)','Viruses','Potyviridae','Chilli veinal mottle virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilo sacchariphagus','Animalia','','Rice borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chino del tomat� virus (Begomovirus)','Viruses','','Chino del tomat� virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chionaspis javanensis','Animalia','','Scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chionaspis pinifoliae','Animalia','','Pine leaf scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Choristoneura conflictana','Animalia','','Large aspen tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Choristoneura fumiferana','Animalia','','Spruce budworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Choristoneura occidentalis','Animalia','','Western spruce budworm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Choristoneura rosaceana','Animalia','Tortricidae','Oblique banded leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chrysanthemum stem necrosis virus (Tospovirus)','Viruses','','Chrysanthemum stem necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chrysodeixis chalcites','Animalia','','Golden twin-spot moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chrysomphalus diversicolor','Animalia','','Scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chrysomyxa abietis','Fungi','','Spruce Needle Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chrysomyxa arctostaphyli','Fungi','','Spruce Broom Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chrysomyxa himalensis','Fungi','','Rust of rhododendron');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ciborinia camelliae','Fungi','Sclerotiniaceae','Camellia flower blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cicadulina mbila','Animalia','','South African maize leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Circulifer tenellus','Animalia','','Beet leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus impietratura virus (Uncharacterised)','Viruses','','Citrus impietratura virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus leprosis virus (Rhabdoviridae)','Viruses','','Citrus leprosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus mosaic virus (Badnavirus)','Viruses','','Citrus mosaic');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus ringspot virus (Unassigned)','Viruses','','Citrus ring spot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus variegation virus (Ilarvirus)','Viruses','','Citrus variegation virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Citrus yellow mosaic virus (Badnavirus)','Viruses','','Citrus yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clavibacter michiganensis ssp. nebraskensis','Fungi','','Leaf freckle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clavibacter michiganensis ssp. sepedonicus','Fungi','','Bacterial ring rot of potato');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clitoria yellow vein virus (Tymovirus)','Viruses','','Clitoria yellow vein virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clover mild mosaic virus (Unassigned)','Viruses','','Clover mild mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clover proliferation phytoplasma','Bacteria','','Clover proliferation');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clover wound tumor virus (Phytorheovirus)','Viruses','','Clover wound tumor virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clover yellow edge phytoplasma','Bacteria','','Clover yellow edge');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clover yellow mosaic virus (Potexvirus)','Viruses','','Clover yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clover yellows virus (Closteroviridae)','Viruses','','Clover yellows virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coccotrypes fallax','Animalia','','Scolytid weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cocksfoot mild mosaic virus (Unassigned)','Viruses','','Cocksfoot mild mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cocksfoot mottle virus (Sobemovirus)','Viruses','','Cocksfoot mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cocoa mottle leaf virus','Viruses','','Cocoa mottle leaf virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cocoa necrosis virus (Nepovirus)','Viruses','','Cocoa necrosis virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacao swollen shoot virus (Badnavirus)','Viruses','','Cocoa swollen shoot virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cacao yellow mosaic virus (Tymovirus)','Viruses','','Cocoa yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coconut cadang-cadang viroid (Cocadviroid)','Viruses','','Cadang cadang disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coconut foliar decay virus (Nanoviridae)','Viruses','','Coconut foliar decay virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coconut lethal yellowing phytoplasma','Bacteria','','Coconut lethal yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coconut tinangaja viroid','Viruses','','Yellow mottle decline');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coffee ringspot virus (Rhabdoviridae)','Viruses','','Coffee ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Colletotrichum coffeanum','Fungi','','Coffee berry disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commelina diffusa virus (Potyviridae)','Viruses','','Commelina diffusa virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commelina mosaic virus (Potyvirus)','Viruses','','Commelina mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commelina virus X (Potexvirus)','Viruses','','Commelina virus X');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Commelina yellow mottle virus (Badnavirus)','Viruses','','Commelina yellow mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conoderus rufangulus','Animalia','','Click beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conopia hector','Animalia','','Cherry tree borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conorrhynchus conirostris','Animalia','','Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conotrachelus aguacatae','Animalia','','Small avocado seed weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conotrachelus nenuphar','Animalia','Curculionidae','Plum curculio');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Contarinia maculipennis','Animalia','','Blossom midge');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Contarinia nasturtii','Animalia','','Swede midge');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes curvignathus','Animalia','Rhinotermitidae','Rubber termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes sjostedti','Animalia','','Termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes vastator','Animalia','','Philippine milk termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Copturus aguacatae','Animalia','','Avocado stem weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coriander feathery red vein virus (Rhabdoviridae)','Viruses','','Coriander feathery red vein virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corticium koleroga','Fungi','Corticiaceae','Thread blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cosmophylum pallidulum','Animalia','','Katydid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cossonus incises','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cotton anthocyanosis virus (Luteoviridae)','Viruses','','Cotton anthocyanosis agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cotton leaf crumple virus (Begomovirus)','Viruses','','Cotton leaf crumple virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cotton leaf curl virus (Begomovirus)','Viruses','','Cotton leaf curl virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cotton virescence phytoplasma','Bacteria','','Cotton virescence phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea chlorotic mottle virus (Bromovirus)','Viruses','','Cowpea chlorotic mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea golden mosaic virus (Begomovirus)','Viruses','','Cowpea golden mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea green vein-banding virus (Potyvirus)','Viruses','','Cowpea green vein-banding virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea mild mottle virus (Carlavirus)','Viruses','','Cowpea mild mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea mosaic virus (Comovirus)','Viruses','','Cowpea mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea rugose mosaic virus (Potyviridae)','Viruses','','Cowpea rugose mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea severe mosaic virus (Comovirus)','Viruses','','Cowpea severe mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea stunt virus (Luteoviridae)','Viruses','','Cowpea stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Craponius inaequalis','Animalia','','Grape curculio');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crimson clover latent virus (Nepovirus)','Viruses','','Crimson clover latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crinipellis perniciosa','Animalia','','Witches\' broom disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crocidosema aporema','Animalia','','Bud borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium coleosporioides','Fungi','','Pine rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium comptoniae','Fungi','','Sweetfern blister rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium conigenum','Fungi','','Blister rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium flaccidium','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium fusiforme','Fungi','','Southern fusiform rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium himalayense','Fungi','','Christmas pine blister rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium kamtschaticum','Fungi','','Japanese white pine rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium quercuum','Fungi','','Fusiform rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium ribicola','Fungi','','White pine blister rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cronartium spp.','Fungi','','Blister rusts');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crossotarsus wallacei','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Croton yellow vein mosaic virus Begomovirus)','Viruses','','Croton yellow vein mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptophilus propinquus','Animalia','','Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptophlebia leucotreta','Animalia','','False codling moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptorrhynchus lapathi','Animalia','','Poplar & willow borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ctenopseustis obliquana','Animalia','','Brownheaded leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cucumber leaf spot virus (Aureusvirus)','Viruses','','Cucumber leaf spot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cucumber necrosis virus (Tombusvirus)','Viruses','','Cucumber necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cucumber soil-borne virus (Carmovirus)','Viruses','','Cucumber soil-borne virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cucumber vein yellowing virus (Unassigned)','Viruses','','Cucumber vein yellowing virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cucurbit yellow stunting disorder virus (Crinivirus)','Viruses','','Cucurbit yellow stunting disorder virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Curculio elephas','Animalia','','Chestnut weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Curculio nucum','Animalia','','Hazelnut weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Curtobacterium flaccumfaciens pv. oortii','Bacteria','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Curtobacterium flaccumfaciens pv. poinsettiae','Bacteria','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cycas necrotic stunt virus (Nepovirus)','Viruses','','Cycas necrotic stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia funebrana','Animalia','','Plum fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia inopinata','Animalia','','Fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia janthinana','Animalia','','Fruit moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia latiferreana','Animalia','Tortricidae','Filbert worm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia packardi','Animalia','','Cherry fruit worm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia prunivora','Animalia','','Lesser apple worm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia pyrivora','Animalia','','Fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia saltitans','Animalia','','Mexican jumping bean moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia splendana','Animalia','','Chestnut tortrix moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cylindrocladium buxicola','Fungi','','Leaf and twig blight of box');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cylindrocladium canadense','Fungi','','Root rot of black spruce');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cylindrocladium parasiticum','Fungi','','Cylindrocladium black rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cymbidium ringspot virus (Tombusvirus','Viruses','','Cymbidium ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cynodon chlorotic streak virus (Rhabdoviridae)','Viruses','','Cynodon chlorotic streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cynosurus mottle virus (Unassigned)','Viruses','','Cynosurus mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cytospora sacchari','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dacus bivittatus','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dacus ciliatus','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dacus vertebratus','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dandelion latent virus (Carlavirus)','Viruses','','Dandelion latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Darna pallivita','Animalia','','Stinging nettle caterpillar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dasineura mali','Animalia','','Apple leaf curling midge');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Datura distortion mosaic virus (Potyviridae)','Viruses','','Datura distortion mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Datura enation mosaic virus (Potyvirus)','Viruses','','Datura enation mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Datura necrosis virus (Potyviridae)','Viruses','','Datura necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Datura shoestring virus (Potyvirus)','Viruses','','Datura shoestring virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Delia antigue','Animalia','','Onion fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus adjunctus','Animalia','','Roundheaded pine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus brevicomis','Animalia','Curculionidae','Western pine beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus frontalis','Animalia','Curculionidae','Southern pin beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus micans','Animalia','','Great spruce bark beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus ponderosae','Animalia','Curculionidae','Mountain pine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus pseudotsugae','Animalia','','Douglas fir beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus rufipennis','Animalia','','Spruce beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus spp.','Animalia','','Pine beetles');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus valens','Animalia','Curculionidae','Red turpentine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendrolimus sibiricus','Animalia','','Siberian silk moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmodium mosaic virus (Potyviridae)','Viruses','','Desmodium mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Desmodium yellow mottle virus (Tymovirus)','Viruses','','Desmodium yellow mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Deudorix isocrates','Animalia','Lycaenidae','Anar caterpillar');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Deuterophoma tracheiphila','Fungi','','Mal secco');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica barberi','Animalia','','Northern corn rootworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica speciosa','Animalia','','Cucurbit beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica spp.','Animalia','','Cucumber beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica undecimpunctata','Animalia','Chrysomelidae','Spotted cucumber beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica virgifera','Animalia','Chrysomelidae','Western corn rootworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica virgifera virgifera','Animalia','Chrysomelidae','Western corn rootworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diacrotricha fasciola','Animalia','','Starfruit flower moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaphania nitidalis','Animalia','','Pickle worm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaphorina citri','Animalia','','Asian citrus psyllid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaporthe helianthi','Fungi','','Stem canker & Stalk rot of Sunflower');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaporthe mali','Fungi','','Apple blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaporthe perniciosa','Fungi','','Phomopsis canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaporthe phaseolorum var caulivora','Fungi','','Stem canker of soybean');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaporthe phaseolorum var meridionalis','Fungi','','Soyabean stem canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaporthe tanakae','Fungi','','Diaporthe canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaporthe vaccinii','Fungi','','Fruit rot & twig blight of Ericaceae');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaprepes abbreviatus','Animalia','','Sugarcane stalk borer weevel');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaspidiotus gigas','Animalia','','Scale insect');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diatraea saccharalis','Animalia','','Stalk borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diclavaspis socotrana','Animalia','','scale insect');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Didymella rabiei','Fungi','','Blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Digitaria streak virus (Mastrevirus)','Viruses','','Digitaria streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dilobopterus costalimai','Animalia','','Sharpshooter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dioscorea alata virus (Potyvirus)','Viruses','','Dioscorea alata virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dioscorea green banding mosaic virus (Potyvirus)','Viruses','','Dioscorea green banding mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Distantiella theobroma','Animalia','','Cacao capsid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ditylenchus angustus','Animalia','','Rice stem nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ditylenchus destructor','Animalia','','Potato rot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ditylenchus khani','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dodonaea yellows-associated virus (Unassigned)','Viruses','','Dodonaea yellows-associated virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dolichoderus thoracicus','Animalia','','Ant');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dolichodorus heterocephalus','Animalia','','Awl nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dolichos yellow mosaic virus (Begomovirus)','Viruses','','Dolichos yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Draeculacephala minerva','Animalia','Cicadellidae','Green sharpshooter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drepanococcus cajani','Animalia','','Scale insect');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Drepanococcus chiton','Animalia','','Wax scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dreyfusia piceae','Animalia','','Balsam woolly aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryocoetes confusus','Animalia','','Western balsam bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryocosmus kuriphilus','Animalia','','Oriental chestnut gall wasp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dulcamara mottle virus (Tymovirus)','Viruses','','Dulcamara mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Duponchelia fovealis','Animalia','','Southern European marshland pyralis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dwarf aster yellows','Viruses','','Dwarf aster yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dysides obscurus','Animalia','','Auger beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dysmicoccus grassii','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dysmicoccus insulae','Animalia','','Mealybug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dysmicoccus neobrevipes','Animalia','Pseudococcidae','Pineapple mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dysmicoccus nesophilus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dyspessa ulula','Animalia','','Garlic carpenterworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Echinochloa ragged stunt virus (Oryzavirus)','Viruses','','Echinochloa ragged stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Echinothrips americanus','Animalia','','Thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eggplant green mosaic virus (Potyviridae)','Viruses','','Eggplant green mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eggplant mottled crinkle virus (Tombusvirus)','Viruses','','Eggplant mottle crinkle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eggplant mottled dwarf virus Nucleorhabdovirus)','Viruses','','Eggplant mottle dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eldana saccharina','Animalia','','African sugarcane borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elderberry virus','Viruses','','Elderberry virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elm mottle virus (Ilarvirus)','Viruses','','Elm mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elm phloem necrosis phytoplasma','Bacteria','','Elm phloem necrosis phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elm witches\'-broom phytoplasma','Bacteria','','Elm witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elm yellows phytoplasma','Bacteria','','Elm yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Elytroteinus subtruncatus','Animalia','','Fiji ginger weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enaphalodes rufulus','Animalia','','Red oak borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Endecatomus lanatus','Animalia','','Powder post beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Endocronartium harknessii','Fungi','Cronartiaceae','Western gall rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Enterobacter cancerogenus','Bacteria','Enterobacteriaceae','Canker and dieback');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Entyloma oryzae','Fungi','','Leaf smut');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eotetranychus carpini','Animalia','Tetranychidae','Yellow mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eotetranychus lewisi','Animalia','','Lewis spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eotetranychus pruni','Animalia','Tetranychidae','Spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eotetranychus pyri','Animalia','','Spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epichoristodes acerbella','Animalia','','South African carnation leafroller');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epidiaspis leperii','Animalia','Diaspididae','Italian pear scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epirus cherry virus (Ourmiavirus)','Viruses','','Epirus cherry virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epitrix cucumeris','Animalia','','Potato flea beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epitrix tuberis','Animalia','','Tuber flea beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erannis defoliaria','Animalia','','Mottled umber moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriophyes gossypii','Animalia','','Cotton blister mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eriophyes litchii','Animalia','','Litchi gall mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erosomyia mangiferae','Animalia','Cecidomyiidae','Mango gall midge');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erthesina fullo','Animalia','Pentatomidae','Yellow spotted stink bug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia amylovora','Bacteria','Enterobacteriaceae','Fireblight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia herbicola pv. gypsophilae','Bacteria','Enterobacteriaceae','');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia pyrifoliae','Bacteria','Enterobacteriaceae','Blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia salicis','Bacteria','Enterobacteriaceae','Willow watermark');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erysimum latent virus (Tymovirus)','Viruses','','Erysimum latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eublemma rufimixta','Animalia','','Noctuid moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eulecanium gigantea','Animalia','','Nut scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euonymus mosaic agents (Flexiviridae)','Viruses','','Euonymus mosaic agents');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia mosaic virus (Germinviridae)','Viruses','','Euphorbia mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphorbia ringspot virus (Potyviridae)','Viruses','','Euphorbia ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphranta canadensis','Animalia','','Currant fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euphranta japonica','Animalia','','Japanese cherry fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('European aster yellows phytoplasma','Bacteria','','European aster yellows');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('European stone fruit yellows phytoplasma','Bacteria','','European stone fruit yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('European wheat striate mosaic virus (Unassigned)','Viruses','','European wheat striate mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eurygaster integriceps','Animalia','','Sunn pest');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eurytoma amygdali','Animalia','','Almond fruit wasp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eurytoma laricis','Animalia','','Larch seed wasp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eurytoma samsonovi','Animalia','','Apricot chalcidoid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eurytoma schreineri','Animalia','','Seed wasp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euscepes postfasciatus','Animalia','','West Indian sweet potato weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euvarroa sinhai','Animalia','','Brood mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Exallomochlus philippinensis','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Exallomochlus sulawesicus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Exobasidium vexans','Fungi','','Blister blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Exosoma lusitanica','Animalia','','Leaf beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Faba bean necrotic yellows virus (Nanovirus)','Viruses','','Faba bean necrotic yellows virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Festuca leaf streak virus (Cytorhabdovirus)','Viruses','','Festuca leaf streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fig virus S (Flexiviridae)','Viruses','','Fig virus S');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Figwort mosaic virus (Caulimovirus)','Viruses','','Figwort mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Flavescence doree phytoplasma','Bacteria','','Flavescence doree phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Foxtail mosaic virus (Potexvirus)','Viruses','','Foxtail mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Frankliniella insularis','Animalia','','Blossom thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fulvius dimidiatus','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Furcaspis oceanica','Animalia','','Coconut red scale');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium circinatum','Fungi','Nectriaceae','Pitch canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium fulginasporum','Fungi','','Smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. albedinis','Fungi','','Bayoudh disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. allii','Fungi','','Yellows: celery');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. asparagi','Fungi','','Foot rot: Asparagus spp.');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. elaeidis','Fungi','','Fusarium wilt of Canary Island date palms');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium sacchari','Fungi','','Pineapple eye rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium tucumaniae','Fungi','','Sudden death syndrome');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium virguliforme','Fungi','','Sudden death syndrome of soybean');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma asteris','Bacteria','','Gentian witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gibberella circinata','Fungi','','Pitch canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gilpinia hercyniae','Animalia','','European spruce sawfly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Globodera pallida','Animalia','','Golden cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Globodera tabacum','Animalia','','Tobacco nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnathotrichus sulcatus','Animalia','Curculionidae','Western hemlock wood stainer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Goldenrod yellows phytoplasma','Bacteria','','Goldenrod yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine Algerian latent virus (Tombusvirus)','Viruses','','Grapevine Algerian latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine asteroid mosaic virus (Unassigned)','Viruses','','Grapevine asteroid mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine berry inner necrosis virus (Trichovirus)','Viruses','','Grapevine berry inner necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine Bratislava mosaic agent','Viruses','','Grapevine Bratislava mosaic agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine Bulgarian latent virus (Nepovirus)','Viruses','','Grapevine Bulgarian latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine chasselas latent agent','Viruses','','Grapevine chasselas latent agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine chrome mosaic (Nepovirus)','Viruses','','Grapevine chrome mosaic nepovirus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine flavescence doree phytoplasma','Bacteria','','Flavescence doree of grapevine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine stunt virus (Unassigned)','Viruses','','Grapevine stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine Tunisian ringspot virus (Nepovirus)','Viruses','','Grapevine Tunisian ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine Ajinashika disease (Luteoviridae)','Viruses','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine line pattern virus (Bromoviridae)','Viruses','','Grapevine line pattern');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine virus C (Vitivirus)','Viruses','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapevine virus D (Vitivirus)','Viruses','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Graphocephala atropunctata','Animalia','Cicadellidae','Blue-green sharpshooter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapholita funebrana','Animalia','','Plum fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapholita inopinata','Animalia','','Manchurian fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapholita packardi','Animalia','Tortricidae','Cherry fruit worm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapholita prunivora','Animalia','Tortricidae','Lesser appleworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grapholita prunivorana','Animalia','','Lesser apple worm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gremmeniella abietina','Fungi','','Scleroderris canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grey dogwood witches\'-broom phytoplasma','Bacteria','','Grey dogwood witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Groundnut chlorotic leaf streak virus','Viruses','','Groundnut chlorotic leaf streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Groundnut chlorotic spot virus (Flexiviridae)','Viruses','','Groundnut chlorotic spot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Groundnut eyespot virus (Potyvirus)','Viruses','','Groundnut eyespot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Groundnut rosette assistor virus (Luteoviridae)','Viruses','','Groundnut rosette assistor virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Groundnut rosette virus (Umbravirus)','Viruses','','Groundnut rosette virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Groundnut witches broom','Bacteria','','Groundnut witches broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guar top necrosis virus (Unassigned)','Viruses','','Guar top necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guinea grass mosaic virus (Potyvirus)','Viruses','','Guinea grass mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gymnosporangium asiaticum','Fungi','','Japanese pear rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gymnosporangium clavipes','Fungi','','Quince rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gymnosporangium fuscum','Fungi','','Pear trellis rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gymnosporangium globosum','Fungi','','American hawthorn rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gymnosporangium juniperi-virginianae','Fungi','','Cedar apple rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gymnosporangium yamadae','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hamaspora longissima','Fungi','','leaf rust of Rubus species');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haplothrips chinensis','Animalia','Phlaeothripidae','Thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Haptoncurina motschulskii','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heilipus lauri','Animalia','','Avocado seed weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helenium virus S (Carlavirus)','Viruses','','Helenium virus S');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helenium virus Y Potyvirus)','Viruses','','Helenium virus Y');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helicoverpa zea','Animalia','Noctuidae','Corn earworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helix pomatia','Animalia','Helicidae','Edible snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemerocampa leucostigma','Animalia','','White-marked tussock moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiberlesia diffinis','Animalia','','Scale insect');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemiberlesia pitysophila','Animalia','','Pine needle hemiberlesian scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemileia vastetrix','Fungi','','Coffee rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hemimene juliana','Animalia','','Nut fruit tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Henbane mosaic virus (Potyvirus)','Viruses','','Henbane mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heracleum latent virus (Vitivirus)','Viruses','','Heracleum latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hesperophanes campestris','Animalia','Cerambycidae','Longhorned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera cajani','Animalia','','Pigeon pea cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera ciceri','Animalia','','Chickpea cyst nematode');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera glycines','Animalia','','Soybean cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera goettingiana','Animalia','','Pea cyst nematode');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera latipons','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera sacchari','Animalia','','Rice nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera zeae','Animalia','','Corn cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterotermes tenuis','Animalia','','Subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibiscus latent ringspot virus (Nepovirus)','Viruses','','Hibiscus latent ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hibiscus leaf curl agent','Viruses','','Hibiscus leaf curl agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hirschmanniella gracilis','Animalia','','Rice root nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hirschmanniella imamuri','Animalia','','Rice root nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hirschmanniella magna','Animalia','','Rice root nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hirschmanniella miticausa','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hirschmanniella spinicaudata','Animalia','','Rice nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Holotrichia mindanaona','Animalia','','White grub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalodisca coagulate','Animalia','','Glassy winged sharpshooter');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalodisca vitripennis','Animalia','Cicadellidae','Glassy-winged sharpshooter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homona coffearia','Animalia','Tortricidae','Tea tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Honeysuckle latent virus (Carlavirus)','Viruses','','Honeysuckle latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hop trefoil cryptic virus 1 (Alphacryptovirus','Viruses','','Hop trefoil cryptic virus 1');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hop trefoil cryptic virus 2 (Betacrypotvirus)','Viruses','','Hop trefoil cryptic virus 2');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hop trefoil cryptic virus 3 (Alphacrypotvirus)','Viruses','','Hop trefoil cryptic virus 3');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplolaimus spp.','Animalia','','Lance nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplocampa danfengensis','Animalia','','Cherry sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplocampa flava','Animalia','','Plum sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplocampa fulvicornis','Animalia','','Plum fruit sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplocampa testudinea','Animalia','','European apple sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hoplocerambyx spinicornis','Animalia','','Longhorned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hordeolicoccus nephelii','Animalia','','Big-eyed mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hordeum mosaic virus (Rymovirus)','Viruses','','Hordeum mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Unknown pathogenic virus 11','Viruses','','Horsechestnut variegation agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Unknown pathogenic virus 12','Viruses','','Horsechestnut yellow mosaic agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Horsegram yellow mosaic virus (Germiniviridae)','Viruses','','Horsegram yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Humulus japonicus virus','Viruses','','Humulus japonicus virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hyacinth mosaic virus (Potyvirus)','Viruses','','Hyacinth mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrangea mosaic viris (Ilarvirus)','Viruses','','Hydrangea mosaic viris');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma japonicum','Bacteria','','Hydrangea phyllody');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrangea ringspot virus (Potexvirus)','Viruses','','Hydrangea ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hydrangea virescence phytoplasma','Bacteria','','Hydrangea virescence');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylemya antiqua','Animalia','','Onion maggot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylobius pales','Animalia','','Pales weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylurgopinus rufipes','Animalia','','Elm bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylurgus palliatus','Animalia','','Exotic bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hymenula cerealis','Fungi','','Cephalosporium stripe: cereals');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hyphantria cunea','Animalia','Arctiidae','Blackheaded webworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypothenemus hampei','Animalia','Curculionidae','Coffee bean borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypoxylon mammatum','Fungi','','Hypoxylon canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crypticerya genistae','Animalia','','Scale insect');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Illinoia liriodendri','Animalia','','Tuliptree aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Illinoia morrisoni','Animalia','','Aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indian peanut clump virus (Pecluvirus)','Viruses','','Indian peanut clump virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Indonesian soybean dwarf virus (Luteoviridae)','Viruses','','Indonesian soybean dwarf virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phellinus weirii','Fungi','','Laminated root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Insulaspis orsoni','Animalia','','Armoured scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips amitinus','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips calligraphus','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips cembrae','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips confusus','Animalia','','California fivespined ips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips duplicatus','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips lecontei','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips paraconfusus','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips pini','Animalia','Curculionidae','Pine engraver');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips plastographus','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips sexdentatus','Animalia','Curculionidae','Bark beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips typographus','Animalia','Curculionidae','Spruce bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize Iranian mosaic virus (Rhabdoviridae)','Viruses','','Iranian maize mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urentius hystricellus','Animalia','','Eggplant lace bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Iris fulva mosaic virus (Potyvirus)','Viruses','','Iris fulva mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Japanese iris necrotic ring virus (Carmovirus)','Viruses','','Iris Japanese necrotic ring virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Jatropha mosaic virus (Germiniviridae)','Viruses','','Jatropha mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus phytoplasma ziziphi','Bacteria','','Jujube witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kalanchoe isometric virus (Unassigned)','Viruses','','Kalanchoe isometric virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kalanchoe latent virus (Carlavirus)','Viruses','','Kalanchoe latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kalanchoe top-spotting virus (Badnavirus)','Viruses','','Kalanchoe top-spotting virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kandyosilis cochleata','Animalia','','Soldier beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Konjac mosaic virus (Potyvirus)','Viruses','','Konjac mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kytorhinus immixtus','Animalia','','Seed weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kyuri green mottle mosaic virus (Tobamovirus)','Viruses','','Kyuri green mottle mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lachnellula willkommii','Fungi','','European larch canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lamium mild mottle virus (Fabavirus)','Viruses','','Lamium mild mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Larinus planus','Animalia','','Canada thistle bud weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Laspeyresia spp.','Animalia','','Fruit worm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lato River virus (Tombusvirus)','Viruses','','Lato River virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lehmannia valentiana','Animalia','','Valencia slug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lema dilecta','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosaphes chinensis','Animalia','','Chinese lepidosaphes scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lepidosaphes salicina','Animalia','','Willow oyster scale');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptinotarsa decemlineata','Animalia','Chrysomelidae','Colorado potato beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptoglossus chilensis','Animalia','','Brown chilean leaf-footed bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptosphaeria libanotis','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lettuce infectious yellows virus (Crinivirus)','Viruses','','Lettuce infectious yellows virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lettuce speckles mottle virus (Umbravirus)','Viruses','','Lettuce speckles mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucoma salicis','Animalia','','Satin moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucoptera coffeella','Animalia','','White coffee leaf miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucoptera malifoliella','Animalia','','Pear leaf blister moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leucostoma cincta','Fungi','','Stonefruit canker');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter africanus','Bacteria','','Huanglongbing (african strain)');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter asiaticus','Bacteria','Rhizobiaceae','Citrus greening');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lilac chlorotic leafspot virus (Capilovirus)','Viruses','','Lilac chlorotic leafspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lilac mottle virus (Carlavirus)','Viruses','','Lilac mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lilac ring mottle virus (Ilarvirus)','Viruses','','Lilac ring mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lily mottle virus Potyvirus)','Viruses','','Lily mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lily virus X (Potexvirus)','Viruses','','Lily virus X');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lima bean golden mosaic virus','Viruses','','Limabean golden mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lime witches? broom phytoplasma','Bacteria','','Lime witches? broom phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Limonius californicus','Animalia','','Wireworm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza bryoniae','Animalia','','Leaf-miner');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza huidobrensis','Animalia','Agromyzidae','Leaf-miner');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza sativae','Animalia','Agromyzidae','Leaf-miner');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza trifolii','Animalia','Agromyzidae','American serpentine leaf-miner');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lissorhoptrus oryzophilus','Animalia','Curculionidae','Rice water weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Listroderes subcinctus','Animalia','','Chilean vegetable weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Litargus connexus','Animalia','','Hairy Fungi beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lobesia botrana','Animalia','Tortricidae','European grapevine moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Longidorus jiangsuensis','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Loofah witches\'-broom phytoplasma','Bacteria','','Loofah witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lopholeucaspis cockerelli','Animalia','Diaspididae','Cockerell scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lychnis ringspot virus (Hordeivirus)','Viruses','','Lychnis ringspot virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria dispar','Animalia','','Gypsy moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria mathura','Animalia','Lymantriidae','Pink gypsy moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria monacha','Animalia','','Nun moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maclura mosaic virus (Macluravirus)','Viruses','','Maclura mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maconellicoccus multipori','Animalia','','Mealybug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma asteris','Bacteria','','Maize bushy stunt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize chlorotic dwarf virus (Waikavirus)','Viruses','','Maize chlorotic dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize chlorotic mottle virus (Machlomovirus)','Viruses','','Maize chlorotic mottle virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize dwarf mosaic virus (Potyvirus)','Viruses','Potyviridae','Maize dwarf mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize line virus (Unassigned)','Viruses','','Maize line virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize mottle/chlorotic stunt virus (Unassigned)','Viruses','','Maize mottle/chlorotic stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize rayado fino virus (Marafivirus)','Viruses','','Maize rayado fino virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize rough dwarf virus (Fijivirus)','Viruses','','Maize rough dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize streak virus Mastrevirus)','Viruses','','Maize streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maize white line mosaic virus (Unassigned)','Viruses','','Maize white line mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malacosoma americanum','Animalia','Lasiocampidae','Eastern tent caterpillar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Malacosoma disstria','Animalia','Lasiocampidae','Forest tent caterpillar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Margarodes prieskaensis','Animalia','','Groundpearls');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Margarodes vitis','Animalia','','Groundpearls');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Margarodes vredendalensis','Animalia','','Groundpearls');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marginitermes spp','Animalia','','Termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marguerite yellows phytoplasma','Bacteria','','Marguerite yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marigold mottle virus (Potyviridae)','Viruses','','Marigold mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Marmara gulosa','Animalia','','Citrus peelminer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Maryland aster yellows','Bacteria','','Maryland aster yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Matsucoccus feytaudi','Animalia','','Maritime pine bast scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Matsucoccus matsumurae','Animalia','','Japanese pine bast scale');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mayetiola destructor','Animalia','Cecidomyiidae','Hessian fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mecinus pyraster','Animalia','','Snout weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Megacyllene caryae','Animalia','','Painted hickory borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Megalometis chilensis','Animalia','','Cane weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Megaplatypus mutatus','Animalia','','Ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melampsora farlowii','Fungi','','Hemlock rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melanaspis corticosa','Animalia','','South African obscure scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melanaspis elaeagni','Animalia','','Black eleagnus scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melanaspis nigropunctata','Animalia','','Armoured scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melanaspis rhizophorae','Animalia','','Scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melandrium yellow fleck virus (Bromovirus)','Viruses','','Melandrium yellow fleck virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melanomma glumarum','Fungi','','Glume blotch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melanotus communis','Animalia','','Wireworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne minor','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne chitwoodi','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne citri','Animalia','','Citrus root-knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne donghalensis','Animalia','','Citrus root-knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne fujianensis','Animalia','','Citrus root-knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne indica','Animalia','','Citrus root-knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne jianyangensis','Animalia','','Citrus root-knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne kongi','Animalia','','Root-knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne lini','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Meloidogyne mingnanica','Animalia','','Citrus root-knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melolontha melolontha','Animalia','Scarabaeidae','cockchafer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melon leaf curl virus','Viruses','','Melon leaf curl virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melon necrotic spot virus (Carmovirus)','Viruses','','Melon necrotic spot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ourmia melon virus (Ourmiavirus)','Viruses','','Melon Ourmia virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melon rugose mosaic virus (Tymovirus)','Viruses','','Melon rugose mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mercetaspis halli','Animalia','Diaspididae','Hall scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Metamasius hemipterus','Animalia','','Pineapple borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Metamasius spp','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Octaspidiotus stauntoniae','Animalia','','Scale insect');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma Mexican periwinkle virescence group','Bacteria','','Mexican periwinkle virescence');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Microcyclus ulei','Fungi','','American leaf disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Milk vetch dwarf virus (Nanovirus)','Viruses','','Milk vetch dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mimosa mosaic virus (Unassigned)','Viruses','','Mimosa mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Minutaleyrodes minutes','Animalia','','Minute white fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mirabilis mosaic virus (Caulimovirus)','Viruses','','Mirabilis mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Miscanthus streak virus (Mastrevirus)','Viruses','','Miscanthus streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mitsuba witches\'-broom phytoplasma','Bacteria','','Mitsuba witches\'-broom');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monilinia fructigena','Fungi','Sclerotiniaceae','Brown rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Moniliophthora roreri','Fungi','','Monilia pod rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus alternatus','Animalia','','Japanese pine sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus carolinensis','Animalia','','Pine sawyer beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus marmorator','Animalia','','Balsam fir sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus mutator','Animalia','','Spotted pine sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus nitens','Animalia','','Sawyer beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus obtusus','Animalia','','Sawyer beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus saltuarius','Animalia','','Sawyer beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus scutellatus','Animalia','','White spotted sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus spp.','Animalia','','Sawyer beetles');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus titillator','Animalia','','Southern pine sawyer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monomorium antarcticum','Animalia','','Southern ant');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mononychellus tanajoa','Animalia','','Green cassava mite; Tanajoa mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mulberry latent virus (Carlavirus)','Viruses','','Mulberry latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mulberry ringspot virus (Nepovirus)','Viruses','','Mulberry ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mungbean yellow mosaic virus (Begomovirus)','Viruses','','Mung bean yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mungbean yellow mosaic India virus','Viruses','','Mungbean yellow mosaic India virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Muskmelon vein necrosis virus (Carlavirus)','Viruses','','Muskmelon vein necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycena citricolor','Fungi','','Cock\'s eye');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycetaspis personata','Animalia','Diaspididae','Masked scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycetaspis sphaerioides','Animalia','','Armoured scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella dearnessii','Fungi','','Black leaf streak');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella gibsonii','Fungi','','Needle blight of pine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella laricis-leptolepidis','Fungi','','Needle cast of Japanese larch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella populorum','Fungi','','Septoria canker of poplar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycovellosiella vaginae','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myndus crudus','Animalia','','American palm ciixid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myiopardalis pardalina','Animalia','','Baluchistan melon fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Myrobalan latent ringspot virus (Nepovirus)','Viruses','','Myrobalan latent ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mythimna loreys','Animalia','','Armyworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nacobbus aberrans','Animalia','','Sugar beet false root knot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nasutitermes corniger','Animalia','','Arboured termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Naupactus xanthographus','Animalia','','South American fruit tree weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neckar River virus (Tombusvirus)','Viruses','','Neckar River virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nectria galligena','Fungi','','European canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nectria mauritiicola','Fungi','','Violet root rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nectriella pironii','Fungi','','Stem gall');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nemorimyza maculosa','Animalia','','Blotch leaf miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neoaliturus haematoceps','Animalia','','Leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neoclytus rufus','Animalia','','Borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neoselenaspidus silvaticus','Animalia','','Mango shield scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neotrionymus monstatus monstatus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Neotrionymus monstatus periolanus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nerine latent virus (Carlavirus)','Viruses','','Nerine latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nerine virus','Viruses','','Nerine virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nerine virus X (Potexvirus)','Viruses','','Nerine virus X');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('New Jersey aster yellows phytoplasma','Bacteria','','New Jersey aster yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nipaecoccus nipae','Animalia','Pseudococcidae','Coconut mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Northern cereal mosaic virus (Cyotrhabdovirus)','Viruses','','Northern cereal mosaic virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Numonia pirivorella','Animalia','','Pear fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oak ringspot virus (Unassigned)','Viruses','','Oak ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oat blue dwarf virus (Marafivirus(','Viruses','','Oat blue dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oat golden stripe virus (Furovirus)','Viruses','','Oat golden stripe virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oat mosaic virus (Bymovirus)','Viruses','','Oat mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oat necrotic mottle virus (Rymovirus)','Viruses','','Oat necrotic mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oat red streak mosaic virus (Unassigned)','Viruses','','Oat red streak mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oat sterile dwarf virus (Fijivirus)','Viruses','','Oat sterile dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Odonototermes formosanus','Animalia','','Formosan subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oklahoma aster yellows phytoplasma','Bacteria','','Oklahoma aster yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Okra leaf-curl virus (Geminiviridae)','Viruses','','Okra leaf-curl virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Okra mosaic virus (Tymovirus)','Viruses','','Okra mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Okra yellow leaf curl agent','Viruses','','Okra yellow leaf curl agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus gossypii','Animalia','','Spider Mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus grypus','Animalia','','Spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus indicus','Animalia','','Sugarcane leaf mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus perditus','Animalia','','Spider Mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus peruvianus','Animalia','','Spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus sacchari','Animalia','','Sugarcane mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus yothersi','Animalia','','Avocado red mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Olive latent ringspot virus (Nepovirus)','Viruses','','Olive latent ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Omphisa anastomosalis','Animalia','','Sweet potato stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oncobasidium theobromae','Fungi','','Vascular sreak dieback');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oncometopia facialis','Animalia','','Sharpshooter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Onions yellow mosaic virus (Tymovirus)','Viruses','','Onions yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oospora oryzetorum','Fungi','','Skin spot of rice');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Operophtera brumata','Animalia','Geometridae','Winter moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophiostoma novo-ulmi','Fungi','','Dutch elm disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophiostoma quercus','Fungi','','Bluestain Fungi');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophiostoma ulmi','Fungi','','Dutch elm disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophiostoma grosmannia','Fungi','','Black stain root disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Opogona aurisquamosa','Animalia','','Moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Opogona sacchari','Animalia','','Banana moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sammon\'s Opuntia virus (Tobamovirus)','Viruses','','Opuntia Sammon\'s virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Opuntiaspis carinata','Animalia','','Keeled mytilaspis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orgyia antiqua','Animalia','Lymantriidae','Rusty tussock moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orgyia pseudotsugata','Animalia','','Douglas-fir tussock moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oryctes monoceros','Animalia','','Coconut beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oryctes rhinoceros','Animalia','Scarabaeidae','Rhinoceros beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ostrinia nubilalis','Animalia','Pyralidae','European corn borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Otiorhynchus ligustici','Animalia','','Alfalfa snout beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Otiorhynchus singularis','Animalia','Curculionidae','Clay coloured weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oulema melanopus','Animalia','Chrysomelidae','Cereal leaf beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ovulariopsis caricae','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oxycarenus hyalinipennis','Animalia','','Cotton seed bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oxycarenus lavaterae','Animalia','','Bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pachymerus pallidus','Animalia','','Seenapod weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Palm lethal yellowing phytoplasma','Bacteria','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pammene fasciana','Animalia','','Chestnut leaf roller');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pandemis cerasana','Animalia','','Common twist moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Panicum streak virus (Mastrevirus)','Viruses','','Panicum streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Papaya leaf curl virus (Begomovirus)','Viruses','','Papaya leaf curl virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paprika mild mottle virus (Tobamovirus)','Viruses','','Paprika mild mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracoccus interceptus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracoccus marginatus','Animalia','Pseudococcidae','Papaya mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paranthrene tabaniformis','Animalia','','Dusky clearwing');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cataenococcus hispidus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paratachardina lobata lobata','Animalia','','Lobate lac scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paratettix mexicanus','Animalia','','Mexican pygmy grasshopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parietaria mottle virus (Ilarvirus)','Viruses','','Parietaria mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parlatoreopsis chinensis','Animalia','Diaspididae','Chinese obscure scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parlatoria crypta','Animalia','Diaspididae','Mango white scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parsnip leafcurl virus (Unassigned)','Viruses','','Parsnip leafcurl virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Parsnip mosaic virus (Potyvirus)','Viruses','','Parsnip mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Passiflora latent virus (Carlavirus)','Viruses','','Passiflora latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Passion fruit ringspot virus (Potyviridae)','Viruses','','Passiflora ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cowpea aphid-borne mosaic virus (Potyvirus)','Viruses','','Passiflora South African virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Passionfruit yellow mosaic virus (Tymovirus)','Viruses','','Passionfruit yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Patchouli mosaic virus (Potyviridae)','Viruses','','Patchouli mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paysandisia archon','Animalia','','Castniid palm borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pea early-browning virus (Tobravirus)','Viruses','','Pea early browning virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pea enation mosaic virus-1 (Enamovirus)','Viruses','','Pea enation mosaic virus-1');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pea enation mosaic virus-2 (Umbravirus)','Viruses','','Pea enation mosaic virus-2');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pea false leaf roll virus','Viruses','','Pea false leaf roll virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pea mild mosaic virus (Comovirus)','Viruses','','Pea mild mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach mosaic virus (Closterovirus)','Viruses','','Peach mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach rosette mosaic virus (Nepovirus)','Viruses','','Peach rosette mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach rosette phytoplasma','Bacteria','Tenericutes','Peach rosette');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach wart agent','Unknown','','Peach wart agent');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma pruni','Bacteria','Tenericutes','Peach X-disease phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach yellow leaf roll (Closteroviridae)','Viruses','','Peach yellow leaf roll');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma ulmi','Bacteria','Tenericutes','Peach yellows phytoplasma');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pealius mori','Animalia','','Mulberry whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peanut chlorotic streak virus (Soymovirus)','Viruses','','Peanut chlorotic streak virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peanut clump virus (Pecluvirus)','Viruses','','Peanut clump virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peanut green mosaic virus (Potyvirus)','Viruses','','Peanut green mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peanut stunt virus (Cucumovirus)','Viruses','','Peanut stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peanut yellow spot virus (Tospovirus)','Viruses','','Peanut yellow spot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pecan bunch phytoplasma','Bacteria','','Pecan bunch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perileucoptera coffeella','Animalia','','Coffee leafminer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Perkinsiella vastatrix','Animalia','','Planthopper');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sacchari','Fungi','','Sugar cane downy mildew');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sorghi','Fungi','','Sorghum downy mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pestalotiopsis hartigii','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phacidiopycnis pseudotsuga','Fungi','','Douglas fir canker');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaeoramularia angolensis','Fungi','','Cercosporiose of citrus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaeosclerotinia nipponica','Fungi','','Leaf spot: apple');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pharaxonotha kirschi','Animalia','','The Mexican grain beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phellinus weirii','Fungi','','Laminated butt rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phenacaspis tangana','Animalia','','Armoured scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phenacoccus manihoti','Animalia','','Cassava mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phialophora cinerescens','Fungi','','Carnation wilt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phialophora gregata','Fungi','','Brown stem rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phialophora malorum','Fungi','','Fruit rot: apple');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Philaenus spumarius','Animalia','Aphrophoridae','Meadow froghopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus\' Phlomobacter fragariae','Bacteria','','Strawberry marginal chlorosis');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoma andigena','Fungi','','Black blight of potatoes');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoma terrestris','Fungi','','Pink rot of onion');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoma tracheiphila','Fungi','Incertae sedis','Mal secco');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phomopsis vitimegaspora','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllactinia papayae','Fungi','','Powdery mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllophaga smithi','Animalia','','White cane grub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllophaga spp.','Animalia','','June beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllosticta solitaria','Fungi','','Apple blotch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllotreta chotanica','Animalia','','Striped flea beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllotreta pallidipennis','Animalia','','Flea beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phymatodes testaceus','Animalia','','Tanbark borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phymatotrichopsis omnivora','Fungi','Rhizinaceae','Texas root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Physoderma leproides','Fungi','','Beet tumor');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora fragariae var. fragariae','Fungi','','Red steele root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora lateralis','Fungi','','Root rot: Chamaecyparis spp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora nemorosa','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora phaseoli','Fungi','','Downy mildew of lima bean');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora quercina','Fungi','','Oak decline');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora ramorum','Fungi','Pythiaceae','Sudden oak death');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora alni','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora kernoviae','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pieris brassicae','Animalia','','Large white butterfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pinnaspis dracaeanae','Animalia','','Armoured scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pinnaspis musae','Animalia','Diaspididae','Banana scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pissodes castaneus','Animalia','','Smal banded pine weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pissodes nemorensis','Animalia','','Deodar weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pissodes spp.','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pissodes strobi','Animalia','','White pine weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pissodes terminalis','Animalia','','Lodgepole terminal weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityogenes chalcographus','Animalia','','Sixtoothed spruce bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pityophthorus juglandis','Animalia','','Walnut twig beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planococcus bagmaticus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planococcus bendovi','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planococcus lilacinus','Animalia','Pseudococcidae','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planococcus litchi','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Planococcus philippinensis','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platypus quercivorus','Animalia','','Oak ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plum bark split virus (Birnaviridae)','Viruses','','Plum bark split virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plum leptonecrosis phytoplasma','Bacteria','','Plum leptonecrosis');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plum pox virus (Potyvirus)','Viruses','Potyviridae','Plum pox virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plum rusty blotch','Unknown','','Plum rusty blotch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Podosphaera pannosa','Fungi','','Powdery mildew of rose');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pogonomyrmex occidentalis','Animalia','','Western harvester ant');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Poliaspis cycadis','Animalia','','Cycad poliapis scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polyscytalum pustulans','Fungi','','Skin spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Popillia japonica','Animalia','Scarabaeidae','Japanese beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato Andean latent virus (Tymovirus)','Viruses','','Potato Andean latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato Andean mottle virus (Comovirus)','Viruses','','Potato Andean mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato black ringspot virus (Nepovirus)','Viruses','','Andean potato calico strain');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato deforming mosaic virus (Begomovirus)','Viruses','','Potato deforming mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato mop-top virus (Pomovirus)','Viruses','','Potato mop-top virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato stolbur phytoplasma','Bacteria','','Potato stolbur');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato virus T (Flexiviridae)','Viruses','','Potato virus T');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato virus U (Nepovirus)','Viruses','','Potato virus U');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato virus V (Potyvirus)','Viruses','','Potato virus V');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato yellow dwarf virus (Nucleorhabdovirus)','Viruses','','Potato yellow dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato yellow vein disease (Unknown)','Viruses','','Potato yellow vein disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato yellowing virus (Alfamovirus)','Viruses','','Potato yellowing virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potebniamyces pyri','Fungi','','Phacidipycnis rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pratylenchus convallariae','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pratylenchus indicus','Animalia','','Root lesion nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pratylenchus laticauda','Animalia','','Root lesion nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prays citri','Animalia','','Citrus flower moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prays endocarpa','Animalia','','Citrus fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Premnotrypes latithorax','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Premnotrypes spp.','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Premnotrypes suturicallis','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Premnotrypes vorax','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('primula yellows phytoplasmas','Bacteria','','Primula yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prodenia litura','Animalia','','Cotton leafworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Proeulia spp.','Animalia','','Tortricid moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Promecotheca cumingii','Animalia','','Coconut hispid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prometopia quadrimaculata','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Prostephanus truncatus','Animalia','','Greater grain borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Proterhinus vestitus','Animalia','','Armoured scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptamorpha desjardinsii','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudischnaspis bowreyi','Animalia','','Bowrey scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudocercospora actinidiae','Fungi','','Sooty spot of kiwi fruit');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus apoplanus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus aurantiacus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus baliteus','Animalia','','Aerial root mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus comstocki','Animalia','Pseudococcidae','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus floriger','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus jackbeardsleyi','Animalia','Pseudococcidae','Jack Beardsley mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus landoi','Animalia','','Lando mealybug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus maritimus','Animalia','Pseudococcidae','Grape mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus orchidicola','Animalia','','Orchid mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus philippinicus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas garcae','Bacteria','','Coffee halo blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas lignicola','Bacteria','','Bacterial stain');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas syringae pv. papulans','Bacteria','','Blister spot of apple');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas syringae pv. persicae','Bacteria','','Bacterial dieback of peach');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudopezicula tracheiphila','Fungi','','Red fire disease of grapevine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudopityophthorus minutissimus','Animalia','','Oak bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudopityophthorus pruinosus','Animalia','','Oak bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pterandrus spp.','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilinus fuscus','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptilodactyla exotica','Animalia','','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ptinus villager','Animalia','','Spider Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia gladioli','Fungi','','Gladiolus rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia macleanii','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia pittierana','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pucciniastrum actinidae','Fungi','','Rust of kiwifruit');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pucciniastrum areolatum','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pulvinaria cacao','Animalia','','Scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Punctodera chalcoensis','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pycnostysanus azaleae','Fungi','','Rhododendron bud and twig blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pyrilla perpusilla','Animalia','Lophopidae','Sugarcane planthopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Quadrastichus erythrinae','Animalia','','Erythrina gall wasp');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Radopholus citri','Animalia','','Burrowing nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Radopholus citrophilus','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Raffaelea quercivora','Fungi','','Japanese oak wilt');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ralstonia solanacearum sequevar 3 (Multilocus genotype24)','Bacteria','','Moko disease Cavendish bananas and Bugtok disease of cooking bananas');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ramularia carthami','Fungi','','Leaf spot: Safflower');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ranunculus phyllody phytoplasma','Bacteria','','Ranunculus phyllody');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Raspberry leaf curl virus (Luteoviridae)','Viruses','','Raspberry leaf curl virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Raspberry ringspot virus (Nepovirus)','Viruses','','Raspberry ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Red clover mottle virus (Comovirus)','Viruses','','Red clover mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhabdoscelus lineaticollis','Animalia','','Asiatic palm weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhacodiella vitis','Fungi','','Acorn rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhadinaphelenchus cocophilus','Animalia','','Red ring nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis cerasi','Animalia','','Cherry fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis cingulata','Animalia','','White-banded cherry fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis completa','Animalia','Tephritidae','Walnut husk fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis congulata','Animalia','','White banded cherry fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis fausta','Animalia','Tephritidae','Black cherry fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis indifferens','Animalia','Tephritidae','Western cherry fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis mendax','Animalia','','Blueberry maggot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis pomonella','Animalia','Tephritidae','Apply fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis ribicola','Animalia','','Dark currant fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis spp.','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis suavis','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizobium larrymoorei','Bacteria','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizoctonia fragariae','Fungi','','Black strawberry root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizoecus amorphophalli','Animalia','','Oriental mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizoecus floridanus','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhizoecus simplex','Animalia','','Scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhodogastria carneola','Animalia','','Tiger moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites aequatus','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites auratus','Animalia','','Apricot weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites auricapillus','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites bacchus','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites confragossicollis','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites cupreus','Animalia','','Leafroller weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites faldermanni','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites giganteus','Animalia','','Large pear fruit weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchites heros','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchophorus palmarum','Animalia','','Palm red weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhynchophorus phoenicis','Animalia','','Palm weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhyparochromus vulgaris','Animalia','','Peanut trash bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhytidodera bowringii','Animalia','Chrysomelidae','Mango longhorned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice dwarf virus (Phytoreovirus)','Viruses','','Rice dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice gall dwarf virus (Phytoreovirus)','Viruses','','Rice gall dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice hoja blanca virus (Tenuivirus)','Viruses','','Rice hoja blanca virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice tungro bacilliform virus (Tungrovirus)','Viruses','','Rice tungro bacilliform virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice tungro spherical virus (Waikavirus)','Viruses','','Rice tungro spherical virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice grassy stunt virus (Tenuivirus), rice wilted stunt strain','Viruses','','Rice wilted stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice yellow dwarf phytoplasma','Bacteria','','Rice yellow dwarf');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice yellow mottle virus (Sobemovirus','Viruses','','Rice yellow mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rigidoporus lignosus','Fungi','','White root disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rondotia menciana','Animalia','','Mulberry white caterpillar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rubus stunt phytoplasma','Bacteria','','Rubus stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sagra femorata','Animalia','','Frog-legged leafbeetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sahlbergella singularis','Animalia','','Cocoa bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Saperda spp.','Animalia','','Long horned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Satsuma dwarf virus (Sadwavirus)','Viruses','','Satsuma dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scaphoideus luteolus','Animalia','','Leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schaphoideus titanus','Animalia','','Leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scirpophaga incertulas','Animalia','','Yellow stemborer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scirtothrips citri','Animalia','','California citrus thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sclerophthora rayssiae var zeae','Fungi','','Brown stripe downy mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scolytus intricatus','Animalia','','European oak bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scolytus morawitzi','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scolytus scolytus','Animalia','','Larger elm bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scutellonema bradys','Animalia','','Yam dry rot nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selenaspidus antsingyi','Animalia','','Armoured scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selenaspidus articulatus','Animalia','','West Indian red scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Selenaspidus littoralis','Animalia','','West Indian red scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Semanotus ligneus','Animalia','','Cedar tree borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Septoria lycopersici var. malagutii','Fungi','','Septoria leafspot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Septoria melanosa','Fungi','','Melanose: Grapevine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia calamistis','Animalia','','Southern pink stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia cretica','Animalia','','Durra stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Shallot yellow stripe virus (Potyvirus)','Viruses','','Shallot yellow stripe virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Singhiella simplex','Animalia','','Fig whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Siphonatrophia cupressi','Animalia','','Aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sitonia cylindricollis','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Solenopsis richteri','Animalia','','Black imported fire ant');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphaceloma perseae','Fungi','','Avocado scab');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spilonota lechriaspis','Animalia','','Budmoth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spilonota ocellana','Animalia','Tortricidae','Eye spotted budmoth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spinach latent virus (Ilarvirus)','Viruses','','Spinach latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spiroplasma citri','Bacteria','','Citrus stubborn');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spodoptera eridania','Animalia','','Southern armyworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Spodoptera littoralis','Animalia','','Egyptian cotton leafworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Squash leaf curl virus (Begomovirud)','Viruses','','Squash leaf curl virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phaeosphaeria avenaria f. sp. triticae (anamorph Stagonospora avenae f. sp. triticea)','Fungi','','Stagonospora blotch of cereals');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stagonospora sacchari','Fungi','Incertae sedis','Leaf scorch of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stathmopoda skelloni','Animalia','','Fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Steirastoma breve','Animalia','','Cacao beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Steneotarsonemus spinki','Animalia','','Pannicle rice mite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenoma catenifer','Animalia','','Avocado seed moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenopterus rufus','Animalia','','Long horn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stenoscelis cryptomeriae','Animalia','','Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stephanoderes hampei','Animalia','','Coffee bean borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stereum huigense','Fungi','','Wood decay');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stigmina deflectens','Fungi','','Leaf spot of juniper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Strawberry Latent C virus Rhabdoviridae','Viruses','','Strawberry Latent C virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Strawberry witches\' broom phytoplasma','Bacteria','','Strawberry witches\' broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Strophosomus melanogrammus','Animalia','','Nut leaf weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Succinea costaricana','Animalia','','Snail');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane grassy shoot phytoplasma','Bacteria','','Sugarcane grassy shoot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane streak virus (Mastrevirus)','Viruses','','Sugar cane streak virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane white leaf phytoplasma','Bacteria','','White leaf of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synanthedon myopaeformis','Animalia','','Hornet clearwing moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Synchytrium endobioticum','Fungi','','New Zealand black wart');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taeniothrips inconsequens','Animalia','Thripidae','Pear thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Taeniothrips samdensis','Animalia','','Thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tagosodes cubanus','Animalia','','Paddy plant hopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tagosodes orizicolus','Animalia','','Rice delphacis');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Palm lethal yellowing phytoplasma','Bacteria','','Tanzanian coconut lethal decline');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tapinoma indicum','Animalia','','Ant');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tecia solanivora','Animalia','','Guatemalan potato moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tessaratoma papillosa','Animalia','','Litchi stink bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetranychus canadensis','Animalia','Tetranychidae','Four-spotted spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetranychus mcdanieli','Animalia','Tetranychidae','McDaniel spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetranychus mexicanus','Animalia','','Spider mite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetranychus turkestani','Animalia','Tetranychidae','Strawberry spider mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetropium castaneum','Animalia','','Black spruce beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetropium fuscum','Animalia','','Brown spruce longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetropium gracilicorne','Animalia','','Thin-antenna spruce borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetropium spp.','Animalia','','Spruce beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumatotibia leucotreta','Animalia','Tortricidae','False codling moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumetopoea pityocampa','Animalia','','Pine processionary caterpillar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumetopoea processionea','Animalia','','Oak processionary caterpillar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thecaphora solani','Fungi','','Potato smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thorictodes heydeni','Animalia','','Death-watch beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thrips fuscipennis','Animalia','','Thrips');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia barclayana','Fungi','','Rice smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia controversa','Fungi','','Dwarf bunt');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia indica','Fungi','Tilletiaceae','Karnal bunt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tobacco etch virus (Potyvirus)','Viruses','','Tobacco etch virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato black ring virus (Nepovirus)','Viruses','','Tomato black ring virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato chlorosis virus (Crinivirus)','Viruses','','Tomato chlorosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato chlorotic dwarf viroid (Pospiviroid)','Viruses','','Tomato chlorotic dwarf viroid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato infectious chlorosis virus (Crinivirus)','Viruses','','Tomato infectious chlorosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato mottle virus (Begomovirus)','Viruses','','Tomato mottle virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato ringspot virus (Nepovirus)','Viruses','','Tomato ringspot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomato yellows','Viruses','','Tomato yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomicus minor','Animalia','','Lesser pine shoot beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tomicus piniperda','Animalia','','Pine shoot beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Torostoma apicale','Animalia','','Cossonid weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Toxotrypana curvicauda','Animalia','','Papaya fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachyphloeus bifoveolatus','Animalia','','Pin cushion weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trachysphaera fructigena','Fungi','','Mealy pod');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribolium destructor','Animalia','','Flour beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trichodorus spp.','Animalia','','Stubby root nematodes');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trioza erytreae','Animalia','','Citrus psyllid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trirhithromyia cyanescens','Animalia','','Tomato fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma granarium','Animalia','Dermestidae','Khapra beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma simplex','Animalia','Dermestidae','Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tropilaelaps clareae','Animalia','','Parasitic bee mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trypodendron domesticum','Animalia','','European hardwood ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tsuwabuki witches\'-broom Phytoplasma','Bacteria','','Tsuwabuki witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ullucus mild mottle virus (Tobamovirus)','Viruses','','Ullucus mild mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ullucus mosaic virus (Potyviridae)','Viruses','','Ullucus mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ullucus virus C (Comovirus)','Viruses','','Ullucus virus C');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Unaspis yanonensis','Animalia','','Arrowhead scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urd bean leaf crinkle virus (Unassigned)','Viruses','','Urd bean leaf crinkle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uredo dioscoreae-alatae','Fungi','','Winged yam rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uredo gladioli-buettneri','Fungi','','Gladiolus rust');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urocystis cepulae','Fungi','','Onion smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uromyces gladioli','Fungi','','Gladiolus rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Uromyces nyikensis','Fungi','','Rust of gladiolus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Valdensia heterodoxa','Fungi','','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vanilla mosaic virus Potyviridae)','Viruses','','Vanilla mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Watermelon mosaic virus (Potyvirus), Vanilla necrosis strain','Viruses','','Vanilla necrosis virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Varroa jacobsoni','Animalia','','Varroa mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Varroa sinhai','Animalia','','Mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Venturia nashicola','Fungi','','Japanese pear scab');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vesperus spp.','Animalia','','Long horn beetles');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Voandzeia distortion mosaic virus (Potyviridae)','Viruses','','Voandzeia distortion mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Voandzeia necrotic mosaic virus (Tymovirus)','Viruses','','Voandzeia necrotic mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chionaspis tangana','Animalia','','Scale');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Vryburgia rimariae','Animalia','','Mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Walnut witches\'-broom Phytoplasma','Bacteria','','Walnut witches\'-broom');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Watercress yellow spot virus (Unassigned)','Viruses','','Watercress yellow spot virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Watermelon chlorotic stunt virus (Begomovirus)','Viruses','','Watermelon chlorotic stunt virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Watermelon curly mottle virus (Geminiviridae)','Viruses','','Watermelon curly mottle virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Western aster yellows phytoplasma','Bacteria','','Western aster yellows');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wheat American striate mosaic virus (Cytorhabdovirus)','Viruses','','Wheat American striate mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wheat dwarf virus (Mastrevirus)','Viruses','','Wheat dwarf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Soil-borne wheat mosaic virus (Furovirus)','Viruses','','Wheat soil-borne mosaic virus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wheat spindle streak mosaic virus (Bymovirus)','Viruses','','Wheat spindle streak mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wheat yellow leaf virus (Closterovirus)','Viruses','','Wheat yellow leaf virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wheat yellow mosaic virus (Bymovirus)','Viruses','','Wheat yellow mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wheat yellowing stripe bacterium','Bacteria','','Wheat yellowing stripe bacterium');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wild cucumber mosaic virus (Tymovirus)','Viruses','','Wild cucumber mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wild potato mosaic virus (Potyvirus)','Viruses','','Wild potato mosaic');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wineberry latent virus (Flexiviridae)','Viruses','','Wineberry latent virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Wisteria vein mosaic virus (Potyvirus)','Viruses','','Wisteria vein mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Witches\'-broom of lime phytoplasma','Bacteria','','Witches\'-broom of lime');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas acernea','Bacteria','Xanthomonadaceae','Cotton small leaf');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas arboricola pv. celebensis','Bacteria','Xanthomonadaceae','Leaf stripes');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas axonopodis pv. betlicola','Bacteria','Xanthomonadaceae','Bacterial blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas axonopodis pv. manihotis','Bacteria','Xanthomonadaceae','Cassava bacterial blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas axonopodis pv. vignicola','Bacteria','Xanthomonadaceae','Cowpea leaf spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas campestris pv. armoraciae','Bacteria','Xanthomonadaceae','Leaf spot disease of cabbage');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas campestris pv. vasculorum','Bacteria','Xanthomonadaceae','Sugarcane gumming disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas axonopodis pv. cassavae','Bacteria','Xanthomonadaceae','Cassava bacterial necrosis');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas citri subsp. citri','Bacteria','Xanthomonadaceae','Citrus canker');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas fragariae','Bacteria','Xanthomonadaceae','Strawberry angular leafspot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas populi','Bacteria','Xanthomonadaceae','Bacterial canker of poplar');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas theicola','Bacteria','Xanthomonadaceae','Leaf blight of tea');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach X-disease phytoplasma','Bacteria','','Peach X-disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xiphinema bricolense','Animalia','','Dagger nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xiphinema californicum','Animalia','','Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xiphinema diversicaudatum','Animalia','','European dagger nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyleborus rugatus','Animalia','','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylella fastidiosa','Bacteria','Xanthomonadaceae','Pierce\'s disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylella fastidiosa pv. citri','Bacteria','','Variegated chlorosis of citrus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylophilus ampelinus','Bacteria','','Bacterial blight of grapevine');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylosandrus compactus','Animalia','Scolytidae','Shot-hole borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylotrechus altaicus','Animalia','','Altai longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylotrechus rusticus','Animalia','','Longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Yam mosaic virus (Potyvirus)','Viruses','','Yam mosaic virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Yellow ring mosaic agent (associated with Jasminum spp.)','Unknown','','Yellow ring mosaic agent');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Yponomeuta malinellus','Animalia','','Apple ermine moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Yucatan coconut lethal decline phytoplasma','Bacteria','','Yucatan coconut lethal decline');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zabrotes subfasciatus','Animalia','Chrysomelidae','Bean weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zaprionus indianus','Animalia','','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zonocerus variegates','Animalia','','Varigated grasshopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zonosemata electa','Animalia','','Pepper maggot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zucchini yellow fleck virus (Potyvirus)','Viruses','','Zucchini yellow fleck virus');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zyphon fulgida','Animalia','','Leafhopper');

-- Cat1 Exotic Fruitfly Species
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha fraterculus','Animalia','Tephritidae','South American fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha ludens','Animalia','Tephritidae','Mexican fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha obliqua','Animalia','Tephritidae','West Indian fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha serpentina','Animalia','Tephritidae','Sapote fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha striata','Animalia','Tephritidae','Guava fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha suspensa','Animalia','Tephritidae','Caribbean fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera albistrigata','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera atrisetosa','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera carambolae','Animalia','Tephritidae','Carambola fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera caryeae','Animalia','Tephritidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera correcta','Animalia','Tephritidae','Guava fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera cucurbitae','Animalia','Tephritidae','Melon fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera curvipennis','Animalia','Tephritidae','Banana fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera decipiens','Animalia','Tephritidae','Pumpkin fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera dorsalis','Animalia','Tephritidae','Oriental fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera facialis','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera frauenfeldi','Animalia','Tephritidae','Mango fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera kandiensis','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera kirki','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera latifrons','Animalia','Tephritidae','Solanum fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera melanotus','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera occipitalis','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera papayae','Animalia','Tephritidae','Papaya fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera passiflorae','Animalia','Tephritidae','Fijian fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera philippinensis','Animalia','Tephritidae','Philippine fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera psidii','Animalia','Tephritidae','South sea guava fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera tau','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera trilineola','Animalia','Tephritidae','Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera trivialis','Animalia','Tephritidae','');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera umbrosia','Animalia','Tephritidae','Breadfruit fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera xanthodes','Animalia','Tephritidae','Pacific fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera zonata','Animalia','Tephritidae','Peach fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratitis rosa','Animalia','Tephritidae','Natal fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis copmleta','Animalia','Tephritidae','Walnut husk fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis fausta','Animalia','Tephritidae','Black cherry fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis indifferens','Animalia','Tephritidae','Western cherry fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagoletis pomonella','Animalia','Tephritidae','Apple maggot');

-- Cat1 PaDIL (Exotic Regulated Pests)
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crioceris duodecimpunctata','Animalia','Chrysomelidae','12 Spotted Asparagus Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetraleurodes acaciae','Animalia','Aleyrodidae','Acacia whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heteronychus arator','Animalia','Scarabaeidae','African black beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caliothrips impurus','Animalia','Thripidae','African cotton thrips');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eldana saccharina','Animalia','Pyralidae','African sugar-cane borer moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apis mellifera scutellata','Animalia','Apidae','Africanized honeybee');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurocanthus citriperdus','Animalia','Aleyrodidae','Aleurocanthus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurocanthus cocois','Animalia','Aleyrodidae','Aleurocanthus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurocerus palmae','Animalia','Aleyrodidae','Aleurocerus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurothrixus antidesmae','Animalia','Aleyrodidae','Aleurothrixus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurotrachelus trachoides','Animalia','Aleyrodidae','Aleurotrachelus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurotulus nephrolepidis','Animalia','Aleyrodidae','Aleurotulus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Subcoccinella vigintiquatuorpunctata','Animalia','Coccinellidae','Alfalfa Ladybird');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyleborus volvulus','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ambrosiodmus minor','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ambrosiodmus obliquus','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryoxylon onoharaensum','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyloterinus politus','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euwallacea validus','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnathotrichus materiarius','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euwallacea destruens','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylosandrus fijianus','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euwallacea bicolor','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyleborus similis','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyleborus deplanatus','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyleborus pfeilii','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ambrosiodmus asperatus','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trypodendron rufitarsis','Animalia','Curculionidae','ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caliothrips phaseoli','Animalia','Thripidae','American bean thrips');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza trifolii','Animalia','Agromyzidae','American serpentine leafminer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas fragariae','Bacteria','Xanthomonadaceae','Angular leaf spot of Strawberry');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anopheles annulipes','Animalia','Culicidae','Anopheles mosquito');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia amylovora','Bacteria','Enterobacteriaceae','Apple and pear fire blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tropinota hirta','Animalia','Scarabaeidae','Apple Blossom Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monarthrum mali','Animalia','Curculionidae','apple wood stainer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Armillaria solidipes','Fungi','Physalacriaceae','Armillaria root rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mythimna unipuncta','Animalia','Noctuidae','Armyworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Siphoninus phillyreae','Animalia','Aleyrodidae','Ash whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylosandrus crassiusculus','Animalia','Curculionidae','Asian ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyleborinus alni','Animalia','Curculionidae','Asian ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tropilaelaps koenigerum','Animalia','Laelapidae','Asian bee mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tropilaelaps thaii','Animalia','Laelapidae','Asian bee mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria dispar dispar race asian','Animalia','Lymantriidae','Asian gypsy moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera papayae','Animalia','Tephritidae','Asian Papaya Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polistes chinensis antennalis','Animalia','Vespidae','Asian paper wasp');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes gestroi','Animalia','Rhinotermitidae','Asian subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aedes albopictus','Animalia','Culicidae','Asian Tiger Mosquito');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaphorina citri','Animalia','Psyllidae','Asiatic citrus psyllid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apis cerana','Animalia','Apidae','Asiatic honeybee');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia inferens','Animalia','Noctuidae','Asiatic pink stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crioceris asparagi','Animalia','Chrysomelidae','Asparagus Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia asparagi','Fungi','Pucciniaceae','Asparagus rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleuroclava aucubae','Animalia','Aleyrodidae','Aucuba whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acaudaleyrodes rachipora','Animalia','Aleyrodidae','Babul whitefly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Blood disease bacterium','Bacteria','Pseudomonodaceae','Banana blood disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guignardia musae','Fungi','Botryosphaeriaceae','Banana freckle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erionota thrax','Animalia','Hesperiidae','Banana skipper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Odoiporus longicollis','Animalia','Curculionidae','Banana stem weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica balteata','Animalia','Chrysomelidae','Banded Cucumber Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylurdrectonus araucariae','Animalia','Curculionidae','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dryocoetes autographus','Animalia','Curculionidae','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orthotomicus angulatus','Animalia','Curculionidae','Bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylurgops rugipennis pinifex','Animalia','Curculionidae','bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylastes salebrosus','Animalia','Curculionidae','bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypothenemus cassavaensis','Animalia','Curculionidae','bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Caliothrips fasciatus','Animalia','Thripidae','Bean thrips');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trichodes apiarius','Animalia','Cleridae','Bee beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphis fabae','Animalia','Aphididae','Black Bean Aphid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apiosporina morbosa','Fungi','Venturiaceae','Black knot of stone fruits');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylastes ater','Animalia','Curculionidae','Black pine bark beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Guignardia bidwellii','Fungi','Botryosphaeriaceae','Black rot of grape');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mycosphaerella fijiensis','Fungi','Mycosphaerellaceae','Black sigatoka of banana');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylosandrus germanus','Animalia','Curculionidae','Black stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus terebrans','Animalia','Curculionidae','Black turpentine beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylosandrus compactus','Animalia','Curculionidae','black twig borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagium mordax','Animalia','Cerambycidae','Blackspotted pliers support beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Grosmannia wageneri','Fungi','Ophiostomataceae','Black-Stain Root Disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus grandis grandis','Animalia','Curculionidae','Boll weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera umbrosa','Animalia','Tephritidae','Breadfruit Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Halyomorpha halys','Animalia','Pentatomidae','Brown marmorated stink bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monilinia spp.','Fungi','Sclerotiniaceae','Brown rot of stone fruit');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchus atomarius','Animalia','Chrysomelidae','Bruchid seed beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchus tristis','Animalia','Chrysomelidae','Bruchid seed beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Arhopalus ferus','Animalia','Cerambycidae','Burnt pine longhorn beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceutorhynchus assimilis','Animalia','Curculionidae','cabbage seedpod weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ciborinia camelliae','Fungi','Sclerotiniaceae','Camellia flower blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apis mellifera capensis','Animalia','Apidae','Cape honeybee');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cerambyx scopoli','Animalia','Cerambycidae','Capricorn beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera carambolae','Animalia','Tephritidae','Carambola Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Metaleurodicus cardini','Animalia','Aleyrodidae','Cardin\'s whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Camponotus nearcticus','Animalia','Formicidae','carpenter ant');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Camponotus modoc','Animalia','Formicidae','Carpenter ant');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trialeurodes ricini','Animalia','Aleyrodidae','Castor whitefly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Subramanianospora vesiculosa','Fungi','Incertae sedis','Casuarina blister bark');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eurygaster maura','Animalia','Scutelleridae','Cereal Bug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryphonectria parasitica','Fungi','Cryphonectriaceae','Chestnut blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hesperophanes campestris','Animalia','Cerambycidae','Chinese Longhorned Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurocanthus woglumi','Animalia','Aleyrodidae','Citrus blackfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas axonopodis pv. citri','Bacteria','Xanthomonadaceae','Citrus canker (canker A)');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberibacter asiaticus','Bacteria','Rhizobiaceae','Citrus huanglongbing');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoplophora chinensis','Animalia','Cerambycidae','Citrus longhorned beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xylella fastidiosa','Bacteria','Xanthomonadaceae','Citrus variegated chlorosis');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dialeurodes citri','Animalia','Aleyrodidae','citrus whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Singhiella citrifolii','Animalia','Aleyrodidae','cloudywinged whitefly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oryctes rhinoceros','Animalia','Scarabaeidae','Coconut rhinoceros beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurodicus pulvinatus','Animalia','Aleyrodidae','coconut whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurodicus cocois','Animalia','Aleyrodidae','Coconut whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cydia pomonella','Animalia','Tortricidae','Codling moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypothenemus hampei','Animalia','Curculionidae','coffee berry borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptinotarsa decemlineata','Animalia','Chrysomelidae','Colorado potato beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypoderma lineatum','Animalia','Oestridae','common cattle grub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribolium confusum','Animalia','Tenebrionidae','confused flour beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coniothyrium zuluense','Fungi','Mycosphaerellaceae','Coniothyrium stem canker of Eucalyptus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes curvignathus','Animalia','Rhinotermitidae','Coptotermes Termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pagiocerus frontalis','Animalia','Curculionidae','corn ear borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xanthomonas axonopodis pv. malvacearum','Bacteria','Xanthomonadaceae','Cotton bacterial blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anomis flava','Animalia','Noctuidae','cotton looper');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phymatotrichopsis omnivora','Fungi','Rhizinaceae','Cotton root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptosporiopsis citri','Fungi','','Cryptosporiopsis leaf spot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nasonovia ribisnigri','Animalia','Aphididae','Currant lettuce aphid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peridroma saucia','Animalia','Noctuidae','Cutworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rugitermes panamae','Animalia','Kalotermitidae','Dampwood Rugitermes termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xestobium rufovillosum','Animalia','Anobiidae','Deathwatch beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dermestes carnivorus','Animalia','Dermestidae','Dermestid beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dermestes laniarius','Animalia','Dermestidae','Dermestid beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylastes nigrinus','Animalia','Curculionidae','Douglas fir root bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apis florea','Animalia','Apidae','Dwarf honey bee');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylesinus aculeatus','Animalia','Curculionidae','Eastern ash bark beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anisogramma anomala','Fungi','Valsaceae','Eastern filbert blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma pruni','Bacteria','Acholeplasmataceae','Eastern peach X disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cobboldia elephantis','Animalia','Oestridae','elephant botfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes elisae','Animalia','Rhinotermitidae','Elisae Coptotermes termite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Agrilus planipennis','Animalia','Buprestidae','Emerald ash borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sitobion avenae','Animalia','Aphididae','English Grain Aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Teratosphaeria destructans','Fungi','Mycosphaerellaceae','Eucalyptus leaf spot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia psidii','Fungi','Pucciniaceae','Eucalyptus rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gonipterus scutellatus','Animalia','Curculionidae','eucalyptus snout beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylastes opacus','Animalia','Curculionidae','European bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria dispar dispar race Europe','Animalia','Lymantriidae','European gypsy moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylotrupes bajulus','Animalia','Cerambycidae','European House Borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhyacionia buoliana','Animalia','Tortricidae','European pine shoot moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anisandrus dispar','Animalia','Curculionidae','European shot-hole borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips typographus','Animalia','Curculionidae','European spruce bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Phytoplasma prunorum','Bacteria','Acholeplasmataceae','European stone fruit yellows');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cephus pygmeus','Animalia','Cephidae','European Wheat Stem Sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crossotarsus externedentatus','Animalia','Curculionidae','exotic pin-hole borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Thaumatotibia leucotreta','Animalia','Tortricidae','False codling moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera passiflorae','Animalia','Tephritidae','Fijian Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus urussovi','Animalia','Cerambycidae','Fir Sawyer Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melolontha hippocastani','Animalia','Scarabaeidae','Forest Cockchafer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes formosanus','Animalia','Rhinotermitidae','Formosan subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Polygraphus rufipennis','Animalia','Curculionidae','Foureyed spruce bark beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera albistrigata','Animalia','Tephritidae','Fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera philippinensis','Animalia','Tephritidae','Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera occipitalis','Animalia','Tephritidae','Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera tau','Animalia','Tephritidae','Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera trivialis','Animalia','Tephritidae','Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera atrisetosa','Animalia','Tephritidae','Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera kirki','Animalia','Tephritidae','Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eudocima fullonia','Animalia','Noctuidae','fruit-piercing moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Achatina fulica','Animalia','Achatinidae','Giant African Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apis dorsata','Animalia','Apidae','Giant honeybee');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurodicus dugesii','Animalia','Aleyrodidae','Giant Whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma glabrum','Animalia','Dermestidae','glabrous cabinet beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Homalodisca vitripennis','Animalia','Cicadellidae','Glassy-Winged Sharp Shooter');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypomeces squamosus','Animalia','Curculionidae','Gold-dust weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylurgus ligniperda','Animalia','Curculionidae','Goldenhaired bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aphis grossulariae','Animalia','Aphididae','Gooseberry Aphid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Roesleria subterranea','Fungi','','Grape root rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phakopsora euvitis','Fungi','Phakopsoraceae','Grapevine leaf rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Costelytra zealandica','Animalia','Scarabaeidae','grass grub');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coccus celatus','Animalia','Coccidae','green coffee scale');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera correcta','Animalia','Tephritidae','Guava Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mayetiola destructor','Animalia','Cecidomyiidae','Hessian fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterobasidion annosum','Fungi','Bondarzewiaceae','Heterobasidion root rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acarapis woodi','Animalia','Tarsonemidae','Honey bee tracheal mite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleyrodes lonicerae','Animalia','Aleyrodidae','honeysuckle whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gasterophilus intestinalis','Animalia','Oestridae','Horse botfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dermatobia hominis','Animalia','Oestridae','Human botfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amrasca biguttula biguttula','Animalia','Cicadellidae','Indian cotton leafhopper');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Xyleborus perforans','Animalia','Curculionidae','Island pinhole borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eumetopina flavipes','Animalia','Delphacidae','Island Sugarcane Planthopper');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Popillia japonica','Animalia','Scarabaeidae','Japanese beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Callidiellum rufipenne','Animalia','Cerambycidae','Japanese cedar longhorned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria dispar japonica','Animalia','Lymantriidae','Japanese gypsy moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleuroclava jasmini','Animalia','Aleyrodidae','Jasmine whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Semanotus bifasciatus','Animalia','Cerambycidae','Juniper bark borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia indica','Fungi','Tilletiaceae','Karnal bunt of wheat');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma granarium','Animalia','Dermestidae','Khapra beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phellinus sulphurascens','Fungi','Hymenochaetaceae','Laminated root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma inclusum','Animalia','Dermestidae','Larger cabinet beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Batocera rubus','Animalia','Cerambycidae','lateral-banded mango longhorn');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchus signaticornis','Animalia','Chrysomelidae','Lentil bruchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchus lentis','Animalia','Chrysomelidae','Lentil Weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchus affinis','Animalia','Chrysomelidae','Lesser pea weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera neohumeralis','Animalia','Tephritidae','Lesser Queensland Fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylurgops palliatus','Animalia','Curculionidae','Lesser spruce shoot beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chamaita sp.','Animalia','Arctiidae','lichen or algae Arctid moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Incisitermes snyderi','Animalia','Kalotermitidae','Light Southeastern Drywood Termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus murrayanae','Animalia','Curculionidae','Lodgepole Pine Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Morimus funereus','Animalia','Cerambycidae','longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rosalia alpina','Animalia','Cerambycidae','longhorn beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acmaeops proteus','Animalia','Cerambycidae','long-horned beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudococcus longispinus','Animalia','Pseudococcidae','Longtail mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Incisitermes immigrans','Animalia','Kalotermitidae','Lowland Tree Drywood Termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cordylobia rodhaini','Animalia','Calliphoridae','Lund’s fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoma tracheiphila','Fungi','Incertae sedis','Mal secco disease of citrus');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sternochetus frigidus','Animalia','Curculionidae','Mango Pulp Weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceratitis capitata','Animalia','Tephritidae','Mediterranean fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchus emarginatus','Animalia','Chrysomelidae','Mediterranean pulse beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera cucurbitae','Animalia','Tephritidae','Melon Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Zabrotes subfasciatus','Animalia','Chrysomelidae','Mexican Bean Weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha ludens','Animalia','Tephritidae','Mexican fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ralstonia solanacearum sequevar 3 (Multilocus genotype24)','Bacteria','','Moko disease of banana');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monomorium salomonis species group','Animalia','Formicidae','Monomorium salomonis Tramp ant');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Corythucha morrilli','Animalia','Tingidae','morrill lace bug');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus ponderosae','Animalia','Curculionidae','Mountain pine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Harmonia axyridis','Animalia','Coccinellidae','Multicolored Asian Lady Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aromia moschata','Animalia','Cerambycidae','Musk beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amyelois transitella','Animalia','Pyralidae','Navel Orangeworm');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paraleyrodes minei','Animalia','Aleyrodidae','Nesting whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Crenidorsum aroidephagus','Animalia','Aleyrodidae','New World whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platypus apicalis','Animalia','Curculionidae','New Zealand pinhole borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria monacha','Animalia','Lymantriidae','Nun moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platypus cylindrus','Animalia','Curculionidae','Oak pin-hole borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera oleae','Animalia','Tephritidae','olive fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Argyrotaenia franciscana','Animalia','Tortricidae','Orange tortrix');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera dorsalis','Animalia','Tephritidae','Oriental Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma ornatum','Animalia','Dermestidae','ornate cabinet beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera xanthodes','Animalia','Tephritidae','Pacific fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Teia anartoides','Animalia','Lymantriidae','painted apple moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dactylotrypes longicollis','Animalia','Curculionidae','palm seed borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coccotrypes distinctus','Animalia','Curculionidae','palm seed borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coccotrypes fijianus','Animalia','Curculionidae','palm seed borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coccotrypes striatus','Animalia','Curculionidae','palm seed borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurotrachelus atratus','Animalia','Aleyrodidae','palm-infesting whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium oxysporum f. sp. cubense','Fungi','Nectriaceae','Panama disease of banana');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paracoccus marginatus','Animalia','Pseudococcidae','Papaya mealybug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paraleyrodes pseudonaranjae','Animalia','Aleyrodidae','Paraleyrodes whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Paraleyrodes bondari','Animalia','Aleyrodidae','Paraleyrodes whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acyrthosiphon pisum','Animalia','Aphididae','pea aphid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza huidobrensis','Animalia','Agromyzidae','Pea leafminer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera zonata','Animalia','Tephritidae','Peach fruit fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pealius rhododendri','Animalia','Aleyrodidae','Pealius whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acrobasis pyrivorella','Animalia','Pyralidae','Pear fruit moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips pini','Animalia','Curculionidae','Pine Engraver');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus galloprovincialis','Animalia','Cerambycidae','Pine sawyer beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Endocronartium harknessii','Fungi','Cronartiaceae','Pine western gall rust');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bursaphelenchus xylophilus','Animalia','Parasitaphelenchidae','Pine Wilt Nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platypus gerstackeri','Animalia','Curculionidae','pin-hole borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Fusarium circinatum','Fungi','Nectriaceae','Pitch canker disease of pine');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dacne japonica','Animalia','Erotylidae','Pleasing fungus beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conotrachelus nenuphar','Animalia','Curculionidae','Plum curculio');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Globodera rostochiensis','Animalia','Heteroderidae','potato cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactericera (Paratrioza) cockerelli','Animalia','Triozidae','potato psyllid');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera decipiens','Animalia','Tephritidae','Pumpkin Fruit Fly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera tryoni','Animalia','Tephritidae','Queensland Fruit Fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia grisescens','Animalia','Noctuidae','Ramu shoot borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ceutorhynchus napi','Animalia','Curculionidae','Rape Stem Weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Deanolis sublimbalis','Animalia','Pyralidae','Red banded mango caterpillar');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus valens','Animalia','Curculionidae','Red turpentine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetraleurodes perseae','Animalia','Aleyrodidae','red-banded whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gyrostigma pavesii','Animalia','Oestridae','rhinoceros botfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rhagium inquisitor','Animalia','Cerambycidae','Ribbed pine borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Magnaporthe oryzae','Fungi','Magnaporthaceae','Rice blast disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia horrida','Fungi','Tilletiaceae','Rice kernel smut');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lissorhoptrus oryzophilus','Animalia','Curculionidae','Rice water weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Helix pomatia','Animalia','Helicidae','Roman Snail');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hylastes porculus','Animalia','Curculionidae','root bark beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adoretus versutus','Animalia','Scarabaeidae','rose beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lymantria mathura','Animalia','Lymantriidae','Rosy Gypsy Moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Otiorhynchus rugosostriatus','Animalia','Curculionidae','Rough strawberry weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rugitermes panamae','Animalia','Kalotermitidae','Rugitermes termite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuraphis noxia','Animalia','Aphididae','Russian Wheat Aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tribolium castaneum','Animalia','Tenebrionidae','rust-red flour beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptinotarsa defecta','Animalia','Chrysomelidae','Satanbos Leaf Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptinotarsa texana','Animalia','Chrysomelidae','Satansbos Leaf Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monochamus sartor','Animalia','Cerambycidae','Sawyer beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anomala dubia','Animalia','Scarabaeidae','Scarab Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anoxia pilosa','Animalia','Scarabaeidae','Scarab Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scolytus rugulosus','Animalia','Curculionidae','Shothole Borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Metamasius hemipterus sericeus','Animalia','Curculionidae','silky cane weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Singhius hibisci','Animalia','Aleyrodidae','Singhius whitefly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ips sexdentatus','Animalia','Curculionidae','Six-spined engraver beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cerambyx cerdo','Animalia','Cerambycidae','Small capricorn beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scirtothrips aurantii','Animalia','Thripidae','South African Citrus Thrips');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coryphodema tristis','Animalia','Cossidae','South African Cossid moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bradinothrips musae','Animalia','Thripidae','South American banana thrips');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus frontalis','Animalia','Curculionidae','Southern pine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica undecimpunctata howardi','Animalia','Chrysomelidae','Spotted Cucumber Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Chilo terrenellus','Animalia','Pyralidae','Stem borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Nectria fuckeliana','Fungi','Nectriaceae','Stem canker of conifer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acleris comariana','Animalia','Tortricidae','Strawberry tortrix moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus bisignifer','Animalia','Curculionidae','Strawberry weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trypodendron lineatum','Animalia','Curculionidae','Striped ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phyllotreta striolata','Animalia','Chrysomelidae','Striped Flea Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora ramorum','Fungi','Pythiaceae','Sudden oak death');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stagonospora sacchari','Fungi','Incertae sedis','Sugarcane leaf scorch');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ustilago scitaminea','Fungi','Ustilaginaceae','Sugarcane Smut');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurolobus barodensis','Animalia','Aleyrodidae','Sugarcane whitefly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adoxophyes orana','Animalia','Tortricidae','Summer fruit tortrix');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Euwallacea fornicatus','Animalia','Curculionidae','tea shot-hole borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cymatothes tristis','Animalia','Tenebrionidae','Tenebrionid beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stromatium barbatum','Animalia','Cerambycidae','The Teak Trunk borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma grassmani','Animalia','Dermestidae','tiny cabinet beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trialeurodes packardi','Animalia','Aleyrodidae','Trialeurodes whitefly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma simplex','Animalia','Dermestidae','trogoderma dermestid beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma megatomoides','Animalia','Dermestidae','trogoderma dermestid beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma sternale','Animalia','Dermestidae','trogoderma dermestid beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bolacothrips striatopennatus','Animalia','Thripidae','Tropical grass thrips');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hypothenemus obscurus','Animalia','Curculionidae','tropical nut borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cordylobia anthropophaga','Animalia','Calliphoridae','Tumbu fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza sativae','Animalia','Agromyzidae','Vegetable leaf miner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Verticillium dahliae','Fungi','Plectosphaerellaceae','Verticillium wilt of cotton');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bruchus brachialis','Animalia','Chrysomelidae','Vetch bruchid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anomala vitis','Animalia','Scarabaeidae','Vine Chafer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diabrotica virgifera virgifera','Animalia','Chrysomelidae','Western Corn Rootworm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Incisitermes minor','Animalia','Kalotermitidae','Western drywood termite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnathotrichus sulcatus','Animalia','Curculionidae','Western hemlock wood stainer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dendroctonus brevicomis','Animalia','Curculionidae','Western pine beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Gnathotrichus retusus','Animalia','Curculionidae','Western pinewood stainer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Reticulitermes hesperus','Animalia','Rhinotermitidae','Western subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Eurygaster austriaca','Animalia','Scutelleridae','Wheat Shield Bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cephus cinctus','Animalia','Cephidae','Wheat Stem Sawfly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scolytus carpini','Animalia','Curculionidae','White beech bark beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Melolontha melolontha','Animalia','Scarabaeidae','White Grub Cockchafer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane white leaf Phytoplasma','Bacteria','','White leaf disease of sugarcane');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rosellinia necatrix','Fungi','Xylariaceae','White root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Holotrichia kiotoensis','Animalia','Scarabaeidae','Whitegrub Beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oxythyrea funesta','Animalia','Scarabaeidae','White-spotted Rose Beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Orgyia thyellina','Animalia','Lymantriidae','White-spotted tussock moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Platypus wilsoni','Animalia','Curculionidae','Wilson\'s white-headed ambrosia beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurothrixus floccosus','Animalia','Aleyrodidae','Woolly Whitefly');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoracantha recurva','Animalia','Cerambycidae','yellow longicorn');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monarthrum fasciatum','Animalia','Curculionidae','yellow-banded ambrosia beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Urocerus gigas','Animalia','Siricidae','Yellow-horned horntail');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erthesina fullo','Animalia','Pentatomidae','Yellow-spotted stink bug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Scyphophorus yucca','Animalia','Curculionidae','Yucca weevil');

-- Cat1 State Regulated Pests (Exotic)
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Achatina fulica','Animalia','Achatinidae','Giant African snail');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Acleris comariana','Animalia','Tortricidae','Strawberry tortrix');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Adoxophyes orana','Animalia','Tortricidae','Summer fruit tortrix');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Aleurolobus barodensis','Animalia','Aleyrodidae','Sugarcane whitefly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Amyelois transitella','Animalia','Pyralidae','Navel orangeworm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anastrepha ludens','Animalia','Tephritidae','Mexican fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anisogramma anomala','Fungi','Valsaceae','Hazelnut blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus bisignatus','Animalia','','Strawberry bud weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Anthonomus grandis','Animalia','','Boll weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Apiosporina morbosa','Fungi','Venturaceae','Black knot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ascochyta oleae','Fungi','','Scalia of olive');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ascochyta rabiei','Fungi','','Chickpea blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera cucurbitae','Animalia','Tephritidae','Melon fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera dorsalis','Animalia','Tephritidae','Oriental fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera papayae','Animalia','Tephritidae','Papaya fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Bactrocera philippinensis','Animalia','Tephritidae','Philippine fruit fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banana bract mosaic virus (Potyvirus)','Viruses','Potyviridae','Banana bract mosaic disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Banana blood disease bacterium','Bacteria','','Blood disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Botrytis squamosa','Fungi','','Leaf blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('African cassava mosaic virus (Begomovirus)','Viruses','','Cassava mosaic virus disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ophiostoma ulmi','Fungi','','Dutch elm disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ciborinia camelliae','Fungi','Sclerotiniaceae','Camellia petal blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Clavibacter michiganensis subsp. sepedonicus','Bacteria','','Potato ring rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Conotrachelus nenuphar','Animalia','Curculionidae','Plum weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes formosanus','Animalia','Rhinotermitidae','Formosan termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes havilandi','Animalia','','Subterranean termite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Coptotermes vastator','Animalia','','Subterranean termite');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('East African cassava mosaic virus(Begomovirus)','Viruses','','Cassava mosaic virus disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('South African cassava mosaic virus(Begomovirus)','Viruses','','Cassava mosaic virus disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cotton leaf curl virus (Begomovirus)','Viruses','','Cotton leaf curl disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryphonectria parasitica','Fungi','Cryphonectriaceae','Chestnut blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Cryptophlebia leucotreta','Animalia','','False codling moth');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diaphorina citri','Animalia','','Citrus psyllid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Didymosphenia geminata','Plantae','','Didymo rock snot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diplodia oleae','Fungi','','Peglion of olive');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ditylenchus destructor','Animalia','','Potato rot nematode');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Diuraphis noxia','Animalia','Aphididae','Russian wheat aphid');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Dothistroma pini','Fungi','','Needle blight');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Epilachna varivestis','Animalia','','Mexican bean beetle');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erionota thrax','Animalia','Hesperiidae','Banana skipper butterfly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Erwinia amylovora','Bacteria','Enterobacteriaceae','Fire blight');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('European stone fruit yellows phytoplasma','Bacteria','','European stone fruit yellows');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Globodera pallida','Animalia','','Pale potato cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Hedylepta indicata','Animalia','','Soybean webspinner');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Heterodera humuli','Animalia','','Hop cyst nematode');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Kontikia orana','Animalia','','');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Leptinotarsa decemlineata','Animalia','Chrysomelidae','Colorado potato beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Candidatus Liberobacter asiaticus','Bacteria','','Huanglongbing/Citrus Greening');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Liriomyza sativae','Animalia','Agromyzidae','Leaf miner');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Lissorhoptrus oryzophilus','Animalia','Curculionidae','Rice water weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mayetiola destructor','Animalia','Cecidomyiidae','Hessian fly');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Monilinia fructigena','Fungi','Sclerotiniaceae','Brown rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Mythimna unipuncta','Animalia','','Armyworm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Numonia pirivorella','Animalia','','Pear fruit moth');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Oligonychus pratensis','Animalia','','Banks grass mite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ostrinia nubilalis','Animalia','Pyralidae','European corn borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peach X phytoplasma','Bacteria','','Peach X disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peridroma saucia','Animalia','Notodontidae','Variegated cutworm');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora philippinensis','Fungi','','Philippine downy mildew');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sacchari','Fungi','','Sugarcane downy mildew');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronosclerospora sorghi','Fungi','','Downy mildew');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Peronospora maydis','Fungi','','Java downy mildew (of maize)');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phakopsora euvitis','Fungi','','Grapevine leaf rust');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phoma tracheiphila','Fungi','Incertae sedis','Mal Secco');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phymatotrichum ominivorum','Fungi','','Texas root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Physopella zeae','Fungi','','Rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora nicotianae var. parasitica','Fungi','','Top rot');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Phytophthora ramorum','Fungi','Pythiaceae','Sudden oak death');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Plum pox virus (Potyvirus)','Viruses','Potyviridae','Plum pox virus/sharka');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pomacea canaliculata','Animalia','','Golden apple snail');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Popillia japonica','Animalia','Scarabaeidae','Japanese beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Potato virus M (Carlavirus)','Viruses','','M PVM');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Pseudomonas celebensis','Bacteria','','Banana blood disease');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Ralstonia solanacearum sequevar 3 (Multilocus genotype24)','Bacteria','','Moko disease Cavendish bananas and Bugtok disease of cooking bananas');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Puccinia psidii','Fungi','','Eucalyptus rust');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Purple top wilt Phytoplasma','Bacteria','','');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Roesleria subterranea','Fungi','','Grape root rot');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Schizaphis graminum','Animalia','','Greenbug');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sclerotium tuliparum','Fungi','','Bulb rot of tulip');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Septoria olivae','Fungi','','');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia grisescens','Animalia','Noctuidae','Stem borer');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia inferens','Animalia','','Rice pink stem borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sesamia spp.','Animalia','','Sugarcane borer');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sitona lepidus','Animalia','','Clover root weevil');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphacelotheca cruenta','Fungi','','Loose kernel smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphacelotheca reiliana','Fungi','','Head smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sphacelotheca sorghi','Fungi','','Covered kernel smut');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Stagonospora sacchari','Fungi','Incertae sedis','Leaf scorch');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sternochetus frigidus','Animalia','Curculionidae','Mango pulp weevil');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane Ramu stunt virus(unknown)','Viruses','','Ramu stunt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane streak mosaic virus (Susmovirus)','Viruses','','Sugarcane streak mosaic');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Sugarcane white leaf phytoplasma','Bacteria','','White leaf');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tetranychus piercei','Animalia','Tetranychidae','Spider mite');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia barclayana','Fungi','','Kernel smut of rice');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tilletia indica','Fungi','Tilletiaceae','Karnal bunt');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tobacco rattle virus (CAM strain) (Tobravirus)','Viruses','','TRV');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tolyposporium ehrenbergii','Fungi','','Long smut');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trichoplusia ni','Animalia','Noctuidae','Cabbage looper');
-- (Duplicate) INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Trogoderma granarium','Animalia','Dermestidae','Khapra beetle');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Rice tungro bacilliform virus','Viruses','','Tungro disease');
INSERT INTO sensitive_species (scientific_name,kingdom,family,common_name) VALUES ('Tylenchus spp.','Anima