/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.jaitools.imageutils.ImageLayout2;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.coverage.grid");
    protected int numOverviews = 0;
    protected MathTransform raster2Model = null;
    protected CoordinateReferenceSystem crs = null;
    protected GeneralEnvelope originalEnvelope = null;
    protected String coverageName = "geotools_coverage";
    protected Object source = null;
    protected Hints hints = GeoTools.getDefaultHints();
    protected double[] highestRes = null;
    protected boolean closeMe;
    protected boolean gzipped;
    protected GridEnvelope originalGridRange = null;
    protected ImageInputStream inStream = null;
    protected double[][] overViewResolutions = null;
    protected GridCoverageFactory coverageFactory;
    private Map<String, ArrayList<Resolution>> resolutionsLevelsMap = new HashMap<String, ArrayList<Resolution>>();
    protected ImageInputStreamSpi inStreamSPI;
    private ImageLayout imageLayout;

    protected AbstractGridCoverage2DReader() {
    }

    public AbstractGridCoverage2DReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public AbstractGridCoverage2DReader(Object input, Hints hints) throws DataSourceException {
        Object factory;
        if (hints == null) {
            this.hints = new Hints();
        }
        if (hints != null) {
            this.hints = hints.clone();
        }
        if (this.hints.containsKey((Object)Hints.GRID_COVERAGE_FACTORY) && (factory = this.hints.get((Object)Hints.GRID_COVERAGE_FACTORY)) != null && factory instanceof GridCoverageFactory) {
            this.coverageFactory = (GridCoverageFactory)((Object)factory);
        }
        if (this.coverageFactory == null) {
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory(this.hints);
        }
        if (input == null) {
            IOException ex = new IOException(Errors.format((int)143, (Object)"input"));
            throw new DataSourceException(ex);
        }
        this.source = input;
    }

    protected boolean checkName(String coverageName) {
        Utilities.ensureNonNull((String)"coverageName", (Object)coverageName);
        return coverageName.equalsIgnoreCase(this.coverageName);
    }

    @Override
    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        if (coverageName.equalsIgnoreCase(this.coverageName)) {
            return this.read(parameters);
        }
        throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
    }

    @Override
    public abstract GridCoverage2D read(GeneralParameterValue[] var1) throws IllegalArgumentException, IOException;

    protected Integer setReadParams(OverviewPolicy overviewPolicy, ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        return this.setReadParams(this.coverageName, overviewPolicy, readP, requestedEnvelope, requestedDim);
    }

    protected Integer setReadParams(String coverageName, OverviewPolicy overviewPolicy, ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        Integer imageChoice = new Integer(0);
        if (overviewPolicy == null) {
            overviewPolicy = this.extractOverviewPolicy();
        }
        readP.setSourceSubsampling(1, 1, 0, 0);
        if (overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            return imageChoice;
        }
        boolean useOverviews = this.numOverviews > 0;
        double[] requestedRes = AbstractGridCoverage2DReader.getResolution(requestedEnvelope, requestedDim, this.getCoordinateReferenceSystem(coverageName));
        if (requestedRes == null) {
            return imageChoice;
        }
        if (useOverviews) {
            imageChoice = this.pickOverviewLevel(coverageName, overviewPolicy, requestedRes);
        }
        this.decimationOnReadingControl(coverageName, imageChoice, readP, requestedRes);
        return imageChoice;
    }

    private OverviewPolicy extractOverviewPolicy() {
        OverviewPolicy overviewPolicy = null;
        if (this.hints != null && this.hints.containsKey((Object)Hints.OVERVIEW_POLICY)) {
            overviewPolicy = (OverviewPolicy)((Object)this.hints.get((Object)Hints.OVERVIEW_POLICY));
        }
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        assert (overviewPolicy != null);
        return overviewPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer pickOverviewLevel(String coverageName, OverviewPolicy policy, double[] requestedRes) {
        double requestedScaleFactor;
        ArrayList<Resolution> resolutionsLevels;
        if (policy == null) {
            policy = this.extractOverviewPolicy();
        }
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            resolutionsLevels = this.resolutionsLevelsMap.get(coverageName);
            if (resolutionsLevels == null) {
                resolutionsLevels = new ArrayList();
                this.resolutionsLevelsMap.put(coverageName, resolutionsLevels);
                resolutionsLevels.add(new Resolution(1.0, this.getHighestRes()[0], this.getHighestRes()[1], 0));
                if (this.numOverviews > 0) {
                    for (int i = 0; i < this.overViewResolutions.length; ++i) {
                        resolutionsLevels.add(new Resolution(this.overViewResolutions[i][0] / this.getHighestRes()[0], this.overViewResolutions[i][0], this.overViewResolutions[i][1], i + 1));
                    }
                    Collections.sort(resolutionsLevels);
                }
            }
        }
        double reqx = requestedRes[0];
        double reqy = requestedRes[1];
        Resolution max = resolutionsLevels.get(0);
        double requestedScaleFactorX = reqx / max.resolutionX;
        double requestedScaleFactorY = reqy / max.resolutionY;
        boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
        double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        if (requestedScaleFactor <= 1.0) {
            return max.imageChoice;
        }
        Resolution min = resolutionsLevels.get(resolutionsLevels.size() - 1);
        if (requestedScaleFactor >= min.scaleFactor) {
            return min.imageChoice;
        }
        Resolution prev = max;
        int size = resolutionsLevels.size();
        for (int i = 1; i < size; ++i) {
            Resolution curr = resolutionsLevels.get(i);
            if (curr.scaleFactor == requestedScaleFactor) {
                return curr.imageChoice;
            }
            if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                if (policy == OverviewPolicy.QUALITY) {
                    return prev.imageChoice;
                }
                if (policy == OverviewPolicy.SPEED) {
                    return curr.imageChoice;
                }
                if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                    return prev.imageChoice;
                }
                return curr.imageChoice;
            }
            prev = curr;
        }
        return max.imageChoice;
    }

    @Override
    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.getReadingResolutions(this.coverageName, policy, requestedResolution);
    }

    @Override
    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        double[] result;
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        if (this.numOverviews > 0) {
            int imageIdx = this.pickOverviewLevel(coverageName, policy, requestedResolution);
            result = this.overViewResolutions[imageIdx];
        } else {
            result = this.getHighestRes();
        }
        double[] clone = new double[result.length];
        System.arraycopy(result, 0, clone, 0, result.length);
        return clone;
    }

    protected final void decimationOnReadingControl(Integer imageChoice, ImageReadParam readP, double[] requestedRes) {
        this.decimationOnReadingControl(imageChoice, readP, requestedRes);
    }

    protected final void decimationOnReadingControl(String coverageName, Integer imageChoice, ImageReadParam readP, double[] requestedRes) {
        int h;
        int w;
        double[] selectedRes = new double[2];
        int choice = imageChoice;
        if (choice == 0) {
            w = this.getOriginalGridRange(coverageName).getSpan(0);
            h = this.getOriginalGridRange(coverageName).getSpan(1);
            selectedRes[0] = this.getHighestRes()[0];
            selectedRes[1] = this.getHighestRes()[1];
        } else {
            selectedRes[0] = this.overViewResolutions[choice - 1][0];
            selectedRes[1] = this.overViewResolutions[choice - 1][1];
            w = (int)Math.round(this.getOriginalEnvelope(coverageName).getSpan(0) / selectedRes[0]);
            h = (int)Math.round(this.getOriginalEnvelope(coverageName).getSpan(1) / selectedRes[1]);
        }
        if (requestedRes == null) {
            readP.setSourceSubsampling(1, 1, 0, 0);
        } else {
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            readP.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    protected final GridCoverage createImageCoverage(PlanarImage image) throws IOException {
        return this.createImageCoverage(this.coverageName, image);
    }

    protected final GridCoverage createImageCoverage(String coverageName, PlanarImage image) throws IOException {
        return this.createImageCoverage(coverageName, image, null);
    }

    protected final GridCoverage2D createImageCoverage(PlanarImage image, MathTransform raster2Model) throws IOException {
        return this.createImageCoverage(this.coverageName, image, raster2Model);
    }

    protected final GridCoverage2D createImageCoverage(String coverageName, PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation(cm, i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            bands[i] = new GridSampleDimension(colorInterpretation.name()).geophysics(true);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create(coverageName, (RenderedImage)image, this.getCoordinateReferenceSystem(coverageName), raster2Model, bands, null, null);
        }
        return this.coverageFactory.create((CharSequence)coverageName, (RenderedImage)image, new GeneralEnvelope(this.getOriginalEnvelope(coverageName)), bands, null, null);
    }

    protected static final double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null && crs != null) {
                MathTransform tr;
                SingleCRS crs2D = CRS.getHorizontalCRS(envelope.getCoordinateReferenceSystem());
                if (crs2D != null && !CRS.equalsIgnoreMetadata(crs, crs2D) && !(tr = CRS.findMathTransform((CoordinateReferenceSystem)crs2D, crs, true)).isIdentity()) {
                    envelope = CRS.transform(tr, (Envelope)envelope);
                    envelope.setCoordinateReferenceSystem(crs);
                }
                requestedRes = new double[]{envelope.getSpan(0) / dim.getWidth(), envelope.getSpan(1) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to get resolution", e);
        }
        catch (FactoryException e) {
            throw new DataSourceException("Unable to get resolution", e);
        }
    }

    public final CoordinateReferenceSystem getCrs() {
        return this.getCoordinateReferenceSystem();
    }

    @Override
    public GridEnvelope getOriginalGridRange() {
        return this.getOriginalGridRange(this.coverageName);
    }

    @Override
    public GridEnvelope getOriginalGridRange(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        assert (this.originalGridRange.getDimension() == 2);
        return new GridEnvelope2D(this.originalGridRange.getLow(0), this.originalGridRange.getLow(1), this.originalGridRange.getSpan(0), this.originalGridRange.getSpan(1));
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCoordinateReferenceSystem(this.coverageName);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.crs;
    }

    @Override
    public GeneralEnvelope getOriginalEnvelope() {
        return this.getOriginalEnvelope(this.coverageName);
    }

    @Override
    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return new GeneralEnvelope(this.originalEnvelope);
    }

    @Override
    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.getOriginalGridToWorld(this.coverageName, pixInCell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        AffineTransform tr;
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            if (this.raster2Model == null) {
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.getOriginalGridRange(coverageName), this.getOriginalEnvelope(coverageName));
                geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                this.raster2Model = geMapper.createTransform();
            }
        }
        if (pixInCell == PixelInCell.CELL_CENTER) {
            return this.raster2Model;
        }
        if (this.raster2Model instanceof AffineTransform) {
            tr = new AffineTransform((AffineTransform)this.raster2Model);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        if (this.raster2Model instanceof IdentityTransform) {
            tr = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        throw new IllegalStateException("This reader's grid to world transform is invalud!");
    }

    public final Object getSource() {
        return this.source;
    }

    public void dispose() {
        block3: {
            if (this.inStream != null && this.closeMe) {
                try {
                    this.inStream.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public void skip() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public boolean hasMoreGridCoverages() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public String[] listSubNames() {
        return this.getGridCoverageNames();
    }

    public String[] getGridCoverageNames() {
        return new String[]{this.coverageName};
    }

    public String getCurrentSubname() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public String[] getMetadataNames(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getMetadataNames();
    }

    public String[] getMetadataNames() {
        return null;
    }

    public String getMetadataValue(String name) {
        return this.getMetadataValue(this.coverageName, name);
    }

    public String getMetadataValue(String coverageName, String name) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return null;
    }

    public int getGridCoverageCount() {
        return 1;
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(this.source == null ? null : String.valueOf(this.source));
        if (this.source instanceof URL) {
            URL url = (URL)this.source;
            info.setTitle(url.getFile());
            try {
                info.setSource(url.toURI());
            }
            catch (URISyntaxException e) {}
        } else if (this.source instanceof File) {
            File file = (File)this.source;
            String filename = file.getName();
            if (filename == null || filename.length() == 0) {
                info.setTitle(file.getName());
            }
            info.setSource(file.toURI());
        }
        return info;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.getDynamicParameters(this.coverageName);
    }

    @Override
    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        return Collections.emptySet();
    }

    @Override
    public int getNumOverviews(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.overViewResolutions != null ? this.overViewResolutions.length : 0;
    }

    @Override
    public int getNumOverviews() {
        return this.getNumOverviews(this.coverageName);
    }

    public GridEnvelope getOverviewGridEnvelope(int overviewIndex) throws IOException {
        return this.getOverviewGridEnvelope(this.coverageName, overviewIndex);
    }

    public GridEnvelope getOverviewGridEnvelope(String coverageName, int overviewIndex) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return null;
    }

    @Override
    public ImageLayout getImageLayout(String coverageName) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return (ImageLayout)this.imageLayout.clone();
    }

    @Override
    public ImageLayout getImageLayout() throws IOException {
        return this.getImageLayout(this.coverageName);
    }

    protected void setLayout(ImageReader reader) throws IOException {
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        ImageLayout2 layout = new ImageLayout2();
        ImageTypeSpecifier its = reader.getImageTypes(0).next();
        layout.setColorModel(its.getColorModel()).setSampleModel(its.getSampleModel());
        layout.setMinX(0).setMinY(0).setWidth(reader.getWidth(0)).setHeight(reader.getHeight(0));
        layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileWidth(reader.getTileWidth(0)).setTileHeight(reader.getTileHeight(0));
        this.setlayout((ImageLayout)layout);
    }

    protected void setlayout(ImageLayout layout) {
        Utilities.ensureNonNull((String)"layout", (Object)layout);
        this.imageLayout = (ImageLayout)layout.clone();
    }

    @Override
    public double[][] getResolutionLevels() throws IOException {
        return this.getResolutionLevels(this.coverageName);
    }

    @Override
    public double[][] getResolutionLevels(String coverageName) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        double[][] returnValue = new double[this.numOverviews + 1][2];
        System.arraycopy(this.getHighestRes(), 0, returnValue[0], 0, 2);
        for (int i = 1; i < returnValue.length; ++i) {
            System.arraycopy(this.overViewResolutions[i - 1], 0, returnValue[i], 0, 2);
        }
        return returnValue;
    }

    protected double[] getHighestRes(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.highestRes;
    }

    double[] getHighestRes() {
        return this.getHighestRes(this.coverageName);
    }

    private static class Resolution
    implements Comparable<Resolution> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public Resolution(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(Resolution other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "Resolution[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + "]";
        }
    }
}

