/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.knowledgebase;

import au.org.ala.sds.model.SensitivityCategory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class KnowledgeBaseFactory {
    protected static final Logger logger = Logger.getLogger(KnowledgeBaseFactory.class);
    private static final Object lock = new Object();
    private static Map<String, String> rules = new HashMap<String, String>();
    private static Map<SensitivityCategory, KnowledgeBase> kbs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KnowledgeBase getKnowledgeBase(SensitivityCategory category) {
        KnowledgeBase knowledgeBase;
        Object object = lock;
        synchronized (object) {
            knowledgeBase = kbs.get(category);
            if (knowledgeBase == null) {
                logger.debug((Object)("Instantiating KnowledgeBase '" + rules.get(category.getId()) + "'"));
                KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                builder.add(ResourceFactory.newClassPathResource((String)rules.get(category.getId())), ResourceType.DRL);
                if (builder.hasErrors()) {
                    throw new RuntimeException(builder.getErrors().toString());
                }
                KieBaseConfiguration configuration = org.kie.internal.KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
                configuration.setOption((KieBaseOption)EventProcessingOption.STREAM);
                knowledgeBase = org.kie.internal.KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)configuration);
                knowledgeBase.addKnowledgePackages(builder.getKnowledgePackages());
                kbs.put(category, knowledgeBase);
            }
        }
        logger.debug((Object)("Using KnowledgeBase '" + rules.get(category.getId()) + "'"));
        return knowledgeBase;
    }

    static {
        rules.put("PBC1", "PBC1-PlantPestNotKnownInAustralia.drl");
        rules.put("PBC2", "PBC2-PlantPestEradicated.drl");
        rules.put("PBC3", "PBC3-PlantPestUnderEradication.drl");
        rules.put("PBC4", "PBC4-PlantPestSubjectToOfficialControl.drl");
        rules.put("PBC5a", "PBC5a-PlantPestInTorresStraitZone.drl");
        rules.put("PBC5b", "PBC5b-PlantPestIsQueenslandFruitFly.drl");
        rules.put("PBC6", "PBC6-PlantPestNotifiableUnderStateLegislation.drl");
        rules.put("PBC8", "PBC8-PlantPestTransient.drl");
        rules.put("PBC9", "PBC9-ExoticBiologicalControlAgent.drl");
        rules.put("PBC10", "PBC10-IdentificationToHigherTaxon.drl");
        kbs = new HashMap<SensitivityCategory, KnowledgeBase>();
    }
}

