/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dao;

import au.org.ala.sds.dao.SensitiveSpeciesDao;
import au.org.ala.sds.model.ConservationInstance;
import au.org.ala.sds.model.PlantPestInstance;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitivityCategoryFactory;
import au.org.ala.sds.model.SensitivityInstance;
import au.org.ala.sds.model.SensitivityZoneFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class SensitiveSpeciesXmlDao
implements SensitiveSpeciesDao {
    protected static final Logger logger = Logger.getLogger(SensitiveSpeciesXmlDao.class);
    private final InputStream stream;

    public SensitiveSpeciesXmlDao(InputStream stream) throws Exception {
        this.stream = stream;
    }

    @Override
    public List<SensitiveTaxon> getAll() throws Exception {
        ArrayList<SensitiveTaxon> species = new ArrayList<SensitiveTaxon>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(this.stream);
        Element root = doc.getRootElement();
        List speciesList = root.getChildren();
        for (Element sse : speciesList) {
            String name = sse.getAttributeValue("name");
            String family = sse.getAttributeValue("family");
            SensitiveTaxon.Rank rank = SensitiveTaxon.Rank.valueOf(sse.getAttributeValue("rank"));
            String commonName = sse.getAttributeValue("commonName");
            SensitiveTaxon ss = new SensitiveTaxon(name, rank);
            ss.setFamily(family);
            ss.setCommonName(commonName);
            if (sse.getAttributeValue("guid") != null) {
                ss.setLsid(sse.getAttributeValue("guid"));
            } else if (sse.getAttributeValue("lsid") != null) {
                ss.setLsid(sse.getAttributeValue("lsid"));
            }
            Element instances = sse.getChild("instances");
            List instanceList = instances.getChildren();
            for (Element ie : instanceList) {
                SensitivityInstance instance = null;
                String zone = ie.getAttributeValue("zone");
                if (ie.getName().equalsIgnoreCase("conservationInstance")) {
                    instance = new ConservationInstance(SensitivityCategoryFactory.getCategory(ie.getAttributeValue("category")), ie.getAttributeValue("authority"), ie.getAttributeValue("dataResourceId"), SensitivityZoneFactory.findZone(ie.getAttributeValue("zone")), ie.getAttributeValue("reason"), ie.getAttributeValue("remarks"), ie.getAttributeValue("generalisation"));
                } else if (ie.getName().equalsIgnoreCase("plantPestInstance")) {
                    instance = new PlantPestInstance(SensitivityCategoryFactory.getCategory(ie.getAttributeValue("category")), ie.getAttributeValue("authority"), ie.getAttributeValue("dataResourceId"), SensitivityZoneFactory.findZone(ie.getAttributeValue("zone")), ie.getAttributeValue("reason"), ie.getAttributeValue("remarks"), ie.getAttributeValue("fromDate"), ie.getAttributeValue("toDate"));
                    List transChildren = ie.getChildren();
                    if (transChildren.size() > 0) {
                        for (Element te : transChildren) {
                            ((PlantPestInstance)instance).addTransientEvent(te.getAttributeValue("eventDate"), SensitivityZoneFactory.getZone(te.getAttributeValue("zone")));
                        }
                    }
                }
                ss.getInstances().add(instance);
            }
            species.add(ss);
        }
        Collections.sort(species);
        return species;
    }
}

