/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.CanonMakernoteDirectory;

public class CanonMakernoteDescriptor
extends TagDescriptor<CanonMakernoteDirectory> {
    public CanonMakernoteDescriptor(@NotNull CanonMakernoteDirectory canonMakernoteDirectory) {
        super(canonMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 12: {
                return this.getSerialNumberDescription();
            }
            case 49436: {
                return this.getFlashActivityDescription();
            }
            case 49426: {
                return this.getFocusTypeDescription();
            }
            case 49420: {
                return this.getDigitalZoomDescription();
            }
            case 49411: {
                return this.getQualityDescription();
            }
            case 49409: {
                return this.getMacroModeDescription();
            }
            case 49410: {
                return this.getSelfTimerDelayDescription();
            }
            case 49412: {
                return this.getFlashModeDescription();
            }
            case 49413: {
                return this.getContinuousDriveModeDescription();
            }
            case 49415: {
                return this.getFocusMode1Description();
            }
            case 49418: {
                return this.getImageSizeDescription();
            }
            case 49419: {
                return this.getEasyShootingModeDescription();
            }
            case 49421: {
                return this.getContrastDescription();
            }
            case 49422: {
                return this.getSaturationDescription();
            }
            case 49423: {
                return this.getSharpnessDescription();
            }
            case 49424: {
                return this.getIsoDescription();
            }
            case 49425: {
                return this.getMeteringModeDescription();
            }
            case 49427: {
                return this.getAfPointSelectedDescription();
            }
            case 49428: {
                return this.getExposureModeDescription();
            }
            case 49431: {
                return this.getLongFocalLengthDescription();
            }
            case 49432: {
                return this.getShortFocalLengthDescription();
            }
            case 49433: {
                return this.getFocalUnitsPerMillimetreDescription();
            }
            case 49437: {
                return this.getFlashDetailsDescription();
            }
            case 49440: {
                return this.getFocusMode2Description();
            }
            case 49671: {
                return this.getWhiteBalanceDescription();
            }
            case 49678: {
                return this.getAfPointUsedDescription();
            }
            case 49679: {
                return this.getFlashBiasDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getSerialNumberDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(12);
        if (n == null) {
            return null;
        }
        return String.format("%04X%05d", n >> 8 & 0xFF, n & 0xFF);
    }

    @Nullable
    public String getFlashBiasDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49679);
        if (n == null) {
            return null;
        }
        boolean bl = false;
        if (n > 61440) {
            bl = true;
            Integer n2 = n = Integer.valueOf(65535 - n);
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        return (bl ? "-" : "") + Float.toString((float)n.intValue() / 32.0f) + " EV";
    }

    @Nullable
    public String getAfPointUsedDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49678);
        if (n == null) {
            return null;
        }
        if ((n & 7) == 0) {
            return "Right";
        }
        if ((n & 7) == 1) {
            return "Centre";
        }
        if ((n & 7) == 2) {
            return "Left";
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49671);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Sunny";
            }
            case 2: {
                return "Cloudy";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Florescent";
            }
            case 5: {
                return "Flash";
            }
            case 6: {
                return "Custom";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocusMode2Description() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49440);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Single";
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashDetailsDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49437);
        if (n == null) {
            return null;
        }
        if ((n << 14 & 1) > 0) {
            return "External E-TTL";
        }
        if ((n << 13 & 1) > 0) {
            return "Internal flash";
        }
        if ((n << 11 & 1) > 0) {
            return "FP sync used";
        }
        if ((n << 4 & 1) > 0) {
            return "FP sync enabled";
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocalUnitsPerMillimetreDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49433);
        if (n == null) {
            return null;
        }
        if (n != 0) {
            return Integer.toString(n);
        }
        return "";
    }

    @Nullable
    public String getShortFocalLengthDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49432);
        if (n == null) {
            return null;
        }
        String string = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(n) + " " + string;
    }

    @Nullable
    public String getLongFocalLengthDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49431);
        if (n == null) {
            return null;
        }
        String string = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(n) + " " + string;
    }

    @Nullable
    public String getExposureModeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49428);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Easy shooting";
            }
            case 1: {
                return "Program";
            }
            case 2: {
                return "Tv-priority";
            }
            case 3: {
                return "Av-priority";
            }
            case 4: {
                return "Manual";
            }
            case 5: {
                return "A-DEP";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAfPointSelectedDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49427);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 12288: {
                return "None (MF)";
            }
            case 12289: {
                return "Auto selected";
            }
            case 12290: {
                return "Right";
            }
            case 12291: {
                return "Centre";
            }
            case 12292: {
                return "Left";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getMeteringModeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49425);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 3: {
                return "Evaluative";
            }
            case 4: {
                return "Partial";
            }
            case 5: {
                return "Centre weighted";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getIsoDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49424);
        if (n == null) {
            return null;
        }
        int n2 = 16384;
        if ((n & n2) > 0) {
            return "" + (n & ~n2);
        }
        switch (n) {
            case 0: {
                return "Not specified (see ISOSpeedRatings tag)";
            }
            case 15: {
                return "Auto";
            }
            case 16: {
                return "50";
            }
            case 17: {
                return "100";
            }
            case 18: {
                return "200";
            }
            case 19: {
                return "400";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49423);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49422);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49421);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getEasyShootingModeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49419);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Full auto";
            }
            case 1: {
                return "Manual";
            }
            case 2: {
                return "Landscape";
            }
            case 3: {
                return "Fast shutter";
            }
            case 4: {
                return "Slow shutter";
            }
            case 5: {
                return "Night";
            }
            case 6: {
                return "B&W";
            }
            case 7: {
                return "Sepia";
            }
            case 8: {
                return "Portrait";
            }
            case 9: {
                return "Sports";
            }
            case 10: {
                return "Macro / Closeup";
            }
            case 11: {
                return "Pan focus";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getImageSizeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49418);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Large";
            }
            case 1: {
                return "Medium";
            }
            case 2: {
                return "Small";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocusMode1Description() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49415);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "One-shot";
            }
            case 1: {
                return "AI Servo";
            }
            case 2: {
                return "AI Focus";
            }
            case 3: {
                return "Manual Focus";
            }
            case 4: {
                return "Single";
            }
            case 5: {
                return "Continuous";
            }
            case 6: {
                return "Manual Focus";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContinuousDriveModeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49413);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                Integer n2 = ((CanonMakernoteDirectory)this._directory).getInteger(49410);
                if (n2 != null) {
                    return n2 == 0 ? "Single shot" : "Single shot with self-timer";
                }
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49412);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Auto";
            }
            case 2: {
                return "On";
            }
            case 3: {
                return "Red-eye reduction";
            }
            case 4: {
                return "Slow-synchro";
            }
            case 5: {
                return "Auto and red-eye reduction";
            }
            case 6: {
                return "On and red-eye reduction";
            }
            case 16: {
                return "External flash";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSelfTimerDelayDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49410);
        if (n == null) {
            return null;
        }
        if (n == 0) {
            return "Self timer not used";
        }
        return Double.toString((double)n.intValue() * 0.1) + " sec";
    }

    @Nullable
    public String getMacroModeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49409);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Macro";
            }
            case 2: {
                return "Normal";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getQualityDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49411);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 2: {
                return "Normal";
            }
            case 3: {
                return "Fine";
            }
            case 5: {
                return "Superfine";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49420);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "No digital zoom";
            }
            case 1: {
                return "2x";
            }
            case 2: {
                return "4x";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocusTypeDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49426);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Manual";
            }
            case 1: {
                return "Auto";
            }
            case 3: {
                return "Close-up (Macro)";
            }
            case 8: {
                return "Locked (Pan Mode)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashActivityDescription() {
        Integer n = ((CanonMakernoteDirectory)this._directory).getInteger(49436);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Flash did not fire";
            }
            case 1: {
                return "Flash fired";
            }
        }
        return "Unknown (" + n + ")";
    }
}

