/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.UnsupportedEncodingException;

public class BufferReader {
    @NotNull
    private final byte[] _buffer;
    private boolean _isMotorolaByteOrder = true;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public BufferReader(@NotNull byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this._buffer = byArray;
    }

    public int getLength() {
        return this._buffer.length;
    }

    public void setMotorolaByteOrder(boolean bl) {
        this._isMotorolaByteOrder = bl;
    }

    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    public byte getByte(int n) throws BufferBoundsException {
        this.CheckBounds(n, 1);
        return this._buffer[n];
    }

    public int getUInt8(int n) throws BufferBoundsException {
        this.CheckBounds(n, 1);
        return this._buffer[n] & 0xFF;
    }

    public int getUInt16(int n) throws BufferBoundsException {
        this.CheckBounds(n, 2);
        if (this._isMotorolaByteOrder) {
            return this._buffer[n] << 8 & 0xFF00 | this._buffer[n + 1] & 0xFF;
        }
        return this._buffer[n + 1] << 8 & 0xFF00 | this._buffer[n] & 0xFF;
    }

    public int getInt32(int n) throws BufferBoundsException {
        this.CheckBounds(n, 4);
        if (this._isMotorolaByteOrder) {
            return this._buffer[n] << 24 & 0xFF000000 | this._buffer[n + 1] << 16 & 0xFF0000 | this._buffer[n + 2] << 8 & 0xFF00 | this._buffer[n + 3] & 0xFF;
        }
        return this._buffer[n + 3] << 24 & 0xFF000000 | this._buffer[n + 2] << 16 & 0xFF0000 | this._buffer[n + 1] << 8 & 0xFF00 | this._buffer[n] & 0xFF;
    }

    public long getInt64(int n) throws BufferBoundsException {
        this.CheckBounds(n, 8);
        if (this._isMotorolaByteOrder) {
            return (long)this._buffer[n] << 56 & 0xFF00000000000000L | (long)this._buffer[n + 1] << 48 & 0xFF000000000000L | (long)this._buffer[n + 2] << 40 & 0xFF0000000000L | (long)this._buffer[n + 3] << 32 & 0xFF00000000L | (long)this._buffer[n + 4] << 24 & 0xFF000000L | (long)this._buffer[n + 5] << 16 & 0xFF0000L | (long)this._buffer[n + 6] << 8 & 0xFF00L | (long)this._buffer[n + 7] & 0xFFL;
        }
        return (long)this._buffer[n + 7] << 56 & 0xFF00000000000000L | (long)this._buffer[n + 6] << 48 & 0xFF000000000000L | (long)this._buffer[n + 5] << 40 & 0xFF0000000000L | (long)this._buffer[n + 4] << 32 & 0xFF00000000L | (long)this._buffer[n + 3] << 24 & 0xFF000000L | (long)this._buffer[n + 2] << 16 & 0xFF0000L | (long)this._buffer[n + 1] << 8 & 0xFF00L | (long)this._buffer[n] & 0xFFL;
    }

    public float getS15Fixed16(int n) throws BufferBoundsException {
        this.CheckBounds(n, 4);
        if (this._isMotorolaByteOrder) {
            float f = (this._buffer[n] & 0xFF) << 8 | this._buffer[n + 1] & 0xFF;
            int n2 = (this._buffer[n + 2] & 0xFF) << 8 | this._buffer[n + 3] & 0xFF;
            return (float)((double)f + (double)n2 / 65536.0);
        }
        float f = (this._buffer[n + 3] & 0xFF) << 8 | this._buffer[n + 2] & 0xFF;
        int n3 = (this._buffer[n + 1] & 0xFF) << 8 | this._buffer[n] & 0xFF;
        return (float)((double)f + (double)n3 / 65536.0);
    }

    public float getFloat32(int n) throws BufferBoundsException {
        return Float.intBitsToFloat(this.getInt32(n));
    }

    public double getDouble64(int n) throws BufferBoundsException {
        return Double.longBitsToDouble(this.getInt64(n));
    }

    @NotNull
    public byte[] getBytes(int n, int n2) throws BufferBoundsException {
        this.CheckBounds(n, n2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this._buffer, n, byArray, 0, n2);
        return byArray;
    }

    @NotNull
    public String getString(int n, int n2) throws BufferBoundsException {
        this.CheckBounds(n, n2);
        byte[] byArray = this.getBytes(n, n2);
        return new String(byArray);
    }

    @NotNull
    public String getString(int n, int n2, String string) throws BufferBoundsException {
        this.CheckBounds(n, n2);
        byte[] byArray = this.getBytes(n, n2);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    @NotNull
    public String getNullTerminatedString(int n, int n2) throws BufferBoundsException {
        int n3;
        this.CheckBounds(n, n2);
        for (n3 = 0; n + n3 < this._buffer.length && this._buffer[n + n3] != 0 && n3 < n2; ++n3) {
        }
        byte[] byArray = this.getBytes(n, n3);
        return new String(byArray);
    }

    private void CheckBounds(int n, int n2) throws BufferBoundsException {
        if (n2 < 0 || n < 0 || (long)n + (long)n2 - 1L >= (long)this._buffer.length) {
            throw new BufferBoundsException(this._buffer, n, n2);
        }
    }
}

