/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.ConditionalBranch;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.From;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.GroupElementFactory;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryArgument;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.DeclarationScopeResolver;

public class LogicTransformer {
    private final Map<GroupElement.Type, Transformation> orTransformations = new HashMap<GroupElement.Type, Transformation>();
    private static LogicTransformer INSTANCE = new LogicTransformer();

    public static LogicTransformer getInstance() {
        return INSTANCE;
    }

    protected LogicTransformer() {
        this.initialize();
    }

    private void initialize() {
        this.addTransformationPair(GroupElement.NOT, new NotOrTransformation());
        this.addTransformationPair(GroupElement.EXISTS, new ExistOrTransformation());
        this.addTransformationPair(GroupElement.AND, new AndOrTransformation());
    }

    private void addTransformationPair(GroupElement.Type parent, Transformation method) {
        this.orTransformations.put(parent, method);
    }

    public GroupElement[] transform(GroupElement cloned, Map<String, Class<?>> globals) throws InvalidPatternException {
        GroupElement[] ands;
        boolean hasNamedConsequenceAndIsStream = this.processTree(cloned);
        cloned.pack();
        if (cloned.isAnd()) {
            ands = new GroupElement[]{cloned};
        } else if (cloned.isOr()) {
            ands = this.splitOr(cloned);
        } else {
            GroupElement wrapper = GroupElementFactory.newAndInstance();
            wrapper.addChild(cloned);
            ands = new GroupElement[]{wrapper};
        }
        for (GroupElement and : ands) {
            this.fixClonedDeclarations(and, globals);
            and.setRoot(true);
        }
        return hasNamedConsequenceAndIsStream ? this.processNamedConsequences(ands) : ands;
    }

    private GroupElement[] processNamedConsequences(GroupElement[] ands) {
        ArrayList<GroupElement> result = new ArrayList<GroupElement>();
        for (GroupElement and : ands) {
            List<RuleConditionElement> children = and.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                RuleConditionElement child = children.get(i);
                if (!(child instanceof NamedConsequence)) continue;
                GroupElement clonedAnd = GroupElementFactory.newAndInstance();
                for (int j = 0; j < i; ++j) {
                    clonedAnd.addChild(children.get(j).clone());
                }
                ((NamedConsequence)child).setTerminal(true);
                clonedAnd.addChild(child);
                children.remove(i--);
                result.add(clonedAnd);
            }
            result.add(and);
        }
        return result.toArray(new GroupElement[result.size()]);
    }

    protected GroupElement[] splitOr(GroupElement cloned) {
        GroupElement[] ands = new GroupElement[cloned.getChildren().size()];
        int i = 0;
        for (RuleConditionElement branch : cloned.getChildren()) {
            if (branch instanceof GroupElement && ((GroupElement)branch).isAnd()) {
                ands[i++] = (GroupElement)branch;
                continue;
            }
            ands[i] = GroupElementFactory.newAndInstance();
            ands[i].addChild(branch);
            ++i;
        }
        return ands;
    }

    protected void fixClonedDeclarations(GroupElement and, Map<String, Class<?>> globals) {
        Stack<RuleConditionElement> contextStack = new Stack<RuleConditionElement>();
        DeclarationScopeResolver resolver = new DeclarationScopeResolver(globals, contextStack);
        contextStack.push(and);
        this.processElement(resolver, contextStack, and);
        contextStack.pop();
    }

    private void processElement(DeclarationScopeResolver resolver, Stack<RuleConditionElement> contextStack, RuleConditionElement element) {
        if (element instanceof Pattern) {
            Pattern pattern = (Pattern)element;
            for (RuleConditionElement ruleConditionElement : pattern.getNestedElements()) {
                this.processElement(resolver, contextStack, ruleConditionElement);
            }
            for (Constraint constraint : pattern.getConstraints()) {
                if (constraint instanceof Declaration) continue;
                this.replaceDeclarations(resolver, pattern, constraint);
            }
        } else if (element instanceof EvalCondition) {
            this.processEvalCondition(resolver, (EvalCondition)element);
        } else if (element instanceof Accumulate) {
            for (RuleConditionElement ruleConditionElement : element.getNestedElements()) {
                this.processElement(resolver, contextStack, ruleConditionElement);
            }
            Accumulate accumulate = (Accumulate)element;
            this.replaceDeclarations(resolver, accumulate);
        } else if (element instanceof From) {
            Declaration[] declarationArray;
            DataProvider provider = ((From)element).getDataProvider();
            for (Declaration aDecl : declarationArray = provider.getRequiredDeclarations()) {
                Pattern old;
                Pattern current;
                Declaration resolved = resolver.getDeclaration(null, aDecl.getIdentifier());
                if (resolved != null && resolved != aDecl) {
                    provider.replaceDeclaration(aDecl, resolved);
                    continue;
                }
                if (resolved != null || (current = resolver.findPatternByIndex((old = aDecl.getPattern()).getIndex())) == null || old == current) continue;
                resolved = new Declaration(aDecl.getIdentifier(), aDecl.getExtractor(), current);
                provider.replaceDeclaration(aDecl, resolved);
            }
        } else if (element instanceof QueryElement) {
            QueryElement qe = (QueryElement)element;
            Pattern pattern = qe.getResultPattern();
            for (Map.Entry<String, Declaration> entry : pattern.getInnerDeclarations().entrySet()) {
                Declaration resolved = resolver.getDeclaration(null, entry.getValue().getIdentifier());
                if (resolved == null || resolved == entry.getValue() || resolved.getPattern() == pattern) continue;
                entry.setValue(resolved);
            }
            List<Integer> varIndexes = LogicTransformer.asList(qe.getVariableIndexes());
            for (int i = 0; i < qe.getArguments().length; ++i) {
                if (!(qe.getArguments()[i] instanceof QueryArgument.Declr)) continue;
                Declaration declr = ((QueryArgument.Declr)qe.getArguments()[i]).getDeclaration();
                Declaration resolved = resolver.getDeclaration(null, declr.getIdentifier());
                if (resolved != declr && resolved.getPattern() != pattern) {
                    qe.getArguments()[i] = new QueryArgument.Declr(resolved);
                }
                if (!ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(resolved.getPattern().getObjectType())) continue;
                declr = pattern.addDeclaration(declr.getIdentifier());
                ArrayElementReader reader = new ArrayElementReader(new SelfReferenceClassFieldReader(Object[].class), i, resolved.getDeclarationClass());
                declr.setReadAccessor(reader);
                varIndexes.add(i);
            }
            qe.setVariableIndexes(LogicTransformer.toIntArray(varIndexes));
        } else if (element instanceof ConditionalBranch) {
            this.processBranch(resolver, (ConditionalBranch)element);
        } else {
            contextStack.push(element);
            for (RuleConditionElement ruleConditionElement : element.getNestedElements()) {
                this.processElement(resolver, contextStack, ruleConditionElement);
            }
            contextStack.pop();
        }
    }

    private void replaceDeclarations(DeclarationScopeResolver resolver, Pattern pattern, Constraint constraint) {
        Declaration[] decl;
        for (Declaration aDecl : decl = constraint.getRequiredDeclarations()) {
            Pattern old;
            Pattern current;
            Declaration resolved = resolver.getDeclaration(null, aDecl.getIdentifier());
            if (constraint instanceof MvelConstraint && ((MvelConstraint)constraint).isUnification()) {
                if (ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(resolved.getPattern().getObjectType())) {
                    Declaration redeclaredDeclr = new Declaration(resolved.getIdentifier(), ((MvelConstraint)constraint).getFieldExtractor(), pattern, false);
                    pattern.addDeclaration(redeclaredDeclr);
                } else if (resolved.getPattern() != pattern) {
                    ((MvelConstraint)constraint).unsetUnification();
                }
            }
            if (resolved != null && resolved != aDecl && resolved.getPattern() != pattern) {
                constraint.replaceDeclaration(aDecl, resolved);
                continue;
            }
            if (resolved != null || (current = resolver.findPatternByIndex((old = aDecl.getPattern()).getIndex())) == null || old == current) continue;
            resolved = new Declaration(aDecl.getIdentifier(), aDecl.getExtractor(), current);
            constraint.replaceDeclaration(aDecl, resolved);
        }
    }

    private void replaceDeclarations(DeclarationScopeResolver resolver, Accumulate accumulate) {
        Declaration[] decl;
        for (Declaration aDecl : decl = accumulate.getRequiredDeclarations()) {
            Pattern old;
            Pattern current;
            Declaration resolved = resolver.getDeclaration(null, aDecl.getIdentifier());
            if (resolved != null && resolved != aDecl) {
                accumulate.replaceDeclaration(aDecl, resolved);
                continue;
            }
            if (resolved != null || (current = resolver.findPatternByIndex((old = aDecl.getPattern()).getIndex())) == null || old == current) continue;
            resolved = new Declaration(aDecl.getIdentifier(), aDecl.getExtractor(), current);
            accumulate.replaceDeclaration(aDecl, resolved);
        }
    }

    private static List<Integer> asList(int[] ints) {
        ArrayList<Integer> list = new ArrayList<Integer>(ints.length);
        for (int i : ints) {
            list.add(i);
        }
        return list;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] ints = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ints[i] = list.get(i);
        }
        return ints;
    }

    private void processEvalCondition(DeclarationScopeResolver resolver, EvalCondition element) {
        Declaration[] decl;
        for (Declaration aDecl : decl = element.getRequiredDeclarations()) {
            Declaration resolved = resolver.getDeclaration(null, aDecl.getIdentifier());
            if (resolved == null || resolved == aDecl) continue;
            element.replaceDeclaration(aDecl, resolved);
        }
    }

    private void processBranch(DeclarationScopeResolver resolver, ConditionalBranch branch) {
        this.processEvalCondition(resolver, branch.getEvalCondition());
        if (branch.getElseBranch() != null) {
            this.processBranch(resolver, branch.getElseBranch());
        }
    }

    protected boolean processTree(GroupElement ce) throws InvalidPatternException {
        boolean[] hasNamedConsequenceAndIsStream = new boolean[2];
        this.processTree(ce, hasNamedConsequenceAndIsStream);
        return hasNamedConsequenceAndIsStream[0] && hasNamedConsequenceAndIsStream[1];
    }

    private void processTree(GroupElement ce, boolean[] result) throws InvalidPatternException {
        boolean hasChildOr = false;
        ce.pack();
        for (Object child : ce.getChildren().toArray()) {
            if (child instanceof GroupElement) {
                GroupElement group = (GroupElement)child;
                this.processTree(group, result);
                if ((group.isOr() || group.isAnd()) && group.getType() == ce.getType()) {
                    group.pack(ce);
                    continue;
                }
                if (!group.isOr()) continue;
                hasChildOr = true;
                continue;
            }
            if (child instanceof NamedConsequence) {
                result[0] = true;
                continue;
            }
            if (!(child instanceof Pattern) || !((Pattern)child).getObjectType().isEvent()) continue;
            result[1] = true;
        }
        if (hasChildOr) {
            this.applyOrTransformation(ce);
        }
    }

    void applyOrTransformation(GroupElement parent) throws InvalidPatternException {
        Transformation transformation = this.orTransformations.get((Object)parent.getType());
        if (transformation == null) {
            throw new RuntimeException("applyOrTransformation could not find transformation for parent '" + (Object)((Object)parent.getType()) + "' and child 'OR'");
        }
        transformation.transform(parent);
    }

    public class NotOrTransformation
    implements Transformation {
        @Override
        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) || !((GroupElement)parent.getChildren().get(0)).isOr()) {
                throw new RuntimeException("NotOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.AND);
            parent.getChildren().clear();
            for (RuleConditionElement ruleConditionElement : or.getChildren()) {
                GroupElement newNot = GroupElementFactory.newNotInstance();
                newNot.addChild(ruleConditionElement);
                parent.addChild(newNot);
            }
            parent.pack();
        }
    }

    class ExistOrTransformation
    implements Transformation {
        ExistOrTransformation() {
        }

        @Override
        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) || !((GroupElement)parent.getChildren().get(0)).isOr()) {
                throw new RuntimeException("ExistOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.NOT);
            parent.getChildren().clear();
            GroupElement and = GroupElementFactory.newAndInstance();
            for (RuleConditionElement ruleConditionElement : or.getChildren()) {
                GroupElement newNot = GroupElementFactory.newNotInstance();
                newNot.addChild(ruleConditionElement);
                and.addChild(newNot);
            }
            parent.addChild(and);
            parent.pack();
        }
    }

    class AndOrTransformation
    implements Transformation {
        AndOrTransformation() {
        }

        @Override
        public void transform(GroupElement parent) throws InvalidPatternException {
            ArrayList<GroupElement> orsList = new ArrayList<GroupElement>();
            RuleConditionElement[] others = new RuleConditionElement[parent.getChildren().size()];
            int permutations = 1;
            int index = 0;
            for (RuleConditionElement child : parent.getChildren()) {
                if (child instanceof GroupElement && ((GroupElement)child).isOr()) {
                    permutations *= ((GroupElement)child).getChildren().size();
                    orsList.add((GroupElement)child);
                } else {
                    others[index] = child;
                }
                ++index;
            }
            parent.setType(GroupElement.OR);
            parent.getChildren().clear();
            int[] indexes = new int[orsList.size()];
            for (int i = 1; i <= permutations; ++i) {
                int j;
                GroupElement and = GroupElementFactory.newAndInstance();
                int mod = 1;
                for (j = orsList.size() - 1; j >= 0; --j) {
                    GroupElement or = (GroupElement)orsList.get(j);
                    and.addChild(0, or.getChildren().get(indexes[j]).clone());
                    if (i % mod == 0) {
                        indexes[j] = (indexes[j] + 1) % or.getChildren().size();
                    }
                    mod *= or.getChildren().size();
                }
                for (j = 0; j < others.length; ++j) {
                    if (others[j] == null) continue;
                    and.addChild(j, others[j].clone());
                }
                parent.addChild(and);
            }
            parent.pack();
        }
    }

    static interface Transformation {
        public void transform(GroupElement var1) throws InvalidPatternException;
    }
}

