/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import au.org.ala.layers.client.Client;
import au.org.ala.layers.dto.Field;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IntersectUtil {
    private static final Logger logger = Logger.getLogger(IntersectUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            logger.info((Object)"intersect a points file with fields");
            logger.info((Object)"args[0] = points filename, a csv with first column latitude, second column longitude \nargs[1] = comma separated field ids.  'all' can be used with local sampling, \nargs[2] = output csv filename\n");
            logger.info((Object)"\nnumber of threads for local sampling can be set to 4 with -DBATCH_THREAD_COUNT=4");
            logger.info((Object)"\nremote sample can be set with -DLAYER_INDEX_URL=http://localhost:8082/layers-index");
            return;
        }
        FileOutputStream fos = null;
        try {
            String fields = args[1];
            if (args[1].equals("all")) {
                List<Field> ff = Client.getFieldDao().getFieldsByDB();
                fields = "";
                for (Field f : ff) {
                    fields = fields + (fields == "" ? "" : ",") + f.getId();
                }
            }
            String points = IntersectUtil.readPointsFile(args[0]);
            ArrayList<String> sample = Client.getLayerIntersectDao().sampling(fields, points);
            fos = new FileOutputStream(args[2]);
            IntersectUtil.writeSampleToStream(fields.split(","), points.split(","), sample, fos);
            fos.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void writeSampleToStream(String[] fields, String[] points, ArrayList<String> sample, OutputStream outputStream) throws IOException {
        int i;
        int[] curPos = new int[sample.size()];
        for (int i2 = 0; i2 < curPos.length; ++i2) {
            curPos[i2] = 0;
        }
        OutputStreamWriter os = new OutputStreamWriter(outputStream, "UTF-8");
        int bNewLine = 10;
        int bComma = 44;
        int bDblQuote = 34;
        os.write("latitude,longitude");
        for (i = 0; i < fields.length; ++i) {
            os.write(bComma);
            os.write(fields[i]);
        }
        for (i = 0; i < points.length; i += 2) {
            os.write(bNewLine);
            os.write(points[i]);
            os.write(bComma);
            os.write(points[i + 1]);
            for (int j = 0; j < sample.size(); ++j) {
                os.write(bComma);
                int nextPos = sample.get(j).indexOf(10, curPos[j]);
                if (nextPos == -1) {
                    nextPos = sample.get(j).length();
                }
                if (curPos[j] > nextPos) continue;
                String s = sample.get(j).substring(curPos[j], nextPos);
                curPos[j] = nextPos + 1;
                if (s == null) continue;
                boolean useQuotes = false;
                if (s.contains("\"")) {
                    s = s.replace("\"", "\"\"");
                    useQuotes = true;
                } else if (s.contains(",")) {
                    useQuotes = true;
                }
                if (useQuotes) {
                    os.write(bDblQuote);
                    os.write(s);
                    os.write(bDblQuote);
                    continue;
                }
                os.write(s);
            }
        }
        os.flush();
    }

    private static String readPointsFile(String filename) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(line.replace("\"", ""));
        }
        return sb.toString();
    }
}

