/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.ComplexRegion;
import au.org.ala.layers.intersect.ShapeRecord;
import au.org.ala.layers.intersect.SimpleRegion;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class ShapeRecords
implements Serializable {
    static final long serialVersionUID = -8141403235810528840L;
    private static final Logger logger = Logger.getLogger(ShapeRecords.class);
    boolean isvalid = false;
    ArrayList<ComplexRegion> region;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapeRecords(String fileprefix, int shapetype) {
        FileInputStream fis = null;
        try {
            ShapeRecord shr;
            fis = new FileInputStream(fileprefix + ".shp");
            FileChannel fc = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)fc.size() - 100);
            fc.read(buffer, 100L);
            buffer.flip();
            buffer.order(ByteOrder.BIG_ENDIAN);
            this.region = new ArrayList();
            while (buffer.hasRemaining() && (shr = new ShapeRecord(buffer, shapetype, this.region.size())) != null && shr.shape != null) {
                ComplexRegion sr = new ComplexRegion();
                ArrayList<SimpleRegion> regions = new ArrayList<SimpleRegion>();
                for (int j = 0; j < shr.getNumberOfParts(); ++j) {
                    SimpleRegion s = new SimpleRegion();
                    s.setPolygon(shr.getPoints(j));
                    regions.add(s);
                }
                sr.addSet(regions);
                this.region.add(sr);
            }
            this.isvalid = true;
        }
        catch (Exception e) {
            logger.error((Object)("loading shape records error: " + fileprefix + ": " + e.toString()), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean isValid() {
        return this.isvalid;
    }

    public ArrayList<ComplexRegion> getRegions() {
        return this.region;
    }

    public int getNumberOfRecords() {
        return this.region.size();
    }
}

